(function ($) {

    "use strict";
    var HTMegaCircleInfographic = function ( $scope, $ ){
        var container_elem = $scope.find('.htmega-circle-infographic-wrapper').eq(0);
        container_elem[0].style.opacity = 1;

        if ( container_elem.length > 0 ) {
           var iconBox =  container_elem.find('.htmega-infographic-item');
           var dataOpt = container_elem.data('settings');
           var rotationAngleWrapper = -90;
           var rotationAngleIicon = 90;
           var contentElementes = container_elem.find('.htmega-infographic-item-content');
           var iconElements = container_elem.find('.htmega-infographic-item');
           var iconElementsWrapper = container_elem.find('.htmega-circle-infographic');
           var iconBoxInner = container_elem.find('.htmega-infographic-item-icon-box');
           var clearRound; 
           var currentIndex = 0;

         //tablet and mobile devices controll
         var currentDevice = elementorFrontend.getCurrentDeviceMode();
         var distance_from_center = 150;
         if('tablet' == currentDevice ){
            distance_from_center = dataOpt.distance_from_center_t;

         } else if('mobile' == currentDevice  ){
            distance_from_center = dataOpt.distance_from_center_m;
         } else {
            distance_from_center = dataOpt.distance_from_center;
         }

            let rotateDeg = 0;
            iconBox.each(function(index, element) {
                $(element).css('transform', 'rotate(' + rotateDeg + 'deg) translate('+ distance_from_center +'px) rotate(-' + rotateDeg + 'deg)');
                rotateDeg += 360 / iconBox.length;
            });
            $(iconBox).on(dataOpt.mouse_event, function() {
                $(this).addClass('htmega-c-info-active');
                $(this).siblings().removeClass('htmega-c-info-active');
                var displayItem =  container_elem.find('#display-'+this.id );
                    $(displayItem).addClass('htmega-c-info-active');
                    $(displayItem).siblings().removeClass('htmega-c-info-active');
            });
            // auto move
            if ( dataOpt.auto_move_active ) {
                function updateActiveClass() {
                    contentElementes.removeClass('htmega-c-info-active');
                    contentElementes.eq(currentIndex).addClass('htmega-c-info-active'); 

                    iconElements.removeClass('htmega-c-info-active'); 
                    iconElements.eq(currentIndex).addClass('htmega-c-info-active');
                }

                function rotateDiv() {
                    rotationAngleWrapper += parseInt(dataOpt.circle_distance); 
                    rotationAngleIicon -= parseInt(dataOpt.circle_distance); 
                    $(iconElementsWrapper).css('transform', 'rotate(' + rotationAngleWrapper + 'deg)');
                    $(iconBoxInner).css('transform', 'rotate(' + rotationAngleIicon + 'deg)');

                    currentIndex = (currentIndex + 1) % contentElementes.length; 
                    updateActiveClass(); 
                    
                    if( contentElementes.last().hasClass('htmega-c-info-active') ) {
                        rotationAngleWrapper = (- 90 - parseInt(dataOpt.circle_distance));
                        rotationAngleIicon = (90 + parseInt(dataOpt.circle_distance));
                        clearInterval(clearRound);
                        clearRound = setInterval(rotateDiv, parseInt(dataOpt.auto_move_speed));
                    }
                }
                $(iconElementsWrapper).on(dataOpt.mouse_event, '.htmega-infographic-item', function() {
                    clearInterval(clearRound); 
                    currentIndex = iconElements.index(this); 
                    updateActiveClass();
                    clearRound = setInterval(rotateDiv, parseInt(dataOpt.auto_move_speed));
                });
                
                clearRound = setInterval( rotateDiv, parseInt(dataOpt.auto_move_speed));
            }
        }
    }
    // Run this code under Elementor.
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-interactive-circle-infographic-addons.default', HTMegaCircleInfographic);
    });      


})(jQuery);
