(function ($) {
    "use strict";
        var WidgetTeamCarouselHandler = function ($scope, $) {
        
            var swiper_elem = $scope.find('.htmega-team-carousel-slider-active').eq(0);
            var slickActivationFor = $scope.find('.htmega-pro-slider-for').eq(0);
            var slickActivationNav = $scope.find('.htmega-pro-slider-nav').eq(0);
            if( swiper_elem.length > 0){ swiper_elem[0].style.display='block'; }
            if( slickActivationFor.length > 0){ slickActivationFor[0].style.display='block'; }
            if( slickActivationNav.length > 0){ slickActivationNav[0].style.display='block'; }
            
            if (swiper_elem.length > 0) {

             var swiper_opt = swiper_elem.data('settings');
                var swiper = new Swiper(swiper_elem[0], { // for js version 8.4.5
                //var swiper = new Swiper( swiper_elem, {
                    slidesPerView : swiper_opt.display_columns,
                    slidesPerGroup: 1,
                    centeredSlides: swiper_opt.slaut_center_slides,
                    loop: swiper_opt.loop,
                    speed: swiper_opt.autoplay_speed,
                    spaceBetween : swiper_opt.slitems_space_between,
                    autoplay: swiper_opt.autoplay,
                    direction: 'horizontal',
                    navigation: {
                        nextEl: swiper_opt.arrow_prev_txt,
                        prevEl: swiper_opt.arrow_next_txt,
                    },
                    pagination: {
                        el: swiper_opt.dots_style,
                        type: 'bullets',
                        clickable: true
                    },
                    breakpoints: {
                        1499: {
                            slidesPerView : swiper_opt.display_columns,
                            spaceBetween : swiper_opt.slitems_space_between,
                        },
                        991: {
                            slidesPerView : swiper_opt.display_columns,
                            spaceBetween : swiper_opt.slitems_space_between,
                        },
                        768: {
                            slidesPerView : swiper_opt.tablet_display_columns,
                            spaceBetween : swiper_opt.tablet_slitems_space_between,
                        },
                        575: {
                            slidesPerView : swiper_opt.mobile_display_columns,
                            spaceBetween : swiper_opt.mobile_slitems_space_between,
                        },
                        0 : {
                            slidesPerView : 1
                        }
                    }


                });
            }

            if (slickActivationFor.length > 0) {
              var slick_opt = slickActivationFor.data('settings');
            /*------ Our Team Slick Slider ------*/
            slickActivationFor.slick({
                slidesToShow:  1,
                slidesToScroll: 1,
                arrows: false,
                fade: true,
                asNavFor: slickActivationNav
              });
              slickActivationNav.slick({
                slidesToShow: slick_opt.display_columns,
                slidesToScroll: 1,
                asNavFor: slickActivationFor,
                margin:0,
                dots: false,
                centerMode: true,
                arrows: slick_opt.arrows,
                infinite: slick_opt.loop,
                autoplaySpeed:slick_opt.autoplay_speed,
                autoplay:slick_opt.autoplay,
                centerPadding: '0px',
                focusOnSelect: true,
                prevArrow: '<div class="slick-prev">' + slick_opt.arrowPrev + '</div>',
                  nextArrow: '<div class="slick-next">' + slick_opt.arrowNext + '</div>',
                      responsive: [
                    {
                      breakpoint: 1024,
                      settings: {
                      slidesToShow: slick_opt.display_columns,

                      }
                    },
                    {
                      breakpoint: 600,
                      settings: {
                        slidesToShow: slick_opt.tablet_display_columns,
                      }
                    },
                    {
                      breakpoint: 480,
                      settings: {
                        slidesToShow: slick_opt.mobile_display_columns,
                      }
                    }
                    ]
              });

            }


        }

    // Run this code under Elementor.
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-team-carousel-addons.default', WidgetTeamCarouselHandler);
    });

})(jQuery);
