(function ($) {
    "use strict";
  
    var HTMegaVideoGallery = function ( $scope, $ ){
        var container_elem = $scope.find('.htmega-video-gallery-wrapper').eq(0);
        if ( container_elem.length > 0 ) {
            container_elem[0].style.display='block';
            // var filterMenu = $scope.find('.htmega-video-gallery-filter-menu').eq(0);
            // var filterGrid = $scope.find('.htmega-video-gallery-filter-wrapper').eq(0);

            var filterMenu = $('.htmega-video-gallery-filter-menu',container_elem);
            var filterGrid = $('.htmega-video-gallery-filter-wrapper',container_elem);
            var dataOpt = container_elem.data('settings');

            if (filterMenu.length > 0) {
                // Filter menu
                if ( !elementorFrontend.isEditMode() ) {
                    $(filterGrid).imagesLoaded( function() {
                        // Isotop Full Grid
                        $(filterGrid).isotope({
                            itemSelector: '.htmega-flex-column',
                            percentPosition: true,
                            masonry: {
                                columnWidth: '.htmega-flex-column',
                            }
                        });
                    });
                }
                $(filterMenu).on( 'click', '.htmega-vgf-btn', function() {
                    $(this).siblings('.is-checked').removeClass('is-checked');
                    $(this).addClass('is-checked');
                    var activeWrapper = $(this).parent().siblings('.htmega-video-gallery-filter-wrapper');
                    var filterValue = $(this).attr('data-filter');
                    $(filterGrid).isotope({ 
                        filter: filterValue,
                    });
                });

            }

            $(container_elem).on('click', '.htmega-video-popup-link', function () {
                var videoType = $(this).data('type');
                var videoSrc = $(this).attr('href');

                if (videoType === 'inline') {
                    // Self-hosted video
                    $.magnificPopup.open({
                        items: {
                            src: videoSrc
                        },
                        type: 'inline',
                        mainClass: 'mfp-fade',
                        removalDelay: 300,
                        closeBtnInside: true, // Show the close button inside the popup
                        //closeOnBgClick: false, // Disable closing when clicking outside the popup
                        callbacks: {
                            open: function () {
                                this.content.find('.htmega-inline-video-container').css('width', '100%'); // Adjust the width as needed
                            }
                        }
                    });
                } else {
                    // YouTube and Vimeo videos
                    $.magnificPopup.open({
                        items: {
                            src: videoSrc
                        },
                        type: 'iframe',
                        mainClass: 'mfp-fade',
                        removalDelay: 300
                    });
                }

                return false;
            });


        }
    }
    // Run this code under Elementor.
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-video-gallery-addons.default', HTMegaVideoGallery);
    });      


})(jQuery);
