<?php
namespace HTMegaPro;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class HTMega_Widgets_Control{

    private static $instance = null;
    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    function __construct(){
        // Register custom category
        add_action( 'elementor/elements/categories_registered', [ $this, 'add_category' ] );
        // Add Plugin actions
        add_filter( 'htmega_widget_list', [ $this, 'init_widgets' ] );
    }

    // Add custom category.
    public function add_category( $elements_manager ) {
        $elements_manager->add_category(
            'htmegapro-addons',
            [
                'title' => __( 'HTMega Addons Pro', 'htmega-pro' ),
                'icon'  => 'fa fa-snowflake',
            ]
        );
    }

    // Controll Widgets
    public function init_widgets($widget_list){

        $widget_list['htmega_view_counter'] = [
            'title'     =>  'View Counter',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];

        $widget_list['htmega_sticky_section'] = [
            'title'     =>  'Sticky Section',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];

        $widget_list['htmega_image_roted'] = [
            'title'     =>  'Image Roted',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['lottie'] = [
            'title'     =>  'Lottie',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['event_calendar'] = [
            'title'     =>  'Event Calendar',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['info_box'] = [
            'title'     =>  'Info Box',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['category_list'] = [
            'title'     =>  'Category List',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];

        $widget_list['pricing_menu'] = [
            'title'     =>  'Pricing Menu',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];

        $widget_list['feature_list'] = [
            'title'     =>  'Feature List',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];

        $widget_list['social_network_icons'] = [
            'title'     =>  'Social Network Icons',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];

        $widget_list['taxonomy_terms'] = [
            'title'     =>  'Taxonomy Terms',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['background_switcher'] = [
            'title'     =>  'Background Switcher',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['facebook_review'] = [
            'title'     =>  'Facebook Review',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['breadcrumbs'] = [
            'title'     =>  'Breadcrumbs',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['page_list'] = [
            'title'     => 'Page List',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    => true,
        ];
        $widget_list['team_carousel'] = [
            'title'     =>  'Team Carousel',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['icon_box'] = [
            'title'     =>  'Icon Box',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['interactive_promo'] = [
            'title'     =>  'Interactive Promo',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['event_box'] = [
            'title'     =>  'Event Box',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['filterable_gallery'] = [
            'title'     =>  'Filterable Gallery',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['whatsapp_chat'] = [
            'title'     =>  'WhatsApp Chat',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['chart'] = [
            'title'     =>  'Chart',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['post_timeline'] = [
            'title'     =>  'Post Timeline',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['post_masonry'] = [
            'title'     =>  'Post Masonry',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['source_code'] = [
            'title'     =>  'Source Code',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['threesixty_rotation'] = [
            'title'     =>  'Threesixty Rotation',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];

        $widget_list['pricing_table_flip_box'] = [
            'title'     =>  'Pricing Table Flip Box',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['flip_switcher_pricing_table'] = [
            'title'     =>  'Flip Switcher Pricing Table',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['dynamic_gallery'] = [
            'title'     =>  'Dynamic Gallery',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['advanced_slider'] = [
            'title'     =>  'Advanced Slider',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['flip_carousel'] = [
            'title'     =>  'Flip Carousel',
            'option-tab'=> 'htmega_element_tabs', 
            'is_pro'    =>  true,
        ];
        $widget_list['interactive_circle_infographic'] = [
            'title'     =>  'Interactive Circle Infographic',
            'option-tab'=> 'htmega_element_tabs',
            'is_pro'    =>  true,
        ];
        $widget_list['copy_coupon_code'] = [
            'title'     =>  'Copy Coupon Code',
            'option-tab'=> 'htmega_element_tabs',
            'is_pro'    =>  true,
        ];
        $widget_list['video_gallery'] = [
            'title'     =>  'Video Gallery',
            'option-tab'=> 'htmega_element_tabs',
            'is_pro'    =>  true,
        ];
        $widget_list['video_playlist'] = [
            'title'     =>  'Video Playlist',
            'option-tab'=> 'htmega_element_tabs',
            'is_pro'    =>  true,
        ];
        $widget_list['blob_shape'] = [
            'title'     =>  'Blob Shape',
            'option-tab'=> 'htmega_element_tabs',
            'is_pro'    =>  true,
        ];


        return $widget_list;

    }

}

HTMega_Widgets_Control::instance();