<?php 
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;


class HTMegaAdvanced_Sticky_Elementor {
	private static $assets_load = null;

    private static $_instance = null;
    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
    public function __construct() {

		// Creates  Advanced Stcky tab at the end of section/Container/Widget Advanced tab.
		add_action( 'elementor/element/section/section_advanced/after_section_end', array( $this, 'register_controls' ), 10 );
		add_action( 'elementor/element/container/section_layout/after_section_end', array( $this, 'register_controls' ), 10 );
		add_action( 'elementor/element/common/_section_style/after_section_end', array( $this, 'register_controls' ), 10 );

		add_action( 'elementor/section/print_template', array( $this, '_print_template' ), 10, 2 );
		add_action( 'elementor/container/print_template', array( $this, '_print_template' ), 10, 2 );

		// add data before section/column rendering.
		add_action( 'elementor/frontend/section/before_render', array( $this, 'before_render' ), 10, 1 );
		add_action( 'elementor/frontend/container/before_render', array( $this, 'before_render' ), 10, 1 );
		add_action( 'elementor/frontend/widget/before_render', array( $this, 'before_render' ), 10, 1 );
		
		add_action( 'elementor/preview/enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'elementor/preview/enqueue_styles', array( $this, 'enqueue_styles' ) );

		add_action( 'elementor/frontend/section/before_render', array( $this, 'check_assets_enqueue' ) );
		add_action( 'elementor/frontend/container/before_render', array( $this, 'check_assets_enqueue' ) );
		add_action( 'elementor/frontend/widget/before_render', array( $this, 'check_assets_enqueue' ));

    }

	/**
	 * Enqueue styles.
	 *
	 * Registers required dependencies for the extension and enqueues them.
	 *
	 * @since 1.6.2
	 * @access public
	 */
	public static function enqueue_styles() {
		//CSS File
		wp_enqueue_style(  'htmega-advanced-sticky',  HTMEGA_ADDONS_PL_URL_PRO . 'extensions/advanced-sticky/assets/css/htmega-advanced-sticky.css', array(), HTMEGA_VERSION_PRO );
	}

	/**
	 * Enqueue scripts.
	 *
	 * Enqueue required JS dependencies for the extension.
	 *
	 * @since 1.6.2
	 * @access public
	 */
	public static function enqueue_scripts() {
        // JS File
        wp_enqueue_script( 'htmega-advanced-sticky', HTMEGA_ADDONS_PL_URL_PRO . 'extensions/advanced-sticky/assets/js/htmega-advanced-sticky.js', array('jquery'),HTMEGA_VERSION_PRO );

	}

	 //Register Sticky  controls.
	public function register_controls( $element ) {

		$element->start_controls_section(
			'section_htmega_advanced_sticky',
			[
				'label' => __( 'HT Mega Advanced Sticky', 'htmega-pro' ),
				'tab'   => Controls_Manager::TAB_ADVANCED,
			]
		);

		$element->add_control(
			'htmega_advanced_sticky_switcher',
			[
				'label'        => __( 'Enable Sticky', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'htmega-advanced-sticky-',
				'render_type'  => 'template',
			]
		);
		if ( strpos( current_filter(), 'common/' ) ) {
		
			$element->add_control(
				'particles_notice',
				[
					'raw'             => __( 'The <b>Sticky settings</b> are not functional in Editor mode. Please preview the page to see the desired result.', 'htmega-pro' ),
					'type'            => Controls_Manager::RAW_HTML,
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
					'condition'   => [
						'htmega_advanced_sticky_switcher' => 'yes'
					],
				]
			);
		}
		$options = array(
			'top'  => __( 'Top', 'htmega-pro' ),
			'bottom' => __( 'Bottom', 'htmega-pro' ),
			'column' => __( 'Column', 'htmega-pro' ),
		);

		// if ( strpos( current_filter(), 'section/' ) ) {
		// 	unset( $options['column'] );
		// }
		$element->add_control (
			'advanced_sticky_position',
			[
				'label' => __( 'Sticky Position', 'htmega-pro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'top',
				'options' => $options,
				'condition' => [
					'htmega_advanced_sticky_switcher' => 'yes'
				]
			]
		);

		$element->add_control(
			'advanced_sticky_zindex',
			[
				'label'   => __( 'Z-Index', 'htmega-pro' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 0,
				'condition'   => [
					'htmega_advanced_sticky_switcher' => 'yes'
				],
			]
		);
		$element->add_control(
			'advanced_sticky_offset',
			[
				'label'   => __( 'Offset', 'htmega-pro' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 0,
				'condition'   => [
					'htmega_advanced_sticky_switcher' => 'yes'
				],
			]
		);
		$element->add_control(
			'advanced_sticky_untill',
			[
				'label'   => __( 'Sticky Until', 'htmega-pro' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'condition'   => [
					'htmega_advanced_sticky_switcher' => 'yes',
					'advanced_sticky_position!' => 'column',
					
				],
				'description' => __( 'Add a section ID without # to until sticky.', 'htmega-pro' ),
			]
		);
		$element->add_control(
			'advanced_sticky_on_scroll_up',
			[
				'label'        => __( 'Show On Scroll Up', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' =>'no',
				'condition'   => [
					'htmega_advanced_sticky_switcher' => 'yes',
					'advanced_sticky_position!' => ['column','bottom'],
				],
			]
		);
		$element->add_control(
			'advanced_sticky_hide_on_tablet',
			[
				'label'        => __( 'Hide On Tablet', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' =>'no',
				'condition'   => [
					'htmega_advanced_sticky_switcher' => 'yes'
				],
			]
		);
		$element->add_control(
			'advanced_sticky_hide_on_mobile',
			[
				'label'        => __( 'Hide On Mobile', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' =>'no',
				'condition'   => [
					'htmega_advanced_sticky_switcher' => 'yes'
				],
			]
		);
		$element->add_control(
			'advanced_sticky_animation',
			[
				'label'        => __( 'Sticky Animation', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' =>'no',
				'condition'   => [
					'htmega_advanced_sticky_switcher' => 'yes'
				],
			]
		);
		$element->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'advanced_sticky_box_shadow',
				'label' => __( 'Sticky Box Shadow', 'htmega-pro' ),
				'selector' => '{{WRAPPER}}.htmega-sticky-open',
				'condition'=>[
					'htmega_advanced_sticky_switcher' => 'yes'
				]
			]
		);

		$element->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'advanced_sticky_bg_color',
				'label' => __( 'Background', 'htmega-pro' ),
				'types' => [ 'classic', 'gradient' ],
				'exclude'=>['image'],
				'selector' => '{{WRAPPER}}.htmega-sticky-open',
				'condition' => [
					'htmega_advanced_sticky_switcher' => 'yes'
				],
			]
		);

		$element->end_controls_section();

	}

	/**
	 * Render Editor Sticky output.
	 *
	 *
	 * @since 1.6.2
	 * @access public
	 * 
	 * @param object $template for current template.
	 * @param object $widget for current widget.
	 */
	public function _print_template( $template, $widget ) {

		ob_start();
		?>
		<#
		if( 'yes' === settings.htmega_advanced_sticky_switcher ) {

			const stickySettings = {
				position: settings.advanced_sticky_position,
				offset: settings.advanced_sticky_offset,
				z_index: settings.advanced_sticky_zindex,
				sticky_untill: settings.advanced_sticky_untill,
				sticky_on_scroll_up: settings.advanced_sticky_on_scroll_up,
				hide_on_tablet: settings.advanced_sticky_hide_on_tablet,
				hide_on_mobile: settings.advanced_sticky_hide_on_mobile,
				sticky_animation: settings.advanced_sticky_animation
				};

			view.addRenderAttribute( 'htmega_sticky_data', {
				'id': 'htmega-advanced-sticky-id-' + view.getID(),
				'class': 'htmega-advanced-sticky-editor',
				'data-sticky_settings': JSON.stringify( stickySettings )
			});

		#>
			<div {{{ view.getRenderAttributeString( 'htmega_sticky_data' ) }}}></div>
		<# } #>
		<?php
		$htmega_sticky_content = ob_get_contents();
		ob_end_clean();

		return $template . $htmega_sticky_content;

	}

	/**
	 * Render HTML output on the frontend.
	 *
	 * Written in PHP and used to generate the final Output.
	 *
	 * @since 1.6.2
	 * @access public
	 * @param object $element for current element.
	 */
	public function before_render( $element ) {

		$settings = $element->get_settings_for_display();
		$sectionid = $element->get_id();

		if ( 'yes' == $settings['htmega_advanced_sticky_switcher'] ) {
            $sticky_settings = [];

			$sticky_settings['position'] = $settings['advanced_sticky_position'];
			$sticky_settings['offset'] = $settings['advanced_sticky_offset'];
			$sticky_settings['z_index'] = $settings['advanced_sticky_zindex'];
			$sticky_settings['sticky_untill'] = $settings['advanced_sticky_untill'];
			$sticky_settings['sticky_on_scroll_up'] = $settings['advanced_sticky_on_scroll_up'];
			$sticky_settings['hide_on_tablet'] = $settings['advanced_sticky_hide_on_tablet'];
			$sticky_settings['hide_on_mobile'] = $settings['advanced_sticky_hide_on_mobile'];
			$sticky_settings['sticky_animation'] = $settings['advanced_sticky_animation'];

			$element->add_render_attribute( '_wrapper', [
				'data-sticky_settings'=> wp_json_encode( $sticky_settings ),
				'id' => "htmega-advanced-sticky-id-{$sectionid}",
			] );
		}
	}

	 //Check Assets Enqueue
	public function check_assets_enqueue( $element ) {
		if ( self::$assets_load ) {
			return;
		}
		if ( 'yes' === $element->get_settings_for_display( 'htmega_advanced_sticky_switcher' ) ) {
			$this->enqueue_styles();
			$this->enqueue_scripts();
			self::$assets_load = true;
			remove_action( 'elementor/frontend/section/before_render', array( $this, 'check_assets_enqueue' ) );
			remove_action( 'elementor/frontend/column/before_render', array( $this, 'check_assets_enqueue' ) );
			remove_action( 'elementor/frontend/container/before_render', array( $this, 'check_assets_enqueue' ) );
		}
	}
}


HTMegaAdvanced_Sticky_Elementor::instance();