<?php
namespace HTMegaPro\Extension\Conditional_Display\Conditions;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class Date
 * Contain all element of date condition
 * @package HTMegaPro\Extension\Conditional_Display\Conditions
 */
class Date extends Condition {

	/**
	 * Get Condition Key
	 *
	 * @return string|void
	 */
	public function get_key_name() {
		return 'date';
	}

	/**
	 * Get Condition Title
	 *
	 * @return string|void
	 */
	public function get_title() {
		return __( 'Date', 'htmega-pro' );
	}

	/**
	 * Get Repeater Control Field Value
	 *
	 * @param array $condition
	 * @return array|void
	 */
	public function get_repeater_control( array $condition ) {
		$default = gmdate( 'd-m-Y' );
		return[
			'label' 		=> $this->get_title(),
			'show_label' 	=> false,
			'type' => Controls_Manager::DATE_TIME,
			'default' => $default,
			'label_block' => true,
			'picker_options' => [
				'enableTime'	=> false,
				'dateFormat' 	=> 'd-m-Y',
			],
			'description' => __( 'The condition will apply after the selected date.', 'htmega-pro' ),
			'condition'	=> $condition,
		];
	}

	/**
	 * Compare Condition value
	 *
	 * @param $settings
	 * @param $operator
	 * @param $value
	 * @return bool|void
	 */
	public function compare_value( $settings, $operator, $value ) {
		$date = strtotime( $value );
		$today = htmega_get_server_time( 'd-m-Y' );
		if ( 'local' === $settings['htmega_time_zone'] ) {
			$today = htmega_get_local_time( 'd-m-Y' );
		}
		$today = strtotime( $today );

		//If $today is equal to $date or grater then $date it return true otherwise false
		$result = ( ( $today >= $date ) );

		return htmega_value_compare( $result, true, $operator );

	}
}
