<?php
namespace HTMegaPro\Extension\Conditional_Display\Conditions;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class Recurring_Visitor
 * Contain all element of recurring visitor condition
 * @package HTMegaPro\Extension\Conditional_Display\Conditions
 */
class Recurring_Visitor extends Condition {

	/**
	 * Get Condition Key
	 *
	 * @return string|void
	 */
	public function get_key_name() {
		return 'recurring_visitor';
	}

	/**
	 * Get Condition Title
	 *
	 * @return string|void
	 */
	public function get_title() {
		return __( 'Recurring Visitor', 'htmega-pro' );
	}

	/**
	 * Get Repeater Control Field Value
	 *
	 * @param array $condition
	 * @return array|void
	 */
	public function get_repeater_control( array $condition ) {
			return [
				'label' 		=> $this->get_title(),
				'show_label' 	=> false,
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'recurring' => __( 'Recurring Visitor', 'htmega-pro' ),
				),
				'default'     => 'recurring',
				'label_block' 	=> true,
				'condition' 		=> $condition,
			];
	}

	/**
	 * Compare Condition value
	 *
	 * @param $settings
	 * @param $operator
	 * @param $value
	 * @return bool|void
	 */
	public function compare_value( $settings, $operator, $value ) {
		$page_id = get_the_ID();

		if ( ! $page_id ) {
			return true;
		}

		$condition_result = isset( $_COOKIE[ 'recurringVisitor' . $page_id ] );

		return htmega_value_compare( $condition_result, true, $operator );
	}
}
