<?php 
namespace HTMega_Floating_Effects;
use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMegaFloatingEffects_Elementor {

    private static $_instance = null;
	static $load_script = false;
    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
	
    public function __construct() {
		add_action( 'elementor/element/common/_section_style/after_section_end', [ __CLASS__, 'register_controls' ], 1 );
		add_action( 'elementor/frontend/widget/before_render', [ __CLASS__, 'should_script_enqueue' ] );
		add_action( 'elementor/preview/enqueue_scripts', [ __CLASS__, 'enqueue_scripts' ] );
    }
	/**
	 * Enqueue scripts.
	 *
	 * Enqueue required JS dependencies for the extension.
	 *
	 * @since 1.6.8
	 * @access public
	 */
	public static function enqueue_scripts() {
        // JS File
        wp_enqueue_script( 'htmega-floating-effects', HTMEGA_ADDONS_PL_URL . 'extensions/floating-effects/assets/js/htmega-floating-effects.js', array('jquery'),HTMEGA_VERSION );
		wp_enqueue_script( 'anime' );

	}



	/**
	 * Set should_script_enqueue based on module settings
	 *
	 * @param Element_Base $section
	 * @return void
	 */
	public static function should_script_enqueue( Element_Base $section ) {
		if ( self::$load_script ) {
			return;
		}

		if ( 'yes' == $section->get_settings_for_display( 'htmega_fe' ) ) {
			self::enqueue_scripts();

			self::$load_script = true;

			remove_action( 'elementor/frontend/widget/before_render', [ __CLASS__, 'should_script_enqueue' ] );
		}
	}



	/**
	 * Register Wrapper link controls.
	 *
	 * @since 1.6.8
	 * @access public
	 * @param object $element for current element.
	 */
	public static function register_controls( $element ) {

		$element->start_controls_section(
			'section_floating_effects',
			[
				'label' => __( 'HTMega Floating Effects', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_ADVANCED,
			]
		);

		$element->add_control(
			'htmega_fe',
			[
				'label' => __( 'Enable', 'htmega-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'no',
				'frontend_available' => true,
			]
		);
		$element->add_control(
			'htmega_fe_motion_toggle',
			[
				'label' => __( 'Motion', 'htmega-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
				]
			]
		);

		$element->add_control(
			'htmega_fe_translate_toggle',
			[
				'label' => __( 'Translate', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_motion_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();

		$element->add_control(
			'htmega_fe_translate_x',
			[
				'label' => __( 'Translate X', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' => 0,
						'to' => 5,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_translate_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_translate_y',
			[
				'label' => __( 'Translate Y', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' => 0,
						'to' => 5,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_translate_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_translate_duration',
			[
				'label' => __( 'Duration', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10000,
						'step' => 100
					]
				],
				'default' => [
					'size' => 1000,
				],
				'condition' => [
					'htmega_fe_translate_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_translate_delay',
			[
				'label' => __( 'Delay', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5000,
						'step' => 100
					]
				],
				'condition' => [
					'htmega_fe_translate_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->end_popover();

		$element->add_control(
			'htmega_fe_rotate_toggle',
			[
				'label' => __( 'Rotate', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_motion_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();

		$element->add_control(
			'htmega_fe_rotate_x',
			[
				'label' => __( 'Rotate X', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' => 0,
						'to' => 45,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => -180,
						'max' => 180,
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_rotate_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_rotate_y',
			[
				'label' => __( 'Rotate Y', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' => 0,
						'to' => 45,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => -180,
						'max' => 180,
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_rotate_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_rotate_z',
			[
				'label' => __( 'Rotate Z', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' => 0,
						'to' => 45,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => -180,
						'max' => 180,
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_rotate_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_rotate_duration',
			[
				'label' => __( 'Duration', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10000,
						'step' => 100
					]
				],
				'default' => [
					'size' => 1000,
				],
				'condition' => [
					'htmega_fe_rotate_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_rotate_delay',
			[
				'label' => __( 'Delay', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5000,
						'step' => 100
					]
				],
				'condition' => [
					'htmega_fe_rotate_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->end_popover();

		$element->add_control(
			'htmega_fe_scale_toggle',
			[
				'label' => __( 'Scale', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_motion_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();

		$element->add_control(
			'htmega_fe_scale_x',
			[
				'label' => __( 'Scale X', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' => 1,
						'to' => 1.2,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5,
						'step' => .1
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_scale_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_scale_y',
			[
				'label' => __( 'Scale Y', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' => 1,
						'to' => 1.2,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5,
						'step' => .1
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_scale_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_scale_duration',
			[
				'label' => __( 'Duration', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10000,
						'step' => 100
					]
				],
				'default' => [
					'size' => 1000,
				],
				'condition' => [
					'htmega_fe_scale_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_scale_delay',
			[
				'label' => __( 'Delay', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10000,
						'step' => 100
					]
				],
				'condition' => [
					'htmega_fe_scale_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->end_popover();
		// Skew
		$element->add_control(
			'htmega_fe_skew_toggle',
			[
				'label' => __( 'Skew', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_motion_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();

		$element->add_control(
			'htmega_fe_skew_x',
			[
				'label' => __( 'Skew X', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' => 0,
						'to' => 20,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => -180,
						'max' => 180,
						'step' => 1
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_skew_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_skew_y',
			[
				'label' => __( 'Skew Y', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' => 0,
						'to' => 20,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => -180,
						'max' => 180,
						'step' => 1
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_skew_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_skew_duration',
			[
				'label' => __( 'Duration', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10000,
						'step' => 100
					]
				],
				'default' => [
					'size' => 1000,
				],
				'condition' => [
					'htmega_fe_skew_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->add_control(
			'htmega_fe_skew_delay',
			[
				'label' => __( 'Delay', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10000,
						'step' => 100
					]
				],
				'condition' => [
					'htmega_fe_skew_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,
			]
		);

		$element->end_popover();

		$element->add_control(
			'htmega_fe_style_toggle',
			array(
				'label'        => __( 'Style', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'separator'    => 'before',
				'condition'    => array(
					'htmega_fe' => 'yes',
				),
				'frontend_available' => true,
			)
		);
		$element->add_control(
			'htmega_fe_opacity_toggle',
			[
				'label' => __( 'Opacity', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_style_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();

		$element->add_control(
			'htmega_fe_opacity',
			array(
				'label'     => __( 'Value', 'htmega-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'default' => [
					'sizes' => [
						'from' =>.5,
						'to' => 1,
					],
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => .1
					]
				],
				'labels' => [
					__( 'From', 'htmega-pro' ),
					__( 'To', 'htmega-pro' ),
				],
				'scales' => 1,
				'handles' => 'range',
				'condition' => [
					'htmega_fe_style_toggle' => 'yes',
					'htmega_fe' => 'yes',
				],
				'render_type' => 'none',
				'frontend_available' => true,

			)
		);

		$element->add_control(
			'htmega_fe_opacity_duration',
			array(
				'label'     => __( 'Duration', 'htmega-pro' ) . ' (ms)',
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10000,
						'step' => 100,
					),
				),
				'default'   => array(
					'unit' => 'px',
					'size' => 1000,
				),
				'condition' => array(
					'htmega_fe'         => 'yes',
					'htmega_fe_style_toggle' => 'yes',
				),
				'frontend_available' => true,
			)
		);

		$element->add_control(
			'htmega_fe_opacity_delay',
			array(
				'label'     => __( 'Delay', 'htmega-pro' ) . ' (ms)',
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10000,
						'step' => 100,
					),
				),
				'condition' => array(
					'htmega_fe'         => 'yes',
					'htmega_fe_style_toggle' => 'yes',
				),
				'frontend_available' => true,

			)
		);
		$element->end_popover();

		$element->add_control(
			'htmega_fe_bg_color_toggle',
			[
				'label' => __( 'Background Color', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_style_toggle' => 'yes',
				],
			]
		);

		$element->start_popover();
			$element->add_control(
				'htmega_fe_bg_color_from',
				array(
					'label'     => __( 'From', 'htmega-pro' ),
					'type'      => Controls_Manager::COLOR,
					'global'    => array(
						'default' => Global_Colors::COLOR_PRIMARY,
					),
					'condition' => array(
						'htmega_fe'          => 'yes',
						'htmega_fe_style_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);

			$element->add_control(
				'htmega_fe_bg_color_to',
				array(
					'label'     => __( 'To', 'htmega-pro' ),
					'type'      => Controls_Manager::COLOR,
					'global'    => array(
						'default' => Global_Colors::COLOR_PRIMARY,
					),
					'condition' => array(
						'htmega_fe'          => 'yes',
						'htmega_fe_style_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);

			$element->add_control(
				'htmega_fe_bg_color_duration',
				array(
					'label'     => __( 'Duration', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'default'   => array(
						'unit' => 'px',
						'size' => 1000,
					),
					'condition' => array(
						'htmega_fe'          => 'yes',
						'htmega_fe_style_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);

			$element->add_control(
				'htmega_fe_bg_color_delay',
				array(
					'label'     => __( 'Delay', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'condition' => array(
						'htmega_fe'          => 'yes',
						'htmega_fe_style_toggle' => 'yes',
					),
					'frontend_available' => true,

				)
			);
		$element->end_popover();

		// End Style Settings
		$element->add_control(
			'htmega_fe_filters_toggle',
			array(
				'label'        => __( 'Filters', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'separator'    => 'before',
				'condition'    => array(
					'htmega_fe' => 'yes',
				),
				'frontend_available' => true,
			)
		);
		// Blur start
		$element->add_control(
			'htmega_fe_blur_toggle',
			[
				'label' => __( 'Blur', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_filters_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();
			$element->add_control(
				'htmega_fe_blur',
				array(
					'label'     => __( 'Value', 'htmega-pro' ),
					'type'      => Controls_Manager::SLIDER,
					'default' => [
						'sizes' => [
							'from' =>0,
							'to' => 1,
						],
						'unit' => 'px',
					],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 10,
							'step' => .1
						]
					],
					'labels' => [
						__( 'From', 'htmega-pro' ),
						__( 'To', 'htmega-pro' ),
					],
					'scales' => 1,
					'handles' => 'range',
					'condition' => [
						'htmega_fe_filters_toggle' => 'yes',
						'htmega_fe' => 'yes',
					],
					'render_type' => 'none',
					'frontend_available' => true,

				)
			);

			$element->add_control(
				'htmega_fe_blur_duration',
				array(
					'label'     => __( 'Duration', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'default'   => array(
						'unit' => 'px',
						'size' => 1000,
					),
					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_filters_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);

			$element->add_control(
				'htmega_fe_blur_delay',
				array(
					'label'     => __( 'Delay', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_filters_toggle' => 'yes',
					),
					'frontend_available' => true,

				)
			);
		$element->end_popover();
		// Blur End
		// Blur start
		$element->add_control(
			'htmega_fe_contrast_toggle',
			[
				'label' => __( 'Contrast', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_filters_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();
			$element->add_control(
				'htmega_fe_contrast',
				array(
					'label'     => __( 'Value', 'htmega-pro' ),
					'type'      => Controls_Manager::SLIDER,
					'default' => [
						'sizes' => [
							'from' =>0,
							'to' => 50,
						],
						'unit' => '%',
					],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 200,
							'step' => 5
						]
					],
					'labels' => [
						__( 'From', 'htmega-pro' ),
						__( 'To', 'htmega-pro' ),
					],
					'scales' => 1,
					'handles' => 'range',
					'condition' => [
						'htmega_fe_contrast_toggle' => 'yes',
						'htmega_fe' => 'yes',
					],
					'render_type' => 'none',
					'frontend_available' => true,

				)
			);

			$element->add_control(
				'htmega_fe_contrast_duration',
				array(
					'label'     => __( 'Duration', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'default'   => array(
						'unit' => 'px',
						'size' => 1000,
					),

					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_contrast_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);

			$element->add_control(
				'htmega_fe_contrast_delay',
				array(
					'label'     => __( 'Delay', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_contrast_toggle' => 'yes',
					),
					'frontend_available' => true,

				)
			);
		$element->end_popover();
		// Blur end
		// Grayscale start
		$element->add_control(
			'htmega_fe_grayscale_toggle',
			[
				'label' => __( 'Grayscale', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_filters_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();
			$element->add_control(
				'htmega_fe_grayscale',
				array(
					'label'     => __( 'Value', 'htmega-pro' ),
					'type'      => Controls_Manager::SLIDER,
					'default' => [
						'sizes' => [
							'from' =>0,
							'to' => 50,
						],
						'unit' => '%',
					],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
							'step' => 5
						]
					],
					'labels' => [
						__( 'From', 'htmega-pro' ),
						__( 'To', 'htmega-pro' ),
					],
					'scales' => 1,
					'handles' => 'range',
					'condition' => [
						'htmega_fe_grayscale_toggle' => 'yes',
						'htmega_fe' => 'yes',
					],
					'render_type' => 'none',
					'frontend_available' => true,

				)
			);

			$element->add_control(
				'htmega_fe_grayscale_duration',
				array(
					'label'     => __( 'Duration', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'default'   => array(
						'unit' => 'px',
						'size' => 1000,
					),

					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_grayscale_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);

			$element->add_control(
				'htmega_fe_grayscale_delay',
				array(
					'label'     => __( 'Delay', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_grayscale_toggle' => 'yes',
					),
					'frontend_available' => true,

				)
			);
		$element->end_popover();
		// Grayscale end
		// Hue start
		$element->add_control(
			'htmega_fe_hue_toggle',
			[
				'label' => __( 'Hue', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_filters_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();
			$element->add_control(
				'htmega_fe_hue',
				array(
					'label'     => __( 'Value', 'htmega-pro' ),
					'type'      => Controls_Manager::SLIDER,
					'default' => [
						'sizes' => [
							'from' =>0,
							'to' => 90,
						],
						'unit' => 'deg',
					],
					'range' => [
						'deg' => [
							'min' => 0,
							'max' => 360,
							'step' => 5
						]
					],
					'labels' => [
						__( 'From', 'htmega-pro' ),
						__( 'To', 'htmega-pro' ),
					],
					'scales' => 1,
					'handles' => 'range',
					'condition' => [
						'htmega_fe_hue_toggle' => 'yes',
						'htmega_fe' => 'yes',
					],
					'render_type' => 'none',
					'frontend_available' => true,

				)
			);

			$element->add_control(
				'htmega_fe_hue_duration',
				array(
					'label'     => __( 'Duration', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'default'   => array(
						'unit' => 'px',
						'size' => 1000,
					),

					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_hue_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);

			$element->add_control(
				'htmega_fe_hue_delay',
				array(
					'label'     => __( 'Delay', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_hue_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);
		$element->end_popover();
		// Hue end
		// Brightness start
		$element->add_control(
			'htmega_fe_brightness_toggle',
			[
				'label' => __( 'Brightness', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_filters_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();
			$element->add_control(
				'htmega_fe_brightness',
				array(
					'label'     => __( 'Value', 'htmega-pro' ),
					'type'      => Controls_Manager::SLIDER,
					'default' => [
						'sizes' => [
							'from' =>0,
							'to' => 50,
						],
						'unit' => '%',
					],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 200,
							'step' => 5
						]
					],
					'labels' => [
						__( 'From', 'htmega-pro' ),
						__( 'To', 'htmega-pro' ),
					],
					'scales' => 1,
					'handles' => 'range',
					'condition' => [
						'htmega_fe_brightness_toggle' => 'yes',
						'htmega_fe' => 'yes',
					],
					'render_type' => 'none',
					'frontend_available' => true,

				)
			);

			$element->add_control(
				'htmega_fe_brightness_duration',
				array(
					'label'     => __( 'Duration', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'default'   => array(
						'unit' => 'px',
						'size' => 1000,
					),

					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_brightness_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);

			$element->add_control(
				'htmega_fe_brightness_delay',
				array(
					'label'     => __( 'Delay', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_brightness_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);
		$element->end_popover();
		// Brightness end
		// Saturation start
		$element->add_control(
			'htmega_fe_saturation_toggle',
			[
				'label' => __( 'Saturation', 'htmega-pro' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'frontend_available' => true,
				'condition' => [
					'htmega_fe' => 'yes',
					'htmega_fe_filters_toggle' => 'yes',
				]
			]
		);

		$element->start_popover();
			$element->add_control(
				'htmega_fe_saturation',
				array(
					'label'     => __( 'Value', 'htmega-pro' ),
					'type'      => Controls_Manager::SLIDER,
					'default' => [
						'sizes' => [
							'from' =>0,
							'to' => 50,
						],
						'unit' => '%',
					],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 200,
							'step' => 5
						]
					],
					'labels' => [
						__( 'From', 'htmega-pro' ),
						__( 'To', 'htmega-pro' ),
					],
					'scales' => 1,
					'handles' => 'range',
					'condition' => [
						'htmega_fe_saturation_toggle' => 'yes',
						'htmega_fe' => 'yes',
					],
					'render_type' => 'none',
					'frontend_available' => true,

				)
			);

			$element->add_control(
				'htmega_fe_saturation_duration',
				array(
					'label'     => __( 'Duration', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'default'   => array(
						'unit' => 'px',
						'size' => 1000,
					),

					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_saturation_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);

			$element->add_control(
				'htmega_fe_saturation_delay',
				array(
					'label'     => __( 'Delay', 'htmega-pro' ) . ' (ms)',
					'type'      => Controls_Manager::SLIDER,
					'range'     => array(
						'px' => array(
							'min'  => 0,
							'max'  => 10000,
							'step' => 100,
						),
					),
					'condition' => array(
						'htmega_fe'         => 'yes',
						'htmega_fe_saturation_toggle' => 'yes',
					),
					'frontend_available' => true,
				)
			);
		$element->end_popover();

		// General Setting start
		$element->add_control(
			'htmega_fe_general_settings_heading',
			array(
				'label'     => __( 'General Settings', 'htmega-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'htmega_fe' => 'yes',
				),
			)
		);

		$element->add_control(
			'htmega_fe_direction',
			array(
				'label'     => __( 'Direction', 'htmega-pro' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'alternate',
				'options'   => array(
					'normal'    => __( 'Normal', 'htmega-pro' ),
					'reverse'   => __( 'Reverse', 'htmega-pro' ),
					'alternate' => __( 'Alternate', 'htmega-pro' ),
				),
				'condition' => array(
					'htmega_fe' => 'yes',
				),
				'frontend_available' => true,
			)
		);

		$element->add_control(
			'htmega_fe_loop',
			array(
				'label'     => __( 'Loop', 'htmega-pro' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'default',
				'options'   => array(
					'default' => __( 'Infinite', 'htmega-pro' ),
					'number'  => __( 'Custom', 'htmega-pro' ),
				),
				'condition' => array(
					'htmega_fe' => 'yes',
				),
				'frontend_available' => true,
			)
		);

		$element->add_control(
			'htmega_fe_loop_number',
			array(
				'label'     => __( 'Number', 'htmega-pro' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 3,
				'condition' => array(
					'htmega_fe' => 'yes',
					'htmega_fe_loop'     => 'number',
				),
				'frontend_available' => true,
			)
		);

		$element->add_control(
			'htmega_fe_easing',
			array(
				'label'     => __( 'Easing', 'htmega-pro' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'easeInOutSine',
				'options'   => array(
					'linear'                  => __( 'Linear', 'htmega-pro' ),
					'easeInOutSine'           => __( 'easeInOutSine', 'htmega-pro' ),
					'easeInOutExpo'           => __( 'easeInOutExpo', 'htmega-pro' ),
					'easeInOutQuart'          => __( 'easeInOutQuart', 'htmega-pro' ),
					'easeInOutCirc'           => __( 'easeInOutCirc', 'htmega-pro' ),
					'easeInOutBack'           => __( 'easeInOutBack', 'htmega-pro' ),
					'steps'                   => __( 'Steps', 'htmega-pro' ),
					'easeInElastic(1, .6)'    => __( 'Elastic In', 'htmega-pro' ),
					'easeOutElastic(1, .6)'   => __( 'Elastic Out', 'htmega-pro' ),
					'easeInOutElastic(1, .6)' => __( 'Elastic In Out', 'htmega-pro' ),
				),
				'condition' => array(
					'htmega_fe' => 'yes',
				),
				'frontend_available' => true,

			)
		);

		$element->add_control(
			'htmega_fe_ease_step',
			array(
				'label'     => __( 'Steps', 'htmega-pro' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 5,
				'condition' => array(
					'htmega_fe' => 'yes',
					'htmega_fe_easing'   => 'steps',
				),
				'frontend_available' => true,
			)
		);

		$element->end_controls_section();
	}
}

HTMegaFloatingEffects_Elementor::instance();