<?php

namespace HTMega_Pro_Builder\Elementor;
use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Controls_Stack;
use Elementor\Plugin as Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
* Widgets Control
*/
class HTMegaBuilder_Widgets_Control{

    private static $instance = null;
    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    function __construct(){
        $this->init();
    }

    // Widgets Initialize
    public function init() {

        // Add Plugin actions
        if(defined( 'ELEMENTOR_VERSION' ) && version_compare( ELEMENTOR_VERSION, '3.5.0', '>=' )){
            add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
        }else{
            add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
        }
    }

    // Widgets Register
    public function register_widgets() {

        $bl_element      = array();
        $element_manager = array();

        // Builder Element
        $bl_element  = array(
            'bl_social_share',
            'bl_print_page',
            'bl_post_navigation',
            'bl_related_post',
            'bl_popular_post',
        );
        $element_manager = array_merge( $element_manager, $bl_element );

        // Include Widget files
        foreach ( $element_manager as $element ){
            if (  ( htmega_get_option_pro( $element, 'htmega_themebuilder_element_tabs', 'on' ) === 'on' ) && file_exists(HTMEGA_ADDONS_PL_PATH_PRO.'extensions/ht-builder/widgets/'.$element.'.php' ) ){
                require( HTMEGA_ADDONS_PL_PATH_PRO.'extensions/ht-builder/widgets/'.$element.'.php' );
                $class_name = 'HTMega_Pro_Builder\Elementor\Widget\\'.$element.'_ELement';

                if(defined( 'ELEMENTOR_VERSION' ) && version_compare( ELEMENTOR_VERSION, '3.5.0', '>=' )){
                    Elementor::instance()->widgets_manager->register( new $class_name() );
                }else{
                    Elementor::instance()->widgets_manager->register_widget_type( new $class_name() );
                }

            }
        }

    }

}

HTMegaBuilder_Widgets_Control::instance();