<?php
namespace HTMega_Pro_Builder\Elementor\Widget;

use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_manager;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Bl_Print_Page_ELement extends Widget_Base {

    public function get_name() {
        return 'bl-print-page';
    }

    public function get_title() {
        return __( 'Print Page', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-document-file';
    }

    public function get_categories() {
        return ['htmega_builder'];
    }
    public function get_keywords() {
        return ['post print', 'print', 'htmega', 'ht mega', 'addons'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs';
    }
    protected function register_controls() {

        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Print Page', 'htmega-pro' ),
            ]
        );
            
            $this->add_control(
                'button_type',
                [
                    'label' => __( 'Button Type', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'icon',
                    'options' => [
                        'icon'      => __( 'Icon', 'htmega-pro' ),
                        'text'      => __( 'Text', 'htmega-pro' ),
                        'icontext'  => __( 'Icon & Text', 'htmega-pro' )
                    ],
                ]
            );

            $this->add_control(
                'icon',
                [
                    'label' => __( 'Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fa fa-print',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'button_type'=>[ 'icon','icontext' ],
                    ]
                ]
            );

            $this->add_control(
                'button_txt',
                [
                    'label' => __( 'Button Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => __( 'Button Text', 'htmega-pro' ),
                    'default' => __( 'Print', 'htmega-pro' ),
                    'condition' => [
                        'button_type'=>[ 'text','icontext' ],
                    ]
                ]
            );


        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'button_style_section',
            array(
                'label' => __( 'Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );

            $this->add_control(
                'heading_text_style',
                [
                    'label' => __( 'Text', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                ]
            );

            $this->add_control(
                'text_color',
                [
                    'label' => __( 'Text Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default'=>'#444444',
                    'selectors' => [
                        '{{WRAPPER}} .htbuilderprint a span' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'text_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htbuilderprint a span',
                ]
            );

            $this->add_control(
                'heading_icon_style',
                [
                    'label' => __( 'Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'icon_color',
                [
                    'label' => __( 'Icon Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default'=>'#444444',
                    'selectors' => [
                        '{{WRAPPER}} .htbuilderprint a i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htbuilderprint a svg path' => 'fill: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'icon_size',
                [
                    'label' => __( 'Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 16,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuilderprint a i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htbuilderprint a svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'icon_space',
                [
                    'label' => __( 'Space', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 2,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuilderprint a span' => 'margin-left: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $button_text = '';
        if( $settings['button_type'] == 'icon' ){
            $button_text = HTMega_Icon_manager::render_icon($settings['icon'], ['aria-hidden' => 'true']);
        }elseif( $settings['button_type'] == 'text' ){
            $button_text = '<span>' . wp_kses_post( $settings['button_txt'] ) .'</span>';
        }else{
            $button_text = HTMega_Icon_manager::render_icon($settings['icon'], ['aria-hidden' => 'true']).'<span>' . wp_kses_post( $settings['button_txt'] ) . '</span>';
        }
        echo '<div class="htbuilderprint"><a href="javascript:window.print()">'.$button_text.'</a></div>';

    }

}
