<?php

namespace HTMega_Pro_Builder\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Bl_Social_Share_ELement extends Widget_Base {

    public function get_name() {
        return 'bl-social-share';
    }

    public function get_title() {
        return __( 'Post Social Share', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-social-icons';
    }

    public function get_categories() {
        return ['htmega_builder'];
    }

    public function get_script_depends() {
        return [
            'goodshare',
        ];
    }
    public function get_keywords() {
        return ['social share', 'elementor social share','share button', 'social', 'share', 'facebook', 'twitter', 'instagram', 'linkedin'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs';
    }
    protected function register_controls() {

        $this->start_controls_section(
            'social_media_sheres',
            [
                'label' => __( 'Social Share', 'htmega-pro' ),
            ]
        );
        
            $repeater = new Repeater();

            $repeater->start_controls_tabs('social_content_area_tabs');

                $repeater->start_controls_tab(
                    'social_content_tab',
                    [
                        'label' => __( 'Content', 'htmega-pro' ),
                    ]
                );

                    $repeater->add_control(
                        'htbuilder_social_media',
                        [
                            'label' => __( 'Social Media', 'htmega-pro' ),
                            'type' => Controls_Manager::SELECT,
                            'default' => 'facebook',
                            'options' => [
                                'vkontakte'       => __( 'Vkontakte', 'htmega-pro' ),
                                'facebook'        => __( 'Facebook', 'htmega-pro' ),
                                'odnoklassniki'   => __( 'Odnoklassniki', 'htmega-pro' ),
                                'moimir'          => __( 'MoiMir', 'htmega-pro' ),
                                'linkedin'        => __( 'LinkedIn', 'htmega-pro' ),
                                'tumblr'          => __( 'Tumblr', 'htmega-pro' ),
                                'pinterest'       => __( 'Pinterest', 'htmega-pro' ),
                                'reddit'          => __( 'Reddit', 'htmega-pro' ),
                                'buffer'          => __( 'Buffer', 'htmega-pro' ),
                                'twitter'         => __( 'Twitter', 'htmega-pro' ),
                                'livejournal'     => __( 'LiveJournal', 'htmega-pro' ),
                                'evernote'        => __( 'Evernote', 'htmega-pro' ),
                                'delicious'       => __( 'Delicious', 'htmega-pro' ),
                                'flipboard'       => __( 'Flipboard', 'htmega-pro' ),
                                'pocket'          => __( 'Pocket', 'htmega-pro' ),
                                'mix'             => __( 'Mix', 'htmega-pro' ),
                                'meneame'         => __( 'Meneame', 'htmega-pro' ),
                                'blogger'         => __( 'Blogger', 'htmega-pro' ),
                                'instapaper'      => __( 'Instapaper', 'htmega-pro' ),
                                'digg'            => __( 'Digg', 'htmega-pro' ),
                                'liveinternet'    => __( 'LiveInternet', 'htmega-pro' ),
                                'surfingbird'     => __( 'Surfingbird', 'htmega-pro' ),
                                'xing'            => __( 'Xing', 'htmega-pro' ),
                                'wordpress'       => __( 'WordPress', 'htmega-pro' ),
                                'baidu'           => __( 'Baidu', 'htmega-pro' ),
                                'renren'          => __( 'RenRen', 'htmega-pro' ),
                                'weibo'           => __( 'Weibo', 'htmega-pro' ),
                                'sms'             => __( 'SMS', 'htmega-pro' ),
                                'skype'           => __( 'Skype', 'htmega-pro' ),
                                'telegram'        => __( 'Telegram', 'htmega-pro' ),
                                'viber'           => __( 'Viber', 'htmega-pro' ),
                                'whatsapp'        => __( 'WhatsApp', 'htmega-pro' ),
                                'wechat'          => __( 'WhatsApp', 'htmega-pro' ),
                                'line'            => __( 'Line', 'htmega-pro' ),
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'htbuilder_social_title',
                        [
                            'label'   => esc_html__( 'Title', 'htmega-pro' ),
                            'type'    => Controls_Manager::TEXT,
                            'default' => esc_html__( 'Facebook', 'htmega-pro' ),
                        ]
                    );

                    $repeater->add_control(
                        'htbuilder_social_icon',
                        [
                            'label'   => esc_html__( 'Icon', 'htmega-pro' ),
                            'type'    => Controls_Manager::ICONS,
                            'default' => [
                                'value' => 'fab fa-facebook-f',
                                'library' => 'fa-solid',
                            ],
                            'recommended' => [
                                'fa-brands' => [
                                    'facebook',
                                    'facebook-f',
                                    'facebook-messenger',
                                    'facebook-square',
                                    'twitter',
                                    'twitter-square',
                                    'linkedin',
                                    'linkedin-in',
                                    'whatsapp',
                                    'whatsapp-square',
                                    'pinterest',
                                    'fa-pinterest-p',
                                    'pinterest-square',
                                    'blogger',
                                    'blogger-b',
                                    'skype',
                                    'telegram',
                                    'telegram-plane',
                                    'line',
                                ],
                            ],                            
                        ]
                    );

                $repeater->end_controls_tab(); // Content tab end

                $repeater->start_controls_tab(
                    'social_rep_style',
                    [
                        'label' => __( 'Style', 'htmega-pro' ),
                    ]
                );

                    $repeater->add_control(
                        'normal_style_heading',
                        [
                            'label' => __( 'Normal Style', 'htmega-pro' ),
                            'type' => Controls_Manager::HEADING,
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_control(
                        'social_text_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}} svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'social_rep_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}',
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_rep_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}',
                        ]
                    );

                    $repeater->add_control(
                        'hover_style_heading',
                        [
                            'label' => __( 'Hover Style', 'htmega-pro' ),
                            'type' => Controls_Manager::HEADING,
                        ]
                    );


                    $repeater->add_control(
                        'social_text_hover_color',
                        [
                            'label'     => __( 'Hover color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}:hover svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'social_rep_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}:hover',
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_rep_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}:hover',
                        ]
                    );

                $repeater->end_controls_tab();// End Style tab

                // Start Icon tab
                $repeater->start_controls_tab(
                    'social_rep_icon_style',
                    [
                        'label' => __( 'Icon Style', 'htmega-pro' ),
                    ]
                );
                    
                    $repeater->add_control(
                        'normal_style_icon_heading',
                        [
                            'label' => __( 'Normal Style', 'htmega-pro' ),
                            'type' => Controls_Manager::HEADING,
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_control(
                        'social_icon_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}} i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}} svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'social_rep_icon_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}} i',
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_rep_icon_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}} i',
                        ]
                    );

                    $repeater->add_responsive_control(
                        'social_rep_icon_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}} i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator'=>'after',
                        ]
                    );

                    $repeater->add_control(
                        'hover_style_icon_heading',
                        [
                            'label' => __( 'Hover Style', 'htmega-pro' ),
                            'type' => Controls_Manager::HEADING,
                        ]
                    );


                    $repeater->add_control(
                        'social_icon_hover_color',
                        [
                            'label'     => __( 'Hover color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}:hover i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}:hover svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'social_rep_icon_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}:hover i',
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_rep_icon_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htbuilder-social-share {{CURRENT_ITEM}}:hover i',
                        ]
                    );

                $repeater->end_controls_tab();// End icon Style tab

            $repeater->end_controls_tabs();// Repeater Tabs end

            $this->add_control(
                'htbuilder_socialmedia_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'htbuilder_social_media' => 'facebook',
                            'htbuilder_social_title' => __( 'Facebook', 'htmega-pro' ),
                            'htbuilder_social_icon' => [
                                'value' => 'fab fa-facebook-f',
                                'library' => 'fa-solid',
                            ]
                        ],
                        [
                            'htbuilder_social_media' => 'twitter',
                            'htbuilder_social_title' => __( 'Twitter', 'htmega-pro' ),
                            'htbuilder_social_icon' => [
                                'value' => 'fab fa-twitter',
                                'library' => 'fa-solid',
                            ]
                        ],
                        [
                            'htbuilder_social_media' => 'linkedin',
                            'htbuilder_social_title' => __( 'Linkedin', 'htmega-pro' ),
                            'htbuilder_social_icon' => [
                                'value' => 'fab fa-linkedin',
                                'library' => 'fa-solid',
                            ]
                        ],
                    ],
                    'title_field' => '{{{ htbuilder_social_title }}}',
                ]
            );

        $this->end_controls_section();

        // Advance Options
        $this->start_controls_section(
            'social_media_sheres_advance_opt',
            [
                'label' => __( 'Advance Options', 'htmega-pro' ),
            ]
        );
            
            $this->add_control(
                'social_view',
                [
                    'label' => esc_html__( 'View', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => false,
                    'options' => [
                        'icon'       => 'Icon',
                        'title'      => 'Title',
                        'icon-title' => 'Icon & Title',
                    ],
                    'default'      => 'icon',
                ]
            );

            $this->add_control(
                'show_label',
                [
                    'label'        => esc_html__( 'Title', 'htmega-pro' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Show', 'htmega-pro' ),
                    'label_off'    => esc_html__( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default'      => 'yes',
                    'condition'    => [
                        'social_view' => 'icon-text',
                    ],
                ]
            );

            $this->add_control(
                'show_counter',
                [
                    'label'        => esc_html__( 'Count', 'htmega-pro' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Show', 'htmega-pro' ),
                    'label_off'    => esc_html__( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'condition'    => [
                        'social_view!' => 'icon',
                    ],
                ]
            );

        $this->end_controls_section();// End Advance Options

        // Style tab section
        $this->start_controls_section(
            'htbuilder_socialshere_style_section',
            [
                'label' => __( 'Item List', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'social_shere_color',
                [
                    'label'     => __( 'Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htbuilder-social-share ul li' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htbuilder-social-share ul li svg path' => 'fill: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .htbuilder-social-share ul li span',
                    'condition'    => [
                        'social_view!' => 'icon',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'social_shere_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htbuilder-social-share li',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'social_shere_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htbuilder-social-share li',
                ]
            );

            $this->add_responsive_control(
                'social_shere_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htbuilder-social-share li' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'social_shere_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuilder-social-share ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                ]
            );

            $this->add_responsive_control(
                'social_shere_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuilder-social-share ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
            'socialshere_icon_style_section',
            [
                'label' => esc_html__( 'Icon', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'social_view' => array( 'icon-title','icon'),
                ]
            ]
        );
        $this->add_control(
            'icon_fontsize',
            [
                'label' => __( 'Icon Font Size', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htbuilder-social-share ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .htbuilder-social-share ul li svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_height',
            [
                'label' => __( 'Icon Height', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 42,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htbuilder-social-share ul li' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_width',
            [
                'label' => __( 'Icon Width', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 42,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htbuilder-social-share ul li' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color_border_heading',
            [
                'label' => __( 'Colors and Border', 'htmega-addons' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs(
            'style_tabs_icon'
        );
            // Normal Style Tab
            $this->start_controls_tab(
                'icon_style_normal_tab',
                [
                    'label' => esc_html__( 'Normal', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'social_shere_icon_color',
                [
                    'label'     => __( 'Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htbuilder-social-share ul li i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htbuilder-social-share ul li svg path' => 'fill: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'social_icon_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htbuilder-social-share li',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'social_icon_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htbuilder-social-share li',
                ]
            );

            $this->add_responsive_control(
                'social_icon_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htbuilder-social-share li' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->end_controls_tab();

            // Hover Style Tab
            $this->start_controls_tab(
                'filter_menu_hover_tab',
                [
                    'label' => esc_html__( 'Hover', 'htmega-pro' ),
                ]
            );

                $this->add_control(
                    'social_shere_icon_color_hover',
                    [
                        'label'     => __( 'color', 'htmega-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htbuilder-social-share ul li:hover i' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .htbuilder-social-share ul li:hover svg path' => 'fill: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'social_icon_background_hover',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htbuilder-social-share li:hover',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'social_icon_border_hover',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htbuilder-social-share li:hover',
                    ]
                );

                $this->add_responsive_control(
                    'social_icon_radius_hover',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htbuilder-social-share li:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();

        $this->add_render_attribute( 'htbuilder_socialshere', 'class', 'htbuilder-social-share' );
        if( $settings['social_view'] == 'icon-title' || $settings['social_view'] == 'title' ){
            $this->add_render_attribute( 'htbuilder_socialshere', 'class', 'htbuilder-social-view-' . esc_attr( $settings['social_view'] ) );
        }
             
        ?>
            <div <?php echo $this->get_render_attribute_string( 'htbuilder_socialshere' ); ?> >
                <ul>
                    <?php 
                    if ( $settings['htbuilder_socialmedia_list'] ) {
                    
                    foreach ( $settings['htbuilder_socialmedia_list'] as $socialmedia ) : ?>
                        <li class="elementor-repeater-item-<?php echo esc_attr( $socialmedia['_id'] ); ?>" data-social="<?php echo esc_attr( $socialmedia['htbuilder_social_media'] ); ?>" > 
                            <?php
                                if( $settings['social_view'] == 'icon' ){
                                    echo HTMega_Icon_manager::render_icon($socialmedia['htbuilder_social_icon'], ['aria-hidden' => 'true']);
                                }elseif( $settings['social_view'] == 'title' ){
                                    echo sprintf('<span>%1$s</span>', esc_html( $socialmedia['htbuilder_social_title'] ) );
                                }else{
                                    echo sprintf('%1$s<span>%2$s</span>', HTMega_Icon_manager::render_icon($socialmedia['htbuilder_social_icon'], ['aria-hidden' => 'true']), esc_html( $socialmedia['htbuilder_social_title'] ) );
                                }
                                if( $settings['show_counter'] == 'yes' ){
                                    echo '<span class="htbuilder-share-counter" data-counter="' . esc_attr( $socialmedia['htbuilder_social_media'] ) . '"></span>';
                                }
                            ?>
                        </li>
                    <?php endforeach;
                    }
                    ?>
                </ul>
            </div>
        <?php

    }

    

}
