<?php 
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Control_Media;


class HTMegaParticles_Elementor {
	private static $assets_load = null;

    private static $_instance = null;
    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
    public function __construct() {

		// Creates  Particles tab at the end of section/column layout tab.
        add_action( 'elementor/element/section/section_layout/after_section_end', array( $this, 'register_controls' ), 10 );
        add_action( 'elementor/element/container/section_layout/after_section_end', array( $this, 'register_controls' ), 10 );
        add_action( 'elementor/element/column/section_advanced/after_section_end', array( $this, 'register_controls' ), 10 );

        // Print template for editor
        add_action( 'elementor/section/print_template', array( $this, '_print_template' ), 10, 2 );
        add_action( 'elementor/container/print_template', array( $this, '_print_template' ), 10, 2 );
        add_action( 'elementor/column/print_template', array( $this, '_print_template' ), 10, 2 );

        // Add data before rendering
        add_action( 'elementor/frontend/section/before_render', array( $this, 'before_render' ), 10, 1 );
        add_action( 'elementor/frontend/container/before_render', array( $this, 'before_render' ), 10, 1 );
        add_action( 'elementor/frontend/column/before_render', array( $this, 'before_render' ), 10, 1 );
        
        add_action( 'elementor/preview/enqueue_scripts', array( $this, 'enqueue_scripts' ) );
        add_action( 'elementor/preview/enqueue_styles', array( $this, 'enqueue_styles' ) );
        add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
        add_action( 'elementor/frontend/before_enqueue_styles', array( $this, 'enqueue_styles' ) );

        add_action( 'elementor/frontend/section/before_render', array( $this, 'check_assets_enqueue' ) );
        add_action( 'elementor/frontend/container/before_render', array( $this, 'check_assets_enqueue' ) );
        add_action( 'elementor/frontend/column/before_render', array( $this, 'check_assets_enqueue' ) );

    }

	/**
	 * Enqueue styles.
	 *
	 * Registers required dependencies for the extension and enqueues them.
	 *
	 * @since 1.4.9
	 * @access public
	 */
	public static function enqueue_styles() {
		//CSS File
		wp_enqueue_style(  'htmega-particles',  HTMEGA_ADDONS_PL_URL_PRO . 'extensions/particles/assets/css/htmega-particles.css', array(), HTMEGA_VERSION_PRO );
	}

	/**
	 * Enqueue scripts.
	 *
	 * Enqueue required JS dependencies for the extension.
	 *
	 * @since 1.4.0
	 * @access public
	 */
	public static function enqueue_scripts() {
        // JS File
        wp_enqueue_script( 'particles', HTMEGA_ADDONS_PL_URL_PRO . 'extensions/particles/assets/js/particles.min.js', array('jquery'),'2.0.0' );
        wp_enqueue_script( 'htmega-particles', HTMEGA_ADDONS_PL_URL_PRO . 'extensions/particles/assets/js/htmega-particles.js', array('jquery'),HTMEGA_VERSION_PRO );

	}

	 //Register Particles controls.
	public function register_controls( $element ) {

		$element->start_controls_section(
			'section_htmega_particles',
			[
				'label' => __( 'HT Mega Particles', 'htmega-pro' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			]
		);
		$element->add_control(
			'htmega_particle_switcher',
			[
				'label'        => __( 'Enable Particles', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'htmega-particles-',
				'render_type'  => 'template',
			]
		);
		$element->add_control (
			'particles_style',
			[
				'label' => __( 'Select Style', 'htmega-pro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'pre_build',
				'options' => [
					'custom'  => __( 'Custom', 'htmega-pro' ),
					'pre_build' => __( 'Pre Build', 'htmega-pro' ),
				],
				'condition' => [
					'htmega_particle_switcher' => 'yes'
				]
			]
		);

		$element->add_control(
			'particles_code',
			[
				'type'        => Controls_Manager::CODE,
				'label'       => esc_html__( 'Enter Custom JSON', 'htmega-pro' ),
				'default'     => '',
				'render_type' => 'template',
				'description'   => sprintf( // translators: 1: Link to particles.js website, 2: Closing anchor tag
					esc_html__('You can generate custom json from %1$s here %2$s  to set particles', 'htmega-pro'),
					'<a href="https://vincentgarreau.com/particles.js/" target="_blank">',
					'</a>'
				),
				'condition'   => [
					'particles_style' => 'custom',
					'htmega_particle_switcher' => 'yes'
				],
			]
		);
        $element->add_control(
            'particles_pre_build_code',
            [
                'label' => esc_html__('Pre Build JSON', 'htmega-pro'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    'default' => __('Default', 'htmega-pro'),
                    'nasa' => __('Nasa', 'htmega-pro'),
                    'bubble' => __('Bubble', 'htmega-pro'),
                    'snow' => __('Snow', 'htmega-pro'),
                    'nyan_cat' => __('Nyan Cat', 'htmega-pro'),
                ],
                'default' => 'default',
				'condition'   => [
					'particles_style' => 'pre_build',
					'htmega_particle_switcher' => 'yes'
				],
            ]
        );
		$element->add_control(
			'particles_zindex',
			[
				'label'   => __( 'Z-Index', 'htmega-pro' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 0,
				'condition'   => [
					'htmega_particle_switcher' => 'yes'
				],
			]
		);
		$element->add_control(
			'particles_notice',
			[
				'raw'             => __( 'To better view of particles, add background color from the <b>Style Tab</b>', 'htmega-pro' ),
				'type'            => Controls_Manager::RAW_HTML,
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				'condition'   => [
					'htmega_particle_switcher' => 'yes'
				],
			]
		);
		$element->add_control(
			'particle_hide_on_tablet',
			[
				'label'        => __( 'Hide On Tablet', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' =>'no',
				'condition'   => [
					'htmega_particle_switcher' => 'yes'
				],
			]
		);
		$element->add_control(
			'particle_hide_on_mobile',
			[
				'label'        => __( 'Hide On Mobile', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' =>'no',
				'condition'   => [
					'htmega_particle_switcher' => 'yes'
				],
			]
		);
		$element->end_controls_section();

	}

	/**
	 * Render Editor Particles output.
	 *
	 *
	 * @since 1.4.9
	 * @access public
	 * 
	 * @param object $template for current template.
	 * @param object $widget for current widget.
	 */
	public function _print_template( $template, $widget ) {

		//$settings = get_settings_for_display();

		
		if ( $widget->get_name() === 'widget' ) {
			return $template;
		}
		ob_start();
		
		echo '<div class="htmega-particle-wrapper" id="htmega-particle-id-{{ view.getID() }}" data-particles-style="{{ settings.particles_style }}" data-particle-source="{{ settings.particles_code }}" data-zindex="{{ settings.particles_zindex }}" data-particles-pre-build-code="{{settings.particles_pre_build_code}}" data-hide-on-tablet="{{settings.particle_hide_on_tablet}}" data-hide-on-mobile="{{settings.particle_hide_on_mobile}}"></div>';
		$particles_content = ob_get_contents();
		ob_end_clean();

		return $template . $particles_content;

	}

	/**
	 * Render HTML output on the frontend.
	 *
	 * Written in PHP and used to generate the final Output.
	 *
	 * @since 1.4.9
	 * @access public
	 * @param object $element for current element.
	 */
	public function before_render( $element ) {

		$settings = $element->get_settings_for_display();
		$sectionid = $element->get_id();

		if ( 'yes' == $settings['htmega_particle_switcher'] ) {
			$element->add_render_attribute( '_wrapper', [
				'data-particles-style' => $settings['particles_style'],
				'data-particle-source' => ($settings['particles_code']) ? $settings['particles_code']:'',
				'data-particles-pre-build-code' => $settings['particles_pre_build_code'],
				'data-zindex' => $settings['particles_zindex'],
				'data-hide-on-tablet' => $settings['particle_hide_on_tablet'],
				'data-hide-on-mobile' => $settings['particle_hide_on_mobile'],
				'data-zindex' => $settings['particles_zindex'],
				'id' => "htmega-particle-id-{$sectionid}",
			] );
		}
	}


	 //Check Assets Enqueue
	public function check_assets_enqueue( $element ) {
		if ( self::$assets_load ) {
			return;
		}
		if ( 'yes' === $element->get_settings_for_display( 'htmega_particle_switcher' ) ) {
			$this->enqueue_styles();
			$this->enqueue_scripts();
			self::$assets_load = true;
			remove_action( 'elementor/frontend/section/before_render', array( $this, 'check_assets_enqueue' ) );
			remove_action( 'elementor/frontend/container/before_render', array( $this, 'check_assets_enqueue' ) );
			remove_action( 'elementor/frontend/column/before_render', array( $this, 'check_assets_enqueue' ) );
		}
	}
}


HTMegaParticles_Elementor::instance();