<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;
use Elementor\HTMega_Icon_Manager;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Category_List_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-category-list-addons';
    }
    
    public function get_title() {
        return __( 'Category List', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-bullet-list';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

	public function get_keywords() {
        return [ 'htmega', 'ht mega', 'taxonomy', 'terms', 'category','category list','post category','htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/category-list-widget/';
	}

    protected function register_controls() {
		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__( 'Category List', 'htmega-pro' ),
			]
		);

		$this->add_control(
			'category_layout',
			[
				'label' => esc_html__( 'Layout', 'htmega-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'inherit',
				'options' => [
					'inherit' => [
						'title' => esc_html__( 'Inline', 'htmega-pro' ),
						'icon' => 'eicon-ellipsis-h',
					],
					'column' => [
						'title' => esc_html__( 'Default', 'htmega-pro' ),
						'icon' => 'eicon-editor-list-ul',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .htmega-category-list.htmega-category-list' => '-webkit-flex-direction: {{VALUE}};-ms-flex-direction: {{VALUE}};flex-direction: {{VALUE}};',
				],
			]
		);

		//Local Function Repeater Catagory 
		$this->show_repeater_catagory();

		$this->add_control(
			'open_new_tab',
			[
				'label'        => __( 'Open Link in New Tab?', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'ON', 'htmega-pro' ),
				'label_off'    => __( 'OFF', 'htmega-pro' ),
				'description' => __('Turn on this switcher to open the link in a new tab.','htmega-pro'),
				'return_value' => 'yes',
				'default'      => 'no',
				'separator' => 'before',

			]
		);
		$this->add_control(
			'show_item_count',
			[
				'label'        => __( 'Show Posts Count', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'ON', 'htmega-pro' ),
				'label_off'    => __( 'OFF', 'htmega-pro' ),
				'description' => __('Turn on this switcher to display the post count for each category.','htmega-pro'),
				'return_value' => 'yes',
				'default'      => 'no',

			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__( 'General', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'category_align',
			[
				'label' => __( 'Alignment', 'htmega-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'htmega-pro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'htmega-pro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'htmega-pro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .htmega-category-list' => 'justify-content: {{VALUE}};',
				],
				'prefix_class' => 'elementor%s-align-',
			]
		);

		$this->add_responsive_control(
			'space_between',
			[
				'label' => esc_html__( 'Space Between', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .htmega-category-list-wrap .htmega-category-list-item' => 'margin: 0 {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'category_menu_width',
			[
				'label' => esc_html__( 'Column Width', 'htmega-pro' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .htmega-category-list.htmega-category-list' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'category_layout' => 'column',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_text_style',
			[
				'label' => esc_html__( 'Category', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->start_controls_tabs('category_style_tabs');

			// Category Normal tab Start
			$this->start_controls_tab(
				'category_style_normal_tab',
				[
					'label' => __( 'Normal', 'htmega-pro' ),
				]
			);
				$this->add_control(
					'htmega_category_text_color',
					[
						'label'     => __( 'Text Color', 'htmega-pro' ),
						'type'      => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .htmega-category-list-link' => 'color: {{VALUE}};',
						],
					]
				);

				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'category_background',
						'label' => __( 'Background', 'htmega-pro' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => '{{WRAPPER}} .htmega-category-list-link',
					]
				);

				$this->add_group_control(
					Group_Control_Typography::get_type(),
					[
						'name' => 'category_typography',
						'label' => __( 'Typography', 'htmega-pro' ),
						'selector' => '{{WRAPPER}} .htmega-category-list-link',
					]
				);

				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'category_border',
						'label' => __( 'Border', 'htmega-pro' ),
						'selector' => '{{WRAPPER}} .htmega-category-list-link',
					]
				);

				$this->add_responsive_control(
					'category_border_radius',
					[
						'label' => __( 'Border Radius', 'htmega-pro' ),
						'type' => Controls_Manager::DIMENSIONS,
						'selectors' => [
							'{{WRAPPER}} .htmega-category-list-link, {{WRAPPER}} .htmega-category-list-link::before' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
						],
					]
				);

				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'box_shadow',
						'label' => __( 'Box Shadow', 'htmega-pro' ),
						'selector' => '{{WRAPPER}} .htmega-category-list-link',
						'separator' => 'before',
					]
				);

				$this->add_responsive_control(
					'category_padding',
					[
						'label' => __( 'Padding', 'htmega-pro' ),
						'type' => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em' ],
						'selectors' => [
							'{{WRAPPER}} .htmega-category-list-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
						],
						'separator' => 'before',
					]
				);

				$this->add_responsive_control(
					'category_margin',
					[
						'label' => __( 'Margin', 'htmega-pro' ),
						'type' => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em' ],
						'selectors' => [
							'{{WRAPPER}} .htmega-category-list-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
						'separator' => 'before',
					]
				);

			$this->end_controls_tab(); // Category Normal tab end

			// Category Hover tab start
			$this->start_controls_tab(
				'category_style_hover_tab',
				[
					'label' => __( 'Hover', 'htmega-pro' ),
				]
			);

				$this->add_control(
					'htmega_categoryhover_text_color',
					[
						'label'     => __( 'Text Color', 'htmega-pro' ),
						'type'      => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .htmega-category-list-link:hover' => 'color: {{VALUE}};',
						],
					]
				);

				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'categoryhover_background',
						'label' => __( 'Background', 'htmega-pro' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => '{{WRAPPER}} .htmega-category-list-link:hover,{{WRAPPER}} .htmega-category-list-link:hover:before',
					]
				);

				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'categoryhover_border',
						'label' => __( 'Border', 'htmega-pro' ),
						'selector' => '{{WRAPPER}} .htmega-category-list-link:hover',
					]
				);

				$this->add_responsive_control(
					'categoryhover_border_radius',
					[
						'label' => __( 'Border Radius', 'htmega-pro' ),
						'type' => Controls_Manager::DIMENSIONS,
						'selectors' => [
							'{{WRAPPER}} .htmega-category-list-link:hover, {{WRAPPER}} .htmega-category-list-link:hover:before' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
						],
					]
				);

				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'boxhover_shadow',
						'label' => __( 'Box Shadow', 'htmega-pro' ),
						'selector' => '{{WRAPPER}} .htmega-category-list-link:hover',
						'separator' => 'before',
					]
				);                    

			$this->end_controls_tab(); // Category Hover tab end

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'icon_color',
				[
					'label' => esc_html__( 'Color', 'htmega-pro' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .htmega-category-list-link i' => 'color: {{VALUE}};',
						'{{WRAPPER}} .category-svg-icon svg path'	=> 'stroke: {{VALUE}}; fill: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'icon_color_hover',
				[
					'label' => esc_html__( 'Hover', 'htmega-pro' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .htmega-category-list-link:hover i' => 'color: {{VALUE}};',
						'{{WRAPPER}} .htmega-category-list-link:hover .category-svg-icon svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_size',
				[
					'label' => esc_html__( 'Size', 'htmega-pro' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 10,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .category-svg-icon svg' => 'width: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .htmega-category-list-link i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_gap',
				[
					'label' => esc_html__( 'Gap', 'htmega-pro' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 5,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .htmega-category-list-link .category-svg-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .htmega-category-list-link i' => 'margin-right: {{SIZE}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();
	}

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();  
		$post_type =  isset( $settings['post_type'] ) ? $settings['post_type'] : 'post';
        $post_categorys = isset( $settings[ $post_type.'_post_category'] ) ? $settings[ $post_type.'_post_category'] : [];
		$category_name =  get_object_taxonomies( $post_type );
		?>

		<div class="htmega-category-list-wrap htmega-category-list-wrap-4">
            <div class="container">
                <!-- Category List Item Start -->
                <ul class="htmega-category-list htmega-category-list-4">
					<?php
					if ( $settings['categories_source'] ==  'group' ) {

						if ( $post_categorys ) {
							if ( in_array( "product_type", $category_name ) ) {
								$category_name['0'] = 'product_cat';
							}
							$icons = HTMega_Icon_Manager::render_icon( $settings['category_list_icon'], [ 'aria-hidden' => 'true' ] );
							
							if($settings['category_list_icon']['library'] == 'svg'){
								$icons = "<span class='category-svg-icon'>".$icons."</span>";
							}
							
								foreach( $post_categorys as $key=> $category ) :
									$term = get_term_by('slug', $category, $category_name[0]);
									$catagory_name = $term->name;
									$category_count = $term->count;
								if( isset( $category ) ) {
									$Url = get_term_link( $term->term_id, $category_name[0] ); ?>
									<li class="htmega-category-list-item htmega-category-<?php echo esc_attr( $category ); ?>">
										<a href="<?php echo esc_url( $Url ) ?>" <?php echo ( 'yes' == $settings['open_new_tab']) ? "target='_blank'" : ""; ?> class="htmega-category-list-link"><?php echo ( 'yes' == $settings['show_item_count'] ) ? ( $icons . " " . esc_html( $catagory_name ) . ' (' . esc_html( $category_count ) . ')' ) : ( $icons . " " . esc_html( $catagory_name ) ); ?></a>
									</li>
								<?php }else{ ?>
									<li class="htmega-category-list-item htmega-category-no-category">
										<a class="htmega-category-list-link"><?php echo esc_html__( "Please Select Category", 'htmega-pro' ) ?></a>
									</li>
								<?php }
									
							endforeach;
						}
						
					} else {
						if ( $settings['category_list'] ) {
						foreach( $settings['category_list'] as $category ): 
						
							$icons = HTMega_Icon_Manager::render_icon( $category['icons'], [ 'aria-hidden' => 'true' ] );
							
							if($category['icons']['library'] == 'svg'){
								$icons = "<span class='category-svg-icon'>".$icons."</span>";
							}

							if(empty($category['taxonomy_name']) ){
								$category['taxonomy_name'] = 'post';
							}

							$slug = $category["{$category['taxonomy_name']}_catagory__link"];

							if(empty($slug )){
								$slug = 'uncategorized';
							}

							$taxonomyName = get_object_taxonomies( $category['taxonomy_name'] );
							if ( in_array( "product_type", $taxonomyName ) ) {
								$taxonomyName['0'] = 'product_cat';
							}

							$categoryObject = get_term_by('slug', $slug, $taxonomyName[0]);
							if( isset( $categoryObject->term_id ) ) {
								$Url = get_term_link( $categoryObject->term_id, $taxonomyName[0] ); ?>
								<li class="htmega-category-list-item elementor-repeater-item-<?php echo esc_attr( $category['_id'] ) ?>">
									<a href="<?php echo esc_url( $Url ) ?>" <?php echo ( $settings['open_new_tab'] == 'yes' ) ? "target='_blank'" : ""; ?> class="htmega-category-list-link"><?php echo ( 'yes' == $settings['show_item_count'] ) ? ( $icons." ".esc_html( ($category['custom_category_name'] == "") ? $categoryObject->name: $category['custom_category_name']) . ' (' . esc_html( $categoryObject->count ) . ')' ) : ( $icons." ".esc_html( ($category['custom_category_name'] == "") ? $categoryObject->name: $category['custom_category_name']) ); ?></a>
								</li>
							<?php }else{ ?>
								<li class="htmega-category-list-item elementor-repeater-item-<?php echo esc_attr( $category['_id'] ); ?>">
									<a class="htmega-category-list-link"><?php echo esc_html__( "Please Select Category", 'htmega-pro' ) ?></a>
								</li>
							<?php }
								
						endforeach; 
						}
					}
					?>                    
                </ul> <!-- Category List Item End -->
            </div>
        </div>

		<?php
    }
	public function show_repeater_catagory(){
		$this->add_control(
			'categories_source',
			[
				'label' => __( 'Selection Type', 'htmega-pro' ),
				'type'    => Controls_Manager::SELECT,
                    'default' => 'individual',
                    'options' => [
                        'individual'    => __( 'Individual', 'htmega-pro' ),
                        "group" => __( 'Group', 'htmega-pro' ),
                    ],
			]
		);
        $this->add_control(
            'post_type',
            [
                'label' => esc_html__( 'Post Type', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => htmega_get_terms_post_types(),
                'default' =>'post',
                'frontend_available' => true,
                'separator' => 'before',
				'condition' => [
					'categories_source'=> 'group'
				]
            ]
        );

        $texnomy_list_g = htmega_get_terms_post_types();
        foreach( $texnomy_list_g as $texnomykey => $texnomyValue ){
            
            $this->add_control(
                "{$texnomykey}_post_category",
                [
                    'label' => esc_html__( 'Select Categories', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => all_object_taxonomie_show_catagory($texnomykey),
                    'condition' => [
                        'post_type' => $texnomykey,
						'categories_source'=> 'group'
                    ],
                ]
            );
        }

		$this->add_control(
			'category_list_icon',
			[
				'label' => esc_html__( 'Icon', 'htmega-pro' ),
				'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-check',
                    'library' => 'fa-solid',
                ],
				'label_block' => true,
				'condition' => [
					'categories_source'=> 'group'
				],
			]
		);	

		$repeater = new Repeater();

		$repeater->add_control(
			'custom_category_name',
			[
				'label' => esc_html__( 'Category Name', 'htmega-pro' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Custom Category Name', 'htmega-pro' ),
			]
		);

		$repeater->add_control(
			'taxonomy_name',
			[
				'label' => esc_html__( 'Content Source', 'htmega-pro' ),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'options' => htmega_get_terms_post_types(),
				'default' => 'post',
			]
		);

		$texnomy_list = htmega_get_terms_post_types();

		foreach($texnomy_list as $texnomykey => $texnomyValue){

			$repeater->add_control(
				"{$texnomykey}_catagory__link",
				[
					'label' => esc_html__( 'Chose Category', 'htmega-pro' ),
					'type' => Controls_Manager::SELECT2,
					'label_block' => true,
					'options' => all_object_taxonomie_show_catagory($texnomykey),
					'condition' => [
						'taxonomy_name' => $texnomykey,
					],
					'default' => 'uncategorized',
				]
			);
		}

		$repeater->add_control(
			'icons',
			[
				'label' => esc_html__( 'Icon', 'htmega-pro' ),
				'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-check',
                    'library' => 'fa-solid',
                ],
				'label_block' => true,
			]
		);	

		$repeater->start_controls_tabs('rep_category_style_tabs');

			$repeater->start_controls_tab(
				'rep_category_style_normal_tab',
				[
					'label' => __( 'Normal', 'htmega-pro' ),
					
				]
			);
		
				$repeater->add_control(
					'rep_category_menu_color',
					[
						'label' => esc_html__( 'Color', 'htmega-pro' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .htmega-category-list-4 {{CURRENT_ITEM}} .htmega-category-list-link' => 'color: {{VALUE}}',
						],
					]
				);
		
				$repeater->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'rep_category_menu_background',
						'label' => esc_html__( 'Background', 'htmega-pro' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => '{{WRAPPER}} .htmega-category-list-4 {{CURRENT_ITEM}} .htmega-category-list-link',
					]
				);
			$repeater->end_controls_tab();
		
		
			$repeater->start_controls_tab(
				'rep_category_style_hover_tab',
				[
					'label' => __( 'Hover', 'htmega-pro' ),
				]
			);

				$repeater->add_control(
					'rep_category_menu_color_hover',
					[
						'label' => esc_html__( 'Color', 'htmega-pro' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .htmega-category-list-4 {{CURRENT_ITEM}} .htmega-category-list-link:hover' => 'color: {{VALUE}}',
						],
					]
				);
		
				$repeater->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'rep_category_menu_background_hover',
						'label' => esc_html__( 'Background', 'htmega-pro' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => '{{WRAPPER}} .htmega-category-list-4 {{CURRENT_ITEM}} .htmega-category-list-link:hover',
					]
				);
		
			$repeater->end_controls_tab();
			
		$repeater->end_controls_tabs();

		$this->add_control(
			'category_list',
			[
				'label' => esc_html__( 'Add Categories', 'htmega-pro' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'taxonomy_name' => 'post',
						'post_catagory__link' => 'uncategorized'
					],
				],
				'title_field' => '<i class="{{ icons.value }}" aria-hidden="true"></i> {{{ custom_category_name }}}',
				'condition' => [
					'categories_source'=> 'individual'
				]
			]
		);
	}

}