<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\HTMega_Icon_manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Chart_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-chart-addons';
    }
    
    public function get_title() {
        return __( 'Chart', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon htmega-chart-img';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_script_depends() {
        return [ 'echarts' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'chart', ' pie chart','line chart','doughnut','doughnut round','nightingale','htmega pro','bar'];
    }
    
    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        // Data Source
        $this->start_controls_section(
            'chart_data_section',
                [
                    'label' => __( 'Data Source', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'chart_type',
                [
                    'label' => __( 'Chart Type', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'pie',
                    'options' => [
                        'line'      => __( 'Line', 'htmega-pro' ),
                        'bar'      => __( 'Bar', 'htmega-pro' ),
                        'bar_h'      => __( 'Horizontal Bar', 'htmega-pro' ),
                        'pie'      => __( 'Pie', 'htmega-pro' ),
                        'doughnut'      => __( 'Doughnut', 'htmega-pro' ),
                        'doughnut_round'      => __( 'Doughnut With rounded corner', 'htmega-pro' ),
                        'nightingale_chart'      => __( 'Nightingale Chart', 'htmega-pro' ),
                    ],
                    
                ]
            );

            $this->add_control(
                'bar_x_axis_labels',
                array(
                    'label'              => __( 'Data Labels', 'htmega-pro' ),
                    'type'               => Controls_Manager::TEXT,
                    'dynamic'            => array( 'active' => true ),
                    'default'            => __('Mon,Tue,Wed,Thu,Fri,Sat,Sun','htmega-pro'),
                    'description'        => __( 'Enter labels for X-Axis separated by \' , \' (Mon,Tue,Wed,Thu,Fri,Sat,Sun)', 'htmega-pro' ),
                    'label_block'        => true,
                    'condition'          => array(
                        'chart_type' =>array('bar','bar_h'),
                    ),
                )
            );

            $repeater_line = new Repeater();

            // Label Text
            $repeater_line->add_control(
                'line_chart_label_name',
                [
                    'label' => esc_html__( 'Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => ['active' => true],
                    'default' => esc_html__( 'Revenue', 'htmega-pro' ),
                ]
            );
            // Data
            $repeater_line->add_control(
                'line_chart_data_value',
                [
                    'label' => esc_html__( 'Data', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => ['active' => true],
                    'label_block'=>true,
                    'description' => __( 'Enter Data separated by \' , \'  Ex.(16, 11, 12, 14, 16, 15, 12, 9, 16)', 'htmega-pro' ),
                    'default' => esc_html__( '16, 11, 12, 14, 16, 15, 12, 9, 16', 'htmega-pro' ),
                ]
            );
            $repeater_line->add_control(
                'line_chart_bg_color',
                [
                    'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                ]
            );

            $this->add_control(
                'line_chart_list',
                [
                    'label' => esc_html__( 'Labels Data', 'htmega-pro' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater_line->get_controls(),
                    'default' => [
                        [
                            'line_chart_label_name' => esc_html__( 'Revenue', 'htmega-pro' ),
                            'line_chart_data_value' => esc_html__( '16, 11, 12, 14, 16, 15, 12, 9, 16', 'htmega-pro' ),
                            'line_chart_bg_color' => esc_html__( '#73ED55', 'htmega-pro' ),
                        ],
                        [
                            'line_chart_label_name' => esc_html__( 'Orders', 'htmega-pro' ),
                            'line_chart_data_value' => esc_html__( '10, 19, 17, 12, 10, 9, 10, 12, 13, 16', 'htmega-pro' ),
                            'line_chart_bg_color' => esc_html__( '#3E5DFF', 'htmega-pro' ),
                        ]

                    ],
                    'title_field' => '{{{ line_chart_label_name }}}',
                    'condition'=>[
                        'chart_type' =>'line',
                    ]
                ]
            );


            // Bar chart repeater
            $repeater_bar = new Repeater();

            $repeater_bar->start_controls_tabs('chart_bar_data_tabs');

                $repeater_bar->start_controls_tab(
                    'bar_chart_content_tab',
                    [
                        'label' => __('Content', 'htmega-pro'),
                    ]
                );

                    // Label Text
                    $repeater_bar->add_control(
                        'bar_chart_label_name',
                        [
                            'label' => esc_html__( 'Label', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'dynamic' => ['active' => true],
                            'default' => esc_html__( 'Minimal', 'htmega-pro' ),
                        ]
                    );
                    // Data
                    $repeater_bar->add_control(
                        'bar_chart_data_value',
                        [
                            'label' => esc_html__( 'Data', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'dynamic' => ['active' => true],
                            'label_block'=>true,
                            'description' => __( 'Enter Data Numbers for Y-Axis separated by \' , \'Ex.(200,300,480,230,300,400,200)', 'htmega-pro' ),
                            'default' => esc_html__( '200,300,480,230,300,400,200', 'htmega-pro' ),
                        ]
                    );

                $repeater_bar->end_controls_tab();

                $repeater_bar->start_controls_tab(
                    'bar_chart_style_tab',
                    [
                        'label' => __('Style', 'htmega-pro'),
                    ]
                );

                    $repeater_bar->add_control(
                        'bar_chart_bg_color',
                        [
                            'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                        ]
                    );
                    $repeater_bar->add_control(
                        'bar_chart_bg_color2',
                        [
                            'label' => esc_html__( 'Background Color 2 (Optional)', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'description' =>esc_html__( 'This Background Color for Gradient', 'htmega-pro' ),
                        ]
                    );
                $repeater_bar->end_controls_tab();

            $repeater_bar->end_controls_tabs();

            $this->add_control(
                'bar_chart_list',
                [
                    'label' => esc_html__( 'Labels Data', 'htmega-pro' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater_bar->get_controls(),
                    'default' => [
                        [
                            'bar_chart_label_name' => esc_html__( 'Minimal', 'htmega-pro' ),
                            'bar_chart_data_value' => esc_html__( '200,300,480,230,300,400,200', 'htmega-pro' ),
                            'bar_chart_bg_color' => esc_html__( '#D8CFFF', 'htmega-pro' ),
                            'bar_chart_bg_color2' => esc_html__( '#8D79F6', 'htmega-pro' ),
                        ],
                        [
                            'bar_chart_label_name' => esc_html__( 'High', 'htmega-pro' ),
                            'bar_chart_data_value' => esc_html__( '200,500,400,400,300,500,100', 'htmega-pro' ),
                            'bar_chart_bg_color' => esc_html__( '#B09FFF', 'htmega-pro' ),
                            'bar_chart_bg_color2' => esc_html__( '#8D79F6', 'htmega-pro' ),
                        ]

                    ],
                    'title_field' => '{{{ bar_chart_label_name }}}',
                    'condition'=>[
                        'chart_type' =>array('bar','bar_h'),
                    ]
                ]
            );


            $repeater = new Repeater();

            $repeater->start_controls_tabs('chart_data_tabs');

                $repeater->start_controls_tab(
                    'pie_chart_content_tab',
                    [
                        'label' => __('Content', 'htmega-pro'),
                    ]
                );

                    // Label Text
                    $repeater->add_control(
                        'pie_chart_label_name',
                        [
                            'label' => esc_html__( 'Label', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'dynamic' => ['active' => true],
                            'default' => esc_html__( 'Red', 'htmega-pro' ),
                        ]
                    );
                    // Data
                    $repeater->add_control(
                        'pie_chart_data_value',
                        [
                            'label' => esc_html__( 'Data', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'dynamic' => ['active' => true],
                            'default' => esc_html__( '120', 'htmega-pro' ),
                        ]
                    );

                $repeater->end_controls_tab();

                $repeater->start_controls_tab(
                    'pie_chart_style_tab',
                    [
                        'label' => __('Style', 'htmega-pro'),
                    ]
                );

                    $repeater->add_control(
                        'pie_chart_bg_color',
                        [
                            'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                        ]
                    );
                    $repeater->add_control(
                        'pie_chart_bg_color2',
                        [
                            'label' => esc_html__( 'Background Color 2 (Optional)', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'description' =>esc_html__( 'This Background Color for Gradient', 'htmega-pro' ),
                        ]
                    );
                $repeater->end_controls_tab();

            $repeater->end_controls_tabs();

            $this->add_control(
                'pie_chart_list',
                [
                    'label' => esc_html__( 'Data List', 'htmega-pro' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'pie_chart_label_name' => esc_html__( 'Red', 'htmega-pro' ),
                            'pie_chart_data_value' => esc_html__( '120', 'htmega-pro' ),
                            'pie_chart_bg_color' => esc_html__( 'red', 'htmega-pro' ),
                        ],
                        [
                            'pie_chart_label_name' => esc_html__( 'Purple', 'htmega-pro' ),
                            'pie_chart_data_value' => esc_html__( '375', 'htmega-pro' ),
                            'pie_chart_bg_color' => esc_html__( '#5F14FF', 'htmega-pro' ),
                        ],
                        [
                            'pie_chart_label_name' => esc_html__( 'Orange', 'htmega-pro' ),
                            'pie_chart_data_value' => esc_html__( '580', 'htmega-pro' ),
                            'pie_chart_bg_color' => esc_html__( '#FF8214', 'htmega-pro' ),
                        ],
                        [
                            'pie_chart_label_name' => esc_html__( 'Yellow', 'htmega-pro' ),
                            'pie_chart_data_value' => esc_html__( '484', 'htmega-pro' ),
                            'pie_chart_bg_color' => esc_html__( '#FDD247', 'htmega-pro' ),
                        ],
                        [
                            'pie_chart_label_name' => esc_html__( 'Green', 'htmega-pro' ),
                            'pie_chart_data_value' => esc_html__( '300', 'htmega-pro' ),
                            'pie_chart_bg_color' => esc_html__( '#03C17B', 'htmega-pro' ),
                        ],
                    ],
                    'title_field' => '{{{ pie_chart_label_name }}}',
                    'condition' =>[
                        'chart_type' =>array('doughnut_round','doughnut','pie','nightingale_chart'),
                    ]
                ]
            );

        $this->end_controls_section();
        $this->start_controls_section(
            'chart_settings_section',
                [
                    'label' => __( 'Settings', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'show_chart_title',
                array(
                    'label'        => __( 'Show Title', 'htmega-pro' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                )
            );

            $this->add_control(
                'chart_title_text',
                array(
                    'label'       => __( 'Title', 'htmega-pro' ),
                    'type'        => Controls_Manager::TEXT,
                    'description' => __( 'Enter the chart title', 'htmega-pro' ),
                    'label_block' => true,
                    'default' =>'Chart Title',
                    'dynamic'     => array( 'active' => true ),
                    'condition'   => array(
                        'show_chart_title' => 'yes',
                    ),
                )
            );

            $this->add_control(
                'chart_title_tag',
                array(
                    'label'       => __( 'HTML Tag', 'htmega-pro' ),
                    'type'        => Controls_Manager::SELECT,
                    'default'     => 'h3',
                    'options'     => array(
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ),
                    'label_block' => true,
                    'condition'   => array(
                        'show_chart_title' => 'yes',
                    ),
                )
            );

            $this->add_responsive_control(
                'chart_legend_show',
                array(
                    'label'              => __( 'Show Legend', 'htmega-pro' ),
                    'type'               => Controls_Manager::SWITCHER,
                    'description'        => __( 'Show or Hide chart legend', 'htmega-pro' ),
                    'label_on'           => 'Show',
                    'label_off'          => 'Hide',
                    'return_value'       => 'true',
                    'default'       => 'true',
                )
            );

            $this->add_responsive_control(
                'chart_legend_position',
                [
                    'label' => __('Legend Position', 'htmega-pro'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __('Left', 'htmega-pro'),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'top' => [
                            'title' => __('Top', 'htmega-pro'),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'right' => [
                            'title' => __('Right', 'htmega-pro'),
                            'icon' => 'eicon-h-align-right',
                        ],
                        'bottom' => [
                            'title' => __('Bottom', 'htmega-pro'),
                            'icon' => 'eicon-v-align-bottom',
                        ],
                    ],
                    'toggle' => false,
                    'default'            => 'bottom',
                    'condition'          => array(
                        'chart_legend_show' => 'true',
                    ),
                ]
            );

            $this->add_responsive_control(
                'legend_gap',
                [
                    'label' => __( 'Legend Item Gap', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' =>20,
                    ],
                    'condition'          => array(
                        'chart_legend_show' => 'true',
                    ),
                ]
            );
            $this->add_control(
                'chart_tool_tips',
                array(
                    'label'              => __( 'Show Tooltips', 'htmega-pro' ),
                    'type'               => Controls_Manager::SWITCHER,
                    'label_on'           => 'Show',
                    'label_off'          => 'Hide',
                    'return_value'       => 'true',
                    'default'       => 'true',
                )
            );
            $this->add_control(
                'chart_tool_title',
                array(
                    'label'       => __( 'Tooltips Title', 'htmega-pro' ),
                    'type'        => Controls_Manager::TEXT,
                    'description' => __( 'Enter the tooltips title', 'htmega-pro' ),
                    'label_block' => true,
                    'dynamic'     => array( 'active' => true ),
                    'condition'   => array(
                        'chart_tool_tips' => 'true',
                        'chart_type' =>array('doughnut_round','doughnut','nightingale_chart','pie'),
                    ),
                )
            );
            $this->add_control(
                'chart_hover_value_center',
                array(
                    'label'              => __( 'Show chart Value in Center on Hover', 'htmega-pro' ),
                    'type'               => Controls_Manager::SWITCHER,
                    'label_on'           => 'Show',
                    'label_off'          => 'Hide',
                    'return_value'       => 'true',
                    'default'       => 'no',
                    'condition' => [
                        'chart_type' =>array('doughnut_round','doughnut','nightingale_chart'),
                    ]
                )
            );
            $this->add_control(
                'hover_value_color',
                [
                    'label' => __( 'Value Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#000000',
                    'condition' => [
                        'chart_type' =>array('doughnut_round','doughnut','nightingale_chart'),
                        'chart_hover_value_center' =>'true',
                    ]
                ]
            );
            $this->add_control(
                'hover_value_size',
                [
                    'label' => esc_html__( 'Value Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                    'default' => 40,
                    'condition' => [
                        'chart_type' =>array('doughnut_round','doughnut','nightingale_chart'),
                        'chart_hover_value_center' =>'true',
                    ]
                ]
            );
            $this->add_control(
                'show_y_axis_label',
                array(
                    'label'              => __( 'Show Value  Y-Axis Label', 'htmega-pro' ),
                    'type'               => Controls_Manager::SWITCHER,
                    'label_on'           => 'Show',
                    'label_off'          => 'Hide',
                    'return_value'       => 'true',
                    'condition' => [
                        'chart_type' =>array('bar','bar_h','line'),
                    ]
                )
            );

        $this->end_controls_section();

//    Style section 

        // Chart Wrapper style section
        $this->start_controls_section(
            'box_style',
            [
                'label' => esc_html__( 'Chart Box Wrapper', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'box_content_width',
            [
                'label' => __( 'Box Width', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1200,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-chart-content-box' => 'max-width: {{SIZE}}{{UNIT}};width:100%;',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_responsive_control(
            'box_content_height',
            [
                'label' => __( 'Chart Height', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1200,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 390,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-chart-content-box' => 'height: {{SIZE}}px;',
                ],
                
            ]
        );

        $this->add_control(
            'chart_inner_radius',
            [
                'label' => __( 'Chart Inner Radius', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    '%' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'condition' => [
                    'chart_type' =>array('doughnut_round','doughnut','nightingale_chart'),
                ]
            ]
        );
        $this->add_control(
            'chart_outer_radius',
            [
                'label' => __( 'Chart Outer Radius', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    '%' => [
                        'min' => 30,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'condition' => [
                    'chart_type' =>array('doughnut_round','doughnut','pie','nightingale_chart'),
                ]
            ]
        );



        $this->add_responsive_control(
            'box_content_alignment',
            [
                'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-chart-box' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'chart_outer_space',
            [
                'label' => esc_html__( 'Chart Outer Space', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],
                'default' => [
                    'top' => '40',
                    'right' => '40',
                    'bottom' => '40',
                    'left' => '40',
                    'unit' => 'px'
                ],
                'condition' => [
                    'chart_type' =>array('bar','bar_h','line'),
                ]
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'chart_item_style',
            [
                'label' => __( 'Chart Item Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'chart_type' =>array('doughnut_round','doughnut','pie','nightingale_chart'),
                ]
            ]
        );

            $this->add_control(
                'chart_border_color',
                [
                    'label' => __( 'Border Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                ]
            );
            $this->add_responsive_control(
                'chart_border_width',
                [
                    'label' => __( 'Border Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                    ],                    
                ]
            );
            $this->add_responsive_control(
                'chart_border_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'size' => '10',
                    ],
                    'condition' => [
                        'chart_type' =>'doughnut_round'
                        ]
                ]
            );
        $this->end_controls_section();
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'chart_title_text!' =>'',
                    'show_chart_title' =>'yes',
                ]
            ]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-chart-title .htmega-chart-title-heading' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-chart-title .htmega-chart-title-heading',
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-chart-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_alignment',
                [
                    'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-chart-title' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
        $this->end_controls_section();
        // Legend Style
        $this->start_controls_section(
            'legent_style',
            [
                'label' => __( 'Legend Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'chart_legend_show' =>'true',
                ]
            ]
            );

            $this->add_control(
                'legend_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#000000',
                ]
            );
            $this->add_responsive_control(
                'legend_size',
                [
                    'label' => esc_html__( 'Legend Size', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                    'default' => 15,
                ]
            );

        $this->end_controls_section();
        // Tooltip  Style
        $this->start_controls_section(
            'tooltips_style',
            [
                'label' => __( 'Tooltips Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'chart_tool_tips' =>'true',
                ]
            ]
            );

            $this->add_control(
                'tooltip_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#ffffff',
                    'condition' => [
                        'chart_tool_tips' =>'true',
                    ]
                ]
            );
            $this->add_control(
                'tooltip_bg_color',
                [
                    'label' => __( 'Background Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#000000',
                    'condition' => [
                        'chart_tool_tips' =>'true',
                    ]
                ]
            );


        $this->end_controls_section();
        // Axis Color  Style
        $this->start_controls_section(
            'axis_style',
            [
                'label' => __( 'Axis Label Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'chart_type' =>array('bar','bar_h','line'),
                ]
            ]
            );

            $this->add_control(
                'axis_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#000000',
                    'condition' => [
                        'chart_type' =>array('bar','bar_h','line'),
                    ]
                ]
            );

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        $this->add_render_attribute( 'chart_title', 'class', 'htmega-chart-title-heading' );
        $pie_chart_data = [];
        if( ( $settings['chart_type'] == 'bar' ||  $settings['chart_type'] == 'bar_h')  && $settings['bar_chart_list'] ){

            foreach ( $settings['bar_chart_list'] as $key => $item ) {
                if( $item['bar_chart_bg_color'] =='' ){
                    $item['bar_chart_bg_color'] = '#5F14FF00';
                }
                if( $item['bar_chart_bg_color2'] == '' ){
                    $item['bar_chart_bg_color2'] = $item['bar_chart_bg_color'];
                }
                $pie_chart_data[$key] =['value'=> explode( ',',$item['bar_chart_data_value'] ), 'name'=>$item['bar_chart_label_name'], 'itemStyle'=>['color'=> [["offset"=> 0,"color"=> $item['bar_chart_bg_color']],["offset"=> 1,"color"=> $item['bar_chart_bg_color2']]]]];
            }
        } else if( $settings['chart_type'] == 'line' && $settings['line_chart_list'] ) {

            foreach ( $settings['line_chart_list'] as $key => $item ) {
                if( $item['line_chart_bg_color'] =='' ){
                    $item['line_chart_bg_color'] = '#73ED55';
                }
                $pie_chart_data[$key] =['data'=>explode( ',', $item['line_chart_data_value']), 'name'=>$item['line_chart_label_name'], 'itemStyle'=>['color'=> $item['line_chart_bg_color']],'type'=> 'line','smooth'=> 'true'];
            }
            
        } else{
            foreach ( $settings['pie_chart_list'] as $key => $item ) {
                if( $item['pie_chart_bg_color'] =='' ){
                    $item['pie_chart_bg_color'] = '#5F14FF00';
                }
                if( $item['pie_chart_bg_color2'] == '' ){
                    $item['pie_chart_bg_color2'] = $item['pie_chart_bg_color'];
                }
                $pie_chart_data[$key] =['value'=> esc_attr( $item['pie_chart_data_value'] ), 'name'=> esc_attr( $item['pie_chart_label_name'] ), 'itemStyle'=>['color'=> [["offset"=> 0,"color"=> esc_attr( $item['pie_chart_bg_color'] ) ],["offset"=> 1,"color"=> esc_attr( $item['pie_chart_bg_color2'] ) ]]]];
            }
        }

        $pie_chart_data = wp_json_encode( $pie_chart_data );


        $chart_legend_position = !empty( $settings['chart_legend_position'] ) ? esc_attr( $settings['chart_legend_position'] ): 'top';
        $legend_gap = !empty( $settings['legend_gap']['size'] ) ? $settings['legend_gap']['size']: 20;
        
        $chart_settings_attribute_args = array(
            'show_y_axis_label'  => esc_attr( $settings['show_y_axis_label'] ),
            'bar_x_axis_labels'  => explode( ',', sanitize_text_field( $settings['bar_x_axis_labels'] ) ),
            'chart_outer_space'  => $settings['chart_outer_space'],
            'axis_color'  => esc_attr( $settings['axis_color'] ),
            'chart_tool_tips'  => esc_attr( $settings['chart_tool_tips'] ),
            'tooltip_color'  => esc_attr( $settings['tooltip_color'] ),
            'tooltip_bg_color'  => esc_attr( $settings['tooltip_bg_color'] ),
            'chart_tool_title'  => esc_attr( $settings['chart_tool_title'] ),
            'chart_hover_value_center'  => ( 'true' == $settings['chart_hover_value_center'] )?true:false,
            'hover_value_size' => !empty( $settings['hover_value_size'] ) ? absint( $settings['hover_value_size'] ): '40',
            'hover_value_color' => !empty( $settings['hover_value_color'] ) ? esc_attr( $settings['hover_value_color'] ) :'#000000',
            'chart_legend_show'  => ('true' == $settings['chart_legend_show'] ) ? true: false,
            'chart_legend_showt'  => isset( $settings['chart_legend_show_tablet'] ) ? true: false,
            'chart_legend_showm'  => isset( $settings['chart_legend_show_mobile'] ) ? true: false,
            'chart_legend_position'  => $chart_legend_position,
            'chart_legend_positiont'  => !empty( $settings['chart_legend_position_tablet'] ) ? esc_attr( $settings['chart_legend_position_tablet'] ): $chart_legend_position,
            'chart_legend_positionm'  => !empty( $settings['chart_legend_position_mobile'] ) ? esc_attr( $settings['chart_legend_position_mobile'] ): $chart_legend_position,
            'legend_size'  => absint( $settings['legend_size'] ),
            'legend_color'  => esc_attr( $settings['legend_color'] ),
            'legend_gap'  => $legend_gap,
            'legend_gapt'  => !empty( $settings['legend_gap_tablet']['size'] ) ? absint( $settings['legend_gap_tablet']['size'] ) : $legend_gap,
            'legend_gapm'  => !empty( $settings['legend_gap_mobile']['size'] ) ? absint( $settings['legend_gap_mobile']['size'] ) : $legend_gap,
            'chart_type'  => esc_attr( $settings['chart_type'] ),
            'chart_border_color'  => esc_attr( $settings['chart_border_color'] ),
            'chart_border_width'  => !empty( $settings['chart_border_width']['size'] ) ? absint( $settings['chart_border_width']['size'] ) : 0,
            'chart_border_radius'  => !empty( $settings['chart_border_radius']['size'] ) ? absint( $settings['chart_border_radius']['size'] ) : 0,
            'chart_inner_radius'  => !empty( $settings['chart_inner_radius']['size'] ) ? absint( $settings['chart_inner_radius']['size'] ) : '',
            'chart_outer_radius'  => !empty( $settings['chart_outer_radius']['size'] ) ? absint( $settings['chart_outer_radius']['size'] ) : ''
        );

    

		$this->add_render_attribute( 'htmega-container',
			[
				'class'         => 'htmega-chart-box',
			]
		);           

		$this->add_render_attribute( 'htmega-canvas',
			[
				'class' => 'htmega-doughunt-chartjs htmega-chart-content-box',
				'data-htmegachart'  => $pie_chart_data,
				'data-chart_settings'  => wp_json_encode($chart_settings_attribute_args),
            ]
		);
        ?>

            <div <?php echo $this->get_render_attribute_string( 'htmega-container' ); ?>>
                <?php if( 'yes' == $settings['show_chart_title'] && !empty( $settings['chart_title_text'] ) ):?>
                <div class="htmega-chart-title">
                    <?php
                        printf( '<%1$s %2$s>%3$s</%1$s>',
                                htmega_escape_tags( $settings['chart_title_tag'], 'h3' ),
                                $this->get_render_attribute_string( 'chart_title' ),
                                htmega_kses_title( $settings['chart_title_text' ] )
                            );
                    ?>
                </div>
                <?php endif; ?>
                <div <?php echo $this->get_render_attribute_string( 'htmega-canvas' ); ?>></div>
            </div>

        <?php

    }


}