<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Dynamic_Gallery_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-dynamic-gallery-addons';
    }
    
    public function get_title() {
        return esc_html__( 'Dynamic Gallery', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-gallery-justified';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_style_depends() {
        return ['magnific-popup'];
    }
    public function get_script_depends() {
        //'dynamic-gallery-active'
        return ['isotope','imagesloaded','magnific-popup'];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'dynamic gallery', 'post gallery', 'filterable gallery', 'gallery', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/';
	}

    protected function register_controls() {
        $this->_general_controls();
        $this->_style_controls();
    }

    protected function _general_controls(){ 
        $this->__dynamic_gallery_item_controls();
        $this->__dynamic_gallery_settings_controls();

    }

    protected function __dynamic_gallery_settings_controls(){
        $this->start_controls_section(
            'dynamic_gallery_settings',
            [
                'label' => esc_html__('Gallery Settings', 'htmega-pro'),
            ]
        );
            $this->add_control(
                'filter_enable',
                [
                    'label' => esc_html__('Enable Filter Menu', 'htmega-pro'),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );

            $this->add_control(
                'dynamic_gallery_menu_layout',
                [
                    'label' => esc_html__( 'Menu Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [
                        '1'   => esc_html__( 'Style 1', 'htmega-pro' ),
                        '2'   => esc_html__( 'Style 2', 'htmega-pro' ),
                        '3'   => esc_html__( 'Style 3', 'htmega-pro' ),
                        '4'   => esc_html__( 'Style 4', 'htmega-pro' ),
                        '5'   => esc_html__( 'Style 5', 'htmega-pro' ),
                        '7'   => esc_html__( 'Style 6', 'htmega-pro' ),
                    ],
                    'condition' => [
                        'filter_enable' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'dynamic_gallery_all_label_text',
                [
                    'label' => esc_html__('Gallery All Label', 'htmega-pro'),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => [ 'active' => true ],
                    'default' => esc_html__('All', 'htmega-pro'),
                    'condition' => [
                        'filter_enable' => 'yes',
                    ],
                ]
            ); 
            $this->add_control(
                'menu_active_number',
                [
                    'label' => __('Active Menu Number', 'htmega-pro'),
                    'description' => __('To active  default menu except "All" add the menu index number of the menu item', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 0,
                    'separator' => 'after',
                    'condition' => [
                        'filter_enable' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'dynamic_gallery_layout',
                [
                    'label' => esc_html__( 'Card Layout', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '2',
                    'options' => [
                        '1'   => esc_html__( 'Layout One', 'htmega-pro' ),
                        '2'   => esc_html__( 'Layout Two', 'htmega-pro' ),

                    ],
                ]
            );
            $this->add_responsive_control(
                'masonry_column',
                [
                    'label' => esc_html__( 'Column', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        "100.00"  => esc_html__('Style One','htmega-pro'),
                        "50.00"  => esc_html__('Style Two','htmega-pro'),
                        "33.33"   => esc_html__('Style Three','htmega-pro'),
                        "25.00"  => esc_html__('Style Four','htmega-pro'),
                        "20.00"   => esc_html__('Style Five','htmega-pro'),
                    ],
                    'desktop_default' => "33.33",
                    'tablet_default' => "50",
                    'mobile_default' => "100",
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-flex-column'   => 'flex: 0 0 {{VALUE}}%; max-width:{{VALUE}}%;width:{{VALUE}}%',
                    ],
                    'frontend_available' => true,
                ]
            );
            $this->add_responsive_control(
                'gird_gutter',
                [
                    'label' => __('Column Gap', 'htmega-pro'),
                    'description' => __('This Column gap value shows in multiplying 2', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 10,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-row .htmega-dynamic-gallery-flex-column' => 'padding-left: {{SIZE}}px;padding-right: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-dynamic-gallery-widget-wrapper' => 'margin-left: -{{SIZE}}px;margin-right: -{{SIZE}}px;',
                    ],
                ]
            ); 
            $this->add_responsive_control(
                'space_bottom',
                [
                    'label' => __('Bottom Space', 'htmega-pro'),
                    'description' => __('Add the item bottom space', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 30,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item' => 'margin-bottom: {{SIZE}}px;',
                    ],
                    'separator' => 'before',
                ]
            ); 
            $this->add_control(
                'show_title',
                [
                    'label' => esc_html__( 'Show Title', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'separator' =>'before'
                ]
            );

            $this->add_control(
                'title_length',
                [
                    'label' => __( 'Title Length', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'step' => 1,
                    'default' => 5,
                    'condition'=>[
                        'show_title'=>'yes',
                    ]
                ]
            );
            $this->add_control(
                'show_content',
                [
                    'label' => esc_html__( 'Show Content', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
            $this->add_control(
                'content_type',
                [
                    'label' => esc_html__( 'Content Source', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'content',
                    'options' => [
                        'content'          => esc_html__('Content','htmega-pro'),
                        'excerpt'            => esc_html__('Excerpt','htmega-pro'),
                    ],
                    'condition'=>[
                        'show_content'=>'yes',
                    ]
                ]
            );
            $this->add_control(
                'content_length',
                [
                    'label' => __( 'Content Length', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'step' => 1,
                    'default' => 20,
                    'condition'=>[
                        'show_content'=>'yes',
                        'content_type'=>'content',
                    ]
                ]
            );
            $this->add_control(
                'show_read_more_btn',
                [
                    'label' => esc_html__( 'Read More Button', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
    
            $this->add_control(
                'read_more_txt',
                [
                    'label' => __( 'Read More Button Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Read More', 'htmega-pro' ),
                    'placeholder' => __( 'Read More', 'htmega-pro' ),
                    'label_block'=>true,
                    'condition'=>[
                        'show_read_more_btn'=>'yes',
                    ]
                ]
            );
            $this->add_control(
                'popup_display',
                [
                    'label' => esc_html__( 'Popup Button', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $this->add_control(
                'popup_link_icon',
                [
                    'label' => esc_html__( 'Popup Icon', 'htmega-pro' ),
                    'type'  => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-search-plus',
                        'library' => 'fa-solid',
                    ],
                    'condition'=>[
                         'popup_display' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'read_more_link_icon',
                [
                    'label' => esc_html__( 'Read More link Icon', 'htmega-pro' ),
                    'type'  => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-link',
                        'library' => 'fa-solid',
                    ],
                    'condition'=>[
                        'popup_display' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'show_load_more_btn',
                [
                    'label' => esc_html__( 'Show Load More Button', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
    
            $this->add_control(
                'show_load_txt',
                [
                    'label' => __( 'Button Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Load More', 'htmega-pro' ),
                    'placeholder' => __( 'Load More', 'htmega-pro' ),
                    'label_block'=>true,
                    'condition' =>[
                        'show_load_more_btn' =>'yes'
                    ]
                ]
            );

        $this->end_controls_section();
    }

    protected function __dynamic_gallery_item_controls(){
        $this->start_controls_section(
            'gallery_item_settings',
            [
                'label' => esc_html__('Content Source', 'htmega-pro'),
            ]
        );

            $this->show_post_source();

        $this->end_controls_section();
    }    

    //_style_controls
    protected function _style_controls() {
        $this->__filterable_menu_style();
        $this->__gallery_item_style();
        $this->__dynamic_gallery_thumbnail_style();
        $this->__dynamic_gallery_title_style();
        $this->__dynamic_gallery_description_style();
        $this->__dynamic_gallery_popup_button_style();
        $this->__dynamic_gallery_read_more_button_style();
        $this->__dynamic_gallery_load_more_button_style();

    }
    protected function __filterable_menu_style(){
        $this->start_controls_section(
            'filterable_menu_style_section',
            [
                'label' => esc_html__( 'Menu Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'filter_enable' => 'yes',
                ]
            ]
        );

            $this->add_control(
                'menu_section_style',
                [
                    'label' => esc_html__( 'Menu Wrapper', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'filterable_menu_alignment',
                [
                    'label'   => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-filter'   => 'text-align: {{VALUE}};',
                        '{{WRAPPER}} .htmega-text-center'   => 'text-align: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'menu_section_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-filter',
                ]
            );

            $this->add_responsive_control(
                'menu_section_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-filter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'menu_section_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-filter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'menu_section_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-filter',
                ]
            );

            $this->add_responsive_control(
                'menu_section_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-filter' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'after',
                ]
            );

            $this->add_control(
                'menu_style',
                [
                    'label' => esc_html__( 'Menu Item Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'filterable_menu_typography',
                    'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-btn, {{WRAPPER}} .htmega-filters-select, {{WRAPPER}} .htmega-dynamic-gallery-filter-search input',
                ]
            );
            $this->add_responsive_control(
                'menu_normal_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-dynamic-gallery-filter-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'menu_normal_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-dynamic-gallery-filter-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            // Menu Style Normal Tabs Start
            $this->start_controls_tabs( 'menu_style_tabs' );

                // Menu Style Normal Tab Start
                $this->start_controls_tab(
                    'menu_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'menu_normal_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-btn' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-filters-select' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter-6 .htmega-filters-select:focus' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter-search input' => 'color: {{VALUE}};',
                                
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter-6 .htmega-dynamic-gallery-filter-inner-border::before' => 'background: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'menu_normal_input_placeholder_color',
                        [
                            'label'     => esc_html__( 'Input placeholder Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter-search input::placeholder' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter-search input:-ms-input-placeholder' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter-search input:-ms-input-placeholder' => 'color: {{VALUE}};',

                            ],
                            'condition' => [
                                'dynamic_gallery_menu_layout' => '7',
                            ]
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_normal_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-btn, {{WRAPPER}} .htmega-dynamic-gallery-filter-inner',
                            'exclude' =>['image']
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'menu_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-btn, {{WRAPPER}} .htmega-dynamic-gallery-filter-inner',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'after',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'menu_normal_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-btn, {{WRAPPER}} .htmega-dynamic-gallery-filter-inner',
                            'separator' => 'before',
                        ]
                    );

                $this->end_controls_tab(); // Menu Style Normal Tab end

                // Menu Style Hover Tab Start
                $this->start_controls_tab(
                    'menu_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'menu_hover_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-btn:hover' => 'color: {{VALUE}};',  
                                '{{WRAPPER}} .htmega-filters-select:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter-search input:hover' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-btn:hover, {{WRAPPER}} .htmega-dynamic-gallery-filter-inner:hover',
                            'exclude' =>['image']
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'menu_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-btn:hover, {{WRAPPER}} .htmega-dynamic-gallery-filter-inner:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter-inner:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'after',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'menu_hover_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-btn:hover, {{WRAPPER}} .htmega-dynamic-gallery-filter-inner:hover',
                            'separator' => 'before',
                        ]
                    );
                $this->end_controls_tab(); // Menu Style Hover Tab End

                // Menu Style Active Tab Start
                $this->start_controls_tab(
                    'menu_style_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'menu_active_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-btn.is-checked' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_active_background_normal',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '
                            
                            {{WRAPPER}} .htmega-dynamic-gallery-filter.htmega-dynamic-gallery-filter-1 .htmega-dynamic-gallery-btn.is-checked, {{WRAPPER}} .htmega-dynamic-gallery-filter-4.htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn.is-checked, {{WRAPPER}} .htmega-dynamic-gallery-filter-5.htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn.is-checked, {{WRAPPER}} .htmega-dynamic-gallery-filter-7.htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn.is-checked,',
                            'condition' => [
                                'dynamic_gallery_menu_layout' => ['4','5','7'],
                            ],
                            'exclude' =>['image']
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_active_background_before_after',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '
                            {{WRAPPER}} .htmega-dynamic-gallery-filter-3.htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn::after,
                            {{WRAPPER}} .htmega-dynamic-gallery-filter-2.htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn.is-checked::before,
                            {{WRAPPER}} .htmega-dynamic-gallery-filter-3.htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn.is-checked::after',
                            'condition' => [
                                'dynamic_gallery_menu_layout' => ['2','3'],
                            ],
                            'exclude' =>['image']
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_active_background_gradient_color',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn.is-checked, {{WRAPPER}} .htmega-dynamic-gallery-btn.is-checked, {{WRAPPER}} .htmega-dynamic-gallery-btn.is-checked::before',
                            'condition' => [
                                'dynamic_gallery_menu_layout' => '1',
                            ],
                            'exclude' =>['image']
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'menu_active_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-btn.is-checked',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_active_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-btn.is-checked' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator' => 'after',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'menu_active_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-btn.is-checked',
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'transition_buttom_border',
                        [
                            'label' => esc_html__( 'Transition Buttom Border', 'htmega-pro' ),
                            'type' => Controls_Manager::HEADING,
                            'separator' => 'before',
                            'condition' => [
                                'dynamic_gallery_menu_layout' => ['5','7'],
                            ]
                        ]
                    );

                    $this->add_control(
                        'transition_buttom_border_active_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn::before' => 'background-color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn::after' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'dynamic_gallery_menu_layout' => ['5','7'],
                            ]
                        ]
                    );

                    $this->add_responsive_control(
                        'transition_buttom_border_active_height',
                        [
                            'label' => esc_html__('Height', 'htmega-pro'),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn::after' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-dynamic-gallery-filter .htmega-dynamic-gallery-btn::before' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'dynamic_gallery_menu_layout' => ['5','7'],
                            ]
                               
                        ]
                    );


                $this->end_controls_tab(); // Menu Style Active Tab End
            $this->end_controls_tabs(); // Menu Style Normal Tabs End
        $this->end_controls_section();
    }

    protected function __gallery_item_style(){
        $this->start_controls_section(
            'gallery_section_item_style_settings',
            [
                'label' => esc_html__('Item Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'gallery_item_background_color',
                [
                    'label' => esc_html__('Background Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-wrap .htmega-dynamic-gallery-item' => 'background-color: {{VALUE}};',
                    ],
                ]
            ); 
            $this->add_responsive_control(
                'gallery_item_padding',
                [
                    'label' => esc_html__('Padding', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-wrap .htmega-dynamic-gallery-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'gallery_item_border',
                    'label' => esc_html__('Border', 'htmega-pro'),
                    'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-wrap .htmega-dynamic-gallery-item',
                ]
            );

            $this->add_responsive_control(
                'gallery_item_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-wrap .htmega-dynamic-gallery-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'after',
                ]
            );
            
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'gallery_item_shadow',
                    'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-wrap .htmega-dynamic-gallery-item',
                ]
            );
        
            $this->add_control(
                'gallery_item_content_section_heading',
                [
                    'label' => esc_html__('Content Box Style', 'htmega-pro'),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'gallery_item_hover_background_color',
                [
                    'label' => esc_html__('Background Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-content' => 'background-color: {{VALUE}};',
                    ],
                ]
            ); 
    
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'gallery_item_content_section_border',
                    'label' => esc_html__('Border', 'htmega-pro'),
                    'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-content',
                ]
            );
            
            $this->add_responsive_control(
                'gallery_item_content_section_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'after',
                ]
            );

            $this->add_responsive_control(
                'gallery_item_content_section_Padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'gallery_item_content_section_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-dynamic-gallery-item.htmega-dynamic-gallery-item-1 .htmega-dynamic-gallery-item-content' => 'top: {{TOP}}{{UNIT}};right: {{RIGHT}}{{UNIT}};bottom: {{BOTTOM}}{{UNIT}};Left: {{LEFT}}{{UNIT}};margin:0px;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'gallery_item_content_alignment',
                [
                    'label'   => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item-content'   => 'text-align: {{VALUE}};',
                    ],
                ]
            );
        $this->end_controls_section();
    }

    protected function __dynamic_gallery_title_style(){
        $this->start_controls_section(
            'dynamic_gallery_title_section',
            [
                'label' => esc_html__('Title Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_title' => 'yes',
                ]
            ]
            );
            
            $this->add_control(
                'dynamic_gallery_title_color',
                [
                    'label' => esc_html__('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-title,{{WRAPPER}} .htmega-dynamic-gallery-item.htmega-dynamic-gallery-item-1 .htmega-dynamic-gallery-item-title' => 'color: {{VALUE}};',
                    ],

                ]
            );
            $this->add_control(
                'dynamic_gallery_title_hover_color',
                [
                    'label' => esc_html__('Hover Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-title:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'dynamic_gallery_title_typography',
                    'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-title',
                ]
            );

            $this->add_responsive_control(
                'dynamic_gallery_title_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'dynamic_gallery_title_hover_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],                
                ]
            );
            $this->add_control(
                'dynamic_gallery_title_border_color',
                [
                    'label' => esc_html__('Border Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item.htmega-dynamic-gallery-item-2 .htmega-dynamic-gallery-item-title' => 'border-color: {{VALUE}};',
                    ],

                    'condition' =>[
                        'dynamic_gallery_layout'=>'2'
                    ]
                ]
            );

            
        $this->end_controls_section();
    }
    protected function __dynamic_gallery_description_style(){
        $this->start_controls_section(
            'dynamic_gallery_description_section',
            [
                'label' => esc_html__('Description Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_content' => 'yes',
                ]
            ]
            );
            
            $this->add_control(
                'dynamic_gallery_description_color',
                [
                    'label' => esc_html__('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item-description,{{WRAPPER}} .htmega-dynamic-gallery-item.htmega-dynamic-gallery-item-1 .htmega-dynamic-gallery-item-description' => 'color: {{VALUE}};',
                    ],

                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'dynamic_gallery_description_typography',
                    'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-item-description',
                ]
            );
            $this->add_responsive_control(
                'dynamic_gallery_description_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'dynamic_gallery_description_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-dynamic-gallery-item-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],                
                ]
            );
            
            
        $this->end_controls_section();
    }

    protected function __dynamic_gallery_popup_button_style(){
        $this->start_controls_section(
            'dynamic_gallery_popup_button_section',
            [
                'label' => esc_html__('Popup Buttons Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'popup_display' => 'yes',
                ]
            ]
        );
            $this->start_controls_tabs('popup_style_tabs');

            $this->start_controls_tab(
                'popup_normal_tab',
                [
                    'label' => __( 'Normal', 'htmega-pro' ),
                ]
            );
                $this->add_control(
                    'dynamic_gallery_popup_button_bg_color',
                    [
                        'label' => esc_html__('Background Color', 'htmega-pro'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-gallery-popup-button a' => 'background-color: {{VALUE}};',
                        ],
                    ]
                );
                
                $this->add_control(
                    'dynamic_gallery_popup_button_color',
                    [
                        'label' => esc_html__('Color', 'htmega-pro'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-gallery-popup-button a i' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .dynamic-gallery-popup-button a svg path' => 'fill: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'dynamic_gallery_popup_button_border',
                        'label' => esc_html__('Border', 'htmega-pro'),
                        'selector' => '{{WRAPPER}} .dynamic-gallery-popup-button a',
                    ]
                );
                
                $this->add_responsive_control(
                    'dynamic_gallery_popup_button_border_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-gallery-popup-button a' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'popup_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                $this->add_control(
                    'dynamic_gallery_popup_button_bg_color_hover',
                    [
                        'label' => esc_html__('Background Color', 'htmega-pro'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-gallery-popup-button a:hover' => 'background-color: {{VALUE}};',
                        ],
                    ]
                );
                
                $this->add_control(
                    'dynamic_gallery_popup_button_color_hover',
                    [
                        'label' => esc_html__('Color', 'htmega-pro'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-gallery-popup-button a:hover i' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .dynamic-gallery-popup-button a:hover svg path' => 'fill: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'dynamic_gallery_popup_button_border:hover',
                        'label' => esc_html__('Border', 'htmega-pro'),
                        'selector' => '{{WRAPPER}} .dynamic-gallery-popup-button a:hover',
                    ]
                );
                
                $this->add_responsive_control(
                    'dynamic_gallery_popup_button_border_radius_hover',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-gallery-popup-button a:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );


                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();
            $this->add_responsive_control(
                'dynamic_gallery_popup_button_size',
                [
                    'label' => esc_html__('Size', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-gallery-popup-button a' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                    'separator'=>'before'
                ]
            );
            
            $this->add_responsive_control(
                'dynamic_gallery_popup_button_font_size',
                [
                    'label' => esc_html__('Icon Font Size', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', 'em'],
                    'range' => [
                        'px' => [
                            'max' => 150,
                        ],
                        'em' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-gallery-popup-button a i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .dynamic-gallery-popup-button a svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    
                ]
            );

            $this->add_responsive_control(
                'dynamic_gallery_popup_button_border_margin',
                [
                    'label' => esc_html__( 'Button Space', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-gallery-popup-button a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],                 
                ]
            );

            $this->add_control(
                'dynamic_gallery_popup_button_position',
                [
                    'type' =>Controls_Manager::POPOVER_TOGGLE,
                    'label' => esc_html__( 'Buttons Position', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                    'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->start_popover();
            
                $this->add_responsive_control(
                    'vertical_position',
                    [
                        'label' => __( 'Vertical Position', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 500,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-gallery-popup-button' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                ); 
                $this->add_responsive_control(
                    'horizontal_position',
                    [
                        'label' => __( 'Horizontal Position', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 500,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-gallery-popup-button' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                ); 

                $this->end_popover();

        $this->end_controls_section();
    }
    protected function __dynamic_gallery_read_more_button_style(){
        // Style Read More button tab section
        $this->start_controls_section(
            'readmore_style_section',
            [
                'label' => __( 'Read More', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'show_read_more_btn'=>'yes',
                    'read_more_txt!'=>'',
                ]
            ]
            );
            $this->start_controls_tabs('readmore_style_tabs');

                $this->start_controls_tab(
                    'readmore_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'readmore_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-read-more a' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'readmore_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-read-more a',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-read-more a',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-read-more a',
                        ]
                    );

                    $this->add_responsive_control(
                        'readmore_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-read-more a' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'readmore_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-read-more a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'readmore_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'readmore_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'readmore_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-read-more a:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-read-more a:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-read-more a:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'readmore_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dynamic-gallery-read-more a:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
    }
    protected function __dynamic_gallery_load_more_button_style(){
        // Style Load More button tab section
        $this->start_controls_section(
            'load_more_style_section',
                [
                    'label' => __( 'Load More Button', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition'=>[
                        'show_load_more_btn'=>'yes',
                    ]
                ]
            );
            $this->start_controls_tabs('load_more_style_tabs');

                $this->start_controls_tab(
                    'load_more_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'load_more_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-loadmore-button' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'load_more_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-loadmore-button',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'load_more_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-loadmore-button',
                            'exclude' =>['image'],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'load_more_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-loadmore-button',
                        ]
                    );

                    $this->add_responsive_control(
                        'load_more_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-loadmore-button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'load_more_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-loadmore-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'load_more_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-load-more-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'load_more_margin_alignment',
                        [
                            'label'   => esc_html__( 'Alignment', 'htmega-pro' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left'    => [
                                    'title' => esc_html__( 'Left', 'htmega-pro' ),
                                    'icon'  => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'htmega-pro' ),
                                    'icon'  => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'htmega-pro' ),
                                    'icon'  => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-load-more-wrapper'   => 'text-align: {{VALUE}};',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'load_more_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'load_more_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-loadmore-button:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'load_more_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-loadmore-button:hover',
                            'exclude' =>['image'],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'load_more_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-loadmore-button:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'load_more_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-loadmore-button:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
    }
    protected function __dynamic_gallery_thumbnail_style(){
        //style thumbnail opacity section
        $this->start_controls_section(
            'post_thumbnail_opacity_section',
            [
                'label' => __( 'Thumbnail  Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'htmega_image',
                'label' => esc_html__( 'Image Size', 'htmega-pro' ),
                'exclude'      => ['custom'],
                'default'      => 'medium',
                'separator' => 'none',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'label' => __( 'Border', 'htmega-pro' ),
                'selector' => '{{WRAPPER}} .htmega-dynamic-gallery-item.htmega-dynamic-gallery-item-2 .htmega-dynamic-gallery-item-image img',
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-dynamic-gallery-item.htmega-dynamic-gallery-item-2 .htmega-dynamic-gallery-item-image img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );
        $this->add_control(
            'image_overlay_color',
            [
                'label' => __( 'Hover Overlay Color', 'htmega-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-dynamic-gallery-item .htmega-dynamic-gallery-item-image::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
    }
    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $unicid         = esc_attr( 'sid'.$this->get_id() );
        $htmega_image  = $this->get_settings_for_display('htmega_image_size');
        $layout = $settings['dynamic_gallery_layout'];
        
        $popup_link_icon = HTMega_Icon_manager::render_icon( $settings['popup_link_icon'], [ 'aria-hidden' => 'true' ] ) ;
        $read_more_link_icon = HTMega_Icon_manager::render_icon( $settings['read_more_link_icon'], [ 'aria-hidden' => 'true' ] ) ;

        $post_type =  isset( $settings['post_type'] ) ? $settings['post_type'] : 'post';
        $post_categorys = isset( $settings[ $post_type.'_post_category'] ) ? $settings[ $post_type.'_post_category'] : [];
        $post_author = $settings['post_author'];
        $exclude_posts = ($settings['exclude_posts'])?$settings['exclude_posts']:[];
        $orderby            = $this->get_settings_for_display('orderby');
        $postorder          = $this->get_settings_for_display('postorder');
        $category_name =  get_object_taxonomies($post_type);
        $menu_active_number =  $settings['menu_active_number'];
        // Post query
        $args = array(
            'post_type'             => $post_type,
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => !empty( $settings['post_limit'] ) ? (int)$settings['post_limit'] : 3,
        );

        if (  !empty( $post_categorys ) ) {

            if( is_array( $post_categorys ) && count( $post_categorys ) > 0 ) {
                if ( in_array( "product_type", $category_name ) ) {
                    $category_name['0'] = 'product_cat';
                }
                if ( $menu_active_number && ! empty($post_categorys[ $menu_active_number - 1 ]) ) {
                    $filtered_category = array( $post_categorys[ $menu_active_number - 1 ] );
                } else {
                    $filtered_category = $post_categorys;
                }
                $field_name = is_numeric( $post_categorys[0] ) ? 'term_id' : 'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => $category_name[0],
                        'terms' => $filtered_category,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }
        // author check
        if (  !empty( $post_author ) ) {
            $args['author__in'] = $post_author;
        }
        // order by  check
        if ( !empty( $orderby ) ) {
            if ( 'date' == $orderby && 'yes'== $settings['custom_order_by_date'] && (!empty( $settings['order_by_date_after'] || $settings['order_by_date_before'] ) ) ) {
            $order_by_date_after = strtotime($settings['order_by_date_after']);
            $order_by_date_before = strtotime($settings['order_by_date_before']);
                $args['date_query'] = array(
                    array(
                        'before'    => array(
                            'year'  => gmdate('Y', $order_by_date_before),
                            'month' =>gmdate('m', $order_by_date_before),
                            'day'   => gmdate('d', $order_by_date_before),
                        ),
                        'after'    => array(
                            'year'  => gmdate('Y', $order_by_date_after),
                            'month' =>gmdate('m', $order_by_date_after),
                            'day'   => gmdate('d', $order_by_date_after),
                        ),
                        'inclusive' => true,
                    ),
                );

            } else {
                $args['orderby'] = $orderby;
            }
        }

        // Exclude posts check
        if (  !empty( $exclude_posts ) ) {
            $exclude_posts = explode(',',$exclude_posts);
            $args['post__not_in'] =  $exclude_posts;
        }

        // Order check
        if (  !empty( $postorder ) ) {
            $args['order'] =  $postorder;
        }
        // empty thumbnail post
        if ( 'yes' === $settings['hide_empty_thumbnail_post'] ) {
            $args['meta_query'] = [
                [
                    'key' => '_thumbnail_id',
                    'compare' => 'EXISTS'
                ],
            ];
        }

        $post_query = new \WP_Query( $args );
        $args['fields'] = 'ids';
        $post_ids = get_posts($args);

        $exclude_posts = array_merge($exclude_posts,$post_ids);
        $read_more_txt_print = isset( $settings['read_more_txt'] ) ? $settings['read_more_txt'] : '';
        $display_options = array(
            'dynamic_gallery_colum_and_catagory_attr'=> "htmega-gallery-item htmega-dynamic-gallery-flex-column gallery-item-js{$unicid}",
            'layout' => esc_attr( $layout ),
            'show_title' => esc_attr( $settings['show_title'] ),
            'htmega_image' => esc_attr( $htmega_image ),
            'title_length' => floatval( $settings['title_length'] ),
            'show_content' => esc_attr( $settings['show_content'] ),
            'content_type' => esc_attr( $settings['content_type'] ),
            'content_length' => floatval( $settings['content_length'] ),
            'show_read_more_btn' => esc_attr( $settings['show_read_more_btn'] ),
            'read_more_txt' =>  wp_kses_post( $read_more_txt_print ) ,
            'post_type' => esc_attr( $settings['post_type'] ),
            'unicid' =>esc_attr(  $unicid ),
            'popup_link_icon' => $popup_link_icon,
            'read_more_link_icon' => $read_more_link_icon,
            'popup_display' => esc_attr( $settings['popup_display'] ),
        );
    
        $gallery_settings = [
            'is_edit_mode' => \Elementor\Plugin::$instance->editor->is_edit_mode(),
            'img_popup' => '.htmega-gallery-img-popup-'. $unicid,
            'gallery_item' => 'gallery-item-js'.$unicid,
            'unicid' => $unicid,
            'post_limit' => $settings['post_limit'],
            'args_json' => $args,
            'display_options' => $display_options,
            'exclude_posts' => $exclude_posts,
            'site_url' => site_url() .'/wp-admin/admin-ajax.php',
            'show_load_txt' => esc_html($settings['show_load_txt']),
            'menu_active_number' => $menu_active_number,
            'security' => wp_create_nonce( "htmega-ajax-post-request" ),
        ];


        $this->add_render_attribute( 'gallery_settings_attr', 'class', 'htmega-dynamic-gallery-active' );
        $this->add_render_attribute( 'gallery_settings_attr', 'data-settings', wp_json_encode( $gallery_settings ) );


        $s_display_none = ( !empty($settings['dynamic_gallery_layout']) ) ? ' style="display:none;"':'';

        $filter_enable = $settings['filter_enable'];
        $filterable_all_label_text = $settings['dynamic_gallery_all_label_text'];


        $layout = $settings['dynamic_gallery_layout'];
        $menu_layout = $settings['dynamic_gallery_menu_layout'];

        $this->add_render_attribute( 'dynamic_gallery_colum_attr', 'class', 'htmega-gallery-item' );

        $select_option_class = "htmega-dynamic-gallery-grid {$unicid} ";

        $this->add_render_attribute( 'dynamic_gallery_row_grid_attr', 'class', 'htmega-dynamic-gallery-row '.$select_option_class );
        ?>
        <div <?php echo $this->get_render_attribute_string( 'gallery_settings_attr' ).$s_display_none; ?>>
        
            <div class="htmega-dynamic-gallery-wrap htmega-page-list-wrap-<?php echo esc_attr($layout); ?>">
            
                <!-- Filterable Gallery Start -->
                <?php if( $filter_enable == "yes" ): ?>
                    <div class="htmega-text-center">
                        <div class="htmega-dynamic-gallery-filter <?php echo esc_attr($unicid);?> htmega-dynamic-gallery-filter-<?php echo esc_attr($menu_layout); ?>" data-target="#htmega-dynamic-gallery-<?php echo esc_attr($unicid); ?>">
                            <!-- Filterable Menu List -->
                            <?php 
                                //All Menu
                                if(!empty($filterable_all_label_text)){
                                    if(!empty( $menu_active_number)){
                                    printf('<button data-filter="*" class="htmega-dynamic-gallery-btn">%1$s</button>', esc_html( $filterable_all_label_text ));
                                    }else{
                                        printf('<button data-filter="*" class="htmega-dynamic-gallery-btn is-checked">%1$s</button>', esc_html( $filterable_all_label_text ));
                                    }
                                }
                                // Menu List
                                if( $post_categorys ){

                                    if ( in_array( "product_type", $category_name ) ) {
                                        $category_name['0'] = 'product_cat';
                                    }

                                    foreach($post_categorys as $key=> $menu){
                                        $term = get_term_by('slug', $menu, $category_name[0]);
                                        $catagories_id = $term->term_id."_".$unicid;
                                        $catagory_name = $term->name;
                                        if ( ! empty( $menu_active_number ) && $key == $menu_active_number - 1 ) {
                                            printf('<button data-filter=".%1$s" class="htmega-dynamic-gallery-btn is-checked" data-slug="%3$s">%2$s</button>', esc_attr( $catagories_id ), esc_html( $catagory_name ), esc_attr( $term->slug ));
                                        } else {
                                            printf('<button data-filter=".%1$s" class="htmega-dynamic-gallery-btn" data-slug="%3$s">%2$s</button>', esc_attr( $catagories_id ), esc_html( $catagory_name ), esc_attr( $term->slug ));
                                        }      
                                    }
                                }
                            
                            ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="htmega-dynamic-gallery-widget-wrapper">
                    <div id="htmega-dynamic-gallery-<?php echo esc_attr($unicid); ?>" <?php echo $this->get_render_attribute_string( 'dynamic_gallery_row_grid_attr' ); ?>>
                        <?php 
                        if($post_query->have_posts()):
                        $this->gallery_sizer_controller();
                    
                        while( $post_query->have_posts() ): $post_query->the_post();
                            $full_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_id()),'full',true); 
                            $full_image = $full_image[0];
                            $filter_data = "";
                            if( $category_name ){     
                                $terms = get_the_terms(get_the_id(),$category_name[0]);
                                $filter_data = "";
                                if( $terms ){  foreach($terms as $term ){
                                        $filter_data .= " ".strval($term->term_id)."_".$unicid;
                                    } 
                                }
                            }
                            $this->remove_render_attribute( 'dynamic_gallery_colum_and_catagory_attr');
                            $this->add_render_attribute( 'dynamic_gallery_colum_and_catagory_attr', 'class', 'htmega-gallery-item htmega-dynamic-gallery-flex-column '. $filter_data.' gallery-item-js'.$unicid );
                            // Remove Elementor Lightbox
                            $this->remove_render_attribute( 'popup_content_attr' );
                            $this->add_render_attribute( 'popup_content_attr', 'data-elementor-open-lightbox', 'no' );
                            
                            ?>
                
                            <div <?php echo $this->get_render_attribute_string( 'dynamic_gallery_colum_and_catagory_attr' ); ?>>
                                <div class="htmega-dynamic-gallery-item htmega-dynamic-gallery-item-<?php echo esc_attr($layout); ?>">
                                    
                                    <?php 
                                    if( has_post_thumbnail() ):
                                        echo '<div class="dynamic-gallery-image">';
                                            if('yes' == $settings['popup_display'] ){ ?>
                                                <div class="htmega-dynamic-gallery-item-image">
                                                    <?php the_post_thumbnail( $htmega_image ); ?>
                                                </div>
                                                <?php 
                                            }else{ ?>
                                                <a <?php echo $this->get_render_attribute_string( 'popup_content_attr' ); ?> class="htmega-dynamic-gallery-item-image htmega-filterable-img-popup <?php echo esc_html( 'htmega-gallery-img-popup-'.$unicid )?>" href="<?php echo esc_url( $full_image ); ?>">
                                                <?php the_post_thumbnail( $htmega_image ); ?>
                                                </a>
                                            <?php 
                                            }
                                            if('yes' == $settings['popup_display'] ){
                                                ?>
                                                <div class="dynamic-gallery-popup-button">
                                                    <?php if( $popup_link_icon ){ ?>
                                                    <a data-elementor-open-lightbox="no" href="<?php echo esc_url( $full_image ) ?>" class=" <?php echo esc_attr( 'htmega-gallery-img-popup-'.$unicid )?>">
                                                    <?php echo $popup_link_icon; ?>
                                                    </a>
                                                    <?php }
                                                    if( $read_more_link_icon ){ ?>
                                                    <a href="<?php the_permalink(); ?>" target="_blank" class="htmega-dynamic-gallery-link">
                                                    <?php echo $read_more_link_icon; ?>
                                                    </a>
                                                    <?php } ?>
                                                </div>
                                                <?php 
                                            } ?>
                                        </div>
                                        <?php
                                    endif;

                                    //gallery popup content                                   
                                    if( $settings['show_content'] == 'yes' ||  $settings['show_title'] == 'yes'){
                                        ?>
                                        <div class="htmega-dynamic-gallery-item-content">
                                            <?php
                                                if( $settings['show_title'] == 'yes' ){
                                                    ?>
                                                    <h3>
                                                        <a href="<?php the_permalink(); ?>" target="_blank" class="htmega-dynamic-gallery-item-title">
                                                            <?php
                                                             if ( 0 > $settings['title_length'] ) { 
                                                                 the_title();
                                                             } else { 
                                                                 echo esc_html( wp_trim_words( get_the_title(), floatval( $settings['title_length'] ), '' ) );
                                                             }
                                                            ?>
                                                        </a>
                                                    </h3>
                                                    <?php
                                                }
                                                if( $settings['show_content'] == 'yes' ){
                                                    if( $settings['content_type'] == 'excerpt' ){
                                                        echo '<p class="htmega-dynamic-gallery-item-description">' . esc_html( get_the_excerpt() ) .'</p>';
                                                    } else {
                                                        echo '<p class="htmega-dynamic-gallery-item-description">'. wp_kses_post( wp_trim_words( strip_shortcodes( get_the_content() ), $settings['content_length'], '' ) ) .'</p>'; 
                                                    }
                                                }

                                            if( $settings['show_read_more_btn'] == 'yes'): ?>
                                                <div class="htmega-dynamic-gallery-read-more">
                                                    <a target="_blank" href="<?php the_permalink();?>">
                                                        <?php echo htmega_kses_desc( $settings['read_more_txt'] );?>
                                                    </a>
                                                </div>
                                                <?php
                                            endif; ?>
                                            
                                        </div>
                                        <?php 
                                    }
                                    ?>
                                </div>
                            </div>
                            <?php 
                        endwhile;
                    else:
                        echo "<div class='htmega-error-notice'>".esc_html__('There are no posts in this query','htmega-pro')."</div>";
                            
                    endif;
                        ?>
                    </div>
                <!-- Filterable Gallery End  -->
                </div>
            </div>
            <?php
            if( $settings['show_load_more_btn'] == 'yes' && $post_query->have_posts() && $settings['post_limit'] <  $post_query->found_posts ): ?>
                <div class="htmega-pro-load-more-wrapper <?php echo esc_attr($unicid);?>">
                    <div class="htmega-loadmore-button <?php echo esc_attr($unicid);?>">
                        <span><?php echo htmega_kses_desc( $settings['show_load_txt'] );?></span>
                        <div class="htmega-loader-img">
                            <img src="<?php echo esc_url( HTMEGA_ADDONS_PL_URL_PRO.'/assets/images/load-more-icon.png' ); ?>" alt="<?php echo esc_attr('...') ?>">
                        </div>
                    </div>
                </div>
                <?php
                endif; ?>
        </div>
    <?php


}

    protected function gallery_sizer_controller(){
        if(!(\Elementor\Plugin::$instance->editor->is_edit_mode()))
        {
            printf('<div %1$s></div>', $this->get_render_attribute_string( 'dynamic_gallery_colum_attr' ));
        }
    }


    public function show_post_source(){

        $this->add_control(
            'post_type',
            [
                'label' => esc_html__( 'Post Type', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => htmega_get_post_types(),
                'default' =>'post',
                'frontend_available' => true,
                'separator' => 'before'
            ]
        );
        $this->add_control(
            'include_by',
            [
                'label' => __( 'Include By', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => [
                    'in_author'      => __( 'Author', 'htmega-pro' ),
                    'in_category'      => __( 'Category', 'htmega-pro' ),
                ],
            ]
        );
        $this->add_control(
            'post_author',
            [
                'label' => esc_html__( 'Authors', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => htmega_get_authors_list(),
                'condition' =>[
                    'include_by' => 'in_author',
                ]
            ]
        );
        $texnomy_list = htmega_get_post_types();
        foreach( $texnomy_list as $texnomykey => $texnomyValue ){
            
            $this->add_control(
                "{$texnomykey}_post_category",
                [
                    'label' => esc_html__( 'Select Categories', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => all_object_taxonomie_show_catagory($texnomykey),
                    'condition' => [
                        'post_type' => $texnomykey,
                        'include_by' => 'in_category',
                    ],
                ]
            );
        }
        $this->add_control(
            "exclude_posts",
            [
                'label' => esc_html__( 'Exclude Posts', 'htmega-pro' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__( 'Example: 10,11,105', 'htmega-pro' ),
                'description' => esc_html__( "To Exclude Post, Enter  the post id separated by ','", 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'post_limit',
            [
                'label' => __('Limit', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
                'separator'=>'before',
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => esc_html__( 'Order By', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'ID'            => esc_html__('ID','htmega-pro'),
                    'date'          => esc_html__('Date','htmega-pro'),
                    'name'          => esc_html__('Name','htmega-pro'),
                    'title'         => esc_html__('Title','htmega-pro'),
                    'comment_count' => esc_html__('Comment count','htmega-pro'),
                    'rand'          => esc_html__('Random','htmega-pro'),
                ],
            ]
        );
        $this->add_control(
            'custom_order_by_date',
            [
                'label' => esc_html__( 'Custom Date', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'condition' =>[
                    'orderby'=>'date'
                ]
            ]
        );
        $this->add_control(
            'order_by_date_before',
            [
                'label' => __( 'Before Date', 'htmega-pro' ),
                'type' => Controls_Manager::DATE_TIME,
                'condition' =>[
                    'orderby'=>'date',
                    'custom_order_by_date'=>'yes',
                ]
            ]
        );
        $this->add_control(
            'order_by_date_after',
            [
                'label' => __( 'After Date', 'htmega-pro' ),
                'type' => Controls_Manager::DATE_TIME,
                'condition' =>[
                    'orderby'=>'date',
                    'custom_order_by_date'=>'yes',
                ]
            ]
        );
        $this->add_control(
            'postorder',
            [
                'label' => esc_html__( 'Order', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC'  => esc_html__('Descending','htmega-pro'),
                    'ASC'   => esc_html__('Ascending','htmega-pro'),
                ],

            ]
        );
        $this->add_control(
            'hide_empty_thumbnail_post',
            [
                'label'         => esc_html__( 'Hide Empty Thumbnail', 'htmega-pro' ),
                'type'          => Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
                'default'       => 'no',
            ]
        );
    }

}