<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\HTMega_Icon_manager;
use Elementor\POPOVER_TOGGLE;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Facebook_Review_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-facebook-review-addons';
    }
    
    public function get_title() {
        return __( 'Facebook Review', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-facebook';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_script_depends() {
        return [ 
            'slick',
         ];
    }

    public function get_style_depends() {
        return ['slick' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'facebook review', 'review','htmega pro'];
    }
    
    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/facebook-review-widget/';
	}

    protected function register_controls() {

        // Page
        $this->start_controls_section(
            'page_options',
            [
                'label' => __( 'Page Overview Settings', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'show_page_info',
                [
                    'label' => esc_html__( 'Show Page Overview', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
            $this->add_control(
                'page_title',
                [
                    'label' => esc_html__( 'Show Title', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => array(
                        'show_page_info' => 'yes',
                    ),
                ]
            );

            $this->add_control(
                'page_name',
                [
                    'label'         => __( 'Custom Page Title', 'htmega-pro' ),
                    'type'          => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default'       => '',
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition'   => array(
                        'show_page_info' => 'yes',
                        'page_title' => 'yes',
                    ),
                ]
            );
            $this->add_control(
                'page_image',
                [
                    'label' => esc_html__( 'Show Image', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => array(
                        'show_page_info' => 'yes',
                    ),
                ]
            );
            $this->add_control(
                'page_about',
                [
                    'label' => esc_html__( 'Page About Content', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition'   => array(
                        'show_page_info' => 'yes',
                    ),
                ]
            );
            $this->add_control(
                'content_limit',
                [
                    'label' => __('Content Length', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 50,
                    'condition' =>[
                        'page_about' => 'yes',
                        'show_page_info' => 'yes',
                    ]
                    
                ]
            );
            $this->add_control(
                'page_rating',
                [
                    'label' => esc_html__( 'Rating', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => array(
                        'show_page_info' => 'yes',
                    ),
                ]
            );
            $this->add_control(
                'page_rate',
                [
                    'label' => esc_html__( 'Page Rate ', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => [
                        'show_page_info' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'reviews_number_text',
                array(
                    'label'       => __( 'Reviews Number Text', 'htmega-pro' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Based on {{review-count}} reviews',
                    'description' => __( 'Add Number of reviews text using this placeholder {{review-count}}', 'htmega-pro' ),
                    'condition'   =>[
                        'show_page_info'      => 'yes',
                        'page_rate' => 'yes',
                    ],
                )
            );
            $this->add_control(
                'page_write_review_button',
                [
                    'label' => esc_html__( 'Review Button', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => [
                        'show_page_info' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'page_write_review_button_text',
                    array(
                        'label'       => __( 'Button Text', 'htmega-pro' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => 'Write Now',
                        'condition'   =>[
                            'show_page_info'      => 'yes',
                            'page_write_review_button' => 'yes',
                        ],
                    )
            );
            $this->add_control(
                'page_write_review_button_icon',
                [
                    'label' => esc_html__( 'Review Button Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => [
                        'show_page_info' => 'yes',
                        'page_write_review_button' => 'yes',
                    ],
                ]
            );

        $this->end_controls_section();
        // Review
        $this->start_controls_section(
            'reviews_options',
            [
                'label' => __( 'Reviews Settings', 'htmega-pro' ),
            ]
            );

            $this->add_control(
                'show_reviews',
                [
                    'label' => esc_html__( 'Show Reviews', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $this->add_control(
                'review_title',
                [
                    'label' => esc_html__( 'Show Reviewer Name', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => array(
                        'show_reviews' => 'yes',
                    ),
                ]
            );
            $this->add_control(
                'review_image',
                [
                    'label' => esc_html__( 'Show Image', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => array(
                        'show_reviews' => 'yes',
                    ),
                ]
            );
            $this->add_control(
                'review_content',
                [
                    'label' => esc_html__( 'Review Content', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => array(
                        'show_reviews' => 'yes',
                    ),
                ]
            );
            $this->add_control(
                'review_content_limit',
                [
                    'label' => __('Content Length', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 25,
                    'condition' =>[
                        'review_content' => 'yes',
                        'show_reviews' => 'yes',
                    ]
                    
                ]
            );
            $this->add_control(
                'review_rating',
                [
                    'label' => esc_html__( 'Rating', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => array(
                        'show_reviews' => 'yes',
                    ),
                ]
            );
            $this->add_control(
                'review_time',
                [
                    'label' => esc_html__( 'Review Time', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => [
                        'show_reviews' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'review_write_review_button',
                [
                    'label' => esc_html__( 'Review Button', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => [
                        'show_reviews' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'review_write_review_button_text',
                    array(
                        'label'       => __( 'Button Text', 'htmega-pro' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => 'Write Now',
                        'condition'   =>[
                            'show_reviews'      => 'yes',
                            'review_write_review_button' => 'yes',
                        ],
                    )
            );
            $this->add_control(
                'review_write_review_button_icon',
                [
                    'label' => esc_html__( 'Review Button Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition'   => [
                        'show_reviews' => 'yes',
                        'review_write_review_button' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'review_layout',
                [
                    'label' => __( 'Review Layout', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'grid',
                    'options' => [
                        'grid'      => __( 'Grid', 'htmega-pro' ),
                        'carousel'      => __( 'Carousel', 'htmega-pro' ),
                    ],
                    
                ]
            );
        
            $this->add_responsive_control(
                'grid_column',
                [
                    'label' => esc_html__( 'Column Width', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'description' => __('For 1, 2, 3, 4, 5 columns set the value 100%, 50%, 33.33%, 25%, 20%.', 'htmega-pro'),
                    'range' => [
                        '%'    => [
                            'min'   => 20,
                            'max'   => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 33.333,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-flex-column'   => 'flex-basis: {{SIZE}}%;',
                    ],
                    'condition' =>[
                        'review_layout' =>'grid'
                    ],
                    'separator' =>'before'
                ]
            );

            $this->add_responsive_control(
                'slitems',
                [
                    'label' => esc_html__( 'Slider Items', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                    'default' => 3,
                    'condition' =>[
                        'review_layout' =>'carousel'
                    ],
                    'separator' =>'before'
                ]
            );
            $this->add_responsive_control(
                'slscroll_columns',
                [
                    'label' => __('Slider Item to Scroll', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                    'default' => 1,
                    'condition' =>[
                        'review_layout' =>'carousel'
                    ]
                ]
            );
            $this->add_responsive_control(
                'gird_gutter',
                [
                    'label' => __('Column Gap', 'htmega-pro'),
                    'description' => __('This Column gap value shows in multiplying 2', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 10,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pro-row .htmega-flex-column,{{WRAPPER}} .slick-slide' => 'padding: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-pro-row, {{WRAPPER}} .slick-list' => 'margin: -{{SIZE}}px;',
                        '{{WRAPPER}} .slick-slide .htmega-flex-column' => 'padding: 0px;',
                    ],
                ]
            );            
            $this->add_control(
                'slider_resolution_toggle',
                [
                    'type' =>Controls_Manager::POPOVER_TOGGLE,
                    'label' => esc_html__( 'Responsive Breakpoints', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                    'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'condition' =>[
                        'review_layout' =>'carousel'
                    ]
                ]
            );
            
            $this->start_popover();
            
                $this->add_control(
                    'tablet_width',
                    [
                        'label' => __('Tablet Breakpoints', 'htmega-pro'),
                        'description' => __('The resolution to tablet device.', 'htmega-pro'),
                        'type' => Controls_Manager::NUMBER,
                        'default' => 991,
                        'separator' => 'after',
                    ]
                );

                $this->add_control(
                    'mobile_width',
                    [
                        'label' => __('Mobile Breakpoints', 'htmega-pro'),
                        'description' => __('The resolution to mobile device.', 'htmega-pro'),
                        'type' => Controls_Manager::NUMBER,
                        'default' => 575,
                    ]
                );
                $this->end_popover();
    
            $this->add_control(
                'slautolay',
                [
                    'label' => esc_html__( 'Slide Auto Play', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'separator' => 'before',
                    'default' => 'no',
                    'condition' => [
                        'slarrows' => 'yes',
                        'review_layout' =>'carousel'
                    ]
                ]
            );
            $this->add_control(
                'slautoplay_speed',
                [
                    'label' => __('Autoplay Speed', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3000,
                    'condition' => [
                        'slautolay' => 'yes',
                        'review_layout' =>'carousel'
                    ]
                ]
            );

            $this->add_control(
                'slanimation_speed',
                [
                    'label' => __('Autoplay Animation Speed', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 300,
                    'condition' => [
                        'slautolay' => 'yes',
                        'review_layout' =>'carousel'
                    ]
                ]
            );
            $this->add_control(
                'slloop',
                [
                    'label' => esc_html__( 'Slide Repeat', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'slarrows' => 'yes',
                        'review_layout' =>'carousel'
                    ]
                ]
            );
            $this->add_control(
                'slarrows',
                [
                    'label' => esc_html__( 'Slider Arrow', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition' =>[
                        'review_layout' =>'carousel'
                    ]
                ]
            );
            $this->add_control(
                'slprevicon',
                [
                    'label' => __( 'Prev Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value'=>'fas fa-angle-left',
                        'library'=>'fa-solid',
                    ],
                    'condition' => [
                        'slarrows' => 'yes',
                        'review_layout' =>'carousel'
                    ],
                    'separator' =>'before'
                ]
            );

            $this->add_control(
                'slnexticon',
                [
                    'label' => __( 'Next Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value'=>'fas fa-angle-right',
                        'library'=>'fa-solid',
                    ],
                    'condition' => [
                        'slarrows' => 'yes',
                        'review_layout' =>'carousel'
                    ]
                ]
            );

            $this->add_control(
                'sldots',
                [
                    'label' => esc_html__( 'Slider Dots', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'review_layout' =>'carousel'
                    ],
                ]
            );
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'page_style_section',
                array(
                    'label' => __( 'Page Overview Style', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'show_page_info' =>'yes',
                    ]
                )
            );
                $this->start_controls_tabs('page_box_style_tabs');
                        
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'box_normal_style_tab',
                    [
                        'label' => esc_html__( 'Box', 'htmega-pro' ),
                    ]
                    );
                    $this->add_responsive_control(
                        'box_content_width',
                        [
                            'label' => __( 'Box Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1200,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => '%',
                                'size' => 100,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-facebook-page-overview' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'box_content_alignment',
                        [
                            'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                            'type' => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'htmega-pro' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'htmega-pro' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'htmega-pro' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-page-overview' => 'justify-content: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'box_normal_padding',
                        [
                            'label' => esc_html__( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-facebook-page-overview' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'box_normal_margin',
                        [
                            'label' => esc_html__( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-facebook-page-overview' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'box_normal_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-facebook-page-overview',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-facebook-page-overview',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-facebook-page-overview' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                $this->end_controls_tab();

            // Box Hover Style Tab
            $this->start_controls_tab(
                'box_hover_style_tab',
                [
                    'label' => esc_html__( 'Content', 'htmega-pro' ),
                ]
                );
                // Image style
                $this->add_control(
                    'page_overview_image_style',
                    [
                        'label' => __( 'Image Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'page_image' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'image_box_width',
                    [
                        'label' => __( 'Image Box Width', 'htmega-pro' ),
                        'type'  => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                            ],
                        ],
                        'default' => [
                            'size' =>70,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-header-image' => 'flex:0 0 {{SIZE}}px;',
                        ],
                        'condition' => [
                            'page_image' =>'yes',
                        ]
                    ]
                );

                $this->add_control(
                    'image_box_height',
                    [
                        'label' => __( 'Image Box Height', 'htmega-pro' ),
                        'type'  => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                            ],
                        ],
                        'default' => [
                            'size' =>70,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-header-image' => 'height: {{SIZE}}px;'
                    
                        ],
                        'condition' => [
                            'page_image' =>'yes',
                        ]
                    ]
                );
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'image_box_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-header-image',
                        'condition' => [
                            'page_image' =>'yes',
                        ]
                        
                    ]
                );    
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'image_box_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-header-image',
                        'separator' =>'before',
                        'condition' => [
                            'page_image' =>'yes',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'image_boxborder_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-header-image' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                        'condition' => [
                            'page_image' =>'yes',
                        ]
                    ]
                );       
                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name' => 'image_box_box_shadow',
                        'label' => __( 'Box Shadow', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-header-image',
                         'condition' => [
                            'page_image' =>'yes',
                        ]
                    ]
                );
                $this->add_responsive_control(
                    'image_box_padding',
                    [
                        'label' => esc_html__( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-header-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'page_image' =>'yes',
                        ]
                    ]
                );            
                $this->add_responsive_control(
                    'image_box_margin',
                    [
                        'label' => esc_html__( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-header-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'page_image' =>'yes',
                        ]
                    ]
                );            
                // Heading style
                $this->add_control(
                    'page_overview_heading_style',
                    [
                        'label' => __( 'Page Title Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'page_title' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'title_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-title' => 'color: {{VALUE}}',
                        ],
                        'condition' => [
                            'page_title' =>'yes',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'title_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-title',
                        'condition' => [
                            'page_title' =>'yes',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'title_margin',
                    [
                        'label' => __( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'page_title' =>'yes',
                        ]
                    ]
                );
                // Rating style
                $this->add_control(
                    'page_overview_rating_style',
                    [
                        'label' => __( 'Page Rating Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'page_rating' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'rating_color',
                    [
                        'label' => __( 'Rated Star Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default'=>'#FCBD23',
                        'condition' => [
                            'page_rating' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'empty_color',
                    [
                        'label' => __( 'Empty Star Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default'=>'#E2E0E5',
                        'condition' => [
                            'page_rating' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'rating_fontsize',
                    [
                        'label' => __( 'Icon Font Size', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'size' => 21,
                        ],
                        'condition' => [
                            'page_rating' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_count',
                    [
                        'label' => __( 'Review Count Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-time' => 'color: {{VALUE}}',
                        ],
                        'condition' => [
                            'page_rate' =>'yes',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'rating_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-time',
                        'condition' => [
                            'page_rate' =>'yes',
                        ]
                    ]
                );
                // Page Info style
                $this->add_control(
                    'page_overview_abut_style',
                    [
                        'label' => __( 'Page About Content Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'page_about' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'page_abut_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-description' => 'color: {{VALUE}}',
                        ],
                        'condition' => [
                            'page_about' =>'yes',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'page_abut_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-description',
                        'condition' => [
                            'page_about' =>'yes',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'page_abut_margin',
                    [
                        'label' => __( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'page_about' =>'yes',
                        ]
                    ]
                );
                // Button style
                $this->add_control(
                    'page_overview_button_style',
                    [
                        'label' => __( 'Page Button Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'readmore_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review svg path' => 'fill: {{VALUE}}',
                        ],
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                );
    
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'readmore_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review',
                        'exclude' => ['image'],
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                );
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'readmore_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review',
                        'condition' => [
                            'page_write_review_button' =>'yes',
                            'page_write_review_button_text[value]!' =>'',
                        ]
                    ]
                );
                $this->add_control(
                    'icon_link_size',
                    [
                        'label' => __( 'Icon Font Size', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 20,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review i' => 'font-size: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review svg' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'page_write_review_button' =>'yes',
                            'page_write_review_button_icon' =>'yes',
                        ]
                    ]
                );
                $this->add_responsive_control(
                    'readmore_padding',
                    [
                        'label' => __( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                ); 
                $this->add_responsive_control(
                    'readmore_margin',
                    [
                        'label' => __( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                ); 
    
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'readmore_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review',
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                );
    
                $this->add_responsive_control(
                    'readmore_border_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'page_overview_button_hover_style',
                    [
                        'label' => __( 'Button Hover Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'readmore_color_hover',
                    [
                        'label' => __( 'Hover Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review:hover svg path' => 'fill: {{VALUE}}',
                        ],
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                );
    
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'readmore_background_hover',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-facebook-page-overview .htmega-facebook-review-item-write-review:hover',
                        'exclude' => ['image'],
                        'condition' => [
                            'page_write_review_button' =>'yes',
                        ]
                    ]
                );
            $this->end_controls_tab();

            $this->end_controls_tabs();
        $this->end_controls_section();
        // Page overview style end
        // Reviews Style start
        $this->start_controls_section(
            'reviews_style_section',
                array(
                    'label' => __( 'Reviews Style', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'show_reviews' =>'yes',
                    ]
                )
            );
                $this->start_controls_tabs('reviews_box_style_tabs');
                        
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'reviews_box_style_tab',
                    [
                        'label' => esc_html__( 'Box', 'htmega-pro' ),
                    ]
                    );
                    $this->add_responsive_control(
                        'reviews_box_padding',
                        [
                            'label' => esc_html__( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'reviews_box_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'reviews_box_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item',
                        ]
                    );

                    $this->add_responsive_control(
                        'reviews_box_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                $this->end_controls_tab();

            // Review content Style Tab
            $this->start_controls_tab(
                'review_box_content_style_tab',
                [
                    'label' => esc_html__( 'Content', 'htmega-pro' ),
                ]
                );
                // Image style
                $this->add_control(
                    'review_image_style',
                    [
                        'label' => __( 'Image Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'review_image' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_image_box_width',
                    [
                        'label' => __( 'Image Box Width', 'htmega-pro' ),
                        'type'  => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                            ],
                        ],
                        'default' => [
                            'size' =>70,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-header-image' => 'flex:0 0 {{SIZE}}px;',
                        ],
                        'condition' => [
                            'review_image' =>'yes',
                        ]
                    ]
                );

                $this->add_control(
                    'review_image_box_height',
                    [
                        'label' => __( 'Image Box Height', 'htmega-pro' ),
                        'type'  => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                            ],
                        ],
                        'default' => [
                            'size' =>70,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-header-image' => 'height: {{SIZE}}px;'
                    
                        ],
                        'condition' => [
                            'review_image' =>'yes',
                        ]
                    ]
                );
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'review_image_box_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-header-image',
                        'condition' => [
                            'review_image' =>'yes',
                        ]
                        
                    ]
                );    
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'review_image_box_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-header-image',
                        'separator' =>'before',
                        'condition' => [
                            'review_image' =>'yes',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'review_image_boxborder_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-header-image' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                        'condition' => [
                            'review_image' =>'yes',
                        ]
                    ]
                );       
                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name' => 'review_image_box_box_shadow',
                        'label' => __( 'Box Shadow', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-header-image',
                         'condition' => [
                            'review_image' =>'yes',
                        ]
                    ]
                );
                $this->add_responsive_control(
                    'review_image_box_padding',
                    [
                        'label' => esc_html__( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-header-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'review_image' =>'yes',
                        ]
                    ]
                );            
                $this->add_responsive_control(
                    'review_image_box_margin',
                    [
                        'label' => esc_html__( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-header-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'review_image' =>'yes',
                        ]
                    ]
                );            
                // Heading style
                $this->add_control(
                    'review_heading_style',
                    [
                        'label' => __( 'Reviewer Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'review_title' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_title_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-title' => 'color: {{VALUE}}',
                        ],
                        'condition' => [
                            'review_title' =>'yes',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'review_title_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-title',
                        'condition' => [
                            'review_title' =>'yes',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'review_title_margin',
                    [
                        'label' => __( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'review_title' =>'yes',
                        ]
                    ]
                );
                // Rating style
                $this->add_control(
                    'review_rating_style',
                    [
                        'label' => __( 'Rating Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'review_rating' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_rating_color',
                    [
                        'label' => __( 'Rated Star Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default'=>'#FCBD23',
                        'condition' => [
                            'review_rating' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_empty_color',
                    [
                        'label' => __( 'Empty Star Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default'=>'#E2E0E5',
                        'condition' => [
                            'review_rating' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_rating_fontsize',
                    [
                        'label' => __( 'Icon Font Size', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'size' => 21,
                        ],
                        'condition' => [
                            'review_rating' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_review_time',
                    [
                        'label' => __( 'Review Time Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-time' => 'color: {{VALUE}}',
                        ],
                        'condition' => [
                            'review_time' =>'yes',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'review_rating_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-time',
                        'condition' => [
                            'review_time' =>'yes',
                        ]
                    ]
                );
                // Rating content style
                $this->add_control(
                    'review_content_heading_style',
                    [
                        'label' => __( 'Review Content Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'review_content' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_content_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-description' => 'color: {{VALUE}}',
                        ],
                        'condition' => [
                            'review_content' =>'yes',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'review_content_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-description',
                        'condition' => [
                            'review_content' =>'yes',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'review_content_margin',
                    [
                        'label' => __( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'review_content' =>'yes',
                        ]
                    ]
                );
                // Review Button style
                $this->add_control(
                    'review_button_heading_style',
                    [
                        'label' => __( 'Review Button Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                );
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'review_button_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review',
                        'condition' => [
                            'review_write_review_button' =>'yes',
                            'review_write_review_button_text[value]!' =>'',
                        ]
                    ]
                );
    
                $this->add_responsive_control(
                    'review_button_padding',
                    [
                        'label' => __( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                ); 
                $this->add_responsive_control(
                    'review_button_margin',
                    [
                        'label' => __( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                ); 
                $this->add_control(
                    'review_button_icon_size',
                    [
                        'label' => __( 'Icon Font Size', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 20,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review i' => 'font-size: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review svg' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'review_write_review_button' =>'yes',
                            'review_write_review_button_icon' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_button_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review svg path' => 'fill: {{VALUE}}',
                        ],
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                );
    
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'review_button_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review',
                        'exclude' => ['image'],
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                );
    
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'review_button_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review',
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                );
    
                $this->add_responsive_control(
                    'review_button_border_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_button_button_hover_style',
                    [
                        'label' => __( 'Button Hover Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'review_button_color_hover',
                    [
                        'label' => __( 'Hover Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review:hover svg path' => 'fill: {{VALUE}}',
                        ],
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                );
    
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'review_button_background_hover',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-fb-ratings-wrapper .htmega-facebook-review-item-write-review:hover',
                        'exclude' => ['image'],
                        'condition' => [
                            'review_write_review_button' =>'yes',
                        ]
                    ]
                );
            $this->end_controls_tab();

            $this->end_controls_tabs();
        $this->end_controls_section();
        // Review style end
       // Style arrow style start
       $this->start_controls_section(
        'htmega_carousel_arrow_style',
        [
            'label'     => __( 'Arrow', 'htmega-pro' ),
            'tab'       => Controls_Manager::TAB_STYLE,
            'condition' =>[
                'review_layout' => 'carousel',
                'slarrows'  => 'yes',
            ],
        ]
    );
        
        $this->start_controls_tabs( 'carousel_arrow_style_tabs' );

            // Normal tab Start
            $this->start_controls_tab(
                'carousel_arrow_style_normal_tab',
                [
                    'label' => __( 'Normal', 'htmega-pro' ),
                ]
            );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#ffffff',
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow svg path' => 'fill: {{VALUE}};',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_fontsize',
                    [
                        'label' => __( 'Font Size', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 20,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'font-size: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow svg' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_arrow_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_arrow_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_height',
                    [
                        'label' => __( 'Height', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 30,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_width',
                    [
                        'label' => __( 'Width', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 30,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_padding',
                    [
                        'label' => __( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'separator' =>'before',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_position',
                    [
                        'label' => __( 'Vertical Position', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_position_x',
                    [
                        'label' => __( 'Horizontal Position', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .htmega-carosul-next.slick-arrow' => 'right: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .htmega-pro-carousel-activation .htmega-carosul-prev.slick-arrow' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

            $this->end_controls_tab(); // Normal tab end

            // Hover tab Start
            $this->start_controls_tab(
                'carousel_arrow_style_hover_tab',
                [
                    'label' => __( 'Hover', 'htmega-pro' ),
                ]
            );

                $this->add_control(
                    'htmega_carousel_arrow_hover_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#ffffff',
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover svg path' => 'fill: {{VALUE}};',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_arrow_hover_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_arrow_hover_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_hover_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

            $this->end_controls_tab(); // Hover tab end

        $this->end_controls_tabs();

    $this->end_controls_section(); // Style instagram arrow style end


    // Style Dots style start
    $this->start_controls_section(
        'htmega_carousel_dots_style',
        [
            'label'     => __( 'Pagination', 'htmega-pro' ),
            'tab'       => Controls_Manager::TAB_STYLE,
            'condition' =>[
                'review_layout' => 'carousel',
                'sldots'  => 'yes',
            ],
        ]
    );
        
        $this->start_controls_tabs( 'carousel_dots_style_tabs' );

            // Normal tab Start
            $this->start_controls_tab(
                'carousel_dots_style_normal_tab',
                [
                    'label' => __( 'Normal', 'htmega-pro' ),
                ]
            );

                $this->add_responsive_control(
                    'carousel_dots_pagination_align',
                    [
                        'label' => __( 'Alignment', 'htmega-pro' ),
                        'type' => Controls_Manager::CHOOSE,
                        'options' => [
                            'left' => [
                                'title' => __( 'Left', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => __( 'Center', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => __( 'Right', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots' => 'text-align: {{VALUE}};',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_dots_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_dots_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_height',
                    [
                        'label' => __( 'Height', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 15,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li' => 'height: {{SIZE}}px;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_width',
                    [
                        'label' => __( 'Width', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 15,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li' => 'width: {{SIZE}}px !important;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_position_x',
                    [
                        'label' => __( 'Horizontal Position', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => -200,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots' => 'bottom: {{SIZE}}px;',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'htmega_carousel_dots_pagination_inner_space',
                    [
                        'label' => __( 'Inner Gap', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

            $this->end_controls_tab(); // Normal tab end

            // Hover tab Start
            $this->start_controls_tab(
                'carousel_dots_style_hover_tab',
                [
                    'label' => __( 'Active', 'htmega-pro' ),
                ]
            );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_dots_hover_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_dots_hover_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_hover_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

            $this->end_controls_tab(); // Hover tab end

        $this->end_controls_tabs();

    $this->end_controls_section(); // Style dots style end
    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $sectionid = "sid". $this-> get_id();
        $fb_page_id  = sanitize_text_field( htmega_get_option( 'fb_page_id','htmega_general_tabs' ) );
        $fb_page_access_token  = sanitize_text_field( htmega_get_option( 'fb_page_access_token','htmega_general_tabs' ) );
        $schedule_update_days  = (int)htmega_get_option( 'schedule_update_days','htmega_general_tabs' );
        $page_name = $settings['page_name'];
        // $fb_page_id = $settings['fb_page_id'];
        // $fb_page_access_token = $settings['fb_page_access_token'];
        $show_page_info = $settings['show_page_info']; 
        $page_title = $settings['page_title']; 
        $page_image = $settings['page_image']; 
        $page_rating = $settings['page_rating']; 
        $page_rate = $settings['page_rate']; 
        $reviews_number_text = $settings['reviews_number_text']; 
        $page_write_review_button = $settings['page_write_review_button']; 
        $page_write_review_button_text = $settings['page_write_review_button_text']; 
        $page_write_review_button_icon = $settings['page_write_review_button_icon']; 

        $show_reviews = $settings['show_reviews']; 
        $review_title = $settings['review_title']; 
        $review_image = $settings['review_image']; 
        $review_rating = $settings['review_rating']; 
        $review_time = $settings['review_time']; 
        $review_write_review_button = $settings['review_write_review_button']; 
        $review_write_review_button_text = $settings['review_write_review_button_text']; 
        $review_write_review_button_icon = $settings['review_write_review_button_icon']; 



        $slider_settings = [
            'sectionid'=> $sectionid,
            'arrows' => ('yes' === $settings['slarrows']),
            'arrow_prev_txt' => HTMega_Icon_manager::render_icon( $settings['slprevicon'], [ 'aria-hidden' => 'true' ] ),
            'arrow_next_txt' => HTMega_Icon_manager::render_icon( $settings['slnexticon'], [ 'aria-hidden' => 'true' ] ),
            'dots' => ('yes' === $settings['sldots']),
            'autoplay' => ('yes' === $settings['slautolay']),
            'autoplay_speed' => absint($settings['slautoplay_speed']),
            'animation_speed' => absint($settings['slanimation_speed']),
            'loop' => ('yes' === $settings['slloop']),
        ];

        $slider_responsive_settings = [
            'display_columns' => absint( $settings['slitems'] ),
            'scroll_columns' => absint( $settings['slscroll_columns'] ),
            'tablet_width' => absint( $settings['tablet_width'] ),
            'tablet_display_columns' => isset( $settings["slitems_tablet"] ) ? absint( $settings["slitems_tablet"] ) : absint( $settings['slitems'] ),
            'tablet_scroll_columns' => isset( $settings["slscroll_columns_tablet"] ) ? absint( $settings["slscroll_columns_tablet"] ) : absint( $settings['slscroll_columns'] ),
            'mobile_width' => absint( $settings['mobile_width'] ),
            'mobile_display_columns' => isset( $settings["slitems_mobile"] ) ? absint( $settings["slitems_mobile"] ) : absint( $settings['slitems'] ),
            'mobile_scroll_columns' => isset( $settings["slscroll_columns_mobile"] ) ? absint( $settings["slscroll_columns_mobile"] ) : absint( $settings['slscroll_columns'] ),
        ];

        $slider_settings = array_merge( $slider_settings, $slider_responsive_settings );

        if( $settings['review_layout'] == 'carousel'){
            $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'class', 'htmega-fb-ratings-wrapper htmega-pro-carousel-activation' );   
            $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'data-settings', wp_json_encode( $slider_settings ) );   
        }else{
            $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'class', 'htmega-fb-ratings-wrapper htmega-pro-row' );   
        }
        $s_display_none = ( $settings['review_layout'] == 'carousel') ? ' style="display:none;"':'';
       

    if( !empty( $fb_page_id ) && !empty( $fb_page_access_token ) ){
 
       if('yes' == $show_page_info ) {
            if ( false === get_transient( 'fb_page_info_transient' ) ) {
                $expire = 86400 * $schedule_update_days;
                $page_info_url = "https://graph.facebook.com/v19.0/{$fb_page_id}?access_token={$fb_page_access_token}&fields=id,name,page_token,access_token,rating_count,overall_star_rating,picture,about";
                
                $response = wp_remote_get( $page_info_url );
                
                if ( is_wp_error( $response ) ) {
                    // Handle error
                    $error_message = $response->get_error_message();
                    echo sprintf( // translators: %s is replaced with the error message. Example: "Something went wrong: File not found."
                        esc_html__( 'Something went wrong: %s', 'htmega-pro' ), 
                        esc_html( $error_message )
                    );
                    return;
                }
                
                $fb_page_info_data = wp_remote_retrieve_body( $response );
                set_transient( 'fb_page_info_transient', $fb_page_info_data, $expire );
                
            }
            //delete_transient( 'fb_page_info_transient' );
            $fb_page_info = get_transient( 'fb_page_info_transient' );
            $fb_page_info = json_decode($fb_page_info, true);

            if( isset( $fb_page_info['id'] ) ){

                $overall_star_rating = (isset( $fb_page_info['overall_star_rating'] ) ) ? $fb_page_info['overall_star_rating']:0;
                $page_name =  ($settings['page_name'])? $settings['page_name']:$fb_page_info['name'];
                $reviews_number_text = str_replace( '{{review-count}}', '%s', $settings['reviews_number_text'] );
                $rating_count = $fb_page_info['rating_count'];

                $page_token = $fb_page_info['page_token'];
                $review_link = "https://www.facebook.com/{$fb_page_id}/reviews/";
                
                    ?>
                <div class="htmega-page-overview">
                    <!-- Facebook Review Item Start -->
                    <div class="htmega-facebook-review-item htmega-facebook-page-overview">
                        <div class="htmega-facebook-review-item-header">
                            <?php if( 'yes' == $page_image && $fb_page_info['picture']['data']['url'] ){ ?>
                            <div class="htmega-facebook-review-item-header-image">
                                <img src="<?php echo esc_url( $fb_page_info['picture']['data']['url'] ); ?>" alt="<?php echo esc_attr( $fb_page_info['name'] ); ?>">
                            </div>
                            <?php } ?>
                            <div class="htmega-facebook-review-item-header-content">
                                <?php if('yes' == $page_title ){ ?>
                                <h5 class="htmega-facebook-review-item-title"><?php echo esc_html( $page_name ); ?></h5>
                                <?php } ?>
                                <?php if ( $overall_star_rating >= 0 && 'yes' == $page_rating  ) {
                                    echo '<div class="htmega-facebook-review-item-rating">';
                                        $average =  ( $overall_star_rating / 5 ) * 100;
                                        htmega_get_avg_rating( $average, $settings['rating_fontsize']['size'], $settings['empty_color'], $settings['rating_color'] );

                                        if( 'yes' == $page_rate && !empty( $reviews_number_text )){
                                        ?>
                                        <span class="htmega-facebook-review-item-time"><?php echo wp_kses_post( sprintf($reviews_number_text, $rating_count ) ); ?></span>
                                    <?php    
                                        }
                                        echo '</div>';
                                    }

                                    if( 'yes' == $settings['page_about'] ){
                                ?>
                                <p class="htmega-facebook-review-item-description">
                                    <?php echo esc_html( wp_trim_words( $fb_page_info['about'], (int)$settings['content_limit'], '' ) ); ?></p>
                            <?php } ?>
                            </div>
                        </div>
                        <?php if ( 'yes' == $page_write_review_button && ('yes' == $page_write_review_button_icon) || !empty( $page_write_review_button_text ) ) { ?>
                        <div class="htmega-facebook-review-item-footer">
                            <a href="<?php echo esc_url( $review_link ); ?>" class="htmega-facebook-review-item-write-review" target="_blank">
                            <?php if ( 'yes' == $page_write_review_button_icon ) { ?>
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.7616 4.19059L13.714 5.14297M14.1901 1.80964C14.3778 1.99722 14.5266 2.21993 14.6282 2.46505C14.7297 2.71017 14.782 2.97289 14.782 3.23821C14.782 3.50353 14.7297 3.76625 14.6282 4.01137C14.5266 4.25649 14.3778 4.4792 14.1901 4.66678L5.14253 13.7144L1.33301 14.6668L2.28539 10.9106L11.3368 1.81345C11.6936 1.45494 12.1721 1.2437 12.6774 1.22164C13.1827 1.19959 13.6778 1.36834 14.0644 1.6944L14.1901 1.80964ZM7.04729 14.6668H14.6663H7.04729Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                <?php }
                                if ( !empty( $page_write_review_button_text ) ) { echo esc_html( $page_write_review_button_text ); } ?>
                            </a>
                        </div>
                        <?php } ?>
                    </div> <!-- Facebook Review Item End -->
                </div>
                <?php
            } else {
                ?>
                <div class="htmega-error-notice">
                    <?php echo esc_html__( 'Something went wrong! It seems like the info is not valid', 'htmega-pro' ); ?>
                </div>
                <?php
                delete_transient( 'fb_page_info_transient' );
                return false;
            }
        } //end page info
        if( 'yes' == $show_reviews ) {
            if ( false === get_transient( 'fb_rating_transient' ) ) {
                $expire = 86400 * $schedule_update_days;
                $rating_url = "https://graph.facebook.com/v14.0/{$fb_page_id}/ratings?access_token={$fb_page_access_token}&fields=reviewer{id,name,picture.width(100).height(100)},created_time,rating,recommendation_type,review_text,open_graph_story{id}&limit=9999";
                
                $response = wp_remote_get( $rating_url );
                
                if ( is_wp_error( $response ) ) {
                    // Handle error
                    $error_message = $response->get_error_message();
                    echo sprintf( // translators: %s is replaced with the error message. Example: "Something went wrong: File not found."
                        esc_html__( 'Something went wrong: %s', 'htmega-pro' ), 
                        esc_html( $error_message )
                    );
                    return;
                }
                
                $fb_rating_data = wp_remote_retrieve_body( $response );
                set_transient( 'fb_rating_transient', $fb_rating_data, $expire );
            }
            $fb_ratings = get_transient( 'fb_rating_transient' );
            $fb_ratings = json_decode( $fb_ratings,true );

            if( isset( $fb_ratings['data'] ) ){
                echo "<div ".$this->get_render_attribute_string( 'htmega_pro_wrapper_attr' ).$s_display_none." >";

                foreach($fb_ratings['data'] as $key=>$rating_data ){
                if( 'positive' == $rating_data['recommendation_type']){
                    $reviewer_star_rating = 5;
                }else {
                    $reviewer_star_rating = isset($rating_data['rating']) ? $rating_data['rating']: 1;
                }

                $reviewer = isset( $rating_data['reviewer']['data'] ) ? $rating_data['reviewer']['data'] :array() ;
                $created_time = $rating_data['created_time'];
                $review_link = "https://www.facebook.com/{$fb_page_id}/reviews/";
            
                ?>
                <div class='htmega-flex-column'>
                    <div class="htmega-facebook-review-item">
                        <div class="htmega-facebook-review-item-header">
                            <?php if( 'yes' == $review_image ){
                                
                                if( isset( $reviewer['picture']['data']['url'] ) ){ ?>
                                    <div class="htmega-facebook-review-item-header-image">
                                        <img src="<?php echo esc_url( $reviewer['picture']['data']['url'] ); ?>" alt="<?php echo esc_attr( $reviewer['name'] ); ?>">
                                    </div>
                               <?php } else {
                                        ?>
                                        <div class="htmega-facebook-review-item-header-image">
                                           <?php echo FACEBOOK_AVATAR;  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                        </div>
                                        <?php
                                    }
                                } ?>
                            <div class="htmega-facebook-review-item-header-content">
                                <?php if( 'yes' == $review_title ){
                                    
                                    if( isset( $reviewer['name'] ) && !empty( $reviewer['name'] ) ){ ?>
                                        <h5 class="htmega-facebook-review-item-title"><?php echo esc_html( $reviewer['name'] ); ?></h5>
                                       <?php
                                     } else { ?>
                                        <h5 class="htmega-facebook-review-item-title"><?php echo esc_html__( 'Anonymous', 'htmega-pro' ); ?></h5>
                                        <?php 
                                        }
                                   } ?>
                                <?php if ( $reviewer_star_rating >= 0 && 'yes' == $review_rating  ) {

                                    echo '<div class="htmega-facebook-review-item-rating">';
                                        $average =  ( $reviewer_star_rating / 5 ) * 100;
                                        htmega_get_avg_rating( $average,  $settings['review_rating_fontsize']['size'], $settings['review_empty_color'], $settings['review_rating_color'] );
                                        echo '</div>';
                                    }
                                ?>
                            </div>
                        </div>
                        <?php
                        if( 'yes' == $settings['review_content'] ){ ?>

                        <div class="htmega-facebook-review-item-body">
                            <p class="htmega-facebook-review-item-description">
                            <?php echo esc_html( wp_trim_words( $rating_data['review_text'], (int)$settings['review_content_limit'], '' ) ); ?></p>
                        </div>
                        <?php } ?>
                        <?php if ( ('yes' == $review_write_review_button && ('yes' == $review_write_review_button_icon) || !empty( $review_write_review_button_text )) || 'yes' == $review_time && !empty( $created_time )  ) { ?>
                        <div class="htmega-facebook-review-item-footer">
                            <a href="<?php echo esc_url( $review_link ); ?>" class="htmega-facebook-review-item-write-review" target="_blank">
                            <?php if ( 'yes' == $review_write_review_button_icon ) { ?>
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.7616 4.19059L13.714 5.14297M14.1901 1.80964C14.3778 1.99722 14.5266 2.21993 14.6282 2.46505C14.7297 2.71017 14.782 2.97289 14.782 3.23821C14.782 3.50353 14.7297 3.76625 14.6282 4.01137C14.5266 4.25649 14.3778 4.4792 14.1901 4.66678L5.14253 13.7144L1.33301 14.6668L2.28539 10.9106L11.3368 1.81345C11.6936 1.45494 12.1721 1.2437 12.6774 1.22164C13.1827 1.19959 13.6778 1.36834 14.0644 1.6944L14.1901 1.80964ZM7.04729 14.6668H14.6663H7.04729Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                <?php }
                                if ( !empty( $review_write_review_button_text ) ) { echo esc_html( $review_write_review_button_text ); } ?>
                            </a>
                            <?php
                            if( 'yes' == $review_time && !empty( $created_time ) ){ ?>
                                <span class="htmega-facebook-review-item-time"><?php echo esc_html( htmega_time_ago($created_time) ); ?></span>
                            <?php } ?>
                        </div>
                        <?php } ?>
                    </div> <!-- Facebook Review Item End -->
                </div>
                <?php
                } //close repeater
                echo "</div>";

            } else { 
                
                    if( $fb_ratings['error'] ){ ?>
                        <div class="htmega-error-notice">
                            <?php echo esc_html__( 'Something went wrong! It seems like the info is not valid', 'htmega-pro' ); ?>
                        </div>
                        <?php
                        delete_transient( 'fb_rating_transient' );
                        return false;
                    } else { ?>
                        <div class="htmega-error-notice">
                            <?php echo esc_html__( 'Something went wrong! It seems like the page you have selected does not have any reviews available.', 'htmega-pro'); ?>
                        </div>
                        <?php
                        delete_transient( 'fb_rating_transient' );
                        return false;
                    }
                
                }
            } //end rating info

        }else{
            ?>


            <div class="htmega-error-notice">
                <?php
                    echo esc_html__('Please insert the page ID and Access Token from the Dashboard > HTMega Addons > Settings.', 'htmega-pro' );
                 ?>
            </div>
            <?php
            delete_transient( 'fb_rating_transient' );
            delete_transient( 'fb_page_info_transient' );
            return false;
        }
    }

}

