<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Filterable_Gallery_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-filterable-gallery-addons';
    }
    
    public function get_title() {
        return esc_html__( 'Filterable Gallery', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-gallery-justified';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_style_depends() {
        return ['magnific-popup'];
    }
    public function get_script_depends() {
        return ['isotope','imagesloaded','magnific-popup'];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'filterable gallery', 'filter', 'filterable', 'gallery', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/filterable-gallery-widget/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {
        $this->_general_controls();
        $this->_style_controls();
    }

    protected function _general_controls(){ 
        $this->__filterable_gallery_settings_controls();
        $this->__filterable_gallery_controls();
        $this->__filterable_gallery_item_controls();
    }

    protected function __filterable_gallery_settings_controls(){
        $this->start_controls_section(
            'filterable_gallery_settings',
            [
                'label' => esc_html__('Gallery Settings', 'htmega-pro'),
            ]
        );

            $this->add_control(
                'filterable_gallery_layout',
                [
                    'label' => esc_html__( 'Layout', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [
                        '1'   => esc_html__( 'Layout One', 'htmega-pro' ),
                        '2'   => esc_html__( 'Layout Two', 'htmega-pro' ),
                        '3'   => esc_html__( 'Layout Three', 'htmega-pro' ),
                        '4'   => esc_html__( 'Layout Four', 'htmega-pro' ),
                        '5'   => esc_html__( 'Layout Five', 'htmega-pro' ),
                        '6'   => esc_html__( 'Layout Six', 'htmega-pro' ),
                        '7'   => esc_html__( 'Layout Seven', 'htmega-pro' ),
                    ],
                ]
            );

            $this->add_control(
                'filter_enable',
                [
                    'label' => esc_html__('Enable Filter Menu', 'htmega-pro'),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'htmega-pro' ),
				    'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
				    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );

            $this->add_control(
                'filterable_gallery_menu_layout',
                [
                    'label' => esc_html__( 'Menu Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [
                        '1'   => esc_html__( 'Style 1', 'htmega-pro' ),
                        '2'   => esc_html__( 'Style 2', 'htmega-pro' ),
                        '3'   => esc_html__( 'Style 3', 'htmega-pro' ),
                        '4'   => esc_html__( 'Style 4', 'htmega-pro' ),
                        '5'   => esc_html__( 'Style 5', 'htmega-pro' ),
                        '6'   => esc_html__( 'Style 6', 'htmega-pro' ),
                        '7'   => esc_html__( 'Style 7', 'htmega-pro' ),
                    ],
                    'condition' => [
                        'filter_enable' => 'yes',
                    ],
                ]
            );

            $this->add_control(
                'filterable_gallery_column',
                [
                    'label' => esc_html__('Select Grid', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '3',
                    'options' => [
                        '1' => esc_html__('Column 1', 'htmega-pro'),
                        '2' => esc_html__('Column 2', 'htmega-pro'),
                        '3' => esc_html__('Column 3', 'htmega-pro'),
                        '4' => esc_html__('Column 4', 'htmega-pro'),
                        '5' => esc_html__('Column 5', 'htmega-pro'),
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'zoom_type',
                [
                    'label'   => esc_html__( 'Zoom Icon Type', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'toggle' => false,
                    'options' => [
                        'icon' => [
                            'title' => esc_html__( 'Icon', 'htmega-pro' ),
                            'icon'  => 'eicon-info-circle',
                        ],
                        'image' => [
                            'title' => esc_html__( 'Image', 'htmega-pro' ),
                            'icon'  => 'eicon-image-bold',
                        ],
                    ],
                    'default' => 'icon',
                    'separator' => 'before',
                    'condition' => [
                        'filterable_gallery_layout' => ['2','5','6','7'],
                    ]
                ]
            );

            $this->add_control(
                'zoom_icon',
                [
                    'label' => esc_html__( 'Icon', 'htmega-pro' ),
                    'type'  => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-search-plus',
                        'library' => 'fa-solid',
                    ],
                    'condition'=>[
                        'zoom_type'=>'icon',
                         'filterable_gallery_layout' => ['2','5','6','7'],
                    ],
                ]
            );

            $this->add_control(
                'zoom_image',
                [
                    'label' => esc_html__('Image','htmega-pro'),
                    'type'=>Controls_Manager::MEDIA,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'zoom_type' => 'image',
                         'filterable_gallery_layout' => ['2','5','6','7'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'zoom_imagesize',
                    'default' => 'full',
                    'condition' => [
                        'zoom_image[url]!' => '',
                        'zoom_type' => 'image',
                        'filterable_gallery_layout' => ['2','5','6','7'],
                    ]
                ]
            );
            
        $this->end_controls_section();
    }

    protected function __filterable_gallery_controls(){
        $this->start_controls_section(
            'filterable_control_controls',
            [
                'label' => esc_html__('Menu Controls', 'htmega-pro'),
                'condition' => [
                    'filter_enable' => 'yes',
                ]
            ]
        );
            $this->add_control(
                'show_empty_menu',
                [
                    'label' => esc_html__('Show Empty Filter Menu?', 'htmega-pro'),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'htmega-pro' ),
				    'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
				    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'filterable_gallery_all_label_text',
                [
                    'label' => esc_html__('Gallery All Label', 'htmega-pro'),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => [ 'active' => true ],
                    'default' => esc_html__('All', 'htmega-pro'),
                    'condition' => [
                        'filter_enable' => 'yes',
                    ],
                ]
            );            
            

            $repeater = new Repeater();
            $repeater->add_control(
                'filterable_menu',
                [
                    'label' => esc_html__( 'List Item', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => [ 
                        'active' => true 
                    ],
                ]
            );

            $this->add_control(
                'filterable_menu_list',
                [
                    'label' => esc_html__( 'Gallery Item Menu', 'htmega-pro' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        ['filterable_menu' => esc_html__( 'Item #1', 'htmega-pro' )],
                        ['filterable_menu' => esc_html__( 'Item #2', 'htmega-pro' )],
                        ['filterable_menu' => esc_html__( 'Item #3', 'htmega-pro' )],
                        ['filterable_menu' => esc_html__( 'Item #4', 'htmega-pro' )],
                    ],
                    'title_field' => '{{{ filterable_menu }}}',
                    'condition' => [
                        'filter_enable' => 'yes',
                    ],
                ]
            );        
        $this->end_controls_section();
    }
    
    protected function __filterable_gallery_item_controls(){
        $this->start_controls_section(
            'gallery_item_settings',
            [
                'label' => esc_html__('Gallery Items', 'htmega-pro'),
            ]
        );
            
            $repeater = new Repeater();
                
            $repeater->add_control(
                'gallery_control_name',
                [
                    'label' => esc_html__('Menu Control Name', 'htmega-pro'),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => ['active' => true],
                    'label_block' => true,
                    'description' => htmega_kses_title('Use the gallery control name from Control Settings.<strong>(Ex. Item 1, Item 2, Item 3)</strong>', 'htmega-pro'),
                ]
            );

            $repeater->add_control(
                'show_item_before_title_icon',
                [
                    'label' => esc_html__('Show Title Before Icon', 'htmega-pro'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'no',
                    'label_on' => esc_html__('Yes', 'htmega-pro'),
                    'label_off' => esc_html__('No', 'htmega-pro'),
                    'return_value' => 'yes',
                ]
            );
            
            $repeater->add_control(
                'item_before_title_type',
                [
                    'label'   => esc_html__( 'Title Before Icon Type', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'toggle' => false,
                    'options' => [
                        'icon' => [
                            'title' => esc_html__( 'Icon', 'htmega-pro' ),
                            'icon'  => 'eicon-info-circle',
                        ],
                        'image' => [
                            'title' => esc_html__( 'Image', 'htmega-pro' ),
                            'icon'  => 'eicon-image-bold',
                        ],
                    ],
                    'default' => 'icon',
                    'separator' => 'before',
                    'condition' => [
                        'show_item_before_title_icon' => 'yes',
                    ]
                ]
            );

            $repeater->add_control(
                'item_before_title_icon',
                [
                    'label' => esc_html__( 'Icon', 'htmega-pro' ),
                    'type'  => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-info',
                        'library' => 'fa-solid',
                    ],
                    'condition'=>[
                        'item_before_title_type'=>'icon',
                        'show_item_before_title_icon' => 'yes',
                    ],
                ]
            );

            $repeater->add_control(
                'item_before_title_image',
                [
                    'label' => esc_html__('Image','htmega-pro'),
                    'type'=>Controls_Manager::MEDIA,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'item_before_title_type' => 'image',
                        'show_item_before_title_icon' => 'yes',
                    ]
                ]
            );
            $repeater->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'item_before_title_imagesize',
                    'default' => 'full',
                    'condition' => [
                        'item_before_title_image[url]!' => '',
                        'item_before_title_type' => 'image',
                        'show_item_before_title_icon' => 'yes',
                    ]
                ]
            );
            
            $repeater->add_control(
                'gallery_item_title',
                [
                    'label' => esc_html__('Gallery Title', 'htmega-pro'),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => ['active' => true],
                    'label_block' => true,
                    'default' => esc_html__('Gallery item name', 'htmega-pro'),
                ]
            );
            

            $repeater->add_control(
                'gallery_img',
                [
                    'label' => esc_html__('Gallery Image', 'htmega-pro'),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );

            $repeater->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'gallery_img_size',
                    'default' => 'full',
                    'condition' => [
                        'gallery_img[url]!' => '',
                    ]
                ]
            );
            
            $repeater->add_control(
                'gallery_item_content',
                [
                    'label' => esc_html__('Item Description', 'htmega-pro'),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'rows' => 4,
                    'default' => esc_html__('Trade crypto like a pro.', 'htmega-pro'),
                ]
            );
            
            $repeater->add_control(
                'gallery_img_link',
                [
                    'label' => esc_html__('Gallery Item Link', 'htmega-pro'),
                    'type' => Controls_Manager::URL,
                    'dynamic'   => ['active' => true],
                    'label_block' => true,
                    'default' => [
                        'url' => '#',
                    ],
                ]
            );
            
            $this->add_control(
                'filterable_gallery_item_list',
                [
                    'type' => Controls_Manager::REPEATER,
                    'seperator' => 'before',
                    'default' => [
                        [
                            'gallery_item_title' => 'Gallery Item',
                            'gallery_control_name' => 'Item #1'
                        ], 
                        [
                            'gallery_item_title' => 'Gallery Item',
                            'gallery_control_name' => 'Item #2'
                        ], 
                        [
                            'gallery_item_title' => 'Gallery Item',
                            'gallery_control_name' => 'Item #1'
                        ], 
                        [
                            'gallery_item_title' => 'Gallery Item',
                            'gallery_control_name' => 'Item #3'
                        ], 
                        [
                            'gallery_item_title' => 'Gallery Item',
                            'gallery_control_name' => 'Item #2'
                        ], 
                        [
                            'gallery_item_title' => 'Gallery Item',
                            'gallery_control_name' => 'Item #3'
                        ],
                    ],
                    'fields' => $repeater->get_controls(),
                    'title_field' => '{{gallery_item_title}}',
                ]
            );
        $this->end_controls_section();
    }    

    //_style_controls
    protected function _style_controls() {
        $this->___filterable_section_style();
        $this->___filterable_menu_style();
        $this->___gallery_item_style();
        $this->__gallery_item_hover_style();
        $this->__gallery_item_zoom_icon_style();
    }

    protected function ___filterable_section_style(){
        $this->start_controls_section(
            'filterable_section_style_settings',
            [
                'label' => esc_html__(' Filterable Gallery Wrapper Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            'filterable_section_background_color',
            [
                'label' => esc_html__('Background Color', 'htmega-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-filterable-gallery-wrap' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'filterable_section_container_padding',
            [
                'label' => esc_html__('Padding', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .htmega-filterable-gallery-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'filterable_section_container_margin',
            [
                'label' => esc_html__('Margin', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .htmega-filterable-gallery-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'filterable_section_border',
                'label' => esc_html__('Border', 'htmega-pro'),
                'selector' => '{{WRAPPER}} .htmega-filterable-gallery-wrap',
            ]
        );
        
        $this->add_responsive_control(
            'filterable_section_border_radius',
            [
                'label' => esc_html__('Border Radius', 'htmega-pro'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 0,
                ],
                'range' => [
                    'px' => [
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-filterable-gallery-wrap' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'filterable_section_shadow',
                'selector' => '{{WRAPPER}} .htmega-filterable-gallery-wrap',
            ]
        );
        
        $this->end_controls_section();
    }

    protected function ___filterable_menu_style(){
        $this->start_controls_section(
            'filterable_menu_style_section',
            [
                'label' => esc_html__( 'Menu Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'filter_enable' => 'yes',
                ]
            ]
        );

            $this->add_control(
                'menu_section_style',
                [
                    'label' => esc_html__( 'Menu Section Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'filterable_menu_alignment',
                [
                    'label'   => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-filter'   => 'text-align: {{VALUE}};',
                        '{{WRAPPER}} .htmega-text-center'   => 'text-align: {{VALUE}};',
                    ],
                    'condition' => [
                        'filterable_gallery_menu_layout!' => ['6']
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'menu_section_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-filterable-gallery-filter',
                ]
            );

            $this->add_responsive_control(
                'menu_section_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-filter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'menu_section_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-filter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'menu_section_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-filterable-gallery-filter',
                ]
            );

            $this->add_responsive_control(
                'menu_section_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-filter' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'after',
                ]
            );

            $this->add_control(
                'menu_style',
                [
                    'label' => esc_html__( 'Menu Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'filterable_menu_typography',
                    'selector' => '{{WRAPPER}} .htmega-filterable-gallery-btn, {{WRAPPER}} .htmega-filters-select, {{WRAPPER}} .htmega-filterable-gallery-filter-search input',
                ]
            );

            // Menu Style Normal Tabs Start
            $this->start_controls_tabs( 'menu_style_tabs' );

                // Menu Style Normal Tab Start
                $this->start_controls_tab(
                    'menu_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'menu_normal_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-btn' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-filters-select' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-6 .htmega-filters-select:focus' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-search input' => 'color: {{VALUE}};',
                                
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-6 .htmega-filterable-gallery-filter-inner-border::before' => 'background: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'menu_normal_input_placeholder_color',
                        [
                            'label'     => esc_html__( 'Input placeholder Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-search input::placeholder' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-search input:-ms-input-placeholder' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-search input:-ms-input-placeholder' => 'color: {{VALUE}};',

                            ],
                            'condition' => [
                                'filterable_gallery_menu_layout' => '7',
                            ]
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_normal_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-filterable-gallery-btn, {{WRAPPER}} .htmega-filterable-gallery-filter-inner',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_normal_padding',
                        [
                            'label' => esc_html__( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'menu_normal_margin',
                        [
                            'label' => esc_html__( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'menu_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-filterable-gallery-btn, {{WRAPPER}} .htmega-filterable-gallery-filter-inner',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'after',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'menu_normal_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-filterable-gallery-btn, {{WRAPPER}} .htmega-filterable-gallery-filter-inner',
                            'separator' => 'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_normal_hight',
                        [
                            'label'   => __( 'Menu Height', 'htmega-pro' ),
                            'type'    => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 250,
                                ],
                            ],
                            'size_units' => [ 'px' ],
                            'selectors'  => [
                                '{{WRAPPER}} .htmega-filterable-gallery-btn' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-inner' => 'height: {{SIZE}}{{UNIT}};',
                               
                            ],
                            'condition' => [
                                'filterable_gallery_menu_layout' => ['6'],
                            ]
                        ]
                    );
                $this->end_controls_tab(); // Menu Style Normal Tab end

                // Menu Style Hover Tab Start
                $this->start_controls_tab(
                    'menu_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'menu_hover_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-btn:hover' => 'color: {{VALUE}};',  
                                '{{WRAPPER}} .htmega-filters-select:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-search input:hover' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-filterable-gallery-btn:hover, {{WRAPPER}} .htmega-filterable-gallery-filter-inner:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'menu_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-filterable-gallery-btn:hover, {{WRAPPER}} .htmega-filterable-gallery-filter-inner:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter-inner:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'after',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'menu_hover_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-filterable-gallery-btn:hover, {{WRAPPER}} .htmega-filterable-gallery-filter-inner:hover',
                            'separator' => 'before',
                        ]
                    );
                $this->end_controls_tab(); // Menu Style Hover Tab End

                // Menu Style Active Tab Start
                $this->start_controls_tab(
                    'menu_style_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'htmega-pro' ),
                        'condition' => [
                            'filterable_gallery_menu_layout!' => '6',
                        ]
                    ]
                );
                    
                    $this->add_control(
                        'menu_active_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-btn.is-checked' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_active_background_normal',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '
                            
                            {{WRAPPER}} .htmega-filterable-gallery-filter.htmega-filterable-gallery-filter-1 .htmega-filterable-gallery-btn.is-checked, {{WRAPPER}} .htmega-filterable-gallery-filter-4.htmega-filterable-gallery-filter .htmega-filterable-gallery-btn.is-checked, {{WRAPPER}} .htmega-filterable-gallery-filter-5.htmega-filterable-gallery-filter .htmega-filterable-gallery-btn.is-checked, {{WRAPPER}} .htmega-filterable-gallery-filter-7.htmega-filterable-gallery-filter .htmega-filterable-gallery-btn.is-checked,',
                            'condition' => [
                                'filterable_gallery_menu_layout' => ['4','5','7'],
                            ]
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_active_background_before_after',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '
                            {{WRAPPER}} .htmega-filterable-gallery-filter-3.htmega-filterable-gallery-filter .htmega-filterable-gallery-btn::after,
                            {{WRAPPER}} .htmega-filterable-gallery-filter-2.htmega-filterable-gallery-filter .htmega-filterable-gallery-btn.is-checked::before,
                            {{WRAPPER}} .htmega-filterable-gallery-filter-3.htmega-filterable-gallery-filter .htmega-filterable-gallery-btn.is-checked::after',
                            'condition' => [
                                'filterable_gallery_menu_layout' => ['2','3'],
                            ]
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_active_background_gradient_color',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-filterable-gallery-filter .htmega-filterable-gallery-btn.is-checked, {{WRAPPER}} .htmega-filterable-gallery-btn.is-checked, {{WRAPPER}} .htmega-filterable-gallery-btn.is-checked::before',
                            'condition' => [
                                'filterable_gallery_menu_layout' => '1',
                            ]
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'menu_active_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-filterable-gallery-btn.is-checked',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_active_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-btn.is-checked' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator' => 'after',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'menu_active_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-filterable-gallery-btn.is-checked',
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'transition_buttom_border',
                        [
                            'label' => esc_html__( 'Transition Buttom Border', 'htmega-pro' ),
                            'type' => Controls_Manager::HEADING,
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'transition_buttom_border_active_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-filter .htmega-filterable-gallery-btn::before' => 'background-color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter .htmega-filterable-gallery-btn::after' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'filterable_gallery_menu_layout' => ['5','7'],
                            ]
                        ]
                    );

                    $this->add_responsive_control(
                        'transition_buttom_border_active_height',
                        [
                            'label' => esc_html__('Height', 'htmega-pro'),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-filterable-gallery-filter .htmega-filterable-gallery-btn::after' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-filterable-gallery-filter .htmega-filterable-gallery-btn::before' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'filterable_gallery_menu_layout' => ['5','7'],
                            ]
                               
                        ]
                    );


                $this->end_controls_tab(); // Menu Style Active Tab End
            $this->end_controls_tabs(); // Menu Style Normal Tabs End
        $this->end_controls_section();
    }

    protected function ___gallery_item_style(){
        $this->start_controls_section(
            'gallery_section_item_style_settings',
            [
                'label' => esc_html__('Item Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
            $this->add_responsive_control(
                'gallery_item_padding',
                [
                    'label' => esc_html__('Padding', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-wrap .htmega-filterable-gallery-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'gallery_item_border',
                    'label' => esc_html__('Border', 'htmega-pro'),
                    'selector' => '{{WRAPPER}} .htmega-filterable-gallery-wrap .htmega-filterable-gallery-item',
                ]
            );

            $this->add_responsive_control(
                'gallery_item_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-wrap .htmega-filterable-gallery-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'after',
                ]
            );
            
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'gallery_item_shadow',
                    'selector' => '{{WRAPPER}} .htmega-filterable-gallery-wrap .htmega-filterable-gallery-item',
                ]
            );
        
        $this->end_controls_section();
    }

    protected function __gallery_item_hover_style(){
        $this->start_controls_section(
            'gallery_item_hover_style_section',
            [
                'label' => esc_html__('Title and Description Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                'filterable_gallery_layout!' => ['2','6'],
                ]
            ]
        );
            $this->add_control(
                'gallery_item_hover_content_section_heading',
                [
                    'label' => esc_html__('Content Section', 'htmega-pro'),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
        
            $this->add_control(
                'gallery_item_hover_background_color_after',
                [
                    'label' => esc_html__('Background Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item-image::after' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['1'],
                    ]
                ]
            );

            $this->add_control(
                'gallery_item_hover_background_color',
                [
                    'label' => esc_html__('Background Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-content' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['3','4','5','7'],
                    ]
                ]
            );     


            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'gallery_item_hover_content_section_border',
                    'label' => esc_html__('Border', 'htmega-pro'),
                    'selector' => '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-content',
                    'condition' => [
                        'filterable_gallery_layout' => ['3','5','7'],
                    ]
                ]
            );
            
            $this->add_responsive_control(
                'gallery_item_hover_content_section_radius',
                [
                    'label' => esc_html__('Border Radius', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-content' => 'border-radius: {{SIZE}}px;',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['3','5','7'],
                    ]
                ]
            );
            
            $this->add_responsive_control(
                'gallery_item_hover_content_section_Padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .gallery-item-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout!' => ['1','3','4'],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'gallery_item_hover_content_section_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .gallery-item-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout!' => ['1','3','4'],
                    ],
                ]
            );

            
            $this->add_control(
                'gallery_item_hover_title_heading',
                [
                    'label' => esc_html__('Title', 'htmega-pro'),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            
            $this->add_control(
                'gallery_item_hover_title_color',
                [
                    'label' => esc_html__('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item:hover .htmega-filterable-gallery-item-title' => 'color: {{VALUE}};',
                    ],

                ]
            );
            
            $this->add_control(
                'gallery_item_title_hover_color',
                [
                    'label' => esc_html__('Hover Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item:hover .htmega-filterable-gallery-item-title' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => '4',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'gallery_item_title_hover_typography',
                    'selector' => '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-title',
                ]
            );

            $this->add_responsive_control(
                'gallery_item_title_hover_Padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['4'],
                    ],
                ]
            );

            $this->add_responsive_control(
                'gallery_item_title_hover_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['1','3','4'],
                    ]                   
                ]
            );
            
            $this->add_control(
                'gallery_item_hover_description_typography_heading',
                [
                    'label' => esc_html__('Description', 'htmega-pro'),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            
            $this->add_control(
                'gallery_item_hover_description_color',
                [
                    'label' => esc_html__('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item:hover .htmega-filterable-gallery-item-description' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'gallery_item_hover_description_typography',
                    'selector' => '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-description',
                ]
            );

            $this->add_responsive_control(
                'gallery_item_hover_description_Padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['4'],
                    ],
                ]
            );

            $this->add_responsive_control(
                'gallery_item_hover_description_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['1','3','4'],
                    ] 
                ]
            );
            
        $this->end_controls_section();
    }

    protected function __gallery_item_zoom_icon_style(){
        $this->start_controls_section(
            'gallery_item_zoom_icon_section',
            [
                'label' => esc_html__('Zoom Icon Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'filterable_gallery_layout' => ['2','5','6','7'],
                ]
            ]
        );

            $this->add_control(
                'gallery_item_zoom_icon_bg_color',
                [
                    'label' => esc_html__('Background Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-action' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['2','6'],
                        'filterable_gallery_layout!' => '7',
                    ]
                ]
            );
            
            $this->add_control(
                'gallery_item_zoom_icon_color',
                [
                    'label' => esc_html__('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-img-popup i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-filterable-img-popup svg path' => 'fill: {{VALUE}};',
                    ],
                ]
            );


            $this->add_responsive_control(
                'gallery_item_zoom_icon_size',
                [
                    'label' => esc_html__('Size', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-action' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['2','6'],
                        'filterable_gallery_layout!' => '7',
                    ]
                ]
            );
            
            $this->add_responsive_control(
                'gallery_item_zoom_icon_font_size',
                [
                    'label' => esc_html__('Icon Font Size', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', 'em'],
                    'range' => [
                        'px' => [
                            'max' => 150,
                        ],
                        'em' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-img-popup i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-filterable-img-popup svg' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
                    ],
                    
                ]
            );
            
            
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'gallery_item_zoom_icon_border',
                    'label' => esc_html__('Border', 'htmega-pro'),
                    'selector' => '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-action',
                    'condition' => [
                        'filterable_gallery_layout' => ['2','6'],
                        'filterable_gallery_layout!' => '7',
                    ]
                ]
            );
            
            $this->add_responsive_control(
                'gallery_item_zoom_icon_border_radius',
                [
                    'label' => esc_html__('Border Radius', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-action' => 'border-radius: {{SIZE}}px;',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['2','6'],
                        'filterable_gallery_layout!' => '7',
                    ]
                ]
            );

            $this->add_responsive_control(
                'gallery_item_zoom_icon_border_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-content .htmega-filterable-gallery-item-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout' => ['7','5'],
                    ]                   
                ]
            );


            $this->add_control(
                'zoom_icon_separator',
                [
                    'label' => esc_html__( 'Separator', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'filterable_gallery_layout!' => ['2','6'],
                    ]
                ]
            );

            $this->add_control(
                'zoom_icon_separator_color',
                [
                    'label' => esc_html__('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-content .htmega-filterable-gallery-item-icon::after' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout!' => ['2','6'],
                    ]
                ]
            );

            $this->add_responsive_control(
                'zoom_icon_separator_',
                [
                    'label' => esc_html__('Height', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range' => [
                        'px' => [
                            'max' => 500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-content .htmega-filterable-gallery-item-icon::after' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout!' => ['2','6'],
                    ]
                    
                ]
            );

            $this->add_responsive_control(
                'zoom_icon_separator_width',
                [
                    'label' => esc_html__('Width', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range' => [
                        'px' => [
                            'max' => 500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-content .htmega-filterable-gallery-item-icon::after' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout!' => ['2','6'],
                    ]
                ]
            );


            $this->add_responsive_control(
                'zoom_icon_separator_position',
                [
                    'label' => esc_html__(' Position', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range' => [
                        'px' => [
                            'max' => 500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-filterable-gallery-item .htmega-filterable-gallery-item-content .htmega-filterable-gallery-item-icon::after' => 'left: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'filterable_gallery_layout!' => ['2','6'],
                    ]
                    
                ]
            );

        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $unicid         = $this->get_id();

        $gallery_settings = [
            'is_edit_mode' => \Elementor\Plugin::$instance->editor->is_edit_mode(),
            'img_popup' => '.htmega-gallery-img-popup-' . esc_attr( $unicid ),
            'gallery_item' => 'gallery-item-js' . esc_attr( $unicid ),
        ];


        $this->add_render_attribute( 'gallery_settings_attr', 'class', 'htmega-filterable-active' );
        $this->add_render_attribute( 'gallery_settings_attr', 'data-settings', wp_json_encode( $gallery_settings ) );


        $s_display_none = ( !empty($settings['filterable_gallery_layout']) ) ? ' style="display:none;"':'';

        $filter_enable = $settings['filter_enable'];
        $filterable_all_label_text = $settings['filterable_gallery_all_label_text'];
        $filterable_menu_list = $settings['filterable_menu_list'];
        $layout = $settings['filterable_gallery_layout'];
        $menu_layout = $settings['filterable_gallery_menu_layout'];
        $show_empty_menu = $settings['show_empty_menu'];

        $this->add_render_attribute( 'filterable_gallery_colum_attr', 'class', 'htmega-gallery-sizer htmega-fg-col-'. esc_attr( $settings['filterable_gallery_column'] ) );

        $row_giid_process = "";
        if($layout == "5"){
            $row_giid_process = "htmega-gx-0 htmega-filterable-gallery-row";
        }else if($layout == "7"){
            $row_giid_process = "htmega-gx-1 htmega-filterable-gallery-row";
        }else{
            $row_giid_process = "htmega-gx-4";
        }

        //Blank Menu Organize
        $not_blank_item_menu =[0=>"null"];
        foreach($settings['filterable_gallery_item_list'] as $filter_blank_item_menu){
            $newArry = explode(",",$filter_blank_item_menu['gallery_control_name']);
            if(is_array($newArry)){
                foreach($newArry as $menu){
                    array_push($not_blank_item_menu, strtolower(str_replace("#", "_", str_replace(" ", "_", $menu)))."_".$unicid);
                }
            }else{
                $item_menu = strtolower(str_replace("#", "_", str_replace(" ", "_", $filter_blank_item_menu['gallery_control_name'])));
                if(!empty($item_menu)){
                    array_push($not_blank_item_menu, $item_menu."_".$unicid);
                }
            }
        }

        $not_blank_item_menu = array_unique($not_blank_item_menu);

        $select_option_class = ($menu_layout == "6") ? "htmega-fg-select-grid ":"htmega-filterable-gallery-grid ";
        $this->add_render_attribute( 'filterable_gallery_row_grid_attr', 'class', 'htmega-fg-row ' . esc_attr( $select_option_class.$row_giid_process ) );
        ?>
        <!-- Filterable Gallery Style 4 Start -->
        <div <?php echo $this->get_render_attribute_string( 'gallery_settings_attr' ).$s_display_none; ?>>
            <div class="htmega-filterable-gallery-wrap htmega-page-list-wrap-<?php echo esc_attr( $layout ); ?>">
            
                <!-- Filterable Gallery Start -->
                <?php if($filter_enable == "yes"):?>
                    <div class="htmega-text-center">
                        <div class="htmega-filterable-gallery-filter htmega-filterable-gallery-filter-<?php echo esc_attr( $menu_layout ) ?>" data-target="#htmega-filterable-gallery-<?php echo esc_attr( $unicid ) ?>">
                            <!-- Filterable Menu List -->
                            <?php $this->gallery_filterable_menu($filter_enable, $filterable_all_label_text, $filterable_menu_list, $menu_layout, $unicid, $not_blank_item_menu, $show_empty_menu) ?>
                        </div>
                    </div>
                <?php endif; ?>

                <div id="htmega-filterable-gallery-<?php echo esc_attr( $unicid ) ?>" <?php echo $this->get_render_attribute_string( 'filterable_gallery_row_grid_attr' ); ?>>
                    <?php 
                        $this->gallery_sizer_controller();
                        $this->filterable_gallery_render($settings, $unicid); 
                    ?>
                </div>
                <!-- Filterable Gallery End  -->
            </div>
        </div>
    <?php }

    protected function gallery_sizer_controller(){
        if(!(\Elementor\Plugin::$instance->editor->is_edit_mode()))
        {
            printf('<div %1$s></div>', $this->get_render_attribute_string( 'filterable_gallery_colum_attr' ));
        }
    }

    protected function gallery_filterable_menu($filter_enable, $filterable_all_label_text, $filterable_menu_list, $menu_layout, $unicid, $not_blank_item_menu, $show_empty_menu){
        
        
            if($menu_layout == "6"){
                $gallery_search_settings_js = [
                    'gallery_item' => 'gallery-item-js'.$unicid,
                ];
        
                $this->add_render_attribute( 'gallery_search_settings_js_attr', 'data-searchsettings', wp_json_encode( $gallery_search_settings_js ) );
                ?>
                
                    <form class="htmega-filterable-gallery-filter-inner">
                        <select id="htmega-filters-select" class="htmega-filters-select">
                            <?php 
                                if(!empty($filterable_all_label_text)){
                                    printf('<option value="*">%1$s</option>', esc_html( $filterable_all_label_text ));    
                                }

                                // Menu List
                                foreach($filterable_menu_list as $menu){
                                    if(!empty($menu['filterable_menu'])){
                                        
                                        $unicMenuId =  strtolower(str_replace("#", "_", str_replace(" ", "_", $menu['filterable_menu']."_".$unicid)));
                                        
                                        if(array_search($unicMenuId, $not_blank_item_menu) || $show_empty_menu == "yes"){
                                            printf('<option value=".%1$s">%2$s</option>', esc_attr( $unicMenuId ), esc_html( $menu['filterable_menu'] ));
                                        }
                                    }
                                }
                            ?>
                        </select>
                        <div class="htmega-filterable-gallery-filter-inner-border"></div>
                        <div class="htmega-filterable-gallery-filter-search">
                            <input type="text" name="search" id="htmega-filters-quicksearch" placeholder="Type hare" onkeyup="search_gallery(this)" <?php echo $this->get_render_attribute_string( 'gallery_search_settings_js_attr' )?>/>
                        </div>
                    </form>
               
            <?php }else{
                //All Menu
                if(!empty($filterable_all_label_text)){
                    printf('<button data-filter="*" class="htmega-filterable-gallery-btn is-checked">%1$s</button>', esc_html( $filterable_all_label_text ));    
                }
                // Menu List
                foreach($filterable_menu_list as $menu){
                    if(!empty($menu['filterable_menu'])){
                        $unicMenuId =  strtolower(str_replace("#", "_", str_replace(" ", "_", $menu['filterable_menu']."_".$unicid )));

                        if(array_search($unicMenuId, $not_blank_item_menu) || $show_empty_menu == "yes"){
                            printf('<button data-filter=".%1$s" class="htmega-filterable-gallery-btn">%2$s</button>', esc_attr( $unicMenuId ), esc_html( $menu['filterable_menu'] ) );
                        }
                    
                    }
                }
            }
    }

    protected function filterable_gallery_render($settings, $unicid){
        $layout = $settings['filterable_gallery_layout'];
        
        $zoom_icon = HTMega_Icon_manager::render_icon( $settings['zoom_icon'], [ 'aria-hidden' => 'true' ] ) ;
        $zoom_image = ($settings['zoom_type'] == "image") ? Group_Control_Image_Size::get_attachment_image_html( $settings, 'zoom_imagesize', 'zoom_image' ) : "";
        $zoom_icon_or_image = "";
        if($zoom_icon){
            $zoom_icon_or_image = isset($zoom_icon) ? $zoom_icon : "";
        }else if(!empty($zoom_image)){
            $zoom_icon_or_image = isset($zoom_image) ? $zoom_image : "";
        }
        
        foreach($settings['filterable_gallery_item_list'] as $gallery_item):

            $menu_filter_controlr = strtolower(str_replace("#", "_", str_replace(" ", "_", $gallery_item['gallery_control_name'])));
            $menu_filter_controlr = explode(",",$menu_filter_controlr);
            
            $filter_data = "";
            foreach($menu_filter_controlr as $menu_filter){
                $filter_data .= " ".$menu_filter."_".$unicid;
            }

            $gallery_image = $gallery_item['gallery_img'];
            $gallery_image_size = isset($gallery_item['gallery_img_size']) ? $gallery_item['gallery_img_size'] : 'full';

            $this->remove_render_attribute( 'filterable_gallery_colum_and_catagory_attr');
            $this->add_render_attribute( 'filterable_gallery_colum_and_catagory_attr', 'class', 'htmega-gallery-item htmega-fg-col-'. esc_attr( $settings['filterable_gallery_column']. $filter_data.' gallery-item-js'.$unicid ) );?>

            <div <?php echo $this->get_render_attribute_string( 'filterable_gallery_colum_and_catagory_attr' ); ?>>
                <div class="htmega-filterable-gallery-item htmega-filterable-gallery-item-<?php echo esc_attr( $layout ) ?>">
                    <?php 
                        $this->filterable_gallery_image_render($layout, $gallery_image , $gallery_image_size, $unicid);
                        $this->filterable_gallery_item_render($layout, $gallery_item, $zoom_icon_or_image, $unicid);
                    ?>
                </div>
            </div>
        <?php endforeach;
    }

    protected function filterable_gallery_image_render($layout, $gallery_image, $image_size, $unicid){
        // Remove Elementor Lightbox
        $this->remove_render_attribute( 'popup_content_attr' );
        $this->add_render_attribute( 'popup_content_attr', 'data-elementor-open-lightbox', 'no' );
        
        $imageURL = wp_get_attachment_image_url( $gallery_image['id'], $image_size );
        if ( ! $imageURL ) {
            $imageURL = $gallery_image['url'];
        }

        if($imageURL):
            if($layout == "2" || $layout == "6"){?>
                <div class="htmega-filterable-gallery-item-image">
                    <img class="img-fluid" src="<?php echo esc_url( $imageURL ); ?>" alt="<?php echo esc_attr( isset($gallery_image['alt']) ? $gallery_image['alt'] : "" ); ?>">
            </div>
            <?php } elseif($layout == "5" || $layout == "7"){?>
                <a <?php echo $this->get_render_attribute_string( 'popup_content_attr' ); ?> class="htmega-filterable-gallery-item-image htmega-filterable-img-popup" href="<?php echo esc_url( $imageURL ); ?>">
                    <img class="img-fluid" src="<?php echo esc_url( $imageURL ); ?>" alt="<?php echo esc_attr( isset($gallery_image['alt']) ? $gallery_image['alt'] : "" ); ?>">
                </a>
            <?php }else{ ?>
                <a <?php echo $this->get_render_attribute_string( 'popup_content_attr' ); ?> class="htmega-filterable-gallery-item-image htmega-filterable-img-popup <?php echo esc_attr( 'htmega-gallery-img-popup-'.$unicid )?>" href="<?php echo esc_url( $imageURL ); ?>">
                    <img class="img-fluid" src="<?php echo esc_url( $imageURL ); ?>" alt="<?php echo esc_attr( isset($gallery_image['alt']) ? $gallery_image['alt'] : "" ); ?>">
                </a>
            <?php }    
        endif;
    }

    protected function filterable_gallery_item_render($layout, $gallery_item, $zoom_icon_or_image, $unicid){
        // Remove Elementor Lightbox
        $this->remove_render_attribute( 'popup_content_action_image_attr' );
        $this->add_render_attribute( 'popup_content_action_image_attr', 'data-elementor-open-lightbox', 'no' );
        
        $gallery_image = $gallery_item['gallery_img'];
        $gallery_image_size = isset($gallery_item['gallery_img_size']) ? $gallery_item['gallery_img_size'] : 'full';

        $imageURL = wp_get_attachment_image_url( $gallery_image['id'], $gallery_image_size );
        if ( ! $imageURL ) {
            $imageURL = $gallery_image['url'];
        }

       if($layout == "2" || $layout == "6"){?> 
            <a <?php echo $this->get_render_attribute_string( 'popup_content_action_image_attr' ); ?> href="<?php echo esc_url( $imageURL ) ?>" class="htmega-filterable-gallery-item-action htmega-filterable-img-popup <?php echo esc_html( 'htmega-gallery-img-popup-'.$unicid )?>"><?php echo isset($zoom_icon_or_image) ? $zoom_icon_or_image : "" ; ?></a>
        <?php }else{?>
            <div class="htmega-filterable-gallery-item-content"><?php $this->filterable_gallery_item_content_render($layout, $gallery_item, $imageURL, $zoom_icon_or_image, $unicid) ?></div>
        <?php }
    }

    protected function filterable_gallery_item_content_render($layout, $gallery_item, $imageURL, $zoom_icon_or_image, $unicid){
        // Remove Elementor Lightbox
        $this->remove_render_attribute( 'popup_content_image_attr' );
        $this->add_render_attribute( 'popup_content_image_attr', 'data-elementor-open-lightbox', 'no' );

        $item_content = $gallery_item['gallery_item_content'];

        if($layout == "1" || $layout == "4" || $layout == "3"){
            $this->filterable_gallery_item_title($gallery_item);
            
            if(!empty($item_content)){
                printf('<p class="htmega-filterable-gallery-item-description">%1$s</p>', esc_html( $item_content));
            }
            
        }else if($layout == "3"){
            $this->filterable_gallery_item_title($gallery_item);

        }else if($layout == "5" || $layout == "7"){?>
            <a <?php echo $this->get_render_attribute_string( 'popup_content_image_attr' ); ?> href="<?php echo esc_url( $imageURL ) ?>" class="htmega-filterable-gallery-item-icon htmega-filterable-img-popup <?php echo esc_attr( 'htmega-gallery-img-popup-'.$unicid )?>"><?php echo isset($zoom_icon_or_image) ? $zoom_icon_or_image : "" ; ?></a>
            <?php 
            // Title Rander
            echo "<div class='gallery-item-description'>";
                $this->filterable_gallery_item_title($gallery_item);
                if(!empty($item_content)){
                    printf('<p class="htmega-filterable-gallery-item-description">%1$s</p>', esc_html( $item_content));
                }
            echo "</div>";
        }
    }


    protected function filterable_gallery_item_title($gallery_item){
        //Title And URL
        $gallery_item_title = $gallery_item['gallery_item_title'];
        $gallery_item_Link = $gallery_item['gallery_img_link'];
        
        if ( ! empty( $gallery_item_Link['url'] ) ) {
            $this->remove_render_attribute( 'gallery_img_link' );
            $this->add_link_attributes( 'gallery_img_link', $gallery_item_Link);
        }?>
        <a <?php echo $this->get_render_attribute_string( 'gallery_img_link' ) ?> class="htmega-filterable-gallery-item-title">
            <?php
                if($gallery_item['item_before_title_type'] == 'icon'){
                    echo HTMega_Icon_manager::render_icon( $gallery_item['item_before_title_icon'], [ 'aria-hidden' => 'true' ] );
                }else if($gallery_item['item_before_title_type'] == 'image'){
                    echo Group_Control_Image_Size::get_attachment_image_html( $gallery_item, 'item_before_title_imagesize', 'item_before_title_image' );
                }
                echo htmega_kses_title( " ".$gallery_item_title ) 
            ?>
        </a>
    <?php }
}