<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Image_Roted_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-image-roted-addons';
    }
    
    public function get_title() {
        return __( 'Image Rotate', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-image-before-after';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'image rotate', 'rotate', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/';
	}

    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'htmega-pro' ),
            ]
        );
            
            $this->add_control(
                'imageroted',
                [
                    'label' => __( 'Image', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'imagesize',
                    'default' => 'large',
                    'separator' => 'none',
                ]
            );

        $this->end_controls_section();

        // Style tab section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __( 'Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'rotedimage_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-image-roted img',
                ]
            );

            $this->add_control(
                'rotedimage_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-image-roted' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-image-roted img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $id         = $this->get_id();
        $this->add_render_attribute( 'image_roted', 'class', 'htmega-image-roted' );

        ?>
            <div <?php echo $this->get_render_attribute_string( 'image_roted' ); ?>>
                <?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'imagesize', 'imageroted' );?>
            </div>
        <?php

    }

}

