<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Info_Box_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-info-box-addons';
    }
    
    public function get_title() {
        return __( 'Info Box', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-info';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'info', 'info box', 'context','text box','icon box', 'htmega pro'];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/info-box-widget/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        // Preset start
        $this->start_controls_section(
            'preset_layout',
            [
                'label' => __( 'Ready Layouts', 'htmega-pro' ),
            ]
        );

        $this->add_control(
            'info_box_preset',
            [
                'label'   => __( 'Select Layout', 'htmega-pro' ),
                'type'    => 'htmega-preset-select',
                'default' => '0',
                'options' => [
                    '0'   => __( 'Default', 'htmega-pro' ),
                    '1'   => __( 'Layout One', 'htmega-pro' ),
                    '2'   => __( 'Layout Two', 'htmega-pro' ),
                    '3'   => __( 'Layout Three', 'htmega-pro' ),
                    '4'   => __( 'Layout Four', 'htmega-pro' ),
                    '5'   => __( 'Layout Five', 'htmega-pro' ),
                    '6'   => __( 'Layout Six', 'htmega-pro' ),
                    '7'   => __( 'Layout Seven', 'htmega-pro' ),
                    '8'   => __( 'Layout Eight', 'htmega-pro' ),
                    '9'   => __( 'Layout Nine', 'htmega-pro' ),
                ]
            ]
        );
        $this->end_controls_section(); // Preset end

        // Icon and image start
        $this->start_controls_section(
            'info_box_icon_image',
            [
                'label' => __( 'Icon/image', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'icon_type',
                [
                    'label'   => __( 'Icon Type', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'none' => [
                            'title' => __( 'None', 'htmega-pro' ),
                            'icon'  => 'eicon-ban',
                        ],
                        'icon' => [
                            'title' => __( 'Icon', 'htmega-pro' ),
                            'icon'  => 'eicon-info-circle',
                        ],
                        'image' => [
                            'title' => __( 'Image', 'htmega-pro' ),
                            'icon'  => 'eicon-image-bold',
                        ],
                        'number' => [
                            'title' => __( 'Number', 'htmega-pro' ),
                            'icon'  => 'eicon-counter',
                        ],
                    ],
                    'default' => 'icon',
                ]
            );
            $this->add_control(
                'info_box_number',
                [
                    'label'         => __( 'Number', 'htmega-pro' ),
                    'type'          => Controls_Manager::TEXT,
                    'default'       => __( '01', 'htmega-pro' ),
                    'condition'=>[
                        'icon_type'=>'number',
                    ],
                ]
            );

            $this->add_control(
                'info_box_icon',
                [
                    'label'         => __( 'Icon', 'htmega-pro' ),
                    'type'          => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-info',
                        'library' => 'fa-solid',
                    ],
                    'condition'=>[
                        'icon_type'=>'icon',
                    ],
                ]
            );

            $this->add_control(
                'info_box_image',
                [
                    'label' => __('Image','htmega-pro'),
                    'type'=>Controls_Manager::MEDIA,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'icon_type' => 'image',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'info_box_imagesize',
                    'default' => 'thumbnail',
                    'separator' => 'none',
                    'condition' => [
                        'info_box_image[url]!' => '',
                        'icon_type' => 'image',
                    ]
                ]
            );
            $this->add_control(
                'icon_position',
                [
                    'label' => __('Position', 'htmega-pro'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __('Left', 'htmega-pro'),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'top' => [
                            'title' => __('Top', 'htmega-pro'),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'right' => [
                            'title' => __('Right', 'htmega-pro'),
                            'icon' => 'eicon-h-align-right',
                        ],
                    ],
                    'default' => 'top',
                    'toggle' => false,
                    'condition' => [
                        'icon_type!' => 'none',
                    ]
                ]
            );

            $this->add_control(
                'icon_v_align',
                [
                    'label' => __('Vertical Alignment', 'htmega-pro'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'start' => [
                            'title' => __('Top', 'htmega-pro'),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'center' => [
                            'title' => __('Center', 'htmega-pro'),
                            'icon' => 'eicon-v-align-middle',
                        ],
                        'flex-end' => [
                            'title' => __('Bottom', 'htmega-pro'),
                            'icon' => 'eicon-v-align-bottom',
                        ],
                    ],
                    'default' => 'top',
                    'toggle' => false,
                    'condition' => [
                        'icon_position!' => 'top',
                        'icon_type!' => 'none',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-2' => 'align-items:{{VALUE}};'
                    ]
                ]
            );

        $this->end_controls_section(); // Icon controller end

        // Title and descriptin
        $this->start_controls_section(
            'info_box_title_description',
            [
                'label' => __( 'Title and Description', 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'info_box_title',
            [
                'label'         => __( 'Title', 'htmega-pro' ),
                'type'          => Controls_Manager::TEXT,
                'label_block' => true,
                'default'       => __( 'Info Box Title', 'htmega-pro' ),
                'dynamic' => [
					'active' => true,
				]
            ]
        );
        $this->add_control(
            'info_box_title_tag',
            [
                'label' => __('Select Title Tag', 'htmega-pro'),
                'type' => Controls_Manager::SELECT,
                'default' => 'h3',
                'options' => [
                    'h1' => __('H1', 'htmega-pro'),
                    'h2' => __('H2', 'htmega-pro'),
                    'h3' => __('H3', 'htmega-pro'),
                    'h4' => __('H4', 'htmega-pro'),
                    'h5' => __('H5', 'htmega-pro'),
                    'h6' => __('H6', 'htmega-pro'),
                    'span' => __('Span', 'htmega-pro'),
                    'p' => __('P', 'htmega-pro'),
                    'div' => __('Div', 'htmega-pro'),
                ],
                'condition' => [
                    'info_box_title[value]!' =>'',
                ]
            ]
        );
        $this->add_control(
            'info_box_description',
            [
                'label'         => __( 'Description', 'htmega-pro' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'There are many variations of Ipsum available, but the maj alteration in some.', 'htmega-pro' ),
                'description' => htmega_get_allowed_tag_desc( 'desc' ),
                'rows' => 5,
				'dynamic' => [
					'active' => true,
				]
            ]
        );

        $this->add_control(
            'index_show',
            [
                'label' => esc_html__( 'Add Index Number', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'icon_position' => 'top',
                ],
            ]
        );
        $this->add_control(
            'indexing_number',
            [
                'label'         => __( 'Index Number', 'htmega-pro' ),
                'type'          => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder'       => __( '01', 'htmega-pro' ),
                'frontend_available' => true,
                'condition' => [
                    'icon_position' => 'top',
                    'index_show' => 'yes',
                ],
                'dynamic' => [
					'active' => true,
				],
                'selectors' => [
                    '{{WRAPPER}} .htmega-info-indexing::before' => 'content: "{{VALUE}}";',
                ],
            ]
        );
        $this->end_controls_section(); // Title and description controller end     

        // Button controller
        $this->start_controls_section(
            'info_box_button',
            [
                'label' => __( 'Button', 'htmega-pro' ),
            ]
        );
        $this->add_control(
			'info_box_button_text',
			[
				'label' => __( 'Button Text', 'htmega-pro' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
                'placeholder' => 'Button Text',
				'dynamic' => [
					'active' => true,
                ],
                
			]
		);
        $this->add_control(
			'info_box_button_link',
			[
				'label' => __( 'Link', 'htmega-pro' ),
				'type' => Controls_Manager::URL,
				'placeholder' => 'https://example.com',
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => '',
				]
			]
		);
 
        $this->add_control(
            'link_icon_type',
            [
                'label'   => __( 'link Icon', 'htmega-pro' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'none' => [
                        'title' => __( 'None', 'htmega-pro' ),
                        'icon'  => 'eicon-ban',
                    ],
                    'icon' => [
                        'title' => __( 'Icon', 'htmega-pro' ),
                        'icon'  => 'eicon-info-circle',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'htmega-pro' ),
                        'icon'  => 'eicon-image-bold',
                    ],
                ],
                'default' => 'none',
            ]
        );
        $this->add_control(
            'info_box_link_icon',
            [
                'label'         => __( 'Icon', 'htmega-pro' ),
                'type'          => Controls_Manager::ICONS,
                'condition'=>[
                    'link_icon_type'=>'icon',
                ],
            ]
        );

        $this->add_control(
            'info_box_link_image',
            [
                'label' => __('Image','htmega-pro'),
                'type'=>Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'link_icon_type' => 'image',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'info_box_link_imagesize',
                'default' => 'thumbnail',
                'separator' => 'none',
                'condition' => [
                    'link_icon_type' => 'image',
                    'info_box_link_image[url]!' => '',
                ]
            ]
        );
        $this->add_control(
            'icon_link_position',
            [
                'label' => __('Position', 'htmega-pro'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Before', 'htmega-pro'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'right' => [
                        'title' => __('After', 'htmega-pro'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'right',
                'toggle' => false,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                        'terms' => [
                                ['name' => 'link_icon_type', 'operator' => '!==', 'value' => 'none'],
                                ['name' => 'info_box_button_text', 'operator' => '!==', 'value' => ''],
                                ['name' => 'info_box_link_image[url]', 'operator' => '!==', 'value' => ''],
                            ]
                        ],
                        [
                        'terms' => [
                                ['name' => 'link_icon_type', 'operator' => '!==', 'value' => 'none'],
                                ['name' => 'info_box_button_text', 'operator' => '!==', 'value' => ''],
                                ['name' => 'info_box_link_icon[value]', 'operator' => '!==', 'value' => ''],
                            ]
                        ],
                    ]
                ],
            ]
        );

        $this->end_controls_section(); //Button controller end
 
        // Style
        // Info box style section
        $this->start_controls_section(
            'box_style',
            [
                'label' => esc_html__( 'Info Box Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            
            $this->add_responsive_control(
                'content_alignment',
                [
                    'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box' => 'text-align: {{VALUE}};',
                        '{{WRAPPER}} .htmega-info-box-2' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'box_normal_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'box_normal_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'box_normal_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-info-box',
                ]
            );
            $this->add_control(
                'box_min_height',
                [
                    'label' => __( 'Min Height', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box' => 'min-height: {{SIZE}}px;',
                
                    ],
                ]
            );

            $this->start_controls_tabs('infobox_box_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'box_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-info-box',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-info-box' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'box_normal_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-info-box',
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'box_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-info-box:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-info-box:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'box_hover_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-info-box:hover',
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();
        // info box icon style
        $this->start_controls_section(
            'info_box_icon_style_section',
            [
                'label' => __( 'Icon Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_type!' =>'none',
                ]
            ]
        );
            $this->add_control(
                'icon_width',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' =>70,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-icon' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'icon_height',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' =>70,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-icon' => 'height: {{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-info-box-icon i' => 'line-height:{{SIZE}}{{UNIT}};',
                
                    ],
                ]
            );
            $this->add_control(
                'icon_font_size',
                [
                    'label' => __( 'Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-icon i,{{WRAPPER}} .htmega-info-box-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-info-box-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'icon_type!' =>'image',
                    ]
                ]
            );
            $this->add_responsive_control(
                'icon_margin',
                [
                    'label' => esc_html__( 'Icon Inner space', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-icon img,{{WRAPPER}} .htmega-info-box-icon i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                            ['name' => 'icon_type', 'operator' => '===', 'value' => 'image'],
                            ['name' => 'icon_type', 'operator' => '===', 'value' => 'icon'],
                        ]
                    ],
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-icon' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-info-box-icon i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-info-box-icon svg path' => 'fill: {{VALUE}}',
                    ],
                    'condition' => [
                        'icon_type!' =>'image',
                    ],
                    'separator' =>'before'
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'icon_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-info-box-icon',
                    
                ]
            );    
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'icon_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-info-box-icon',
                    'separator' =>'before'
                ]
            );

            $this->add_responsive_control(
                'icon_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-icon' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );       
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'icon_box_shadow',
                    'label' => __( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-info-box-icon',
                ]
            );
            $this->add_responsive_control(
                'icon_box_margin',
                [
                    'label' => esc_html__( 'Icon Box Space', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();

        // Title tab section
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'info_box_title!' =>'',
                ]
            ]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-info-box-title',
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Description tab section
        $this->start_controls_section(
            'descrioption_style',
            [
                'label' => __( 'Description Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'info_box_description!' =>'',
                ]
            ]
        );

            $this->add_control(
                'description_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-text' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'description_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-info-box-text',
                ]
            );

            $this->add_responsive_control(
                'description_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Button tab section
        $this->start_controls_section(
            'button_style',
            [
                'label' => __( 'Button Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        ['name' => 'info_box_button_text', 'operator' => '!==', 'value' => ''],
                        ['name' => 'link_icon_type', 'operator' => '!==', 'value' => 'none'],
                    ]
                ],
            ]
        );


            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'readmore_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-info-box-link',
                    'condition' => [
                        'info_box_button_text[value]!' =>'',
                    ]
                ]
            );


            $this->add_responsive_control(
                'readmore_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            ); 
            $this->add_control(
                'icon_link_size',
                [
                    'label' => __( 'Icon Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 20,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-link i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-info-box-link svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'link_icon_type' =>'icon',
                    ]
                ]
            );
            $this->add_control(
                'icon_space',
                [
                    'label' => __( 'Icon Space', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-link-position-left .htmega-info-box-link i' => 'margin-right: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-link-position-left .htmega-info-box-link img' => 'margin-right: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-link-position-right .htmega-info-box-link i' => 'margin-left: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-link-position-right .htmega-info-box-link img' => 'margin-left: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-link-position-right .htmega-info-box-link svg' => 'margin-left: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-link-position-right .htmega-info-box-link svg' => 'margin-left: {{SIZE}}px;',
                
                    ],
                    'condition' => [
                        'info_box_button_text[value]!' =>'',
                        'link_icon_type!' =>'none',
                    ]
                ]
            );
                $this->add_responsive_control(
                    'button_alignment',
                    [
                        'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                        'type' => Controls_Manager::CHOOSE,
                        'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                        ],
                        'default' =>'right',
                        'selectors' => [
                            '{{WRAPPER}} .htmega-info-box-link-box' => 'text-align: {{VALUE}};',
                        ],
                        'condition' => [
                            'icon_position' => 'top',
                            'indexing_number[value]!' => '',
                            'index_show' => 'yes',
                            
                        ]
                    ]
                );


            $this->start_controls_tabs('readmore_style_tabs' );

            $this->start_controls_tab(
                'readmore_style_normal_tab',
                [
                    'label' => __( 'Normal', 'htmega-pro' ),

                ]
            );

            $this->add_control(
                'readmore_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-link' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-info-box-link svg path' => 'fill: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'readmore_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-info-box-link',
                    'exclude' => ['image'],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'readmore_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-info-box-link',
                ]
            );

            $this->add_responsive_control(
                'readmore_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-box-link' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'readmore_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'readmore_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-info-box-link:hover' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-info-box-link:hover svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-info-box-link:hover',
                            'exclude' => ['image'],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-info-box-link:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'readmore_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-info-box-link:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();

        // Indexing style tab section
        $this->start_controls_section(
            'indexing_style',
            [
                'label' => __( 'Indexing Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'indexing_number[value]!' =>'',
                    'icon_position' =>'top',
                ]
            ]
        );

            $this->add_control(
                'indexing_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-indexing::before' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'indexing_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-info-indexing::before',
                ]
            );

            $this->add_responsive_control(
                'indexing_margin',
                [
                    'label' => __( 'Space', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-info-indexing::before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section(); // end indexing style

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $this->add_render_attribute( 'info_box_title', 'class', 'htmega-info-box-title' );
        $this->add_render_attribute( 'info_box_wapper', 'class', 'htmega-info-box htmega-link-position-'.$settings['icon_link_position'] );

        if( 'top'== $settings['icon_position'] && '' != $settings['indexing_number']){
            $this->add_render_attribute( 'info_box_wapper', 'class', 'htmega-info-indexing');
        }
        if( 'left'== $settings['icon_position'] ){
            $this->add_render_attribute( 'info_box_wapper', 'class', 'htmega-info-box-2');
        } elseif('right'== $settings['icon_position'] ){
            $this->add_render_attribute( 'info_box_wapper', 'class', 'htmega-info-box-2 flex-row-reverse');
        }


        ?>
            <div <?php echo $this->get_render_attribute_string( 'info_box_wapper' ); ?>>
            <?php
           
                if( !empty( $settings['info_box_number'] ) ){
                    echo '<div class="htmega-info-box-icon">'.esc_html( $settings['info_box_number'] ).'</div>';
                }
                if( !empty( $settings['info_box_icon'] ) ){
                    echo '<div class="htmega-info-box-icon">'.HTMega_Icon_manager::render_icon( $settings['info_box_icon'], [ 'aria-hidden' => 'true' ] ).'</div>';
                }
                if( !empty( $settings['info_box_image']['url'] ) ){
                    echo '<div class="htmega-info-box-icon">'.Group_Control_Image_Size::get_attachment_image_html( $settings, 'info_box_imagesize', 'info_box_image' ).'</div>';
                }

                ?>

                <div class="htmega-info-box-content">
                    <?php
                        if ( $settings['info_box_title' ] ) :
                            printf( '<%1$s %2$s>%3$s</%1$s>',
                                htmega_escape_tags( $settings['info_box_title_tag'], 'h3' ),
                                $this->get_render_attribute_string( 'info_box_title' ),
                                htmega_kses_title( $settings['info_box_title' ] )
                            );
                        endif;
                    ?>
                    <?php if ( !empty( $settings['info_box_description'] ) ) : ?>
                        <p class="htmega-info-box-text"><?php echo htmega_kses_desc( $settings['info_box_description' ] ); ?></p>
                    <?php endif; ?>
                   
                    <?php

                        $link_iocn = '';
                        if( !empty( $settings['info_box_link_icon'] )){
                            $link_iocn = HTMega_Icon_manager::render_icon( $settings['info_box_link_icon'], [ 'aria-hidden' => 'true' ] );
                        } else if(!empty( $settings['info_box_link_image']['url']) ){
                            $link_iocn = Group_Control_Image_Size::get_attachment_image_html( $settings, 'info_box_link_imagesize', 'info_box_link_image' );
                        }
                      if ( !empty( $settings['info_box_button_text'] ) || !empty( $link_iocn ) ) {

                        if( isset(  $settings['info_box_button_link']['url'] ) && !empty( $settings['info_box_button_link']['url'] ) ){
                            $this->add_link_attributes( 'url', $settings['info_box_button_link'] );
                        }
                        ?>
                        <div class="htmega-info-box-link-box">
                            <a <?php echo $this->get_render_attribute_string( 'url' ); ?> class="htmega-info-box-link">
                                <?php
                                    echo ('left' == $settings['icon_link_position'] ) ? $link_iocn.' '.esc_html( $settings['info_box_button_text'] ): esc_html( $settings['info_box_button_text'] ).' '.$link_iocn;
                                ?>
                            </a>
                        </div>

                    <?php

                    }
                    
                    ?>
                    

                </div>
            </div>
        <?php
    }

	public function content_template() {
		?>
        <#
        view.addRenderAttribute( 'info_box_title', 'class', 'htmega-info-box-title' );
        view.addRenderAttribute( 'info_box_wapper', 'class', 'htmega-info-box htmega-link-position-' + settings.icon_link_position );
        if( 'top'== settings.icon_position && '' != settings.indexing_number){
            view.addRenderAttribute( 'info_box_wapper', 'class', 'htmega-info-indexing');
        }
        if( 'left' == settings.icon_position ){
            view.addRenderAttribute( 'info_box_wapper', 'class', 'htmega-info-box-2');
        } else if('right'== settings.icon_position ){
            view.addRenderAttribute( 'info_box_wapper', 'class', 'htmega-info-box-2 flex-row-reverse');
        }
        #>
        <div {{{ view.getRenderAttributeString( 'info_box_wapper' ) }}}>
        <#
       
            if( '' !== settings.info_box_number && 'number' == settings.icon_type ){ #>
                <div class="htmega-info-box-icon">{{ settings.info_box_number }}</div>
           <# } 
            if( '' !== settings.info_box_icon && 'icon' == settings.icon_type ){ 
                 var iconHTML = elementor.helpers.renderIcon( view, settings.info_box_icon, { 'aria-hidden': true }, 'i' , 'object' ); #>
                <div class="htmega-info-box-icon">{{{ iconHTML.value }}}</div>
           <# } 

           if( '' != settings.info_box_image.url  && 'image' == settings.icon_type ){
            var image = {
				id: settings.info_box_image.id,
				url: settings.info_box_image.url,
				size: settings.info_box_image_size,
				dimension: settings.info_box_image_custom_dimension,
				model: view.getEditModel()
			};
			var image_url = elementor.imagesManager.getImageUrl( image );

			if ( ! image_url ) {
				return;
			}
            #>
            <div class="htmega-info-box-icon"><img src="{{ image_url }}"></div>
           <# } #>
           <div class="htmega-info-box-content">
            <#
                if ( '' != settings.info_box_title ) { #>
                    <h3 class="htmega-info-box-title">{{ settings.info_box_title }}</h3>
                <# }

                if ( '' !== settings.info_box_description ) { #>
                    <p class="htmega-info-box-text">{{ settings.info_box_description }}</p>
                <# } 

                var link_iocn = '';
                if( '' != settings.info_box_link_icon.value  && 'icon' == settings.link_icon_type  ){
                    link_iocn = elementor.helpers.renderIcon( view, settings.info_box_link_icon, { 'aria-hidden': true }, 'i' , 'object' );
                    link_iocn = link_iocn.value;

                } else if( '' !== settings.info_box_link_image.url && 'image'== settings.link_icon_type ){

                        var link_image = {
                            id: settings.info_box_link_image.id,
                            url: settings.info_box_link_image.url,
                            size: settings.info_box_link_image_size,
                            dimension: settings.info_box_link_image_custom_dimension,
                            model: view.getEditModel()
                        };
                        var link_image_url = elementor.imagesManager.getImageUrl( link_image );

                        if ( ! link_image_url ) {
                            return;
                        }
                        link_iocn = '<img src="'+link_image_url+'">';

                }

                if ( '' !== settings.info_box_button_text || ''!= link_iocn  ) {
                    #>
                    <div class="htmega-info-box-link-box">
                        <a href="{{ settings.info_box_button_link.url }}" class="htmega-info-box-link">
                            
                        <#
                        
                       var link_content =  ('left' == settings.icon_link_position) ? link_iocn + " "+ settings.info_box_button_text : settings.info_box_button_text + " "+ link_iocn;
                            #>
                        {{{link_content}}}
                    </a>
                    </div>

                <#
                }
                #>

            </div>
        </div>

		<?php
	}

}

