<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Interactive_Circle_Infographic_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-interactive-circle-infographic-addons';
    }
    
    public function get_title() {
        return __( 'Interactive Circle Infographic', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-integration';
    }

    public function get_categories() {
        return [ 'htmega-pro' ];
    }
    public function get_keywords() {
        return ['circle infographic', 'interactive circle infographic', 'circle content', 'htmega', 'ht mega'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs/';
    }
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Circle Content', 'htmega-pro' ),
            ]
        );
            $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                'active_item',
                [
                    'label' => esc_html__( 'Active This Item', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $repeater->start_controls_tabs('circle_content_tabs');

                $repeater->start_controls_tab(
                    'circle_content_tab_icon',
                    [
                        'label' => __( 'Icon Box', 'htmega-pro' ),
                    ]
                );
                    $repeater->add_control(
                        'icon_type',
                        [
                            'label'   => __( 'Icon Type', 'htmega-pro' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'none' => [
                                    'title' => __( 'None', 'htmega-pro' ),
                                    'icon'  => 'eicon-ban',
                                ],
                                'icon' => [
                                    'title' => __( 'Icon', 'htmega-pro' ),
                                    'icon'  => 'eicon-info-circle',
                                ],
                                'image' => [
                                    'title' => __( 'Image', 'htmega-pro' ),
                                    'icon'  => 'eicon-image-bold',
                                ],
                            ],
                            'default' => 'icon',
                        ]
                    );
                    $repeater->add_control(
                        'circle_info_icon',
                        [
                            'label'         => __( 'Icon', 'htmega-pro' ),
                            'type'          => Controls_Manager::ICONS,
                            'default' => [
                                'value' => 'fas fa-info',
                                'library' => 'fa-solid',
                            ],
                            'condition'=>[
                                'icon_type'=>'icon',
                            ],
                        ]
                    );
        
                    $repeater->add_control(
                        'circle_info_image',
                        [
                            'label' => __('Image','htmega-pro'),
                            'type'=>Controls_Manager::MEDIA,
                            'dynamic' => [
                                'active' => true,
                            ],
                            'condition' => [
                                'icon_type' => 'image',
                            ]
                        ]
                    );
                    $repeater->add_control(
                        'icon_box_title',
                        [
                            'label'   => esc_html__( 'Short Title', 'htmega-pro' ),
                            'type'    => Controls_Manager::TEXT,
                            'default' => esc_html__( 'Item One', 'htmega-pro' ),
                        ]
                    );
                    $repeater->add_control(
                        'icon_c_style',
                        [
                            'label' => esc_html__( 'Custom Style', 'htmega-pro' ),
                            'type' => Controls_Manager::SWITCHER,
                            'return_value' => 'yes',
                            'default' => 'no',
                            'separator' =>'before'
                        ]
                    );
                    $repeater->add_control(
                        'icon_c_color',
                        [
                            'label' => __( 'Icon Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-infographic-item-icon-box' => 'color: {{VALUE}}',
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-infographic-item-icon-box i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-infographic-item-icon-box svg path' => 'fill: {{VALUE}}',
                            ],
                            'condition' => [
                                'icon_c_style' => 'yes',
                            ]
                        ]
                    );

                    $repeater->add_control(
                        'title_c_color',
                        [
                            'label' => __( 'Title Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-infographic-item-title' => 'color: {{VALUE}}',
                            ],
                            'condition' => [
                                'icon_c_style' => 'yes',
                            ]
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'icon_c_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-infographic-item-icon-box',
                            'condition' => [
                                'icon_c_style' => 'yes',
                            ]
                            
                        ]
                    );    
                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'icon_c_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-infographic-item-icon-box',
                            'separator' =>'before',
                            'condition' => [
                                'icon_c_style' => 'yes',
                            ]
                        ]
                    );

                    $repeater->add_responsive_control(
                        'icon_c_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-infographic-item-icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'condition' => [
                                'icon_c_style' => 'yes',
                            ]
                        ]
                    );       
                    $repeater->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'icon_c_box_shadow',
                            'label' => __( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-infographic-item-icon-box',
                            'condition' => [
                                'icon_c_style' => 'yes',
                            ]
                        ]
                    );
                    $repeater->add_control(
                        'icon_c_active',
                        [
                            'label' => esc_html__( 'Active Style', 'htmega-pro' ),
                            'type' => Controls_Manager::SWITCHER,
                            'return_value' => 'yes',
                            'default' => 'no',
                            'separator' =>'before',
                            'condition' => [
                                'icon_c_style' => 'yes',
                            ]
                        ]
                    );
                    $repeater->add_control(
                        'icon_c_color_active',
                        [
                            'label' => __( 'Icon Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-c-info-active .htmega-infographic-item-icon-box' => 'color: {{VALUE}}',
                                '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-c-info-active .htmega-infographic-item-icon-box i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-c-info-active .htmega-infographic-item-icon-box svg path' => 'fill: {{VALUE}}',
                            ],
                            'condition' => [
                                'icon_c_style' => 'yes',
                                'icon_c_active' => 'yes',
                            ]
                        ]
                    );

                    $repeater->add_control(
                        'title_c_color_active',
                        [
                            'label' => __( 'Title Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-c-info-active .htmega-infographic-item-title' => 'color: {{VALUE}}',
                            ],
                            'condition' => [
                                'icon_c_style' => 'yes',
                                'icon_c_active' => 'yes',
                            ]
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'icon_c_background_active',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-c-info-active .htmega-infographic-item-icon-box',
                            'condition' => [
                                'icon_c_style' => 'yes',
                                'icon_c_active' => 'yes',
                            ]
                            
                        ]
                    );    
                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'icon_c_border_active',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-c-info-active .htmega-infographic-item-icon-box',
                            'separator' =>'before',
                            'condition' => [
                                'icon_c_style' => 'yes',
                                'icon_c_active' => 'yes',
                            ]
                        ]
                    );

                    $repeater->add_responsive_control(
                        'icon_c_border_radius_active',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-c-info-active .htmega-infographic-item-icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'condition' => [
                                'icon_c_style' => 'yes',
                                'icon_c_active' => 'yes',
                            ]
                        ]
                    ); 
                $repeater->end_controls_tab(); // Title style end
                // Description front style start
                $repeater->start_controls_tab(
                    'circle_content_tab_content',
                    [
                        'label' => __( 'Content', 'htmega-pro' ),
                    ]
                    );

                    $repeater->add_control(
                        'circle_content',
                        [
                            'label' => esc_html__( 'Content', 'htmega-pro' ),
                            'type' => Controls_Manager::WYSIWYG,
                            'title' => __( 'Content', 'htmega-pro' ),
                            'default'     => __('Default description. Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'htmega-pro'),
                            'show_label' => false,
                        ]
                    );
                    $repeater->add_control(
                        'content_c_active',
                        [
                            'label' => esc_html__( 'Custom Content Style', 'htmega-pro' ),
                            'type' => Controls_Manager::SWITCHER,
                            'return_value' => 'yes',
                            'default' => 'no',
                            'separator' =>'before',
                        ]
                    );
                    $this->add_control(
                        'content_c_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-infographic-item-content' => 'color: {{VALUE}}',
                            ],
                            'condition' => [
                                'content_c_active' => 'yes',
                            ]
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'content_typography_c',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-infographic-item-content',
                            'condition' => [
                                'content_c_active' => 'yes',
                            ]
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'content_c_box_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-infographic-item-content',
                            'condition' => [
                                'content_c_active' => 'yes',
                            ]
                        ]
                    );
        
                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'content_c_box_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-infographic-item-content',
                            'condition' => [
                                'content_c_active' => 'yes',
                            ]
                        ]
                    );
        
                    $repeater->add_responsive_control(
                        'content_c_box_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-infographic-item-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'condition' => [
                                'content_c_active' => 'yes',
                            ]
                        ]
                    );
        
                    $repeater->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'content_c_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-infographic-item-content',
                            'condition' => [
                                'content_c_active' => 'yes',
                            ]
                        ]
                    );
                $repeater->end_controls_tab(); 
            $repeater->end_controls_tabs();

            $this->add_control(
                'item_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'icon_box_title'=> esc_html__( 'Item 1', 'htmega-pro' ),
                            'circle_content'=> esc_html__( 'Content One - Showcase your interactive content with the HTMega Circle Infographic Elementor widget.', 'htmega-pro' ),
                            'active_item' => 'yes',
                            'circle_info_icon'   => [
                                'value'   => 'far fa-address-book',
                                'library' => 'fa-solid'
                            ],
                        ],
                        [
                            'icon_box_title'=> esc_html__( 'Item 2', 'htmega-pro' ),
                            'circle_content'=> esc_html__( 'Content Two - Showcase your interactive content with the HTMega Circle Infographic Elementor widget.', 'htmega-pro' ),
                            'circle_info_icon'   => [
                                'value'   => 'far fa-comments',
                                'library' => 'fa-solid'
                            ],
                        ],
                        [
                            'icon_box_title'=> esc_html__( 'Item 3', 'htmega-pro' ),
                            'circle_content'=> esc_html__( 'Content Three - Showcase your interactive content with the HTMega Circle Infographic Elementor widget.', 'htmega-pro' ),
                            'circle_info_icon'   => [
                                'value'   => 'far fa-image',
                                'library' => 'fa-solid'
                            ],
                        ],
                        [
                            'icon_box_title'=> esc_html__( 'Item 4', 'htmega-pro' ),
                            'circle_content'=> esc_html__( 'Content Four - Showcase your interactive content with the HTMega Circle Infographic Elementor widget.', 'htmega-pro' ),
                            'circle_info_icon'   => [
                                'value'   => 'far fa-bookmark',
                                'library' => 'fa-solid'
                            ],
                        ],
                        [
                            'icon_box_title'=> esc_html__( 'Item 5', 'htmega-pro' ),
                            'circle_content'=> esc_html__( 'Content Five - Showcase your interactive content with the HTMega Circle Infographic Elementor widget.', 'htmega-pro' ),
                            'circle_info_icon'   => [
                                'value'   => 'far fa-gem',
                                'library' => 'fa-solid'
                            ],
                        ],
                        [
                            'icon_box_title'=> esc_html__( 'Item 6', 'htmega-pro' ),
                            'circle_content'=> esc_html__( 'Content Six - Showcase your interactive content with the HTMega Circle Infographic Elementor widget.', 'htmega-pro' ),
                            'circle_info_icon'   => [
                                'value'   => 'far fa-bell',
                                'library' => 'fa-solid'
                            ],
                        ]
                    ],
                    'title_field' => '{{icon_box_title}}',
                ]
            );

        $this->end_controls_section();

        // Carousel Settings
        $this->start_controls_section(
            'circle_info_settings_section',
            [
                'label' => esc_html__( 'Settings', 'htmega-pro' ),
            ]
        );
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'icon_image_size',
                    'default' => 'full',
                    'separator' => 'none',
                ]
            );
            $this->add_control(
                'mouse_event',
                [
                    'label' => esc_html__( 'Mouse Event', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'click',
                    'options' => [
                        'click'  => esc_html__( 'Click', 'htmega-pro' ),
                        'mouseover'  => esc_html__( 'Mouse Hover', 'htmega-pro' ),
                    ],
                ]
            );
            $this->add_control(
                'auto_move_active',
                [
                    'label' => esc_html__( 'Circle Auto Move', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $this->add_control(
                'auto_move_speed',
                [
                    'label' => esc_html__( 'Auto Move Speed', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'step' => 10,
                    'default' => 2000,
                    'condition' => ['auto_move_active' => 'yes']
                ]
            );
            $this->add_control(
                'circle_distance',
                [
                    'label' => esc_html__( 'Circle Round Distance', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'step' => 1,
                    'default' => 30,
                    'condition' => ['auto_move_active' => 'yes']
                ]
            );
        $this->end_controls_section();
        // Style
        // Content Box style section
        $this->start_controls_section(
            'box_style',
            [
                'label' => esc_html__( 'Circle Box', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'box_width_wrpper',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-circle-infographic-wrapper' => 'width: {{SIZE}}px;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'box_height_wrpper',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-circle-infographic-wrapper' => 'height: {{SIZE}}px;',
                
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'box_normal_background_wrpper',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-circle-infographic-wrapper',
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'box_normal_border_wrpper',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-circle-infographic-wrapper',
                ]
            );

            $this->add_responsive_control(
                'box_normal_border_radius_wrpper',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-circle-infographic-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'box_normal_shadow_wrpper',
                    'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-circle-infographic-wrapper',
                ]
            );
            $this->add_responsive_control(
                'box_normal_padding_wrpper',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-circle-infographic-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
        // Content Box style section
        $this->start_controls_section(
            'content_box_style',
            [
                'label' => esc_html__( 'Content Box', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'content_box_wrapper_heading',
                [
                    'label' => __( 'Content Box Wrapper Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                ]
            );
            $this->add_responsive_control(
                'content_box_width_wrpper',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-content-wrapper' => 'width: {{SIZE}}px;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_box_height_wrpper',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-content-wrapper' => 'height: {{SIZE}}px;',
                
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'content_box_background_wrapper',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-infographic-content-wrapper',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'content_box_border_wrapper',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-infographic-content-wrapper',
                ]
            );

            $this->add_responsive_control(
                'content_box_border_radius_wrapper',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'content_box_shadow_wrapper',
                    'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-infographic-content-wrapper',
                ]
            );
            $this->add_responsive_control(
                'content_box_wrapper_inner_space',
                [
                    'label' => esc_html__( 'Inner Space', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-item-content' => 'top:{{TOP}}{{UNIT}}; right:{{RIGHT}}{{UNIT}}; bottom:{{BOTTOM}}{{UNIT}}; left:{{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            // Content box style
            $this->add_control(
                'content_box_heading',
                [
                    'label' => __( 'Content Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'content_alignment',
                [
                    'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-item-content' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-item-content' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-infographic-item-content',
                ]
            );
            $this->add_responsive_control(
                'content_box_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'content_box_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-infographic-item-content',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'content_box_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-infographic-item-content',
                ]
            );

            $this->add_responsive_control(
                'content_box_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-item-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'content_box_shadow',
                    'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-infographic-item-content',
                ]
            );

        $this->end_controls_section();
        // info box icon style
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => __( 'Icon Box', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'distance_from_center',
                [
                    'label' => __( 'Distance', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'default' => [
                        'size' =>200,
                    ],
                ]
            );

            $this->add_responsive_control(
                'icon_width',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                        ],
                    ],
                    'default' => [
                        'size' =>80,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-item-icon-box' => 'width: {{SIZE}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'icon_height',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                        ],
                    ],
                    'default' => [
                        'size' =>80,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-item-icon-box' => 'height: {{SIZE}}px;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'icon_font_size',
                [
                    'label' => __( 'Icon Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 30,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-item-icon-box i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-infographic-item-icon-box svg,
                        {{WRAPPER}} .htmega-infographic-item-icon-box img' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-infographic-item-title',
                ]
            );
            $this->add_responsive_control(
                'title_space_top',
                [
                    'label' => __( 'Title Space Top', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' =>5,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-infographic-item-title' => 'margin-top: {{SIZE}}px;',
                
                    ],
                ]
            );
            $this->add_control(
                'colors_and_border_style_heading',
                [
                    'label' => __( 'Colors & Borders', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->start_controls_tabs('icon__box_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'box_icon_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'icon_color',
                        [
                            'label' => __( 'Icon Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-infographic-item-icon-box, {{WRAPPER}} .htmega-infographic-item-icon-box i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-infographic-item-icon-box svg path' => 'fill: {{VALUE}}',
                            ],
                            'separator' =>'before'
                        ]
                    );

                    $this->add_control(
                        'title_color',
                        [
                            'label' => __( 'Title Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-infographic-item-title' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'icon_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-infographic-item-icon-box',
                            
                        ]
                    );    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'icon_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-infographic-item-icon-box',
                            'separator' =>'before'
                        ]
                    );

                    $this->add_responsive_control(
                        'icon_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-infographic-item-icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );       
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'icon_box_shadow',
                            'label' => __( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-infographic-item-icon-box',
                        ]
                    );
                $this->end_controls_tab();
                // Box Hover Style Tab
                $this->start_controls_tab(
                    'icon_active_style_tab',
                    [
                        'label' => esc_html__( 'Active', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'icon_color_active',
                        [
                            'label' => __( 'Icon Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-c-info-active .htmega-infographic-item-icon-box' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-c-info-active .htmega-infographic-item-icon-box i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-c-info-active .htmega-infographic-item-icon-box svg path' => 'fill: {{VALUE}}',
                            ],
                            'separator' =>'before'
                        ]
                    );
                    $this->add_control(
                        'title_color_active',
                        [
                            'label' => __( 'Title Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-c-info-active .htmega-infographic-item-title' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'icon_background_active',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-c-info-active .htmega-infographic-item-icon-box',
                            
                        ]
                    );    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'icon_border_active',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-c-info-active .htmega-infographic-item-icon-box',
                            'separator' =>'before'
                        ]
                    );

                    $this->add_responsive_control(
                        'icon_border_radius_active',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-c-info-active .htmega-infographic-item-icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );       
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'icon_box_shadow_active',
                            'label' => __( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-c-info-active .htmega-infographic-item-icon-box',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();


        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $item_list = $this->get_settings_for_display('item_list');
        $id         = $this->get_id();
        $distance_from_center = !empty( $settings['distance_from_center']['size'] ) ? $settings['distance_from_center']['size']: 150;
        $this->add_render_attribute( 'area_attr', 'class', 'htmega-circle-infographic-wrapper' );
        $this->add_render_attribute( 'area_attr', 'style', 'opacity: 0' );

        $circle_info_settings = [
            'distance_from_center'  => absint( $distance_from_center ),
            'distance_from_center_t'  => !empty( $settings['distance_from_center_tablet']['size'] ) ? absint( $settings['distance_from_center_tablet']['size'] ) : absint( $distance_from_center ),
            'distance_from_center_m'  => !empty( $settings['distance_from_center_mobile']['size'] ) ? absint( $settings['distance_from_center_mobile']['size'] ) : absint( $distance_from_center ),
            'mouse_event'  => esc_attr( $settings['mouse_event'] ),
            'auto_move_active'  => ( 'yes' == $settings['auto_move_active'] ),
            'auto_move_speed'  => isset( $settings['auto_move_speed'] ) ? absint( $settings['auto_move_speed'] ) : 2000,
            'circle_distance'  => isset( $settings['circle_distance'] ) ? absint( $settings['circle_distance'] ) : 30,
        ];
        $this->add_render_attribute( 'area_attr', 'data-settings', wp_json_encode( $circle_info_settings ) );

        if( is_array( $item_list ) ){
        ?>                
            <div <?php echo $this->get_render_attribute_string( 'area_attr' ); ?> >
                <div class="htmega-circle-infographic">
                    <?php 
                    $active_item_status_icon = false;
                    $active_item_icon = '';
                        foreach ( $item_list as $item ) {
                            $id = $item['_id'];

                            if( !$active_item_status_icon && 'yes' == $item['active_item'] ) {
                                $active_item_icon = 'htmega-c-info-active';
                                $active_item_status_icon = true;
                            } else {
                                $active_item_icon = '';
                            }
                            if (  empty($item['circle_info_icon'] ) && empty( $item['icon_box_title'] ) ) {
                                echo '<div class="htmega-infographic-item" style="opacity:0"></div>';
                            } else {

                                ?>
                            <div class="htmega-infographic-item <?php echo esc_attr( $active_item_icon ); ?> elementor-repeater-item-<?php echo esc_attr( $id ); ?>" id="<?php echo esc_attr($id); ?>">
                                <div class="htmega-infographic-item-icon-box">
                                    <?php
                                    if ( $item['icon_type'] == 'image' && $item['circle_info_image']['url'] ) {
                                        $allText = !empty($item['circle_info_image']['alt']) ? $item['circle_info_image']['alt'] : esc_html__( 'icon Image', 'htmega-pro' );
                                        $circle_info_image = '<img alt="'. esc_attr( $allText ) .'" src="'.  Group_Control_Image_Size::get_attachment_image_src( $item['circle_info_image']['id'], 'icon_image_size', $settings ) .'" />';
                                        echo wp_kses_post( $circle_info_image );
                                    } 
                                    if ( $item['icon_type'] == 'icon' && $item['circle_info_icon']['value'] ) {
                                            echo HTMega_Icon_manager::render_icon( $item['circle_info_icon'] );
                                    }
                                    if ( $item['icon_box_title'] ) : ?>
                                    <span class="htmega-infographic-item-title"><?php echo htmega_kses_title( $item['icon_box_title'] ); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php
                            }
                    }
                    ?>
                </div>
                <div class="htmega-infographic-content-wrapper">
                    <?php 
                        $active_item_status = false;
                        $active_item = '';
                    foreach ( $item_list as $item ) {

                        if( !$active_item_status && 'yes' == $item['active_item'] ) {
                            $active_item = 'htmega-c-info-active';
                            $active_item_status = true;
                        } else {
                            $active_item = '';
                        }
                        $id = $item['_id'];
                    if( $item['circle_content'] ) {
                            echo "<div class='htmega-infographic-item-content " . esc_attr($active_item) . " elementor-repeater-item-" . esc_attr($id) . "' id='display-" . esc_attr($id) . "'>" . wp_kses_post($item['circle_content']) . "</div>";
                        }
                    }
                    ?>
                </div>
            </div>
        <?php
        }

    }

}