<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Interactive_Promo_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-interactive-promo-addons';
    }
    
    public function get_title() {
        return esc_html__( 'Interactive Promo', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-call-to-action';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'interactive promo', 'interactive', 'promo', 'promotion', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/interactive-promo-widget/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {
        $this->_general_controls();
        $this->_style_controls();
    }

    protected function _general_controls(){ 
        $this->__interactive_promo_data_input_section();
    }


    protected function __interactive_promo_data_input_section(){

        $this->start_controls_section(
            'interactive_promo_section',
            [
                'label' => esc_html__( 'Interactive Promo', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'promo_effect',
                [
                    'label' => esc_html__('Select Promo Effect', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [
                        '1' => esc_html__('Promo Effect 1', 'htmega-pro'),
                        '2' => esc_html__('Promo Effect 2', 'htmega-pro'),
                        '3' => esc_html__('Promo Effect 3', 'htmega-pro'),
                        '4' => esc_html__('Promo Effect 4', 'htmega-pro'),
                        '5' => esc_html__('Promo Effect 5', 'htmega-pro'),
                        '6' => esc_html__('Promo Effect 6', 'htmega-pro'),
                        '7' => esc_html__('Promo Effect 7', 'htmega-pro'),
                        '8' => esc_html__('Promo Effect 8', 'htmega-pro'),
                        '9' => esc_html__('Promo Effect 9', 'htmega-pro'),
                        '10' => esc_html__('Promo Effect 10', 'htmega-pro'),
                        '11' => esc_html__('Promo Effect 11', 'htmega-pro'),
                        '12' => esc_html__('Promo Effect 12', 'htmega-pro'),
                        '13' => esc_html__('Promo Effect 13', 'htmega-pro'),
                        '14' => esc_html__('Promo Effect 14', 'htmega-pro'),
                        '15' => esc_html__('Promo Effect 15', 'htmega-pro'),
                    ],
                ]
            );

            $this->add_control(
                'promo_bg_image',
                [
                    'label' => esc_html__('Promo Background Image','htmega-pro'),
                    'type'=>Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                    'dynamic' => [
                        'active' => true,
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'promo_bg_image_size',
                    'default' => 'full',
                    'condition' => [
                        'promo_bg_image[url]!' => '',
                    ]
                ]
            );

            $this->add_control(
                'promo_title',
                [
                    'label'         => esc_html__( 'Title', 'htmega-pro' ),
                    'type'          => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default'       => esc_html__( 'Interactive Effect', 'htmega-pro' ),
                    'separator' => 'before',
                    'dynamic' => [
                        'active' => true,
                    ],
                    'description' => esc_html__( 'Put the highlighted word in between the span tags!', 'htmega-pro')
                ]
            );
            
            $this->add_control(
                'promo_description',
                [
                    'label'         => esc_html__( 'Description', 'htmega-pro' ),
                    'type'          => Controls_Manager::TEXTAREA,
                    'rows' => 5,
                    'default'       => esc_html__( 'Lorem ipsum dolor sit amet consectet adipisci elit. Lacus faucibus risus risus hac euid eget ut At tellus.', 'htmega-pro' ),
                    'dynamic' => [
                        'active' => true,
                    ]
                ]
            );

            $this->add_control(
                'promo_link',
                [
                    'label' => esc_html__( 'Promo Link', 'htmega-pro' ),
                    'type' => Controls_Manager::URL,
                    'placeholder' => 'https://example.com',
                    'dynamic' => [
                        'active' => true,
                    ],
                    'default' => [
                        'url' => '',
                    ]
                ]
            );

            
            $this->add_control(
                'additional_options',
                [
                    'label' => esc_html__( 'Additional Options', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'promo_title_tag',
                [
                    'label' => esc_html__('Select Title Tag', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'h2',
                    'options' => htmega_html_tag_lists(),
                    'condition' => [
                        'promo_title[value]!' =>'',
                    ]
                ]
            );

        $this->end_controls_section(); 
    }

    //_style_controls
    protected function _style_controls() {
        $this->__promo_section_style();
        $this->__promo_title_style();
        $this->__promo_description_style();
    }

    protected function __promo_section_style(){
        $this->start_controls_section(
            'promo_style',
            [
                'label' => esc_html__( 'Promo Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'promo_width',
                [
                    'label' => esc_html__( 'Promo Box Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px','%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1500,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => '%',
                        'size' => 100,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-wrap' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'promo_border_color',
                [
                    'label' => esc_html__( 'Hover Border Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-content::after' => 'border-right-color: {{VALUE}}; border-left-color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-content::before' => 'border-top-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-2 .htmega-interactive-promo-description::before' => 'border-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-3 .htmega-interactive-promo-title::after' => 'background: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-5::after' => 'border-right-color: {{VALUE}}; border-left-color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-5::before' => 'border-top-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-5:hover::after' => 'border-right-color: {{VALUE}}; border-left-color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-5:hover::before' => 'border-top-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-7 .htmega-interactive-promo-title::after' => 'background: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-8 .htmega-interactive-promo-content::before' => 'background: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-8 .htmega-interactive-promo-content::after' => 'background: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-10 .htmega-interactive-promo-title::after' => 'background: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-11 .htmega-interactive-promo-content::before' => 'border-left-color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-15::before' => 'border-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'promo_effect!' => ['4','6', '9','12','13','14'],
                    ]
                    
                ]
            );

            $this->add_responsive_control(
                'promo_border_width',
                [
                    'label' => esc_html__( 'Hover Border Width', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-content::after' => 'border-right-width: {{RIGHT}}{{UNIT}};  border-left-width: {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-content::before' => 'border-top-width: {{TOP}}{{UNIT}};  border-bottom-width: {{BOTTOM}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-2 .htmega-interactive-promo-description::before' => 'border-right-width: {{RIGHT}}{{UNIT}}; border-left-width: {{LEFT}}{{UNIT}}; border-top-width: {{TOP}}{{UNIT}};  border-bottom-width: {{BOTTOM}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-5:hover::after' => 'border-right-width: {{RIGHT}}{{UNIT}};  border-left-width: {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-5::before' => 'border-top-width: {{TOP}}{{UNIT}};  border-bottom-width: {{BOTTOM}}{{UNIT}};',
                    ],
                    'condition' => [
                        'promo_effect' => ['1','2','5'],
                    ]
                ]
            ); 

            $this->add_control(
                'promo_border_width_single',
                [
                    'label' => esc_html__( 'Hover Border Width', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 1000,
                    'step' => 1,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-11 .htmega-interactive-promo-content::before' => 'border-left-width: {{VALUE}}px;',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-15::before' => 'border-width: {{VALUE}}px;',
                    ],
                    'condition' => [
                        'promo_effect' => ['11','15'],
                    ]
                ]
            );

            $this->add_control(
                'promo_border_radius',
                [
                    'label' => esc_html__( 'Hover Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 1000,
                    'step' => 1,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-content::after' => 'border-radius: {{VALUE}}px;',
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-content::before' => 'border-radius: {{VALUE}}px;',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-2 .htmega-interactive-promo-description::before' => 'border-radius: {{VALUE}}px;',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-5::after' => 'border-radius: {{VALUE}}px;',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-5::before' => 'border-radius: {{VALUE}}px;',
                        '.htmega-interactive-promo-card.htmega-interactive-promo-card-15::before' => 'border-radius: {{VALUE}}px;',
                    ],
                    'condition' => [
                        'promo_effect' => ['1','2','5','15'],
                    ]
                ]
            );

            $this->add_responsive_control(
                'promo_border_position',
                [
                    'label' => esc_html__( 'Hover Border Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => -500,
                            'max' => 500,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-3 .htmega-interactive-promo-title::after' => 'top: {{SIZE}}%;',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-7 .htmega-interactive-promo-title::after' => 'top: {{SIZE}}%;',
                    ],
                    'condition' => [
                        'promo_effect' => ['3','7']
                    ],
                ]
            );

            $this->add_control(
                'background_opacity_color_header',
                [
                    'label' => esc_html__( 'Background Opacity Color', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'promo_effect!' => ['11','12','13']
                        
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background_opacity_color',
                    'label' => esc_html__( 'Background Opacity Color', 'htmega-pro' ),
                    'types' => ['classic','gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-content',
                    'condition' => [
                        'promo_effect!' => ['11','12','13']
                    ]
                ]
            );

            $this->add_control(
                'background_hover_opacity_color_header',
                [
                    'label' => esc_html__( 'Hover Background Opacity Color', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'promo_effect!' => ['11','12','13']
                        
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background_opacity_color_hover',
                    'label' => esc_html__( 'Hover Background Opacity Color', 'htmega-pro' ),
                    'types' => [ 'classic','gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card:hover .htmega-interactive-promo-content',
                    'condition' => [
                        'promo_effect!' => ['11','12','13','15']
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background_opacity_color_hover_15',
                    'label' => esc_html__( 'Hover Background Opacity Color', 'htmega-pro' ),
                    'types' => [ 'classic','gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-15::before',
                    'condition' => [
                        'promo_effect' => ['15']
                    ]
                ]
            );

        $this->end_controls_section();
    }

    protected function __promo_title_style(){
        $this->start_controls_section(
            'promo_title_style',
            [
                'label' => esc_html__( 'Title Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'title_color_heading',
                [
                    'label' => esc_html__( 'Title', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-title' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-12 .htmega-interactive-promo-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'title_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-title',
                    'condition' => [
                        'promo_effect' => ['12']
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-title',
                ]
            );

            $this->add_control(
                'highlight_title_color_heading',
                [
                    'label' => esc_html__( 'Highlight Title and Typography', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'highlight_title_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'highlight_title_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-title span',
                ]
            );


            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'title_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-title',
                    'condition' => [
                        'promo_effect' => ['12']
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'title_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-title' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                    'condition' => [
                        'promo_effect' => ['12']
                    ],
                ]
            );

            $this->add_responsive_control(
                'title_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-12 .htmega-interactive-promo-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-12 .htmega-interactive-promo-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'promo_effect' => ['12']
                    ],
                ]
            );

            $this->add_responsive_control(
                'title_position',
                [
                    'label' => esc_html__( 'Title Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => -500,
                            'max' => 500,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-12 .htmega-interactive-promo-content' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'promo_effect' => ['12']
                    ],
                    'separator' => 'before'
                ]
            );

        $this->end_controls_section();
    }

    protected function __promo_description_style(){
        $this->start_controls_section(
            'promo_description_style',
            [
                'label' => esc_html__( 'Description Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'description_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-description' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-12 .htmega-interactive-promo-description' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'description_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-description',
                    'condition' => [
                        'promo_effect' => ['12']
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'description_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-description',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'description_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-description',
                ]
            );

            $this->add_responsive_control(
                'description_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-description' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'description_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-12 .htmega-interactive-promo-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'description_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card .htmega-interactive-promo-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-12 .htmega-interactive-promo-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'description_background_opacity_header',
                [
                    'label' => esc_html__( 'Background Opacity', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'promo_effect' => ['2']
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'description_background_opacity',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-2 .htmega-interactive-promo-description::before',
                    'condition' => [
                        'promo_effect' => ['2']
                    ],
                ]
            );

            $this->add_responsive_control(
                'hover_description_position',
                [
                    'label' => esc_html__( 'Hover Description Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => -500,
                            'max' => 500,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-interactive-promo-card.htmega-interactive-promo-card-12:hover .htmega-interactive-promo-content' => 'bottom: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'promo_effect' => ['12']
                    ],
                    'separator' => 'before'
                ]
            );

        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $this->add_render_attribute( 'promo_area_attr', 'class', 'htmega-interactive-promo-card htmega-interactive-promo-card-'. esc_attr( $settings['promo_effect'] ) );
        // Promo URL
        if ( ! empty( $settings['promo_link']['url'] ) ) {
			$this->add_link_attributes( 'promo_link', $settings['promo_link'] );
		}

        ?>

        <div class="htmega-interactive-promo-wrap">
            <a class="htmega-interactive-promo-link" <?php echo $this->get_render_attribute_string( 'promo_link' ); ?>>
                <figure <?php echo $this->get_render_attribute_string( 'promo_area_attr' ); ?>>
                    <!-- BG Image -->
                    <?php if(!empty( $settings['promo_bg_image']['url'])){
                        $this->promo_image_render($settings['promo_bg_image'], (isset($settings['promo_bg_image_size']) ? $settings['promo_bg_image_size'] : 'full'));
                    }?>
                    <figcaption class="htmega-interactive-promo-content">
                        <?php 
                        echo ($settings['promo_effect'] == '1') ? "<div class='htmega-interactive-promo-content-box'>" : "";
                            //Title and Description
                            ($settings['promo_effect'] != '12') ? $this->promo_title_render($settings['promo_title'], $settings['promo_title_tag']) : $this->promo_description_render($settings['promo_description']);
                            //Description and Title
                            ($settings['promo_effect'] != '12') ? $this->promo_description_render($settings['promo_description']) : $this->promo_title_render($settings['promo_title'], $settings['promo_title_tag']);
                        echo ($settings['promo_effect'] == '1') ? "<div>" : ""; ?>
                    </figcaption>
                </figure>
            </a>
        </div>

    <?php }

    //Image Render
    protected function promo_image_render($image, $image_size){
        $imageURL = wp_get_attachment_image_url( $image['id'], $image_size );
        if ( ! $imageURL ) {
            $imageURL = $image['url'];
        }
        if($imageURL):?>
            <img class="htmega-interactive-effect-image" src="<?php echo esc_url( $imageURL ); ?>" alt="<?php echo esc_attr( isset($image['alt']) ? $image['alt'] : "" ); ?>">
        <?php 
        
    // var_dump( $image);
    
    endif;
    }

    //Title Render
    protected function promo_title_render($title, $title_tag){
        if(!empty($title)){
           echo "<" . htmega_escape_tags($title_tag, 'h2') . " class='htmega-interactive-promo-title'>". htmega_kses_title( $title) . "</" . htmega_escape_tags($title_tag, 'h2') . ">";
        }
    }

    //Description Render
    protected function promo_description_render($description){
        if(!empty($description)): ?>
            <p class="htmega-interactive-promo-description"><?php echo htmega_kses_desc( $description )?></p>
        <?php endif;
    }
}