<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Pricing_Menu_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-pricing-menu-addons';
    }
    
    public function get_title() {
        return __( 'Pricing Menu', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-info-box';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'pricing', 'pricing menu', 'food', 'menu', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/price-menu-widget/';
	}

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Pricing Menu', 'htmega-pro' ),
            ]
        );
            
            $this->add_control(
                'layout',
                [
                    'label' => esc_html__( 'Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'one',
                    'options' => [
                        'one'   => esc_html__( 'Style One', 'htmega-pro' ),
                        'two'   => esc_html__( 'Style Two', 'htmega-pro' ),
                        'three' => esc_html__( 'Style Three', 'htmega-pro' ),
                    ],
                ]
            );

            $this->add_control(
                'menu_image',
                [
                    'label' => esc_html__( 'Image', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'condition'=>[
                        'layout'=>'three',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'menu_image_size',
                    'default' => 'large',
                    'separator' => 'none',
                    'condition'=>[
                        'layout'=>'three',
                        'menu_image[url]!'=>'',
                    ]
                ]
            );

            $this->add_control(
                'menu_title',
                [
                    'label' => esc_html__( 'Title', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Salmon Filet', 'htmega-pro' ),
					'label_block'=>true,
                    'condition'=>[
                        'layout'=> 'three',
                    ],
                ]
            );

            $this->add_control(
                'menu_description',
                [
                    'label' => esc_html__( 'Description', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt.', 'htmega-pro' ),
                    'condition'=>[
                        'layout'=>'three'
                    ],
                ]
            );

            $repeater = new Repeater();

			$repeater->add_control(
                'rep_menu_image',
                [
                    'label' => esc_html__( 'Image', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $repeater->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'rep_menu_image_size',
                    'default' => 'large',
                    'separator' => 'none',
                    'condition'=>[
                        'rep_menu_image[url]!'=>'',
                    ]
                ]
            );


            $repeater->add_control(
                'rep_menu_name',
                [
                    'label'=> esc_html__( 'Menu name', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Aloo Tikki (5 pcs.)', 'htmega-pro' ),
                    'label_block'=>true,
                ]
            );

			$repeater->add_control(
                'rep_menu_description',
                [
                    'label' => esc_html__( 'Description', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fermentum.', 'htmega-pro' ),
                ]
            );

            $repeater->add_control(
                'rep_menu_price',
                [
                    'label'=> esc_html__( 'Menu Price', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( '50', 'htmega-pro' ),
                    'label_block'=>true,
                ]
            );

            $this->add_control(
                'menu_list',
                [
                    'label'   => esc_html__( 'Pricing Menu List', 'htmega-pro' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
						[
                            'rep_menu_name' => esc_html__( 'Vegetable Samosas (3 pcs.)', 'htmega-pro' ),
                            'rep_menu_description' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fermentum.', 'htmega-pro' ),
                            'rep_menu_price' => esc_html__( '50', 'htmega-pro' ),
                        ],
						[
                            'rep_menu_name' => esc_html__( 'Aloo Tikki (5 pcs.)', 'htmega-pro' ),
                            'rep_menu_description' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fermentum.', 'htmega-pro' ),
                            'rep_menu_price' => esc_html__( '100', 'htmega-pro' ),
                        ],
						[
                            'rep_menu_name' => esc_html__( 'Spiced Crab Cakes', 'htmega-pro' ),
                            'rep_menu_description' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fermentum.', 'htmega-pro' ),
                            'rep_menu_price' => esc_html__( '70', 'htmega-pro' ),
                        ],
                    ],
                    'title_field' => '{{{ rep_menu_name }}}',
                    'separator' => 'after',
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
            'currency_section',
            [
                'label' => esc_html__( 'Pricing Option', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'currency_symbol',
                [
                    'label'   => esc_html__( 'Currency Symbol', 'htmega-pro' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        ''             => esc_html__( 'None', 'htmega-pro' ),
                        'dollar'       => '&#36; ' . __( 'Dollar', 'htmega-pro' ),
                        'euro'         => '&#128; ' . __( 'Euro', 'htmega-pro' ),
                        'baht'         => '&#3647; ' . __( 'Baht', 'htmega-pro' ),
                        'franc'        => '&#8355; ' . __( 'Franc', 'htmega-pro' ),
                        'guilder'      => '&fnof; ' . __( 'Guilder', 'htmega-pro' ),
                        'krona'        => 'kr ' . __( 'Krona', 'htmega-pro' ),
                        'lira'         => '&#8356; ' . __( 'Lira', 'htmega-pro' ),
                        'peseta'       => '&#8359 ' . __( 'Peseta', 'htmega-pro' ),
                        'peso'         => '&#8369; ' . __( 'Peso', 'htmega-pro' ),
                        'pound'        => '&#163; ' . __( 'Pound Sterling', 'htmega-pro' ),
                        'real'         => 'R$ ' . __( 'Real', 'htmega-pro' ),
                        'ruble'        => '&#8381; ' . __( 'Ruble', 'htmega-pro' ),
                        'rupee'        => '&#8360; ' . __( 'Rupee', 'htmega-pro' ),
                        'indian_rupee' => '&#8377; ' . __( 'Rupee (Indian)', 'htmega-pro' ),
                        'shekel'       => '&#8362; ' . __( 'Shekel', 'htmega-pro' ),
                        'yen'          => '&#165; ' . __( 'Yen/Yuan', 'htmega-pro' ),
                        'won'          => '&#8361; ' . __( 'Won', 'htmega-pro' ),
                        'custom'       => __( 'Custom', 'htmega-pro' ),
                    ],
                    'default' => 'dollar',
                ]
            );

            $this->add_control(
                'currency_symbol_custom',
                [
                    'label'     => esc_html__( 'Custom Symbol', 'htmega-pro' ),
                    'type'      => Controls_Manager::TEXT,
                    'condition' => [
                        'currency_symbol' => 'custom',
                    ],
                ]
            );

        $this->end_controls_section();

		$this->start_controls_section(
            'reviews_section',
            [
                'label' => esc_html__( 'Menu Retting', 'htmega-pro' ),
                'condition' => [
                    'layout' => 'three',
                ],
            ]
        );

            $this->add_control(
                'review_rating',
                [
                    'label'     => esc_html__( 'Manual Rating', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'min' 		=> 1,
					'max' 		=> 5,
					'step' 		=> 1,
					'default' 	=> 5,
                ]
            );

            $this->add_control(
                'totel_review',
                [
                    'label'     => esc_html__( 'Total Review', 'htmega-pro' ),
                    'type'      => Controls_Manager::TEXT,
					'default' 	=> 140,
                    'placeholder' => esc_html__( '100 Review', 'htmega-pro'),
                    'label_block'=>true,
                ]
            );

        $this->end_controls_section();

        // Style tab section
        $this->start_controls_section(
            'area_style',
            [
                'label' => esc_html__( 'Items Area', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'area_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item, {{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item, {{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item-title, {{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item-price',
                    'condition'=>[
                        'layout'=>'three'
                    ],
                ]
            );

            $this->add_control(
                'area_image_backround_header',
                [
                    'label' => esc_html__( 'Area Image Background', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'layout' => 'three',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'image_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-image',
                    'separator' => 'before',
                     'condition' => [
                        'layout' => 'three',
                    ],
                ]
            );
                
            $this->add_responsive_control(
                'pricing_area_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'pricing_area_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'area_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item, {{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item',
                    'condition'=>[
                        'layout'=>'three'
                    ],
                ]
            );

            $this->add_control(
                'pricing_area_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item-image' => 'border-radius: {{TOP}}{{UNIT}} 0px 0px {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition'=>[
                        'layout'=>'three'
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'pricing_area_hover_box_shadow',
                    'label' => esc_html__( 'Hover Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item:hover, {{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item:hover',
                    'condition'=>[
                        'layout'=>'three'
                    ],
                ]
            );


        $this->end_controls_section();

        // Priching Title Style tab section
        $this->start_controls_section(
            'pricing_title',
            [
                'label' => esc_html__( 'Title', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'layout'=>'three'
                ],
            ]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-heading' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-heading',
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'title_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Title Style tab section
        $this->start_controls_section(
            'menu_title_style',
            [
                'label' => esc_html__( 'Menu Item', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'menu_title_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'menu_area_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item, {{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-title, {{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item-title, {{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item-price,{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-header-left',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'menu_title_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-title',
                ]
            );

            $this->add_control(
                'menu_title_image_backround_heading',
                [
                    'label' => esc_html__( 'Image Background', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'layout!' => 'three',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'menu_title_image_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-image',
                    'separator' => 'before',
                    'condition' => [
                        'layout!' => 'three',
                    ],
                ]
            );

            $this->add_responsive_control(
                'menu_title_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'menu_title_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'menu_area_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-box .htmega-pricing-menu-item',
                    'condition'=>[
                        'layout!'=>'three'
                    ],
                ]
            );
            
            $this->add_control(
                'menu_pricing_area_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-box .htmega-pricing-menu-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-box .htmega-pricing-menu-item-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item-3 .htmega-pricing-menu-item-image' => 'border-radius: {{TOP}}{{UNIT}} 0px 0px {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'layout' => 'two',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'menu_hover_box_shadow',
                    'label' => esc_html__( 'Hover Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-box .htmega-pricing-menu-item:hover',
                    'layout!'=>'three'
                ]
            );

            $this->add_control(
                'menu_title_before_color',
                [
                    'label' => esc_html__( 'Dot Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        
                        '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item .htmega-pricing-menu-item-list:before' => 'background-image: -webkit-gradient(linear, left top, right top, color-stop(30%, transparent), color-stop(70%, {{VALUE}}))',
                        '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item .htmega-pricing-menu-item-list:before' => 'background-image: -webkit-linear-gradient(left, transparent 30%, {{VALUE}} 70%)',
                        '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item .htmega-pricing-menu-item-list:before' => 'background-image: -o-linear-gradient(left, transparent 30%, {{VALUE}} 70%)',
                        '{{WRAPPER}} .htmega-pricing-menu-wrap .htmega-pricing-menu-item .htmega-pricing-menu-item-list:before' => 'background-image: linear-gradient(to right, transparent 30%, {{VALUE}} 70%)',

                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-header:before' => 'background-image: -webkit-gradient(linear, left top, right top, color-stop(30%, transparent), color-stop(70%, {{VALUE}}))',
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-header:before' => 'background-image: -webkit-linear-gradient(left, transparent 30%, {{VALUE}} 70%)',
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-header:before' => 'background-image: -o-linear-gradient(left, transparent 30%, {{VALUE}} 70%)',
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-header:before' => 'background-image: linear-gradient(to right, transparent 30%, {{VALUE}} 70%)',
                    ],
                    'separator' => 'before',
                     'condition'=>[
                        'layout!'=>'two'
                    ],

                ]
            );

        $this->end_controls_section();

        // Description Style tab section
        $this->start_controls_section(
            'description_style',
            [
                'label' => esc_html__( 'Description', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            
            $this->add_control(
                'description_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-description' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'description_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-description',
                ]
            );

            $this->add_responsive_control(
                'description_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'description_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Price Style tab section
        $this->start_controls_section(
            'price_style',
            [
                'label' => esc_html__( 'Price', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            
            $this->add_control(
                'price_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-price' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'price_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-price',
                ]
            );
            
            $this->add_responsive_control(
                'price_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Price Style tab section
        $this->start_controls_section(
            'review_style',
            [
                'label' => esc_html__( 'Review', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => 'three',
                ],
            ]
        );
            
            $this->add_control(
                'retting_eneble_color',
                [
                    'label' => esc_html__( 'Retting Eneble Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-rating' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'retting_dsable_color',
                [
                    'label' => esc_html__( 'Retting Disable Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-rating.rating-deactivate' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'review_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-review-count, {{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-rating i',
                ]
            );

            $this->add_responsive_control(
                'review_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-review' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'review_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pricing-menu-item .htmega-pricing-menu-item-review' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();


    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
		$menu_list = $settings['menu_list'];

		$currencysymbol = '';
        if ( ! empty( $settings['currency_symbol'] ) ) {
            if ( $settings['currency_symbol'] != 'custom' ) {
                $currencysymbol = $this->get_currency_symbol( $settings['currency_symbol'] );
            } else {
                $currencysymbol = $settings['currency_symbol_custom'];
            }
        }
		
		?>
        <?php if($settings['layout'] != 'three'): ?>
            <div class="htmega-pricing-menu-wrap">
                <div class="htmega-pricing-menu-box">

                    <?php foreach($menu_list as $menu):			
                        if($settings['layout'] == 'one'):?>
                            <!-- Pricing Menu Item Start -->
                            <div class="htmega-pricing-menu-item htmega-pricing-menu-item-1">
                                <div class="htmega-pricing-menu-item-header">
                                    <div class="htmega-pricing-menu-item-header-left">
                                        <!-- menu Image -->
                                        <?php if(!empty( $menu['rep_menu_image']['url'])): ?>
                                            <span class="htmega-pricing-menu-item-image">
                                                <?php echo Group_Control_Image_Size::get_attachment_image_html( $menu, 'rep_menu_image_size', 'rep_menu_image' ); ?>
                                            </span>
                                        <?php endif ?>
                                        <!-- Menu Name -->
                                        <?php if(!empty($menu['rep_menu_name'])): ?>
                                            <h5 class="htmega-pricing-menu-item-title"><?php echo esc_html( $menu['rep_menu_name'] ) ?></h5>
                                        <?php endif ?>
                                    </div>
                                    <!-- Menu Price -->
                                    <?php if(!empty( $menu['rep_menu_price'])): ?>
                                        <span class="htmega-pricing-menu-item-price">
                                            <span class="htmega-pricing-price-currency"><?php echo esc_html($currencysymbol)?></span><?php echo esc_html($menu['rep_menu_price']) ?></span>
                                    <?php endif ?>

                                </div>
                                <!-- Menu Description -->
                                <?php if(!empty( $menu['rep_menu_description'])): ?>
                                    <p class="htmega-pricing-menu-item-description"><?php echo esc_html( $menu['rep_menu_description'] ) ?></p>
                                <?php endif ?>
                            </div> <!-- Pricing Menu Item End -->

                        <?php elseif($settings['layout'] == 'two'): ?>

                            <div class="htmega-pricing-menu-box">
                                <!-- Pricing Menu Item Start -->
                                <div class="htmega-pricing-menu-item htmega-pricing-menu-item-3">
                                    <!-- menu Image -->
                                    <?php if(!empty( $menu['rep_menu_image']['url'])): ?>
                                        <div class="htmega-pricing-menu-item-image">
                                            <?php echo Group_Control_Image_Size::get_attachment_image_html( $menu, 'rep_menu_image_size', 'rep_menu_image' ); ?>
                                        </div>
                                    <?php endif ?>

                                    <div class="htmega-pricing-menu-item-content">
                                        <!-- Menu Name -->
                                        <?php if(!empty($menu['rep_menu_name'])): ?>
                                            <h5 class="htmega-pricing-menu-item-title"><?php echo esc_html( $menu['rep_menu_name'] ) ?></h5>
                                        <?php endif ?>

                                        <!-- Menu Price -->
                                        <?php if(!empty( $menu['rep_menu_price'])): ?>
                                            <span class="htmega-pricing-menu-item-price">
                                                <span class="htmega-pricing-price-currency"><?php echo esc_html($currencysymbol)?></span><?php echo esc_html($menu['rep_menu_price']) ?></span>
                                        <?php endif ?>

                                        <!-- Menu Description -->
                                        <?php if(!empty( $menu['rep_menu_description'])): ?>
                                            <p class="htmega-pricing-menu-item-description"><?php echo esc_html( $menu['rep_menu_description'] ) ?></p>
                                        <?php endif ?>
                                    </div>
                                </div> <!-- Pricing Menu Item End -->
                            </div>
                    <?php 
                        endif;    
                    endforeach ?>
                </div>
            </div>

        <?php else: ?>
            <div class="htmega-pricing-menu-wrap">
                <!-- Pricing Menu Item Start -->
                <div class="htmega-pricing-menu-item htmega-pricing-menu-item-4">
                    <!-- Menu Image -->
                    <?php if(!empty( $settings['menu_image']['url'])): ?>
                        <div class="htmega-pricing-menu-item-image">
                            <?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'menu_image_size', 'menu_image' ) ?>
                        </div>
                    <?php endif ?>
                    <!-- Menu Title -->
                    <div class="htmega-pricing-menu-item-content">
                        <?php if(!empty($settings['menu_title'])): ?>
                            <h3 class="htmega-pricing-menu-item-heading"><?php echo esc_html( $settings['menu_title'] ) ?></h3>
                        <?php endif ?>
                        <!-- Menu Description -->
                        <?php if(!empty( $settings['menu_description'])): ?>
                            <p class="htmega-pricing-menu-item-description"><?php echo esc_html( $settings['menu_description'] ) ?></p>
                        <?php endif ?>

                        <?php foreach($menu_list as $menu):	?>
                            <div class="htmega-pricing-menu-item-list">
                                <!-- Menu Item Name -->
                                <?php if(!empty($menu['rep_menu_name'])): ?>
                                    <h5 class="htmega-pricing-menu-item-title">
                                    <?php if(!empty( $menu['rep_menu_image']['url'])): ?>
                                        <?php echo Group_Control_Image_Size::get_attachment_image_html( $menu, 'rep_menu_image_size', 'rep_menu_image' ); ?>
                                    <?php endif ?>
                                    <?php echo esc_html( $menu['rep_menu_name'] ) ?></h5>
                                <?php endif ?>
                                <!-- Menu Item Price -->
                                <?php if(!empty( $menu['rep_menu_price'])): ?>
                                    <span class="htmega-pricing-menu-item-price">
                                        <span class="htmega-pricing-price-currency"><?php echo esc_html($currencysymbol)?></span><?php echo esc_html($menu['rep_menu_price']) ?></span>
                                <?php endif ?>
                            </div>
                            <!-- Menu Description -->
                            <?php if(!empty( $menu['rep_menu_description'])): ?>
                                <p class="htmega-pricing-menu-item-description"><?php echo esc_html( $menu['rep_menu_description']) ?></p>
                            <?php endif ?>
                    <?php endforeach ?>
                    <!-- Menu Retting and Review -->
                    <?php if(!empty( $settings['totel_review']) ): ?>
                        <div class="htmega-pricing-menu-item-review">
                                <!-- Menu Retting -->
                                <?php for($i = 0; $i < 5; $i++): 
                                    if($settings['review_rating'] > $i): ?>
                                        <span class="htmega-pricing-menu-item-rating"><i class="fa fa-star"></i></span>
                                    <?php else: ?>
                                        <span class="htmega-pricing-menu-item-rating rating-deactivate"><i class="fa fa-star"></i></span>
                                <?php 
                                    endif;
                                endfor; ?>
                            <!-- Menu Review -->
                            <span class="htmega-pricing-menu-item-review-count"><?php echo esc_html( '('.$settings['totel_review'].')' ) ?></span>
                        </div>
                    <?php endif ?>
                    </div>
                </div> <!-- Pricing Menu Item End -->
            </div>
        <?php endif ?>
	<?php }
    // Currency Symbol
	private function get_currency_symbol( $symbol_name ) {
        $symbols = [
            'dollar'       => '&#36;',
            'baht'         => '&#3647;',
            'euro'         => '&#128;',
            'franc'        => '&#8355;',
            'guilder'      => '&fnof;',
            'indian_rupee' => '&#8377;',
            'krona'        => 'kr',
            'lira'         => '&#8356;',
            'peseta'       => '&#8359',
            'peso'         => '&#8369;',
            'pound'        => '&#163;',
            'real'         => 'R$',
            'ruble'        => '&#8381;',
            'rupee'        => '&#8360;',
            'shekel'       => '&#8362;',
            'won'          => '&#8361;',
            'yen'          => '&#165;',
        ];
        return isset( $symbols[ $symbol_name ] ) ? $symbols[ $symbol_name ] : '';
    }

}