<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Pricing_Table_Flip_Box_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-pricing-table-flip-box';
    }
    
    public function get_title() {
        return esc_html__( 'Pricing Table Flip Box', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-flip-box';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'flip box', 'pricing table', 'pricing table flip' ];
    }

    public function get_help_url() {
		return 'https://wphtmega.com/docs/';
	}
    protected function register_controls() {
        $this->_general_controls();
        $this->_style_controls();
    }

    protected function _general_controls(){ 
        $this->__flip_box_layout_section();
        $this->__flip_box_header_section();
        $this->__flip_box_price_section();
        $this->__flip_box_features_section();
        $this->__flip_box_footer_section();
    }

    //Layout
    protected function __flip_box_layout_section(){
        // Layout Fields tab start
        $this->start_controls_section(
            'htmega_pricing_layout',
            [
                'label' => esc_html__('Layouts', 'htmega-pro'),
            ]
        );
            $this->add_control(
                'htmega_pricing_style',
                [
                    'label' => esc_html__('Layout', 'htmega-pro'),
                    'type' => 'htmega-preset-select',
                    'default' => '1',
                    'options' => [
                        '1'   => esc_html__('Layout One', 'htmega-pro'),
                        '2'   => esc_html__('Layout Two', 'htmega-pro'),
                    ],
                ]
            );
        $this->end_controls_section(); // Layout Fields tab end
    }
    //Header 
    protected function __flip_box_header_section(){
        // Header Fields tab start
        $this->start_controls_section(
            'htmega_pricing_header',
            [
                'label' => esc_html__('Header', 'htmega-pro'),
            ]
        );


        $this->add_control(
            'pricing_title',
            [
                'label' => esc_html__('Title', 'htmega-pro'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__('Enter your pricing Title name here', 'htmega-pro'),
                'default' => esc_html__('Standard', 'htmega-pro'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'pricing_sub_title',
            [
                'label' => esc_html__('Sub Title', 'htmega-pro'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__('Enter your pricing sub title name here', 'htmega-pro'),
                'default' => esc_html__('Perfect to get Started', 'htmega-pro'),
            ]
        );


        $this->add_responsive_control(
            'htmega_header_alignment_padding',
            [
                'label' => esc_html__('Padding', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box-wrap .htmega-pt-flip-box-priching-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section(); // Header Fields tab end
    }
    //Price
    protected function __flip_box_price_section(){
        // Pricing Fields tab start
        $this->start_controls_section(
            'htmega_pricing_price',
            [
                'label' => esc_html__('Pricing', 'htmega-pro'),
            ]
        );
        $this->add_control(
            'htmega_currency_symbol',
            [
                'label'   => esc_html__('Currency Symbol', 'htmega-pro'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''             => esc_html__('None', 'htmega-pro'),
                    'dollar'       => '&#36; ' . esc_html__('Dollar', 'htmega-pro'),
                    'euro'         => '&#128; ' . esc_html__('Euro', 'htmega-pro'),
                    'baht'         => '&#3647; ' . esc_html__('Baht', 'htmega-pro'),
                    'franc'        => '&#8355; ' . esc_html__('Franc', 'htmega-pro'),
                    'guilder'      => '&fnof; ' . esc_html__('Guilder', 'htmega-pro'),
                    'krona'        => 'kr ' . esc_html__('Krona', 'htmega-pro'),
                    'lira'         => '&#8356; ' . esc_html__('Lira', 'htmega-pro'),
                    'peseta'       => '&#8359 ' . esc_html__('Peseta', 'htmega-pro'),
                    'peso'         => '&#8369; ' . esc_html__('Peso', 'htmega-pro'),
                    'pound'        => '&#163; ' . esc_html__('Pound Sterling', 'htmega-pro'),
                    'real'         => 'R$ ' . esc_html__('Real', 'htmega-pro'),
                    'ruble'        => '&#8381; ' . esc_html__('Ruble', 'htmega-pro'),
                    'rupee'        => '&#8360; ' . esc_html__('Rupee', 'htmega-pro'),
                    'indian_rupee' => '&#8377; ' . esc_html__('Rupee (Indian)', 'htmega-pro'),
                    'shekel'       => '&#8362; ' . esc_html__('Shekel', 'htmega-pro'),
                    'yen'          => '&#165; ' . esc_html__('Yen/Yuan', 'htmega-pro'),
                    'won'          => '&#8361; ' . esc_html__('Won', 'htmega-pro'),
                    'custom'       => esc_html__('Custom', 'htmega-pro'),
                ],
                'default' => 'dollar',
            ]
        );

        $this->add_control(
            'htmega_currency_symbol_custom',
            [
                'label'     => esc_html__('Custom Symbol', 'htmega-pro'),
                'type'      => Controls_Manager::TEXT,
                'condition' => [
                    'htmega_currency_symbol' => 'custom',
                ],
            ]
        );

        $this->add_control(
            'htmega_price',
            [
                'label'   => esc_html__('Price', 'htmega-pro'),
                'type'    => Controls_Manager::TEXT,
                'default' => '39',
            ]
        );

        $this->add_control(
            'htmega_offer_price',
            [
                'label'        => esc_html__('Offer', 'htmega-pro'),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'htmega_original_price',
            [
                'label'     => esc_html__('Original Price', 'htmega-pro'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => '49',
                'condition' => [
                    'htmega_offer_price' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'htmega_period',
            [
                'label'   => esc_html__('Period', 'htmega-pro'),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__('Per month', 'htmega-pro'),
            ]
        );

        $this->add_responsive_control(
            'htmega_price_alignment_padding',
            [
                'label' => esc_html__('Padding', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box-wrap .htmega-pt-flip-box__price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section(); // Pricing Fields tab end
    }
    //Feature
    protected function __flip_box_features_section(){
        // Features tab start
        $this->start_controls_section(
            'htmega_pricing_features',
            [
                'label' => esc_html__('Features', 'htmega-pro'),
            ]
        );

        $this->add_control(
            'features_label',
            [
                'label' => esc_html__('Features Label', 'htmega-pro'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__('Enter your features label here', 'htmega-pro'),
                'default' => esc_html__('Basic Includes', 'htmega-pro'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'htmega_features_title',
            [
                'label'   => esc_html__('Title', 'htmega-pro'),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__('Features Tilte', 'htmega-pro'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'htmega_features_icon',
            [
                'label'   => esc_html__('Icon', 'htmega-pro'),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-angle-double-right',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_control(
            'htmega_features_list',
            [
                'label' => esc_html__('Features List', 'htmega-pro'),
                'type'    => Controls_Manager::REPEATER,
                'fields'  =>  $repeater->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'htmega_features_title' => esc_html__('Features Title One', 'htmega-pro'),
                        'htmega_features_icon' => 'fas fa-angle-double-right',
                    ],
                    [
                        'htmega_features_title' => esc_html__('Features Title Two', 'htmega-pro'),
                        'htmega_features_icon' => 'fas fa-angle-double-right',
                    ],
                    [
                        'htmega_features_title' => esc_html__('Features Title Three', 'htmega-pro'),
                        'htmega_features_icon' => 'fas fa-angle-double-right',
                    ],
                    [
                        'htmega_features_title' => esc_html__('Features Title Four', 'htmega-pro'),
                        'htmega_features_icon' => 'fas fa-angle-double-right',
                    ],
                    [
                        'htmega_features_title' => esc_html__('Features Title Five', 'htmega-pro'),
                        'htmega_features_icon' => 'fas fa-angle-double-right',
                    ],
                ],
                'title_field' => '{{{ htmega_features_title }}}',
            ]
        );

        $this->add_responsive_control(
            'pricing_features_list_padding',
            [
                'label' => esc_html__('Padding', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__details ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section(); // Features Fields tab end
    }
    //Footer
    protected function __flip_box_footer_section(){
        // Footer tab start
        $this->start_controls_section(
            'htmega_pricing_footer',
            [
                'label' => esc_html__('Footer', 'htmega-pro'),
            ]
        );

        $this->add_control(
            'htmega_button_text',
            [
                'label'   => esc_html__('Button Text', 'htmega-pro'),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__('Select Plan', 'htmega-pro'),
            ]
        );

        $this->add_control(
            'htmega_button_link',
            [
                'label'       => esc_html__('Link', 'htmega-pro'),
                'type'        => Controls_Manager::URL,
                'placeholder' => 'http://your-link.com',
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        $this->end_controls_section(); // Footer Fields tab end
    }

    //_style_controls
    protected function _style_controls() {
        $this->__flip_box_section_style();
        $this->__flip_box_header_section_style();
        $this->__flip_box_pricing_section_style();
        $this->__flip_box_features_section_style();
        $this->__flip_box_footer_section_style();
    }

    protected function __flip_box_section_style(){
         // Style tab section start
         $this->start_controls_section(
            'htmega_pricing_style_section',
            [
                'label' => esc_html__('Flip Box Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'pricing_table_background',
                    'label' => esc_html__('Background', 'htmega-pro'),
                    'types' => ['gradient'],
                    'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__side',
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'pricing_table_box_shadow',
                    'label' => esc_html__('Box Shadow', 'htmega-pro'),
                    'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__side',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'pricing_table_border',
                    'label' => esc_html__('Border', 'htmega-pro'),
                    'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__side',
                ]
            );

            $this->add_responsive_control(
                'pricing_table_margin',
                [
                    'label' => esc_html__('Margin', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__side' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'pricing_table_padding',
                [
                    'label' => esc_html__('Padding', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__side' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'pricing_table_radius',
                [
                    'label' => esc_html__('Border Radius', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__side' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

        $this->end_controls_section(); // Style tab section end 
    }

    protected function __flip_box_header_section_style(){
        // Header Title style tab start
        $this->start_controls_section(
            'htmega_header_title_style',
            [
                'label'     => esc_html__('Header', 'htmega-pro'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'pricing_title!' => ''
                ]
            ]
        );

        $this->add_control(
            'pricing_header_heading_title',
            [
                'label'     => esc_html__('Title', 'htmega-pro'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'pricing_header_title_color',
            [
                'label'     => esc_html__('Color', 'htmega-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price-type' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'pricing_header_title_typography',
                'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price-type',
            ]
        );

        $this->add_responsive_control(
            'pricing_header_title_margin',
            [
                'label' => esc_html__('Margin', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price-type' => 'margin: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'pricing_header_heading_sub_title',
            [
                'label'     => esc_html__('Sub Title', 'htmega-pro'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'pricing_header_sub_title_color',
            [
                'label'     => esc_html__('Color', 'htmega-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price-desc' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'pricing_header_sub_title_typography',
                'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price-desc',
            ]
        );

        $this->add_responsive_control(
            'pricing_header_sub_title_margin',
            [
                'label' => esc_html__('Margin', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price-desc' => 'margin: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->end_controls_section(); // Header Title style tab End
    }

    protected function __flip_box_pricing_section_style(){
        // Header Price Style tab start
        $this->start_controls_section(
            'htmega_header_price_style',
            [
                'label'     => esc_html__('Pricing', 'htmega-pro'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'htmega_price!' => ''
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'pricing_header_price_background',
                'label' => esc_html__('Background', 'htmega-pro'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pricing_header_price_border',
                'label' => esc_html__('Border', 'htmega-pro'),
                'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price',
            ]
        );

        $this->add_responsive_control(
            'pricing_header_price_margin',
            [
                'label' => esc_html__('Margin', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price' => 'margin: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'pricing_header_price_radius',
            [
                'label' => esc_html__('Border Radius', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'pricing_header_heading_original_price',
            [
                'label'     => esc_html__('Original Price', 'htmega-pro'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'htmega_offer_price' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pricing_header_price_symbol_color',
            [
                'label'     => esc_html__('Color', 'htmega-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .ht-old-price' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'htmega_offer_price' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'pricing_header_price_symbol_typography',
                'selector' => ' {{WRAPPER}} .htmega-pt-flip-box .ht-old-price',
                'condition' => [
                    'htmega_offer_price' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pricing_header_heading_price',
            [
                'label'     => esc_html__('Price', 'htmega-pro'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'pricing_header_price_color',
            [
                'label'     => esc_html__('Color', 'htmega-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .ht-new-price' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'pricing_header_price_typography',
                'selector' => '{{WRAPPER}} .htmega-pt-flip-box .ht-new-price',
            ]
        );

        $this->add_responsive_control(
            'pricing_header_price',
            [
                'label' => esc_html__('Padding', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .ht-new-price' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'pricing_header_heading_Period',
            [
                'label'     => esc_html__('Period', 'htmega-pro'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'htmega_period!' => '',
                ],
            ]
        );

        $this->add_control(
            'pricing_header_price_period_color',
            [
                'label'     => esc_html__('Color', 'htmega-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price-status' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'htmega_period!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'pricing_header_price_period_typography',
                'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price-status',
                'condition' => [
                    'htmega_period!' => '',
                ]
            ]
        );

        $this->add_responsive_control(
            'pricing_header_price_period',
            [
                'label' => esc_html__('Padding', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__price-status' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->end_controls_section(); // Header Price style tab end
    }

    protected function __flip_box_features_section_style(){
        // Features style tab start
        $this->start_controls_section(
            'htmega_features_style',
            [
                'label'     => esc_html__('Features', 'htmega-pro'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );     

        $this->add_control(
            'pricing_features_area_toggle',
            [
                'label' => esc_html__('Price Features Box Area', 'htmega-pro'),
                'type' => Controls_Manager::POPOVER_TOGGLE,
                'label_off' => esc_html__('None', 'htmega-pro'),
                'label_on' => esc_html__('Custom', 'htmega-pro'),
                'return_value' => 'yes',
            ]
        );

        $this->start_popover();

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'pricing_features_area_background',
                    'label' => esc_html__('Background', 'htmega-pro'),
                    'types' => ['classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .htmega-pt-flip-box__details ul',
                ]
            );

            $this->add_responsive_control(
                'pricing_features_area_padding',
                [
                    'label' => esc_html__('Padding', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box__details ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
    
            $this->add_responsive_control(
                'pricing_features_area_margin',
                [
                    'label' => esc_html__('Margin', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box__details ul' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
    
            $this->add_responsive_control(
                'pricing_features_area_border_radius',
                [
                    'label' => esc_html__('Border Radius', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box__details ul' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );

        $this->end_popover();

        $this->add_control(
            'pricing_features_item_color',
            [
                'label'     => esc_html__('Color', 'htmega-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box__details ul li' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'pricing_features_item_typography',
                'selector' => '{{WRAPPER}} .htmega-pt-flip-box__details ul li',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pricing_features_item_border',
                'label' => esc_html__('Border', 'htmega-pro'),
                'selector' => '{{WRAPPER}} .htmega-pt-flip-box__details ul li',
            ]
        );

        $this->add_responsive_control(
            'pricing_features_item_padding',
            [
                'label' => esc_html__('Padding', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box__details ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'pricing_features_item_margin',
            [
                'label' => esc_html__('Margin', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box__details ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->add_control(
            'pricing_features_item_icon',
            [
                'label'     => esc_html__('Icon', 'htmega-pro'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'htmega_features_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'htmega-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box__details li i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .htmega-pt-flip-box__details li svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'htmega_badge_position_right',
            [
                'label' => esc_html__('Icon Size', 'htmega-pro'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 17,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box__details li i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .htmega-pt-flip-box__details li svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'htmega_badge_position_margin',
            [
                'label' => esc_html__('Icon Space', 'htmega-pro'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-pt-flip-box__details li i, {{WRAPPER}} .htmega-pt-flip-box__details li svg' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section(); // Features style tab end
    }

    protected function __flip_box_footer_section_style(){
        
        // Footer style tab start
        $this->start_controls_section(
            'htmega_pricing_footer_style',
            [
                'label'     => esc_html__('Footer', 'htmega-pro'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->start_controls_tabs('pricing_footer_style_tabs');

                // Pricing Normal tab start
                $this->start_controls_tab(
                    'style_pricing_normal_tab',
                    [
                        'label' => esc_html__('Normal', 'htmega-pro'),
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name' => 'style_pricing_normal_box_shadow',
                        'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name'     => 'pricing_footer_typography',
                        'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan',
                    ]
                );

                $this->add_control(
                    'pricing_footer_color',
                    [
                        'label'     => esc_html__('Color', 'htmega-pro'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan' => 'color: {{VALUE}}',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'pricing_footer_background',
                        'label' => esc_html__('Background', 'htmega-pro'),
                        'types' => ['classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'pricing_footer_border',
                        'label' => esc_html__('Border', 'htmega-pro'),
                        'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan',
                    ]
                );

                $this->add_responsive_control(
                    'pricing_footer_padding',
                    [
                        'label' => esc_html__('Padding', 'htmega-pro'),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => ['px', '%', 'em'],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'pricing_footer_margin',
                    [
                        'label' => esc_html__('Margin', 'htmega-pro'),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => ['px', '%', 'em'],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'pricing_footer_radius',
                    [
                        'label' => esc_html__('Border Radius', 'htmega-pro'),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

                $this->end_controls_tab(); // Pricing Normal tab end

                // Pricing Hover tab start
                $this->start_controls_tab(
                    'style_pricing_hover_tab',
                    [
                        'label' => esc_html__('Hover', 'htmega-pro'),
                    ]
                );

                $this->add_control(
                    'pricing_footer_hover_color',
                    [
                        'label'     => esc_html__('Color', 'htmega-pro'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan:hover' => 'color: {{VALUE}}',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'pricing_footer_hover_background',
                        'label' => esc_html__('Background', 'htmega-pro'),
                        'types' => ['classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan:hover',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'pricing_footer_hover_border',
                        'label' => esc_html__('Border', 'htmega-pro'),
                        'selector' => '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan:hover , {{WRAPPER}} .htmega-pricing-style-5 .htmega-pricing-body a.price_btn:hover',
                    ]
                );

                $this->add_responsive_control(
                    'pricing_footer_hover_radius',
                    [
                        'label' => esc_html__('Border Radius', 'htmega-pro'),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pt-flip-box .htmega-pt-flip-box__footer .htmega-pt-flip-box__priceing-plan:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

                $this->end_controls_tab(); // Pricing Hover tab end

            $this->end_controls_tabs();

        $this->end_controls_section(); // Footer style tab end
    }


    protected function render( $instance = [] ) { 
        $settings   = $this->get_settings_for_display();
        $features_list = $settings['htmega_features_list']; ?>

        <!-- Pricing Table Flip Box 1 style Start -->
        <div class="htmega-pt-flip-box-wrap">
            <?php if($settings['htmega_pricing_style'] == '1'){?>
                <div class="htmega-pt-flip-box">
                    <div class="htmega-pt-flip-box__side htmega-pt-flip-box__side--front htmega-pt-flip-box__side--front-1">
                        <div class="htmega-pt-flip-box__top">                           
                            <!-- Header -->
                            <?php $this->header_section($settings['pricing_title'], $settings['pricing_sub_title']) ?>
                            <!-- Price -->
                            <?php $this->Pricing_section($settings) ?>
                            
                        </div>
                    </div>
                    <div class="htmega-pt-flip-box__side htmega-pt-flip-box__side--back htmega-pt-flip-box__side--back-1">
                
                        <!-- Features List Display -->
                        <?php $this->features_list_render($settings['features_label'], $features_list)?>
                        <!-- Footer Section  -->
                        <?php $this->footer_section_render($settings['htmega_button_text'], $settings['htmega_button_link'] )?>
            
                    </div>
                </div>
            <?php }elseif($settings['htmega_pricing_style'] == '2'){ ?>
                
                <div class="htmega-pt-flip-box htmega-pt-flip-box-element-3">
                    <div class="htmega-pt-flip-box__side htmega-pt-flip-box__side--front">
                        <div class="htmega-pt-flip-box__top">
                            <div class="htmega-pt-flip-box__top-inner">
                                
                                <?php 
                                    // Header
                                    $this->header_section($settings['pricing_title'], $settings['pricing_sub_title']);
                                    //Pricing Section
                                    $this->Pricing_section_style_2($settings);     
                                ?>

            
                            </div>
                        </div>
                        
                        <!-- Features List Display -->
                        <?php $this->features_list_render($settings['features_label'], $features_list)?>

                        <!-- Footer Section  -->
                        <?php $this->footer_section_render($settings['htmega_button_text'], $settings['htmega_button_link'] )?>

                    </div>
                    <div class="htmega-pt-flip-box__side htmega-pt-flip-box__side--back">
                        <div class="htmega-pt-flip-box__top">
                            <div class="htmega-pt-flip-box__top-inner">
                                <?php 
                                    //Pricing Title
                                    $this->header_section($settings['pricing_title'], $settings['pricing_sub_title']);
                                    //Pricing Section
                                    $this->Pricing_section_style_2($settings);                
                                ?>
                            </div>
                        </div>

                        <!-- Footer Section  -->
                        <?php $this->footer_section_render($settings['htmega_button_text'], $settings['htmega_button_link'] )?>
                    </div>
                </div>

            <?php } ?>

        </div>
        <!-- Pricing Table Flip Box 1 style End -->
    <?php }


    private function header_section($header_title, $header_sub_title){
        echo "<div class='htmega-pt-flip-box-priching-heading'>";
            //Pricing Title
            if($header_title){
                printf("<h5 class='htmega-pt-flip-box__price-type'>%s</h5>", esc_html( $header_title ));
            }

            // Pricing Sub Title
            if($header_sub_title){
                printf("<p class='htmega-pt-flip-box__price-desc'>%s</p>", esc_html( $header_sub_title ));
            }
        echo "</div>";
    }

    private function Pricing_section_style_2($settings){?>
       <div class="htmega-pt-flip-box__price">
            <?php
                $currencysymbol = '';
                if (!empty($settings['htmega_currency_symbol'])) {
                    if ($settings['htmega_currency_symbol'] != 'custom') {
                        $currencysymbol = '<sub>' . $this->get_currency_symbol($settings['htmega_currency_symbol']) . '</sub>';
                    } else {
                        $currencysymbol = '<sub>' . esc_html( $settings['htmega_currency_symbol_custom'] ) . '</sub>';
                    }
                }

                echo "<div class='htmega-pt-flip-box-style-2'>";
                    if ($settings['htmega_offer_price'] == 'yes' && !empty($settings['htmega_original_price'])) {
                        if (!empty($settings['htmega_price'])) {
                            echo '<p class="htmega-pt-flip-box__price-value ht-old-price">'.htmega_kses_title($settings['htmega_original_price']) . htmega_kses_title( $currencysymbol ) .'</p><p class="htmega-pt-flip-box__price-value ht-new-price">'.htmega_kses_title($settings['htmega_price']) . wp_kses_post( $currencysymbol ) . '</p>';
                        }
                    } else {
                        if (!empty($settings['htmega_price'])) {
                            echo '<p class="htmega-pt-flip-box__price-value ht-new-price">'. htmega_kses_title( $settings['htmega_price'] ) . wp_kses_post( $currencysymbol ) . '</p>';
                        }
                    }
                echo "</div>";

                //Pricing Period
                if($settings['htmega_period']){
                    printf("<p class='htmega-pt-flip-box__price-status'>%s</p>", esc_html( $settings['htmega_period'] ) );
                }
            ?>
        </div>
        <?php
            
    }


    private function Pricing_section($settings){
        // Currency symbol
        $currencysymbol = '';
        if (!empty($settings['htmega_currency_symbol'])) {
            if ($settings['htmega_currency_symbol'] != 'custom') {
                $currencysymbol = '<span>' . $this->get_currency_symbol($settings['htmega_currency_symbol']) . '</span>';
            } else {
                $currencysymbol = '<span>' . esc_html( $settings['htmega_currency_symbol_custom'] ) . '</span>';
            }
        } ?>

        <div class="htmega-pt-flip-box__price">
            <div class="htmega-pt-flip-box__price-value">
                    <?php
                        if ($settings['htmega_offer_price'] == 'yes' && !empty($settings['htmega_original_price'])) {
                            if (!empty($settings['htmega_price'])) {
                                echo '<div class="ht-old-price">' . htmega_kses_title( $currencysymbol ) . htmega_kses_title($settings['htmega_original_price']) . '</div><div class="ht-new-price">' . wp_kses_post( $currencysymbol ) . htmega_kses_title($settings['htmega_price']) . '</div>';
                            }
                        } else {
                            if (!empty($settings['htmega_price'])) {
                                echo '<div class="ht-new-price">' . wp_kses_post( $currencysymbol ) . htmega_kses_title( $settings['htmega_price'] ) . '</div>';
                            }
                        }
                    ?>
            </div>
            
            <?php
                //Pricing Period
                if($settings['htmega_period']){
                    printf("<p class='htmega-pt-flip-box__price-status'>%s</p>", esc_html( $settings['htmega_period'] ) );
                }
            ?>
            
        </div>
    <?php }

    private function features_list_render($features_label, $features_list){
        //Features Label
        if($features_label){
            printf('<h4 class="htmega-pt-flip-box__heading">%1$s</h4>', esc_html($features_label));
        }

        //Features List
        if ($features_list) : ?>
            <div class="htmega-pt-flip-box__details">
                <ul>
                    <?php foreach ($features_list as $features):?>
                        <li class="elementor-repeater-item-<?php echo esc_attr($features['_id']); ?>">
                        
                            <?php
                                if (!empty($features['htmega_features_icon']['value'])) {
                                    echo HTMega_Icon_manager::render_icon($features['htmega_features_icon'], ['aria-hidden' => 'true']);
                                }
                                echo esc_html($features['htmega_features_title']);
                            ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; 
    }

    private function footer_section_render($button_text, $button_link){

        if ( ! empty( $button_link['url'] ) ) {
            $this->remove_render_attribute( 'htmega_button_link');
			$this->add_link_attributes( 'htmega_button_link', $button_link );
		}

        echo '<div class="htmega-pt-flip-box__footer">';    
            if($button_text){
                printf('<a class="htmega-pt-flip-box__priceing-plan" %1$s>%2$s</a>', $this->get_render_attribute_string( 'htmega_button_link' ), esc_html( $button_text ) );
            }
        echo '</div>';
    }


    private function get_currency_symbol($symbol_name)
    {
        $symbols = [
            'dollar'       => '&#36;',
            'baht'         => '&#3647;',
            'euro'         => '&#128;',
            'franc'        => '&#8355;',
            'guilder'      => '&fnof;',
            'indian_rupee' => '&#8377;',
            'krona'        => 'kr',
            'lira'         => '&#8356;',
            'peseta'       => '&#8359',
            'peso'         => '&#8369;',
            'pound'        => '&#163;',
            'real'         => 'R$',
            'ruble'        => '&#8381;',
            'rupee'        => '&#8360;',
            'shekel'       => '&#8362;',
            'won'          => '&#8361;',
            'yen'          => '&#165;',
        ];
        return isset($symbols[$symbol_name]) ? $symbols[$symbol_name] : '';
    }
}