<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Social_Network_Icons_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-social-network-icons-addons';
    }
    
    public function get_title() {
        return __( 'Social Network Icons', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-social-icons';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_style_depends() {
        return ['hover-animation'];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'social', 'social network', 'network','social media', 'media', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/social-network-widget/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Social Media', 'htmega-pro' ),
            ]
        );

            $repeater = new Repeater();

            $repeater->add_control(
                'social_title',
                [
                    'label' => esc_html__( 'Title', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Facebook', 'htmega-pro' ),
                    'placeholder' => esc_html__( 'Type your social media title here', 'htmega-pro' ),
                    'label_block'=>true,
                ]
            );

            $repeater->add_control(
                'social_link',
                [
                    'label' => esc_html__( 'Social Media Link', 'htmega-pro' ),
                    'type' => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'htmega-pro' ),
                    'show_external' => true,
                    'default' => [
                        'url' => 'https://facebook.com',
                        'is_external' => true,
                        'nofollow' => true,
                    ],
                ]
            );

            $repeater->add_control(
                'social_icon',
                [
                    'label' => esc_html__( 'Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fab fa-facebook-f',
                        'library' => 'fa-solid',
                    ],
                    'fa4compatibility' => 'socialicon',
                ]
            );

            $repeater->add_control(
                'individual_style',
                [
                    'label' => esc_html__( 'Individual Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'htmega-pro' ),
                    'label_off' => esc_html__( 'No', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $repeater->start_controls_tabs(
                'icon_individual_style_tab',
                [
                    'condition' => [
                        'individual_style' => 'yes'
                    ],
                ]
            );

                $repeater->start_controls_tab(
                    'icon_individual_style_normal',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    
                    $repeater->add_control(
                        'icon_ind_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-social-network-list-item{{CURRENT_ITEM}} a' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'icon_ind_bg_color',
                        [
                            'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-social-network-list-item{{CURRENT_ITEM}} a' => 'background-color: {{VALUE}}',
                            ],
                        ]
                    );

                    $repeater->add_responsive_control(
                        'ind_social_font_size',
                        [
                            'label' => esc_html__( 'Font Size', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-social-network-list .htmega-social-network-list-item{{CURRENT_ITEM}} a i' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-social-network-list .htmega-social-network-list-item{{CURRENT_ITEM}} a' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-social-network-list-item{{CURRENT_ITEM}} a .htmega-social-network-icon svg *' => 'fill: {{SIZE}}{{UNIT}};',
                            ],
                            'condition'=>[
                                'show_type'=>'icon',
                            ],
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_ind_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-social-network-list-item{{CURRENT_ITEM}}',
                        ]
                    );

                $repeater->end_controls_tab();

                $repeater->start_controls_tab(
                    'icon_individual_style_hover',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $repeater->add_control(
                        'icon_ind_hover_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-social-network-list-item{{CURRENT_ITEM}} a:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'icon_ind_hover_bg_color',
                        [
                            'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-social-network-list-item{{CURRENT_ITEM}} a:hover' => 'background-color: {{VALUE}}',
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'icon_ind_hover_border_color',
                        [
                            'label' => esc_html__( 'Border Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-social-network-list-item{{CURRENT_ITEM}} a:hover' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'hover_ind_animation',
                        [
                            'label' => esc_html__( 'Hover Animation', 'htmega-pro' ),
                            'type' => Controls_Manager::HOVER_ANIMATION,
                        ]
                    );

                $repeater->end_controls_tab();

            $repeater->end_controls_tabs();

            $this->add_control(
                'social_media_list',
                [
                    'label' => esc_html__( 'Social Media List', 'htmega-pro' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'social_title' => esc_html__( 'Facebook', 'htmega-pro' ),
                            'social_link' => ['url' => 'https://facebook.com/'],
                            'social_icon' =>[
                                'value' => 'fab fa-facebook-f',
                                'library' => 'fa-solid',
                            ],
                        ],
                        [
                            'social_title' => esc_html__( 'Twitter', 'htmega-pro' ),
                            'social_link' => ['url' => 'https://twitter.com/'],
                            'social_icon' =>[
                                'value' => 'fab fa-twitter',
                                'library' => 'fa-solid',
                            ],
                        ],
                        [
                            'social_title' => esc_html__( 'Instagram', 'htmega-pro' ),
                            'social_link' => ['url' => 'https://instagram.com/'],
                            'social_icon' =>[
                                'value' => 'fab fa-instagram',
                                'library' => 'fa-solid',
                            ],
                        ],
                       
                        [
                            'social_title' => esc_html__( 'Dribbble', 'htmega-pro' ),
                            'social_link' => ['url' => 'https://dribbble.com/'],
                            'social_icon' =>[
                                'value' => 'fab fa-dribbble',
                                'library' => 'fa-solid',
                            ],
                        ],
                        [
                            'social_title' => esc_html__( 'Behance', 'htmega-pro' ),
                            'social_link' => ['url' => 'https://www.behance.net'],
                            'social_icon' =>[
                                'value' => 'fab fa-behance',
                                'library' => 'fa-solid',
                            ],
                        ]
                    ],
                    'title_field' => '{{{ elementor.helpers.renderIcon( this, social_icon, {}, "i", "panel" ) || \'<i class="{{ social_icon.value }}" aria-hidden="true"></i>\' }}} {{{ social_title }}}',
                ]
            );

            $this->add_control(
                'additional_0ptions',
                [
                    'label' => esc_html__( 'Additional Options', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'content_alignment',
                [
                    'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'start' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'fa fa-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'fa fa-align-center',
                        ],
                        'end' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'fa fa-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-social-network-list' => 'justify-content: {{VALUE}};',
                    ],
                    'default' => 'center',
                ]
            );

            $this->add_responsive_control(
                'space_between',
                [
                    'label' => esc_html__( 'Space between', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                            'step' => 1,
                        ],
                    ],                        
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-social-network-list' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'show_type',
                [
                    'label' => esc_html__( 'Social Media Types', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'icon',
                    'options' => [
                        'text'  => esc_html__( 'Text', 'htmega-pro' ),
                        'icon' => esc_html__( 'Icon', 'htmega-pro' ),
                    ],
                ]
            );

        $this->end_controls_section();           

        // Style tab section
        $this->start_controls_section(
            'area_style',
            [
                'label' => esc_html__( 'Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


            $this->add_responsive_control(
                'social_width',
                [
                    'label' => esc_html__( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 65,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-social-network-list-item a' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition'=>[
                        'show_type'=>'icon',
                    ],
                ]
            );

            $this->add_responsive_control(
                'social_height',
                [
                    'label' => esc_html__( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 65,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-social-network-list-item a' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition'=>[
                        'show_type'=>'icon',
                    ],
                ]
            );

            $this->add_responsive_control(
                'social_font_size',
                [
                    'label' => esc_html__( 'Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-social-network-list li a i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-social-network-list-item a .htmega-social-network-icon svg,{{WRAPPER}} .htmega-social-network-list li a svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition'=>[
                        'show_type'=>'icon',
                    ],
                ]
            );
            $this->add_responsive_control(
                'social_normal_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-social-network-list li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'social_normal_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-social-network-list li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->start_controls_tabs('social_media_style_tabs');
                // Normal Tab
                $this->start_controls_tab(
                    'social_media_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                ); 
                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'social_media_typography',
                            'label' => esc_html__( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-social-network-list li a',
                            'condition'=>[
                                'show_type'=>'text',
                            ],
                        ]
                    );

                    $this->add_control(
                        'social_normal_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-social-network-list li a' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-social-network-list li a svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'social_normal_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-social-network-list-link',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'social_normal_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-social-network-list li a',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_normal_border_text',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-social-network-list li',
                            'condition'=>[
                                'show_type'=>'text',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_normal_border_icon',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-social-network-list li a',
                            'condition'=>[
                                'show_type'=>'icon',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'social_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-social-network-list li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-social-network-list li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                $this->end_controls_tab();

                // Hover Tab
                $this->start_controls_tab(
                    'social_media_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'social_hover_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-social-network-list li a:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'social_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-social-network-list li a:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'social_hover_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-social-network-list li a:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-social-network-list li:hover',
                            'condition'=>[
                                'show_type'=>'text',
                            ],
                        ]
                        
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_hover_border_icon',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-social-network-list li a:hover',
                            'condition'=>[
                                'show_type'=>'icon',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();


    }


    protected function render( $instance = [] ) {
        $settings = $this->get_settings_for_display();
        $social_media_list = $settings['social_media_list']; ?>

        <div class="htmega-social-network-list-wrap">
            <!-- Social network icons Start -->
            <div class="htmega-social-network-list-box">
                <ul class="htmega-social-network-list htmega-social-network-list-1">
              
                    <?php 
                    $countAnimation = 0;
                    if( !empty( $social_media_list ) && count( $social_media_list ) > 0 ) {
                    foreach($social_media_list as $social_media):
                        //Social Icon
                       if($social_media['social_icon']['library'] == 'svg'){
                            $iconImage = "<span class='htmega-social-network-icon'>". HTMega_Icon_manager::render_icon( $social_media['social_icon'], [ 'aria-hidden' => 'true' ] )."</span>";
                        }else{
                            $iconImage = HTMega_Icon_manager::render_icon( $social_media['social_icon'], [ 'aria-hidden' => 'true' ] );
                        }
                        
                        //Social Link
                        $this->add_link_attributes( $social_media['_id'], $social_media['social_link'] );
                        
                        $elementClass = 'htmega-social-network-list-link';

                        if ( $social_media['hover_ind_animation'] ) {
                            $elementClass .= ' elementor-animation-' . $social_media['hover_ind_animation'];
                        }
                           
                        $this->add_render_attribute( 'hoveranimation'.$social_media['_id'], 'class', esc_attr( $elementClass ) );
                    ?>
                        <li class="htmega-social-network-list-item elementor-repeater-item-<?php echo esc_attr($social_media['_id'])?>">
                            <a href="<?php echo esc_url( $social_media['social_link']['url'] ) ?>" <?php echo $this->get_render_attribute_string( $social_media['_id'] ) . $this->get_render_attribute_string( 'hoveranimation'.esc_attr( $social_media['_id'] ) ); ?>>
                                <?php if($settings['show_type'] == 'icon'){
                                    echo $iconImage;
                                }else{
                                    echo esc_html( $social_media['social_title'] );
                                }?>
                            </a>
                        </li>
                    <?php endforeach; 
                    
                    }
                    ?>


                </ul>
            </div>
        </div>
        <?php
    }

}