<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Sticky_Section_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-sticky-section-addons';
    }
    
    public function get_title() {
        return __( 'Sticky Section', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-filter';
    }
    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }
    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'sticky section', 'content sticky', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/';
	}

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'htmega-pro' ),
            ]
        );
            $this->add_control(
                'content_source',
                [
                    'label' => __( 'Content Source', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'custom',
                    'options' => [
                        'custom'    => __( 'Custom', 'htmega-pro' ),
                        "elementor" => __( 'Elementor Template', 'htmega-pro' ),
                    ],
                ]
            );

            $this->add_control(
                'template_id',
                [
                    'label' => __( 'Elementor Template', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '0',
                    'options'     => htmega_elementor_template(),
                    'condition'   => [
                        'content_source' => "elementor"
                    ],
                ]
            );

            $this->add_control(
                'custom_text',
                [
                    'label' => __( 'Description', 'htmega-pro' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'default'=>__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.','htmega-pro'),
                    'placeholder' => __( 'Enter your text', 'htmega-pro' ),
                    'condition' => [
                        'content_source' =>'custom',
                    ],
                ]
            );

            $this->add_responsive_control(
                'sticky_width',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => '%',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-sticky-section' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'sticky_offset',
                [
                    'label' => __( 'Offset', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 0,
                ]
            );
        $this->end_controls_section();

        // Style tab section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __( 'Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'sticky_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-sticky-section',
                    'condition' => [
                        'content_source' =>'custom',
                    ],
                ]
            );

            $this->add_control(
                'sticky_content_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-sticky-section' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'content_source' =>'custom',
                    ],
                ]
            );

            $this->add_control(
                'sticky_zindex',
                [
                    'label' => __( 'z-index', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 10000,
                    'step' => 1,
                    'default' => 999,
                    'selectors'   => array(
                        '{{WRAPPER}} .htmega-sticky-section' => 'z-index: {{VALUE}};',
                    ),
                ]
            );

            $this->add_control(
                'sticky_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-sticky-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'sticky_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-sticky-section',
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'sticky_box_shadow',
                    'label' => __( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-sticky-section',
                ]
            );


        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $id         = $this->get_id();
        $this->add_render_attribute( 'sticky_section', 'class', 'htmega-sticky-section' );
        $this->add_render_attribute( 'sticky_section', 'class', 'htmega-sticky-selector-'.$id );

        ?>
            <div <?php echo $this->get_render_attribute_string( 'sticky_section' ); ?>>
                <?php
                    if ( $settings['content_source'] == 'custom' && !empty( $settings['custom_text'] ) ) {
                        echo wp_kses_post( $settings['custom_text'] );
                    } elseif ( $settings['content_source'] == "elementor" && !empty( $settings['template_id'] )) {
                        echo htmega_get_template_content_by_id( $settings['template_id'] );
                    }
                ?>
            </div>

            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    'use strict';

                    var $stickyWrapperArea = $('.htmega-sticky-selector-<?php echo $id; ?>');
                    var $containerArea = $stickyWrapperArea.closest('.elementor-container, .elementor-row');
                    var totalOffset = $containerArea.offset().top + $containerArea.outerHeight();
                    var zindex = '<?php echo isset($settings['sticky_zindex']) ? esc_js( $settings['sticky_zindex'] ) : 1 ?>';
                    var offsetSetting = '<?php echo isset($settings['sticky_offset']) ? esc_js( $settings['sticky_offset'] ) : 0 ?>';

                    var HTMegaStickyToggler = function () {
                        var windowScroll = $(window).scrollTop();
                        var windowHeight = $(window).height();

                        if ( totalOffset <= windowScroll ) {
                            let sectionWidth = $stickyWrapperArea.parent().outerWidth();
                            $stickyWrapperArea.addClass('htmega-sticky-open');
                            $stickyWrapperArea.parent().css({'position':'fixed','z-index':esc_js( zindex ),'width':esc_js( sectionWidth )+'px'});
                            if ( $( '#wpadminbar' ) && 'fixed' === $( '#wpadminbar' ).css( 'position' ) ) {
                                var offset = $( '#wpadminbar' ).outerHeight( true );
                                offset = offset + parseInt(offsetSetting);
                                $stickyWrapperArea.parent().css( 'top', offset+'px' );
                            }else{
                                $stickyWrapperArea.parent().css( 'top', offsetSetting+'px' );
                            }
                        } else if ( totalOffset > windowScroll) {
                            $stickyWrapperArea.removeClass('htmega-sticky-open');
                            $stickyWrapperArea.parent().css({'position':'static','z-index':''});
                        }
                    };
                    HTMegaStickyToggler();
                    $(window).scroll(HTMegaStickyToggler);

                });
            </script>
        <?php

    }

}
