<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Taxonomy_Terms_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-taxonomy-terms-addons';
    }
    
    public function get_title() {
        return __( 'Taxonomy Terms', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-radio';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'taxonomy', 'terms', 'catagory','tag', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/taxonomy-terms-widget/';
	}

    protected function register_controls() {
        $this->start_controls_section(
			'post_quary_header',
			[
				'label' => esc_html__( 'Post Query', 'htmega-pro' ),
			]
		);

            $this->show_taxnomy_terms();

        $this->end_controls_section();

        // Additional Option
        $this->start_controls_section(
            'additional_option_section',
            [
                'label' => esc_html__( 'Additional Options', 'htmega-pro' ),
            ]
        );

            $this->add_responsive_control(
                'item_display',
                [
                    'label' => esc_html__( 'Item Display Style', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'toggle' => false,
                    'options' => [
                        'horizontal' => [
                            'title' => esc_html__( 'Horizontal', 'htmega-pro' ),
                            'icon' => 'eicon-bullet-list',
                        ],
                        'vertical' => [
                            'title' => esc_html__( 'Vertical', 'htmega-pro' ),
                            'icon' => 'eicon-form-vertical',
                        ],
                    ],
                    'default' => 'horizontal',
                ]
            );

            $this->add_responsive_control(
                'item_alignment',
                [
                    'label'     => esc_html__('Alignment', 'htmega-pro'),
                    'type'      => Controls_Manager::CHOOSE,
                    'options'   => [
                        'left'   => [
                            'title' => esc_html__('Left', 'htmega-pro'),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__('Center', 'htmega-pro'),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right'  => [
                            'title' => esc_html__('Right', 'htmega-pro'),
                            'icon'  => 'eicon-text-align-right',
                        ],
                    ],
                    'default'   => 'center',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-box' => 'text-align: {{VALUE}};',
                    ],
                    'condition' => [
                        'item_display' => 'horizontal',
                    ],
                ]
            );

            $this->add_responsive_control(
                'section_width',
                [
                    'label' => esc_html__( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 150,
                            'max' => 1400,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-box .htmega-taxonomy-terms-3' => 'max-width: {{SIZE}}{{UNIT}}',
                    ],
                    'condition' => [
                        'item_display' => 'horizontal',
                    ],
                ]
            );

            $this->add_control(
                'title_specing',
                [
                    'label' => esc_html__( 'Title Spacing', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 200,
                        ],
                    ],
                    'default' => [
                        'size' => 8,
                    ],
                    'condition' => [
                        'item_display' => 'vertical',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-1 .htmega-taxonomy-terms-item-image'  => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'global_options',
                [
                    'label' => esc_html__( 'Global', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'icon_type_global',
                [
                    'label' => esc_html__( 'Icon Type', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'icon' => [
                            'title' => esc_html__( 'Icon', 'htmega-pro' ),
                            'icon' => 'eicon-editor-italic',
                        ],
                        'image' => [
                            'title' => esc_html__( 'Image', 'htmega-pro' ),
                            'icon' => 'eicon-image',
                        ],
                    ],
                    'default'=>'icon',
                    'toggle' => false,
                ]
            );

            $this->add_control(
                'term_icon_global',
                [
                    'label'       => esc_html__( 'Icon', 'htmega-pro' ),
                    'type'        => Controls_Manager::ICONS,
                    'label_block' => true,
                    'condition'=>[
                        'icon_type_global'=>'icon'
                    ]
                ]
            );

            $this->add_control(
                'term_icon_image_global',
                [
                    'label' => esc_html__( 'Icon Image', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'condition'=>[
                        'icon_type_global'=>'image'
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'term_icon_image_size_global',
                    'label' => esc_html__( 'Icon And Image List', 'htmega-pro' ),
                    'default' => 'large',
                    'separator' => 'none',
                    'condition'=>[
                        'term_icon_image_global[url]!'=>'',
                        'icon_type_global'=>'image',
                    ]
                ]
            );

            $this->add_control(
                'icon_specing',
                [
                    'label' => esc_html__( 'Icon Spacing', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 150,
                        ],
                    ],
                    'default' => [
                        'size' => 8,
                    ],
                    'condition' => [
                        'item_display' => 'horizontal',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link .terms-svg-icon'  => 'margin-right: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link i, {{WRAPPER}} .htmega-taxonomy-terms-item-link svg' => 'margin-right: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link .htmega-terms-image' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );


            $this->add_control(
                'individual_options',
                [
                    'label' => esc_html__( 'Individual', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'add_custom_term_icon',
                [
                    'label' => esc_html__( 'Custom Terms Icon or Image', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'htmega-pro' ),
                    'label_off' => esc_html__( 'No', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'after',
                ]
            );

            $repeater = new Repeater();

            $repeater->add_control(
                'term_id',
                [
                    'label' => esc_html__( 'Terms items ID', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );

            $repeater->add_control(
                'icon_type',
                [
                    'label' => esc_html__( 'Icon Type', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'icon' => [
                            'title' => esc_html__( 'Icon', 'htmega-pro' ),
                            'icon' => 'eicon-editor-italic',
                        ],
                        'image' => [
                            'title' => esc_html__( 'Image', 'htmega-pro' ),
                            'icon' => 'eicon-image',
                        ],
                    ],
                    'default'=>'icon',
                    'toggle' => false,
                ]
            );

            $repeater->add_control(
                'term_icon',
                [
                    'label'       => esc_html__( 'Icon', 'htmega-pro' ),
                    'type'        => Controls_Manager::ICONS,
                    'label_block' => true,
                    'condition'   =>[
                        'icon_type'=>'icon'
                    ]
                ]
            );

            $repeater->add_control(
                'term_icon_image',
                [
                    'label' => esc_html__( 'Icon Image', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'condition'=>[
                        'icon_type'=>'image'
                    ]
                ]
            );

            $repeater->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'term_icon_image_size',
                    'label' => esc_html__( 'Icon And Image List', 'htmega-pro' ),
                    'default' => 'large',
                    'separator' => 'none',
                    'condition'=>[
                        'term_icon_image[url]!'=>'',
                        'icon_type'=>'image',
                    ]
                ]
            );

            $this->add_control(
                'custom_iconimage_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'select_menu' => '',
                        ]
                    ],
                    'title_field' => '{{{ term_id }}}',
                    'condition' => [
                        'add_custom_term_icon' => 'yes',
                    ],
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_text_style',
            [
                'label' => esc_html__( 'Terms Item', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
            $this->start_controls_tabs('terms_style_tabs');
        
            //Terms Normal tab Start
            $this->start_controls_tab(
                'terms_style_normal_tab',
                [
                    'label' => esc_html__( 'Normal', 'htmega-pro' ),
                ]
            );
                $this->add_control(
                    'htmega_terms_text_color',
                    [
                        'label'     => esc_html__( 'Text Color', 'htmega-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-link' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-link .htmega-taxonomy-terms-item-title' => 'color: {{VALUE}};',
                        ],
                    ]
                );
        
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'terms_background',
                        'label' => esc_html__( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-link',
                    ]
                );
        
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'terms_typography',
                        'label' => esc_html__( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-link .htmega-taxonomy-terms-item-title',
                    ]
                );
        
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'terms_border',
                        'label' => esc_html__( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-link',
                        'condition' => [
                            'item_display' => 'horizontal',
                        ],
                    ]
                );
                
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'vertical_terms_border',
                        'label' => esc_html__( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-image',
                        'condition' => [
                            'item_display' => 'vertical',
                        ],
                    ]
                );
        
                $this->add_responsive_control(
                    'terms_border_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-link, {{WRAPPER}} .htmega-taxonomy-terms-item-link::before' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-image, {{WRAPPER}} .htmega-taxonomy-terms-item-image::before' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );
        
                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name' => 'horizontal_box_shadow',
                        'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-link',
                        'separator' => 'before',
                        'condition' => [
                            'item_display' => 'horizontal',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name' => 'vertical_box_shadow',
                        'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-image',
                        'separator' => 'before',
                        'condition' => [
                            'item_display' => 'vertical',
                        ],
                    ]
                );
        
                $this->add_responsive_control(
                    'terms_padding',
                    [
                        'label' => esc_html__( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                        ],
                        'separator' => 'before',
                    ]
                );
        
                $this->add_responsive_control(
                    'terms_margin',
                    [
                        'label' => esc_html__( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'separator' => 'before',
                    ]
                );
            $this->end_controls_tab(); // terms Normal tab end
        
            // terms Hover tab start
            $this->start_controls_tab(
                'terms_style_hover_tab',
                [
                    'label' => esc_html__( 'Hover', 'htmega-pro' ),
                ]
            );
        
                $this->add_control(
                    'htmega_terms_hover_text_color',
                    [
                        'label'     => esc_html__( 'Text Color', 'htmega-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover' => 'color: {{VALUE}};',
                            '{{WRAPPER}} a.htmega-taxonomy-terms-item-link:hover h3.htmega-taxonomy-terms-item-title' => 'color: {{VALUE}};',
                        ],
                    ]
                );
        
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'terms_hover_background',
                        'label' => esc_html__( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover,{{WRAPPER}} .htmega-taxonomy-terms-item-link::before',
                    ]
                );

                $this->add_control(
                    'htmega_terms_hover_background_overlay_color',
                    [
                        'label'     => esc_html__( 'Background Overlay', 'htmega-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-link::before' => 'background-color: {{VALUE}};',
                        ],
                    ]
                );
        
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'horizontal_terms_hover_border',
                        'label' => esc_html__( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover',
                        'condition' => [
                            'item_display' => 'horizontal',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'vertical_terms_hover_border',
                        'label' => esc_html__( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-image:hover',
                        'condition' => [
                            'item_display' => 'vertical',
                        ],
                    ]
                );
        
                $this->add_responsive_control(
                    'terms_hover_border_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover, {{WRAPPER}} .htmega-taxonomy-terms-item-link:hover:before' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            '{{WRAPPER}} .htmega-taxonomy-terms-item-image:hover, {{WRAPPER}} .htmega-taxonomy-terms-item-link:hover:before' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );
        
                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name' => 'horizontal_boxhover_shadow',
                        'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover',
                        'separator' => 'before',
                        'condition' => [
                            'item_display' => 'horizontal',
                        ],
                    ]
                );   

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name' => 'vertical_boxhover_shadow',
                        'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-image:hover',
                        'separator' => 'before',
                        'condition' => [
                            'item_display' => 'vertical',
                        ],
                    ]
                );  
                
                $this->add_control(
                    'htmega_terms_after_color',
                    [
                        'label'     => esc_html__( 'Border Color', 'htmega-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-taxonomy-terms-3 .htmega-taxonomy-terms-item-link::after' => 'background-color: {{VALUE}};',
                        ],
                    ]
                );
        
            $this->end_controls_tab(); // terms Hover tab end
        
        $this->end_controls_tabs();
        
        $this->end_controls_section();


        $this->start_controls_section(
            'section_number_count',
            [
                'label' => esc_html__( 'Number Count', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'item_display' => 'vertical',
                ],
            ]
        );
            $this->add_control(
                'terms_number_box_size',
                [
                    'label' => esc_html__( 'Number Box Size', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 300,
                        ],
                    ],
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-1 .htmega-taxonomy-terms-item-number'  => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'terms_number_position_vertical',
                [
                    'label' => esc_html__( 'Position Vertical', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 300,
                            'min'=> -300
                        ],
                    ],
                    'default' => [
                        'size' => 0,
                    ],
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-1 .htmega-taxonomy-terms-item-number'  => 'top: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'terms_number_position_horizontal',
                [
                    'label' => esc_html__( 'Position Horizontal', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 300,
                            'min'=> -300
                        ],
                    ],
                    'default' => [
                        'size' => 0,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-1 .htmega-taxonomy-terms-item-number'  => 'left: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'terms_number_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-item-link .htmega-taxonomy-terms-item-number',
                    'separator' => 'before',
                ]
            );
            
            $this->add_control(
                'htmega_terms_number_color',
                [
                    'label'     => esc_html__( 'Number Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-wrap .htmega-taxonomy-terms-item-number' => 'color: {{VALUE}};',
                    ],
                    
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'htmega_terms_number_bg_color',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-wrap .htmega-taxonomy-terms-item-number',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'htmega_terms_number_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-wrap .htmega-taxonomy-terms-item-number',
                ]
            );

            $this->add_responsive_control(
                'htmega_terms_number_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-wrap .htmega-taxonomy-terms-item-number' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'htmega_terms_number_box_shadow',
                    'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-wrap .htmega-taxonomy-terms-item-number',
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => esc_html__( 'Icon', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
            $this->add_control(
                'icon_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link svg path' => 'fill: {{VALUE}};',
                        '{{WRAPPER}} .terms-svg-icon svg path'	=> 'stroke: {{VALUE}}; fill: {{VALUE}};',
                    ],
                ]
            );
        
            $this->add_control(
                'icon_color_hover',
                [
                    'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover svg path' => 'fill: {{VALUE}};',
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover .terms-svg-icon svg path' => 'stroke: {{VALUE}}; fill: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'icon_stroke_color',
                [
                    'label' => esc_html__( 'Stroke Svg', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'stroke_icon_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link i' => 'stroke: {{VALUE}};',
                        '{{WRAPPER}} .terms-svg-icon svg path, {{WRAPPER}} .htmega-taxonomy-terms-item-link svg path'	=> 'stroke: {{VALUE}};',
                    ],
                ]
            );
        
            $this->add_control(
                'stroke_icon_color_hover',
                [
                    'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover i' => 'stroke: {{VALUE}}',
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link:hover .terms-svg-icon svg path, {{WRAPPER}} .htmega-taxonomy-terms-item-link:hover svg path' => 'stroke: {{VALUE}};',
                    ],
                ]
            );
        
            $this->add_responsive_control(
                'icon_size',
                [
                    'label' => esc_html__( 'Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 10,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .terms-svg-icon svg,{{WRAPPER}} .htmega-taxonomy-terms-item-link svg' => 'width: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-taxonomy-terms-item-link i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'htmega_terms_image_bg_heading',
                [
                    'label' => esc_html__( 'Image Background', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'item_display' => 'vertical',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'terms_image_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-taxonomy-terms-wrap .htmega-taxonomy-terms-item-image',
                    'condition' => [
                        'item_display' => 'vertical',
                    ],
                ]
            );
        
        $this->end_controls_section();

    }


    protected function render( $instance = [] ) {
        $settings = $this->get_settings_for_display();
        $post_type =  isset( $settings['select_post_type'] ) ? $settings['select_post_type'] : 'post';

        $terms = get_terms( $settings[ $post_type.'_select_taxonomy'] );
        $excludeTerms = $settings['exclude_select_terms'];

        $excludeTermsList = explode(',',$excludeTerms);
        $excludeTermsListCount = count($excludeTermsList);


        $customIconImageList = $settings['custom_iconimage_list'];
        $termsIcons = ""; ?>

      <div class="htmega-taxonomy-terms-wrap">
            <div class="htmega-taxonomy-terms-box">
                <ul class="htmega-taxonomy-terms <?php echo esc_attr($settings['item_display'] == 'vertical') ? 'htmega-taxonomy-terms-1':'htmega-taxonomy-terms-3' ?>">
                    
                    <?php if(!empty($terms) && !is_wp_error( $terms )){

                        foreach( $terms as $term ): 

                            // Global Icon And Image Manage
                            if( $settings['icon_type_global'] === 'icon' ){

                                if($settings['term_icon_global']['library'] == 'svg'){
                                    $termsIcons = "<div class='terms-svg-icon'>". HTMega_Icon_manager::render_icon( $settings['term_icon_global'], [ 'aria-hidden' => 'true' ] )."</div>";
                                }else{
                                    $termsIcons = "<div class='htmega-terms-list-icon'>".HTMega_Icon_manager::render_icon( $settings['term_icon_global'], [ 'aria-hidden' => 'true' ] )."</div>";
                                }
                            }elseif( $settings['icon_type_global'] === 'image' ){
                                $termsIcons = ( !empty( $settings['term_icon_image_global']['url'] ) ? "<div class='htmega-terms-image '".$this->get_render_attribute_string( 'icon_attr' ).">". Group_Control_Image_Size::get_attachment_image_html( $settings, 'term_icon_image_size_global', 'term_icon_image_global' ).'</div>' : '' );
                            }


                            // individual Icon and Image Manage
                            if($settings['add_custom_term_icon'] == 'yes'){
                                foreach($customIconImageList as $customIconImage){

                                   if($customIconImage['term_id'] == $term->term_id){
                                        if( $customIconImage['icon_type'] === 'icon' ){

                                            if($customIconImage['term_icon']['library'] == 'svg'){
                                                $termsIcons = "<div class='terms-svg-icon'>". HTMega_Icon_manager::render_icon( $customIconImage['term_icon'], [ 'aria-hidden' => 'true' ] )."</div>";
                                            }else{
                                                $termsIcons = "<div class='htmega-terms-list-icon'>".HTMega_Icon_manager::render_icon( $customIconImage['term_icon'], [ 'aria-hidden' => 'true' ] )."</div>";
                                            }
                                        }elseif( $customIconImage['icon_type'] === 'image' ){
                                            $termsIcons = ( !empty( $customIconImage['term_icon_image']['url'] ) ? "<div class='htmega-terms-image '".$this->get_render_attribute_string( 'icon_attr' ).">". Group_Control_Image_Size::get_attachment_image_html( $customIconImage, 'term_icon_image_size', 'term_icon_image' ).'</div>' : '' );
                                        }
                                        break;
                                   }
                                }
                            }
                            
                            //Exclude Terms List
                            $excludeTermsListCheck = false;
                            for($i = 0; $i < $excludeTermsListCount; $i++ ){
                                $excludeTermsListCheck = $excludeTermsList[$i] == $term->slug;
                                if( $excludeTermsListCheck == '1' ){
                                    break;
                                }
                            }

                            if( $excludeTermsListCheck != '1' ):
                            
                                if($settings['item_display'] == 'horizontal'): ?>

                                    <li class="htmega-taxonomy-terms-item">
                                        <a href="<?php echo get_category_link($term->term_id) ?>" class="htmega-taxonomy-terms-item-link">
                                            <div class="htmega-taxonomy-terms-item-content">
                                                <?php echo $termsIcons;  $termsIcons = ""; ?>
                                                <h3 class="htmega-taxonomy-terms-item-title"><?php echo esc_html( $term->name) ?></h3>

                                            </div>
                                            <span class="htmega-taxonomy-terms-item-number"><?php echo esc_html( $term->count) ?></span>
                                        </a>
                                    </li>

                                <?php elseif($settings['item_display'] == 'vertical'):?>
                                    
                                    <li class="htmega-taxonomy-terms-item">
                                        <a href="<?php echo get_category_link($term->term_id) ?>" class="htmega-taxonomy-terms-item-link">
                                            <div class="htmega-taxonomy-terms-item-content">
                                                <div class="htmega-taxonomy-terms-item-image">
                                                    <?php echo $termsIcons;  $termsIcons = ""; ?>
                                                </div>
                                                <h3 class="htmega-taxonomy-terms-item-title"><?php echo esc_html( $term->name ) ?></h3>
                                            </div>
                                            <span class="htmega-taxonomy-terms-item-number"><?php echo esc_html( $term->count ) ?></span>
                                        </a>
                                    </li>

                        <?php   
                                endif;
                            endif;
                            
                        endforeach;
                    }else{?>
                        <h3 class="not_found_message"><?php echo esc_html__( 'Taxonomy Terms Not Found', 'htmega-pro' ) ?></h3>
                    <?php } ?>
                </ul>
            </div><!-- Taxonomy Terms End  -->
        </div>
        <!-- Taxonomy Terms Style 3 End -->  
<?php
    }

    public function show_taxnomy_terms(){

        $this->add_control(
			'select_post_type',
			[
				'label' => esc_html__( 'Content Source', 'htmega-pro' ),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
                'show_label' => true,
                'multiple' => false,
				'options' => htmega_get_terms_post_types(),
				'default' => 'post',
			]
		);

        $texnomy_list = htmega_get_terms_post_types();       
        foreach($texnomy_list as $texnomykey => $texnomyValue){
            
            $this->add_control(
                "{$texnomykey}_select_taxonomy",
                [
                    'label' => esc_html__( 'Select Taxonomy', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'options' => get_taxonomie_by_post_type($texnomykey),
                    'condition' => [
						'select_post_type' => $texnomykey,
					],
                ]
            );
            
        }

        $this->add_control(
            "exclude_select_terms",
            [
                'label' => esc_html__( 'Exclude Terms', 'htmega-pro' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__( 'Example: cat1, cat2', 'htmega-pro' ),
                'description' => esc_html__( 'TO Exclude, Enter Comma Separated Term Slugs', 'htmega-pro' ),
            ]
        );
        
    }

}