<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Video_Playlist_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-video-playlist-addons';
    }
    
    public function get_title() {
        return __( 'Video Playlist', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-video-playlist';
    }

    public function get_categories() {
        return [ 'htmega-pro' ];
    }

    public function get_style_depends() {
        return [
            'htmega-unitegallery',
        ];
    }
    public function get_script_depends() {
        return [
            'htmega-unitegallery',
            'htmega-ug-theme-video'
        ];
	}
    public function get_keywords() {
        return ['video playlist', 'youtube playlist','video popup', 'youtube gallery', 'vimeo playlist', 'vimeo gallery', 'video carousel', 'video list', 'htmega', 'ht mega'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs/';
    }
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        // Video Layout
        $this->start_controls_section(
            'video_playlist_layout_section',
            [
                'label' => esc_html__( 'Layout', 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'video_playlist_layout',
            [
                'label'   => __( 'Layout', 'htmega-pro' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'right-thumb',
                'options' => [
                    'right-thumb'      => __( 'Default', 'htmega-pro' ),
                    'right-no-thumb'   => __( 'Title & Description', 'htmega-pro' ),
                    'right-title-only' => __( 'Only Title', 'htmega-pro' ),
                ],
                
            ]
        );

        $this->add_control(
            'gallery_height',
            [
                'label'       => __('Gallery Height', 'htmega-pro'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 500,
                'selectors' => [
                    '{{WRAPPER}} .ug-strip-panel' => 'height: {{VALUE}}px!important',
                ],
            ]
        );
        $this->add_control(
            'video_autoplay',
            [
                'label' => esc_html__( 'Video Autoplay', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'video_autoplay_next',
            [
                'label' => esc_html__( 'Autoplay Next Video', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'description' => __( 'The next video plays automatically once the current one ends.', 'htmega-pro')
            ]
        );
        $this->add_control(
            'navigation_buttons',
            [
                'label' => esc_html__( 'Navigation Buttons', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'mouse_hover_navigation',
            [
                'label' => esc_html__( 'Mouse Hover Navigation', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Video List', 'htmega-pro' ),
            ]
        );
            $repeater = new Repeater();

                $repeater->add_control(
                    'video_type',
                    [
                        'label' =>esc_html__( 'Video Source', 'htmega-pro' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'youtube',
                        'options' => [
                            'youtube'    => esc_html__( 'YouTube', 'htmega-pro' ),
                            'vimeo'      => esc_html__( 'Vimeo', 'htmega-pro' ),
                            'wistia'      => esc_html__( 'Wistia', 'htmega-pro' ),
                            'selfhosted' => esc_html__( 'Self Hosted', 'htmega-pro' )
                        ],
                    ]
                );
                
                $repeater->add_control(
                    'video_id',
                    [
                        'label'          => esc_html__( 'Video ID', 'htmega-pro' ),
                        'type'           => Controls_Manager::TEXT,
                        'default'    => esc_attr('XHOmBV4js_E'),
                        'dynamic'        => [
                            'active'     => true,
                        ],
                        'condition'      => [
                            'video_type' => ['youtube','vimeo','wistia']
                        ]
                    ]
                );

                $repeater->add_control(
                    'self_hosted_video',
                    [
                        'label' => esc_html__( 'Upload Video', 'htmega-pro' ),
                        'type' => Controls_Manager::MEDIA,
                        'media_type' => 'video',
                        'condition'      => [
                            'video_type' => 'selfhosted'
                        ]
                    ]
                );
                $repeater->add_control(
                    'video_title',
                    [
                        'label' =>esc_html__( 'Video Title', 'htmega-pro' ),
                        'type' => Controls_Manager::TEXT,
                        'label_block' => true,
                        'dynamic' => [
                            'active' => true,
                        ],
                    ]
                );
                $repeater->add_control(
                    'video_des',
                    [
                        'label' =>esc_html__( 'Video Description', 'htmega-pro' ),
                        'type' => Controls_Manager::TEXT,
                        'dynamic' => [
                            'active' => true,
                        ],
                        'label_block' => true,
                    ]
                );
                $repeater->add_control(
                    'video_thumbnail',
                    [
                        'label' => esc_html__( 'Custom Thumbnail', 'htmega-pro' ),
                        'type' => Controls_Manager::MEDIA,
                        'dynamic' => [
                            'active' => true,
                        ],
                    ]
                );


            $this->add_control(
                'item_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'video_title' => esc_html__( 'Video Title One', 'htmega-pro' ),
                            'video_type'  => 'youtube',
                            'video_id' => 'z_9Z9VWhaEQ',
                        ],
                        [
                            'video_title' => esc_html__( 'Video Title Two', 'htmega-pro' ),
                            'video_type'  => 'youtube',
                            'video_id' => 'XHOmBV4js_E',
                        ],
                        [
                            'video_title' => esc_html__( 'Video Title Three', 'htmega-pro' ),
                            'video_type'  => 'youtube',
                            'video_id' => 'z_9Z9VWhaEQ',
                        ]
                    ],
                    'title_field' => '{{video_title}}',
                ]
            );

        $this->end_controls_section();
        // content section end
        // Video List panle style section
        $this->start_controls_section(
            'video_list_panel_style',
            [
                'label' => esc_html__( 'Video List Panel', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'video_list_panel_width',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 80,
                            'max' => 500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .ug-thumb-wrapper' => 'max-width:{{SIZE}}px;',
                    ],
                ]
            );

            $this->add_control(
                'video_list_panel_background',
                [
                    'label' => __( 'Backgorund Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .ug-strip-panel' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'video_list_panel_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .ug-strip-panel',
                ]
            );

            $this->add_responsive_control(
                'video_list_panel_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .ug-strip-panel' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_control(
                'video_list_panel_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'default' => [
                        'top' => 10,
                        'right' => 10,
                        'bottom' => 10,
                        'left' => 10,
                    ],
                ]
            );
        $this->end_controls_section();
        // item style end
        // Video Item style section
        $this->start_controls_section(
            'video_item',
            [
                'label' => esc_html__( 'Video Item', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'video_item_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'default' => [
                        'top' => 10,
                        'right' => 10,
                        'bottom' => 10,
                        'left' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .ug-thumb-wrapper' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px; height:auto;',
                        '{{WRAPPER}} .ug-thumb-inner' => 'padding:0;display:flex;',
                        '{{WRAPPER}} .htmega-video-playlist-right-no-thumb .ug-thumb-inner' => 'padding:0;display:block;',
                    ],
                ]
            );
            $this->add_control(
                'video_item_gap',
                [
                    'label' => __( 'Item Gap', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                ]
            );

            $this->start_controls_tabs('video_item_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'box_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                $this->add_control(
                    'video_item_background',
                    [
                        'label' => __( 'Backgorund Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '',
                        'selectors' => [
                            '{{WRAPPER}} .ug-thumb-wrapper' => 'background: {{VALUE}};',
                        ],
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .ug-thumb-wrapper',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ug-thumb-wrapper' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();

                // Video Hover Style Tab
                $this->start_controls_tab(
                    'video_item_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'video_item_background_hover',
                        [
                            'label' => __( 'Backgorund Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .ug-thumb-wrapper:hover' => 'background: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_normal_border_hover',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .ug-thumb-wrapper:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_normal_border_radius_hover',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ug-thumb-wrapper:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();
                // Video Active Style Tab
                $this->start_controls_tab(
                    'video_item_active_style_tab',
                    [
                        'label' => esc_html__( 'Active', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'video_item_background_active',
                        [
                            'label' => __( 'Backgorund Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .ug-thumb-wrapper.ug-thumb-selected' => 'background: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_normal_border_active',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .ug-thumb-wrapper.ug-thumb-selected',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_normal_border_radius_active',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ug-thumb-wrapper.ug-thumb-selected' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();
        // item style end


        // Thumbnail Style
        $this->start_controls_section(
            'thumbnials_style_section',
            [
                'label' => esc_html__( 'Thumbnails', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'video_playlist_layout' =>'right-thumb'
                ]
            ]
        );
            $this->add_control(
                'thumbnial_right_space',
                [
                    'label' => __( 'Space From Title', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .ug-thumb-right' => 'padding-left: {{SIZE}}px;',
                        '{{WRAPPER}} .ug-thumb-icon' => 'flex:none;',
                    ],
                ]
            );
            $this->add_control(
                'thumbnial_height',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .ug-thumb-icon' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'thumbnial_width',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .ug-thumb-icon' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->start_controls_tabs('thumbnial_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'thumbnial_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'thumbnial_box_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .ug-thumb-icon',
                        ]
                    );

                    $this->add_responsive_control(
                        'thumbnial_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ug-thumb-icon' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'thumbnial_active_style_tab',
                    [
                        'label' => esc_html__( 'Active', 'htmega-pro' ),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'thumbnial_active_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .ug-thumb-selected .ug-thumb-icon',
                        ]
                    );

                    $this->add_responsive_control(
                        'thumbnial_active_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ug-thumb-selected .ug-thumb-icon' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();
        // Thumbnail

        // Title Style
        $this->start_controls_section(
			'video_title_section',
			[
				'label' => esc_html__( 'Title', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

            $this->add_control(
                'video_title_color',
                [
                    'label'  => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .ug-thumb-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
                
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'video_title_typography',
                    'selector' => '{{WRAPPER}} .ug-thumb-title',
                ]
            );
            $this->add_responsive_control(
                'video_title_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .ug-thumb-title' => 'margin: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
		$this->end_controls_section();

        // Description Style
        $this->start_controls_section(
            'video_description_section',
            [
                'label' => esc_html__( 'Description', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'video_playlist_layout!' =>'right-title-only'
                ]
            ]
        );
    
            $this->add_control(
                'video_description_color',
                [
                    'label'  => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .ug-thumb-desc' => 'color: {{VALUE}}',
                    ],
                ]
            );
                
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'video_description_typography',
                    'selector' => '{{WRAPPER}} .ug-thumb-desc',
                ]
            );
    
        $this->end_controls_section();

        // Video Player section
        $this->start_controls_section(
            'video_player_style',
            [
                'label' => esc_html__( 'Video Player', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'video_player_background',
                [
                    'label' => __( 'Backgorund Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .ug-videoplayer' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'video_player_panel_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .ug-videoplayer',
                ]
            );

            $this->add_responsive_control(
                'video_player_panel_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .ug-videoplayer' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px; overflow:hidden;',
                    ],
                ]
            );
            $this->add_control(
                'video_player_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .ug-videoplayer' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
        $this->end_controls_section();
        // item style end
    }

    protected function render( $instance = [] ) {
        $settings  = $this->get_settings_for_display();
        $items     = $this->get_settings_for_display('item_list');
        $sectionid = $this->get_id();

        $slider_settings = [
            'sectionid'                   => esc_attr( $sectionid ),
            'video_playlist_layout'       => esc_attr( $settings['video_playlist_layout'] ),
            'gallery_height'              => isset( $settings['gallery_height']) ? esc_attr( $settings['gallery_height'] ) : '',
            'video_autoplay'              => ( 'yes' === $settings['video_autoplay'] ),
            'video_autoplay_next'         => ( 'yes' === $settings['video_autoplay_next'] ),
            'mouse_hover_navigation'      => ( 'yes' === $settings['mouse_hover_navigation'] ),
            'navigation_buttons'          => ( 'yes' === $settings['navigation_buttons'] ),
            'video_list_panel_padding'    => $settings['video_list_panel_padding'],
            'video_list_panel_background' => isset( $settings['video_list_panel_background'] ) ? $settings['video_list_panel_background'] : '',
            'video_item_gap' => $settings['video_item_gap'],
        ];
        $this->add_render_attribute( 'area_attr', 'class', 'htmega-video-playlist-wrapper htmega-video-playlist-' . esc_attr( $settings['video_playlist_layout'] ) );
        $this->add_render_attribute( 'area_attr', 'id', 'htmega-video-playlist-' . esc_attr( $sectionid ) );
        $this->add_render_attribute( 'area_attr', 'data-settings', wp_json_encode( $slider_settings ) );
        $this->add_render_attribute( 'area_attr', 'style', 'display:none;' );

        ?>

        <div <?php echo $this->get_render_attribute_string( 'area_attr' ); ?> >
        <?php
        if( $items ) { 
            foreach( $items as $item ) {
                // default thumbnail
                $thumbnailUrl = HTMEGA_ADDONS_PL_URL.'assets/images/image-placeholder.png';

                //for youtube video 
                if ( $item['video_type'] === 'youtube' ) {
                    if ( !empty( $item['video_thumbnail']['url'] ) ) {
                        $thumbnailUrl = esc_url( $item['video_thumbnail']['url'] );
                    } else {
                        $thumbnailUrl ="https://img.youtube.com/vi/" . $item['video_id'] . "/mqdefault.jpg";
                    }
                    echo '<img alt="' . esc_attr($item['video_title']) . '"
                    src="' . esc_url( $thumbnailUrl ) . '"
                    data-type="youtube"
                    data-videoid="' . esc_attr($item['video_id']) . '"
                    data-description="' . esc_attr($item['video_des']) . '">';
        
                } elseif ( $item['video_type'] === 'vimeo' ) { //for vimeo video 
                    if ( !empty( $item['video_thumbnail']['url'] ) ) {
                        $thumbnailUrl = esc_url( $item['video_thumbnail']['url'] );
                    } else {
                        $vimeoVideoUrl = "https://vimeo.com/" . $item['video_id'];
                        $encodedUrl = urlencode($vimeoVideoUrl);
                        $oembedApiUrl = "https://vimeo.com/api/oembed.json?url={$encodedUrl}";
                        
                        $response = htmega_get_remote_file_data($oembedApiUrl);
                        if ( $response !== false ) {
                            $data = json_decode($response, true);
                            $thumbnailUrl = $data['thumbnail_url'];
                            $newWidth = 1280;
                            $newHeight = 720;
                            $thumbnailUrl = preg_replace('/(\d+)x(\d+)/', "{$newWidth}x{$newHeight}", $thumbnailUrl);
                        }

                    }

                    echo '<img alt="' . esc_attr( $item['video_title'] ) . '"
                    data-type="vimeo"
                    src="' . esc_url( $thumbnailUrl ) . '"
                    data-image="' . esc_url( $thumbnailUrl ) . '"
                    data-videoid="' . esc_attr( $item['video_id'] ) . '"
                    data-description="' . esc_attr( $item['video_des'] ) . '">';
        
                } elseif ( $item['video_type'] == 'selfhosted' ) { //for selfhosted video
                    if ( !empty( $item['video_thumbnail']['url'] ) ) {
                        $thumbnailUrl = esc_url( $item['video_thumbnail']['url'] );
                    } else {
                        $thumbnailUrl = HTMEGA_ADDONS_PL_URL.'assets/images/image-placeholder.png';
                    }
                    if ( !empty( $item['self_hosted_video']['url'] ) ) {
                        $videoUrl = $item['self_hosted_video']['url'];
                        $data_self_hosted = '';
                        // check video type from url $videoUrl
                        if ( strpos($videoUrl, '.mp4') !== false ) {
                            $data_self_hosted = 'data-videomp4="' . esc_url( $videoUrl ) . '"';
                        } elseif ( strpos($videoUrl, '.ogv') !== false ) {
                            $data_self_hosted = 'data-videoogv="' . esc_url( $videoUrl ) . '"';
                        } elseif ( strpos($videoUrl, '.webm') !== false ) {
                            $data_self_hosted = 'data-videowebm="' . esc_url( $videoUrl ) . '"';
                        }
                    }
                    
                    echo '<img alt="' . esc_attr( $item['video_title'] ) . '"
                    src="' . esc_url( $thumbnailUrl ) . '"
                    data-type="html5video"
                    data-image="' . esc_url( $thumbnailUrl ) . '"
                    '. $data_self_hosted .'
                    data-description="' . esc_attr( $item['video_des'] ) . '">';
                    
                } elseif ( $item['video_type'] === 'wistia' ) { //for wistia video

                    // wistia video integration 
                    if ( !empty( $item['video_thumbnail']['url'] ) ) {
                        $thumbnailUrl = esc_url( $item['video_thumbnail']['url'] );
                    } else {
                        $vimeoVideoUrl = "https://fast.wistia.com/oembed?url=https://embed.wistia.com/medias/" . esc_attr( $item['video_id'] );
                        $response = htmega_get_remote_file_data($vimeoVideoUrl);
                        if ( $response !== false ) {
                            $data = json_decode($response, true);

                            $newWidth = $settings['thumbnial_width']['size'] ? absint( $settings['thumbnial_width']['size'] ) : 320;
                            $newHeight = $settings['thumbnial_height']['size'] ? absint( $settings['thumbnial_height']['size'] ) : 180;

                            $thumbnailUrl = $data['thumbnail_url'];
                            $thumbnailUrl = preg_replace('/(\d+)x(\d+)/', "{$newWidth}x{$newHeight}", $thumbnailUrl);
                        }
                    }

                    echo '<img alt="' . esc_attr( $item['video_title'] ) . '"
                    src="' . esc_url( $thumbnailUrl ) . '"
                    data-type="wistia"
                    data-image="' . esc_url( $thumbnailUrl ) . '"
                    data-videoid="' . esc_attr( $item['video_id'] ) . '"
                    data-description="' . esc_attr( $item['video_des'] ) . '">';

                }
            }  // foreach end
        } ?>
        </div>
         <?php
    }

}