<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_View_Counter_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-view-counter-addons';
    }
    
    public function get_title() {
        return __( 'View Counter', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-counter';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }
    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'post view', 'view count', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/';
	}
    protected function register_controls() {

        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'View Counter', 'htmega-pro' ),
            ]
        );
            
            $this->add_control(
                'counter_type',
                [
                    'label' => __( 'Counter Type', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'post',
                    'options' => [
                        'post'      => __( 'Post', 'htmega-pro' ),
                        'page'      => __( 'Page', 'htmega-pro' ),
                    ],
                ]
            );

            $this->add_control(
                'additional_text_type',
                [
                    'label' => __( 'Additional Text Type', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        ''      => __( 'Default', 'htmega-pro' ),
                        'icon'  => __( 'Icon', 'htmega-pro' ),
                        'text'  => __( 'Text', 'htmega-pro' ),
                    ],
                ]
            );

            $this->add_control(
                'icon',
                [
                    'label' => __( 'Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'condition'=>[
                        'additional_text_type' => 'icon',
                    ]
                ]
            );

            $this->add_control(
                'additional_txt',
                [
                    'label' => __( 'Additional Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => __( 'Additional Text', 'htmega-pro' ),
                    'default' => __( 'View', 'htmega-pro' ),
                    'condition'=>[
                        'additional_text_type' => 'text',
                    ]
                ]
            );


        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'button_style_section',
            array(
                'label' => __( 'Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'counter_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htbuildercounter',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'view_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htbuildercounter',
                ]
            );

            $this->add_responsive_control(
                'viewcounter_border_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuildercounter' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'viewcounter_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuildercounter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'viewcounter_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuildercounter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'heading_text_style',
                [
                    'label' => __( 'Text', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'text_color',
                [
                    'label' => __( 'Text Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default'=>'#444444',
                    'selectors' => [
                        '{{WRAPPER}} .htbuildercounter span' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'text_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htbuildercounter span',
                ]
            );

            $this->add_control(
                'heading_icon_style',
                [
                    'label' => __( 'Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'icon_color',
                [
                    'label' => __( 'Icon Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default'=>'#444444',
                    'selectors' => [
                        '{{WRAPPER}} .htbuildercounter i' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'icon_size',
                [
                    'label' => __( 'Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 16,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuildercounter i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'icon_space',
                [
                    'label' => __( 'Space', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 2,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuildercounter i' => 'margin-right: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htbuildercounter span.htviewtxt' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $button_text = '';

        if( $settings['additional_text_type'] == 'icon' ){
            $button_text = \Elementor\HTMega_Icon_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] );
        }elseif( $settings['additional_text_type'] == 'text' ){
            $button_text = '<span class="htviewtxt">' . esc_html( $settings['additional_txt'] ) . '</span>';
        }else{
            $button_text = '<span class="htviewtxt">'.__( 'View', 'htmega-pro' ).'</span>';
        }
        echo sprintf('<div class="htbuildercounter">%1$s<span>%2$s</span></div>', $button_text, htmega_getpostviews( get_the_ID(), $settings['counter_type'] ) );

    }

}

