<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Whatsapp_chat_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-whatsapp-chat-addons';
    }
    
    public function get_title() {
        return __( 'WhatsApp Chat', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-commenting-o';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }
    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'whatsapp', 'whatsapp chat', 'whatsapp agent', 'whatsapp message', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/whatsapp-chat-widget/';
	}
    protected function register_controls() {

        // WhatsApp Button
        $this->start_controls_section(
            'switcher_general_section',
            [
                'label' => __( 'WhatsApp Button', 'htmega-pro' ),
            ]
        ); 
        
            // Whatsapp Button Icon
            $this->add_control(
                'whatsapp_button_icon',
                [
                    'label' => esc_html__( 'Button Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fab fa-whatsapp',
                        'library' => 'fa-brands',
                    ],
                    'recommended' => [
                        'fa-brands' => [
                            'whatsapp',
                            'whatsapp-square',
                        ]
                    ],
                ]
            );

            // Show Button Label
            $this->add_control(
                'show_button_label',
                [
                    'label' => esc_html__( 'Show Button Label', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );    

            // Button Label Text
            $this->add_control(
                'button_label_text',
                [
                    'label' => esc_html__( 'Button Label Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => ['active' => true],
                    'default' => esc_html__( 'Chat Now', 'htmega-pro' ),
                    'placeholder' => esc_html__( 'Chat Now', 'htmega-pro' ),
                    'condition' => [
                        'show_button_label' => 'yes'
                    ]
                ]
            ); 

            // Button Icon Postitoning
            $this->add_responsive_control(
                'button_align',
                [
                    'label' => esc_html__( 'Label Position', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-h-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-button' => 'flex-direction: {{VALUE}}',
                    ],
                    'default' => 'row',
                    'condition' => [
                        'show_button_label' => 'yes'
                    ]
                ]
            );

            $this->add_control(
                'labe_width',
                [
                    'label' => esc_html__( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 250,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-button.button-label , {{WRAPPER}} .htmega-whatsapp-chat-button.no-label' => 'width: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );     

            $this->add_control(
                'labe_height',
                [
                    'label' => esc_html__( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 150,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-button.button-label , {{WRAPPER}} .htmega-whatsapp-chat-button.no-label' => 'height: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );  

            $this->add_control(
                'labe_spacing',
                [
                    'label' => esc_html__( 'Spacing', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 150,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-button.button-label' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_button_label' => 'yes'
                    ]
                ]
            );
            
            $this->add_control(
                'whatsapp_popup_positioning',
                [
                    'label' => esc_html__( 'Popup Box Position', 'htmega-pro' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                    'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );       

            $this->start_popover();

                $this->add_responsive_control(
                    'whatsapp_position_top',
                    [
                        'label' => esc_html__( 'Top', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 550,
                                'step' => 1,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-whatsapp-chat-popup-box' => 'top: {{SIZE}}{{UNIT}};',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'whatsapp_position_right',
                    [
                        'label' => esc_html__( 'Right', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 550,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 0,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-whatsapp-chat-popup-box' => 'right: {{SIZE}}{{UNIT}};',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'whatsapp_position_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 550,
                                'step' => 1,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-whatsapp-chat-popup-box' => 'bottom: {{SIZE}}{{UNIT}};',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'whatsapp_position_left',
                    [
                        'label' => esc_html__( 'Left', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 550,
                                'step' => 1,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-whatsapp-chat-popup-box' => 'left: {{SIZE}}{{UNIT}};',
                        ]
                    ]
                );

            $this->end_popover();

        $this->end_controls_section();

        // Popup Header
        $this->start_controls_section(
            'switcher_popup_header_section',
            [
                'label' => __( 'Popup Header', 'htmega-pro' ),
            ]
        );        
        
            // Whatsapp Popup Icon
            $this->add_control(
                'whatsapp_popup_icon',
                [
                    'label' => esc_html__( 'Popup Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'far fa-comments',
                        'library' => 'fa-brands',
                    ],
                    'recommended' => [
                        'fa-regular' => [
                            'comment',
                            'comment-alt',
                            'comment-dots',
                            'comments',
                        ],
                        'fa-solid' => [
                            'comment',
                            'comment-alt',
                            'comment-dollar',
                            'comment-dots',
                            'comment-medical',
                            'comment-slash',
                            'comments',
                            'comments-dollar',
                        ],
                    ],
                ]
            );

                $this->add_control(
                    'popup_icon_color',
                    [
                        'label' => esc_html__( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-whatsapp-chat-popup-icon i' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .htmega-whatsapp-chat-popup-icon svg path , {{WRAPPER}} .htmega-whatsapp-chat-popup-icon svg' => 'fill: {{VALUE}}',
                        ],
                        'condition' => [
                            'whatsapp_popup_icon[value]!' => ''
                        ]
                    ]
                ); 

                $this->add_responsive_control(
                    'popup_icon_size',
                    [
                        'label' => esc_html__( 'Icon Size', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => ['px'],
                        'default' => [
                            'unit' => 'px',
                            'size' => 16,
                        ],                    
                        'selectors' => [
                            '{{WRAPPER}} .htmega-whatsapp-chat-popup-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .htmega-whatsapp-chat-popup-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'whatsapp_popup_icon[value]!' => ''
                        ]
                    ]
                );

                $this->add_control(
                    'popup_spacing',
                    [
                        'label' => esc_html__( 'Spacing', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 150,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 10,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-whatsapp-chat-popup-header-left' => 'gap: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'whatsapp_popup_icon[value]!' => ''
                        ]
                    ]
                );                

            // Popup Icon Heading 
            $this->add_control(
                'popup_header_heading',
                [
                    'label' => esc_html__( 'Popup Header Text', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );  

            // Send Button Text
            $this->add_control(
                'header_top_text',
                [
                    'label' => esc_html__( 'Header Content', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => ['active' => true],
                    'default' => esc_html__( 'Whatsapp Chat', 'htmega-pro' ),
                ]
            );

            $this->add_control(
                'header_top_text_tag',
                [
                    'label' => __('Select Tag', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'h3',
                    'options' => [
                        'h1' => __('H1', 'htmega-pro'),
                        'h2' => __('H2', 'htmega-pro'),
                        'h3' => __('H3', 'htmega-pro'),
                        'h4' => __('H4', 'htmega-pro'),
                        'h5' => __('H5', 'htmega-pro'),
                        'h6' => __('H6', 'htmega-pro'),
                        'span' => __('Span', 'htmega-pro'),
                        'p' => __('P', 'htmega-pro'),
                        'div' => __('Div', 'htmega-pro'),
                    ],
                    'condition' => [
                        'header_top_text[value]!' =>'',
                    ]
                ]
            );

        // Close Icon Heading 
		$this->add_control(
			'close_icon_heading',
			[
				'label' => esc_html__( 'Close Icon', 'htmega-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        // Whatsapp Closs Icon
        $this->add_control(
            'whatsapp_close_icon',
            [
                'label' => esc_html__( 'Colse Icon', 'htmega-pro' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-times',
                    'library' => 'fa-brands',
                ],
                'recommended' => [
                    'fa-regular' => [
                        'times-circle',
                        'window-close',
                    ],
                    'fa-solid' => [
                        'times',
                        'times-circle',
                        'window-close',
                    ],
                ],
            ]
        );

            $this->add_control(
                'close_icon_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-header-right button.htmega-whatsapp-chat-close-icon i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-header-right button.htmega-whatsapp-chat-close-icon svg path , {{WRAPPER}} .htmega-whatsapp-chat-popup-header-right button.htmega-whatsapp-chat-close-icon svg' => 'fill: {{VALUE}}',
                    ],
                    'condition' => [
                        'whatsapp_close_icon[value]!' => ''
                    ]
                ]
            ); 

            $this->add_responsive_control(
                'close_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'default' => [
                        'unit' => 'px',
                        'size' => 16,
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-header-right button.htmega-whatsapp-chat-close-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-header-right button.htmega-whatsapp-chat-close-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'whatsapp_close_icon[value]!' => ''
                    ]
                ]
            );

        $this->end_controls_section(); 

        // Agents
        $this->start_controls_section(
            'switcher_content_body_section',
            [
                'label' => __( 'Popup Content Body', 'htmega-pro' ),
            ]
        );   

            //Intro Text
            $this->add_control(
                'whatsapp_intro_text',
                [
                    'label' => esc_html__( 'Intro Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'dynamic' => ['active' => true],
                    'rows' => 10,
                    'default' => esc_html__( 'Send us a note right away, and we will get back to you as soon as we can.', 'htmega-pro' ),
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'whatsapp_intro_tag',
                [
                    'label' => __('Select Tag', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'p',
                    'options' => [
                        'h1' => __('H1', 'htmega-pro'),
                        'h2' => __('H2', 'htmega-pro'),
                        'h3' => __('H3', 'htmega-pro'),
                        'h4' => __('H4', 'htmega-pro'),
                        'h5' => __('H5', 'htmega-pro'),
                        'h6' => __('H6', 'htmega-pro'),
                        'span' => __('Span', 'htmega-pro'),
                        'p' => __('P', 'htmega-pro'),
                        'div' => __('Div', 'htmega-pro'),
                    ],
                    'condition' => [
                        'header_top_text[value]!' =>'',
                    ]
                ]
            );

        // Back Icon Heading 
		$this->add_control(
			'back_icon_heading',
			[
				'label' => esc_html__( 'Back Icon', 'htmega-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        // Whatsapp Back Icon
        $this->add_control(
            'whatsapp_back_icon',
            [
                'label' => esc_html__( 'Back Icon', 'htmega-pro' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-left',
                    'library' => 'fa-brands',
                ],
                'recommended' => [
                    'fa-regular' => [
                        'arrow-alt-circle-left',
                    ],
                    'fa-solid' => [
                        'arrow-alt-circle-left',
                        'arrow-circle-left',
                        'arrow-left',
                        'long-arrow-alt-left',
                        'backward',
                        'fast-backward',
                        'step-backward',
                        'angle-double-left',
                        'angle-left',
                    ],
                ],
            ]
        );  
        
        $this->add_responsive_control(
            'whatsapp_back_size',
            [
                'label' => esc_html__( 'Icon Size', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],                    
                'selectors' => [
                    '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'whatsapp_back_icon[value]!' => ''
                ]
            ]
        ); 

        // Border Radius
        $this->add_responsive_control(
            'whatsapp_back_button_radius',
            [
                'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'whatsapp_back_icon[value]!' => ''
                ]
            ]
        );     

        // Whatsapp back button padding
        $this->add_responsive_control(
            'whatsapp_back_button_padding',
            [
                'label' => esc_html__( 'Padding', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'whatsapp_back_icon[value]!' => ''
                ]
            ]
        );       

        $this->start_controls_tabs('whatsapp_back_tabs_style');

            $this->start_controls_tab(
                'whatsapp_back_tab_normal',
                [
                    'label' => __('Normal', 'htmega-pro'),
                    'condition' => [
                        'whatsapp_back_icon[value]!' => ''
                    ]
                ]
            );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'back_button_background',
                        'label' => esc_html__( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'exclude' => [ 'image'],
                        'selector' => '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer',
                    ]
                );

                $this->add_control(
                    'back_icon_color',
                    [
                        'label' => esc_html__( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer i' => 'color: {{VALUE}}',
                            '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer svg path , {{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer svg' => 'fill: {{VALUE}}',
                        ]
                    ]
                );     

            $this->end_controls_tab();

            $this->start_controls_tab(
                'whatsapp_back_tab_hover',
                [
                    'label' => __('Hover', 'htmega-pro'),
                    'condition' => [
                        'whatsapp_back_icon[value]!' => ''
                    ]
                ]
            );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'back_button_hover_background',
                        'label' => esc_html__( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'exclude' => [ 'image'],
                        'selector' => '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer:hover',
                    ]
                );

                $this->add_control(
                    'back_icon_hover_color',
                    [
                        'label' => esc_html__( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer:hover i' => 'color: {{VALUE}}',
                            '{{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer:hover svg path , {{WRAPPER}} button.htmega-whatsapp-chat-agent-message-box-close.htmega-whatsapp-chat-closer:hover svg' => 'fill: {{VALUE}}',
                        ]
                    ]
                );  

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section(); 

        // Agents
        $this->start_controls_section(
            'switcher_agent_section',
            [
                'label' => __( 'Agent List', 'htmega-pro' ),
            ]
        );

        $repeater = new Repeater();

        // agent name
		$repeater->add_control(
			'agent_name', [
				'label' => esc_html__( 'Name', 'htmega-pro' ),
				'type' => Controls_Manager::TEXT,
                'dynamic' => ['active' => true],
				'default' => esc_html__( 'Bobbie P. Purdom' , 'htmega-pro' ),
				'label_block' => true,
			]
		);       

        // agent designation
		$repeater->add_control(
			'agent_designation', [
				'label' => esc_html__( 'Designation', 'htmega-pro' ),
				'type' => Controls_Manager::TEXT,
                'dynamic' => ['active' => true],
				'default' => esc_html__( 'Support Agent' , 'htmega-pro' ),
				'label_block' => true,
			]
		);  

        // agent designation
		$repeater->add_control(
			'agent_number', [
				'label' => esc_html__( 'Number', 'htmega-pro' ),
				'description' => esc_html__( 'Important Note: Use the country code. (e.g. +1 for USA)', 'htmega-pro' ),
				'type' => Controls_Manager::TEXT,
                'dynamic' => ['active' => true],
				'default' => esc_html__( '+8806364264' , 'htmega-pro' ),
				'label_block' => true,
			]
		); 

        // Available Hours
		$repeater->add_control(
			'agent_availabel_hours', [
				'label' => esc_html__( 'Available Hours', 'htmega-pro' ),
				'type' => Controls_Manager::TEXT,
                'dynamic' => ['active' => true],
				'default' => esc_html__( 'Available from 08:00 to 12:00' , 'htmega-pro' ),
				'label_block' => true,
			]
		);  
        
        // Agent Image
		$repeater->add_control(
			'agent_image',
			[
				'label' => esc_html__( 'Choose Image', 'htmega-pro' ),
				'type' => Controls_Manager::MEDIA,
			]
		);   
        
        // Agent Image Size  
        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'agent_imagesize',
                'default' => 'thumbnail',
                'separator' => 'none',
                'condition' => [
                    'agent_image[url]!' => '',
                ]
            ]
        );    

		$this->add_control(
			'agent_list',
			[
				'label' => esc_html__( 'Agent List', 'htmega-pro' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'agent_name' => esc_html__( 'Bobbie P. Purdom', 'htmega-pro' ),
						'agent_designation' => esc_html__( 'Support Agent', 'htmega-pro' ),
						'agent_number' => esc_html__( '+8806364264', 'htmega-pro' ),
						'agent_availabel_hours' => esc_html__( 'Available from 08:00 to 12:00', 'htmega-pro' ),
					],
					[
						'agent_name' => esc_html__( 'Moriah Franecki', 'htmega-pro' ),
						'agent_designation' => esc_html__( 'Sales Agent', 'htmega-pro' ),
						'agent_number' => esc_html__( '+8802587104', 'htmega-pro' ),
						'agent_availabel_hours' => esc_html__( 'Available from 13:00 to 18:00', 'htmega-pro' ),
					],
					[
						'agent_name' => esc_html__( 'Guy Franecki', 'htmega-pro' ),
						'agent_designation' => esc_html__( 'Manager', 'htmega-pro' ),
						'agent_number' => esc_html__( '+8808105867', 'htmega-pro' ),
						'agent_availabel_hours' => esc_html__( 'Available from 19:00 to 23:00', 'htmega-pro' ),
					],
				],
				'title_field' => '{{{ agent_name }}}',
			]
		);

        $this->end_controls_section();

        // Submit Button
        $this->start_controls_section(
            'whatsapp_submit_button_section',
            [
                'label' => __( 'Submit Button', 'htmega-pro' ),
            ]
        );

            // Send Button Text
            $this->add_control(
                'send_button_text',
                [
                    'label' => esc_html__( 'Send Button Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => ['active' => true],
                    'default' => esc_html__( 'Send message', 'htmega-pro' ),
                    'placeholder' => esc_html__( 'Send message', 'htmega-pro' ),
                ]
            );
        
            // Whatsapp Send Icon
            $this->add_control(
                'whatsapp_send_icon',
                [
                    'label' => esc_html__( 'Send Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'label_block' => false,
                    'skin' => 'inline',
                    'default' => [
                        'value' => 'fas fa-paper-plane',
                        'library' => 'fa-brands',
                    ],
                    'recommended' => [
                        'fa-regular' => [
                            'paper-plane',
                        ],
                        'fa-solid' => [
                            'paper-plane',
                            'location-arrow',
                        ],
                    ],
                ]
            );

            // Button Icon Postitoning
            $this->add_responsive_control(
                'submit_button_align',
                [
                    'label' => esc_html__( 'Button Icon Position', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row-reverse' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'row' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-h-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link' => 'flex-direction: {{VALUE}}',
                    ],
                    'default' => 'row-reverse',
                    'condition' => [
                        'whatsapp_send_icon[value]!' => ''
                    ]
                ]
            );

            // Submit button alignment 
            $this->add_responsive_control(
                'whatsapp_submit_button_alignment',
                [
                    'label' => __('Alignment', 'htmega-pro'),
                    'type' => Controls_Manager::CHOOSE,
                    'default' => 'left',
                    'options' => [
                        'left' => [
                            'title' => __('Left', 'htmega-pro'),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => __('Center', 'htmega-pro'),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => __('Right', 'htmega-pro'),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-submit-button' => 'text-align: {{VALUE}};',
                    ],
                ]
            );            
                
            // Gap
            $this->add_responsive_control(
                'submit_gap_control',
                [
                    'label' => esc_html__( 'Gap', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],       
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'whatsapp_send_icon[value]!' => ''
                    ]
                ]
            );    
            
            // Icon Size
            $this->add_responsive_control(
                'submit_icon_button_size',
                [
                    'label' => esc_html__( 'Icon Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'default' => [
                        'unit' => 'px',
                        'size' => 16,
                    ],       
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link svg path , {{WRAPPER}} .htmega-whatsapp-chat-message-send-link svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'whatsapp_send_icon[value]!' => ''
                    ]
                ]
            );  

            // Button typography
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'submit_button_typography',
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link',
                ]
            );    

            // Border Radius
            $this->add_responsive_control(
                'submit_icon_button_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            // Padding
            $this->add_responsive_control(
                'submit_icon_button_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            // Margin
            $this->add_responsive_control(
                'submit_icon_button_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->start_controls_tabs('whatsapp_submit_button_style');

                $this->start_controls_tab(
                    'whatsapp_submit_tab_normal',
                    [
                        'label' => __('Normal', 'htmega-pro'),
                    ]
                );

                    $this->add_control(
                        'submit_button_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'submit_button_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'exclude' => [ 'image'],
                            'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link',
                        ]
                    );                

                $this->end_controls_tab();

                $this->start_controls_tab(
                    'whatsapp_submit_tab_hover',
                    [
                        'label' => __('Hover', 'htmega-pro'),
                    ]
                );

                    $this->add_control(
                        'submit_button_hover_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'submit_button_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'exclude' => [ 'image'],
                            'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-message-send-link:hover',
                        ]
                    );  

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();

        // Item Style
        $this->start_controls_section(
            'whatsapp_button_style',
            array(
                'label' => __( 'WhatsApp Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );

            $this->add_responsive_control(
                'whatsapp_button_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'default' => [
                        'unit' => 'px',
                        'size' => 24,
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-button-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-whatsapp-chat-button-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'label_typography',
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-button-label',
                    'condition' => [
                        'show_button_label' => 'yes'
                    ]
                ]
            );

            $this->start_controls_tabs( 'whatsapp_button_tabs' );

                // Normal tab Start
                $this->start_controls_tab(
                    'whatsapp_button_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );

                    // Button Icon Color 
                    $this->add_control(
                        'whatsapp_button_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-whatsapp-chat-button-icon i, {{WRAPPER}} .htmega-whatsapp-chat-button-label' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-whatsapp-chat-button-icon svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'whatsapp_button_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-button',
                        ]
                    );

                $this->end_controls_tab(); // Normal tab end

                // Hover tab Start
                $this->start_controls_tab(
                    'whatsapp_button_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );

                    // Button Icon Hover Color 
                    $this->add_control(
                        'whatsapp_button_color_hover_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-whatsapp-chat-button:hover .htmega-whatsapp-chat-button-icon i , {{WRAPPER}} .htmega-whatsapp-chat-button:hover .htmega-whatsapp-chat-button-label' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-whatsapp-chat-button:hover .htmega-whatsapp-chat-button-icon svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    // hover background color 
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'whatsapp_button_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-button:hover',
                        ]
                    );

                $this->end_controls_tab(); // Normal tab end

            $this->end_controls_tabs(); // Tabs end

        $this->end_controls_section();        

        // Item Style
        $this->start_controls_section(
            'whatsapp_area_style',
            array(
                'label' => __( 'Popup Area', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );

            // Area Border
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'whatsapp_area_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-popup-box',
                ]
            );

            $this->add_control(
                'whatsapp_area_width',
                [
                    'label' => esc_html__( 'Area Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 5,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 370,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-box' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );            

            // Border Radius
            $this->add_responsive_control(
                'content_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );        

        $this->end_controls_section();

        // Item Style
        $this->start_controls_section(
            'whatsapp_header_style',
            array(
                'label' => __( 'Header', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );

            // Area Background
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'whatsapp_header_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-popup-header',
                ]
            );
            
            // padding 
            $this->add_responsive_control(
                'header_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            ); 

            // Header for popup Icon 
            $this->add_control(
                'header_text_control',
                [
                    'label' => esc_html__( 'Header Text', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'header_typography',
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-popup-hero-title',
                ]
            );

            $this->add_control(
                'header_text_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-hero-title' => 'color: {{VALUE}}',
                    ],
                ]
            );      

        $this->end_controls_section();

        // Item Style
        $this->start_controls_section(
            'whatsapp_container_style',
            array(
                'label' => __( 'Container', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );

            // Container Background
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'whatsapp_continer_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-popup-body',
                ]
            );

            // Color
            $this->add_control(
                'whatsapp_status_text_color',
                [
                    'label' => esc_html__( 'Status Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-body-title' => 'color: {{VALUE}}',
                    ],
                ]
            );            

            // Typography
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'whatsapp_content_typography',
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-popup-body-title',
                ]
            );
            
            // Status Spacing
            $this->add_responsive_control(
                'status_spacing_control',
                [
                    'label' => esc_html__( 'Status Spacing', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],                  
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-body-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );  

            // Padding
            $this->add_responsive_control(
                'content_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            ); 
            
        $this->end_controls_section();

        // Item Style
        $this->start_controls_section(
            'whatsapp_agent_control',
            array(
                'label' => __( 'Agents', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );

            // Container Background
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'whatsapp_agents_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'exclude' => [ 'image' ],
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-agent-link',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'agent_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-agent-link:not(:last-child)',
                ]
            );    
            
            // Agent Spacing
            $this->add_responsive_control(
                'agent_spacing_control',
                [
                    'label' => esc_html__( 'Item Spacing', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],                  
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-link:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );            

            // Border Radius
            $this->add_responsive_control(
                'agents_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );    

            // Padding
            $this->add_responsive_control(
                'agents_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );    

            $this->add_control(
                'image_setting_control',
                [
                    'label' => esc_html__( 'Image Control', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );   
            
            // Gap
            $this->add_responsive_control(
                'agent_gap_control',
                [
                    'label' => esc_html__( 'Gap', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'default' => [
                        'unit' => 'px',
                        'size' => 12,
                    ],       
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-left-side' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );  

            // Border Radius
            $this->add_responsive_control(
                'agents_images_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-popup-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );   

            $this->add_control(
                'available_hours',
                [
                    'label' => esc_html__( 'Available Hours', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );  

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'available_time_typ',
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-agent-list-chat-time',
                ]
            );

            $this->add_control(
                'available_time_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-list-chat-time' => 'color: {{VALUE}}',
                    ],
                ]
            );   

            // Margin
            $this->add_responsive_control(
                'agents_images_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-list-chat-time' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );          

            // Agent Name 
            $this->add_control(
                'agent_name',
                [
                    'label' => esc_html__( 'Agent Name', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );  

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'agent_name_typ',
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-agent-name',
                ]
            );

            $this->add_control(
                'agent_name_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-name' => 'color: {{VALUE}}',
                    ],
                ]
            );   

            // Margin
            $this->add_responsive_control(
                'agent_name_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );    

            // Agent Designations
            $this->add_control(
                'agent_designation',
                [
                    'label' => esc_html__( 'Agent Designation', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );  

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'designation_typ',
                    'selector' => '{{WRAPPER}} .htmega-whatsapp-chat-agent-last-mes',
                ]
            );

            $this->add_control(
                'designation_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-last-mes' => 'color: {{VALUE}}',
                    ],
                ]
            );   

            // Margin
            $this->add_responsive_control(
                'designation_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-whatsapp-chat-agent-last-mes' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        $this->add_render_attribute( 'header_top_text', 'class', 'htmega-whatsapp-chat-popup-hero-title' );
        $this->add_render_attribute( 'whatsapp_intro_text', 'class', 'htmega-whatsapp-chat-popup-body-title' );

        if($settings['show_button_label'] == 'yes'){
            $button_label = 'button-label';
        }else{
            $button_label = 'no-label';
        }

        $this->add_render_attribute( 'whatsapp_button', 'class', 'htmega-whatsapp-chat-button'.' '.$button_label );
        
        ?>
        <div class="htmega-whatsapp-chat-popup-wrap">
            <button <?php echo $this->get_render_attribute_string( 'whatsapp_button' ); ?>>
                <div class="htmega-whatsapp-chat-button-icon">
                    <?php Icons_Manager::render_icon( $settings['whatsapp_button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </div>
                <?php 
                    if($settings['show_button_label'] == 'yes'){ ?>
                        <div class="htmega-whatsapp-chat-button-label">
                            <?php echo esc_html( $settings['button_label_text'] ); ?>
                        </div>
                    <?php }
                ?>
            </button>

            <div class="htmega-whatsapp-chat-popup-box">
                <div class="htmega-whatsapp-chat-popup-header">
                    <div class="htmega-whatsapp-chat-popup-header-left">
                        <div class="htmega-whatsapp-chat-popup-icon">
                            <?php Icons_Manager::render_icon( $settings['whatsapp_popup_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </div>     

                        <?php
                            if ( $settings['header_top_text' ] ) :
                                printf( '<%1$s %2$s>%3$s</%1$s>',
                                    htmega_escape_tags( $settings['header_top_text_tag'], 'h3' ),
                                    $this->get_render_attribute_string( 'header_top_text' ),
                                    htmega_kses_title( $settings['header_top_text' ] )
                                );
                            endif;
                        ?>
                        
                    </div>
                    <div class="htmega-whatsapp-chat-popup-header-right">
                        <button class="htmega-whatsapp-chat-close-icon">
                            <?php Icons_Manager::render_icon( $settings['whatsapp_close_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </button>
                    </div>
                </div>
                <div class="htmega-whatsapp-chat-popup-body">
                    <div class="htmega-whatsapp-chat-popup-body-top">
                        
                            <?php if ( $settings['whatsapp_intro_text' ] ) :
                                printf( '<%1$s %2$s>%3$s</%1$s>',
                                    htmega_escape_tags( $settings['whatsapp_intro_tag'], 'p' ),
                                    $this->get_render_attribute_string( 'whatsapp_intro_text' ),
                                    htmega_kses_title( $settings['whatsapp_intro_text' ] )
                                );
                            endif; ?>

                        <button class="htmega-whatsapp-chat-agent-message-box-close">
                            <?php Icons_Manager::render_icon( $settings['whatsapp_back_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </button>

                    </div>

                    <div class="htmega-whatsapp-chat-agents">
                    <?php foreach($settings["agent_list"] as $agent): ?>
                        <a href="https://wa.me/<?php echo esc_attr( $agent['agent_number'] ); ?>" class="htmega-whatsapp-chat-agent-link">
                            <div class="htmega-whatsapp-chat-agent-left-side">
                                <?php if( !empty( $agent['agent_image']['url'] ) ){
                                    echo '<div class="htmega-whatsapp-chat-agent-image">'.Group_Control_Image_Size::get_attachment_image_html( $agent, 'agent_imagesize', 'agent_image' ).'</div>';
                                } ?>
                                <div class="htmega-whatsapp-chat-agent-details">

                                    <?php if(!empty($agent['agent_availabel_hours'])): ?>
                                        <p class="htmega-whatsapp-chat-agent-list-chat-time"><?php echo esc_html( $agent['agent_availabel_hours'] ); ?></p>
                                    <?php endif; ?>
                                    <!-- Agent Name  -->
                                    <?php if(!empty($agent['agent_name'])): ?>
                                        <h6 class="htmega-whatsapp-chat-agent-name"><?php echo esc_html( $agent['agent_name'] ); ?></h6>
                                    <?php endif; ?>      

                                    <!-- Agent Designation  -->
                                    <?php if($agent['agent_designation']): ?>
                                    <p class="htmega-whatsapp-chat-agent-last-mes"><?php echo esc_html( $agent['agent_designation'] ); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </a>                        
                    <?php endforeach ?>
                    </div>
               
                    <div class="htmega-whatsapp-chat-agents-message-box">
                        <textarea class="htmega-whatsapp-chat-agents-mess-input" name="" id="" cols="30" rows="10" placeholder="<?php esc_html__( 'Write your message here and click the send button.', 'htmega-pro' ); ?>"></textarea>
                        <div class="htmega-whatsapp-submit-button">
                            <a href="#" class="htmega-whatsapp-chat-message-send-link">
                                <?php echo wp_kses_post( $settings['send_button_text'] ); ?>
                                <?php Icons_Manager::render_icon( $settings['whatsapp_send_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
        
        <?php

    }

}