<?php


namespace JFB_Compatibility\Woocommerce\Methods\Wc_Product_Modification;

use Jet_Form_Builder\Actions\Methods\Abstract_Modifier;
use JFB_Modules\Actions_V2\Insert_Post\Properties\Post_Content_Property;
use JFB_Modules\Actions_V2\Insert_Post\Properties\Post_Excerpt_Property;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

class Product_Total_Sales_Property extends Base_Product_Property {

	public function get_id(): string {
		return 'total_sales';
	}

	public function get_label(): string {
		return __( 'Product Total Sales', 'jet-form-builder' );
	}


	public function get_value( Abstract_Modifier $modifier ) {
		parent::get_value( $modifier );
		$product = $this->get_product( $modifier );

		$product->set_total_sales( $this->value );
	}
}
