<?php
/**
 * LearnDash Country class.
 *
 * @since 4.25.0
 *
 * @package LearnDash\Core
 */

namespace LearnDash\Core\Utilities;

use StellarWP\Learndash\StellarWP\Arrays\Arr;

/**
 * A helper class to provide easier ways to work with countries.
 *
 * @since 4.25.0
 */
class Countries {
	/**
	 * Returns a list of countries with their codes.
	 *
	 * @since 4.25.0
	 *
	 * @return array<string,string> Code as key, name as value.
	 */
	public static function get_all(): array {
		return [
			'AF' => esc_html__( 'Afghanistan', 'learndash' ),
			'AX' => esc_html__( 'Åland', 'learndash' ),
			'AL' => esc_html__( 'Albania', 'learndash' ),
			'DZ' => esc_html__( 'Algeria', 'learndash' ),
			'AS' => esc_html__( 'American Samoa', 'learndash' ),
			'AD' => esc_html__( 'Andorra', 'learndash' ),
			'AO' => esc_html__( 'Angola', 'learndash' ),
			'AI' => esc_html__( 'Anguilla', 'learndash' ),
			'AQ' => esc_html__( 'Antarctica', 'learndash' ),
			'AG' => esc_html__( 'Antigua and Barbuda', 'learndash' ),
			'AR' => esc_html__( 'Argentina', 'learndash' ),
			'AM' => esc_html__( 'Armenia', 'learndash' ),
			'AW' => esc_html__( 'Aruba', 'learndash' ),
			'AU' => esc_html__( 'Australia', 'learndash' ),
			'AT' => esc_html__( 'Austria', 'learndash' ),
			'AZ' => esc_html__( 'Azerbaijan', 'learndash' ),
			'BS' => esc_html__( 'Bahamas', 'learndash' ),
			'BH' => esc_html__( 'Bahrain', 'learndash' ),
			'BD' => esc_html__( 'Bangladesh', 'learndash' ),
			'BB' => esc_html__( 'Barbados', 'learndash' ),
			'BY' => esc_html__( 'Belarus', 'learndash' ),
			'BE' => esc_html__( 'Belgium', 'learndash' ),
			'BZ' => esc_html__( 'Belize', 'learndash' ),
			'BJ' => esc_html__( 'Benin', 'learndash' ),
			'BM' => esc_html__( 'Bermuda', 'learndash' ),
			'BT' => esc_html__( 'Bhutan', 'learndash' ),
			'BO' => esc_html__( 'Bolivia', 'learndash' ),
			'BQ' => esc_html__( 'Bonaire, Sint Eustatius and Saba', 'learndash' ),
			'BA' => esc_html__( 'Bosnia and Herzegovina', 'learndash' ),
			'BW' => esc_html__( 'Botswana', 'learndash' ),
			'BV' => esc_html__( 'Bouvet Island', 'learndash' ),
			'BR' => esc_html__( 'Brazil', 'learndash' ),
			'IO' => esc_html__( 'British Indian Ocean Territory', 'learndash' ),
			'BN' => esc_html__( 'Brunei Darussalam', 'learndash' ),
			'BG' => esc_html__( 'Bulgaria', 'learndash' ),
			'BF' => esc_html__( 'Burkina Faso', 'learndash' ),
			'BI' => esc_html__( 'Burundi', 'learndash' ),
			'KH' => esc_html__( 'Cambodia', 'learndash' ),
			'CM' => esc_html__( 'Cameroon', 'learndash' ),
			'CA' => esc_html__( 'Canada', 'learndash' ),
			'CV' => esc_html__( 'Cape Verde', 'learndash' ),
			'KY' => esc_html__( 'Cayman Islands', 'learndash' ),
			'CF' => esc_html__( 'Central African Republic', 'learndash' ),
			'TD' => esc_html__( 'Chad', 'learndash' ),
			'CL' => esc_html__( 'Chile', 'learndash' ),
			'CN' => esc_html__( 'China', 'learndash' ),
			'CX' => esc_html__( 'Christmas Island', 'learndash' ),
			'CC' => esc_html__( 'Cocos (Keeling) Islands', 'learndash' ),
			'CO' => esc_html__( 'Colombia', 'learndash' ),
			'KM' => esc_html__( 'Comoros', 'learndash' ),
			'CG' => esc_html__( 'Congo (Brazzaville)', 'learndash' ),
			'CD' => esc_html__( 'Congo (Kinshasa)', 'learndash' ),
			'CK' => esc_html__( 'Cook Islands', 'learndash' ),
			'CR' => esc_html__( 'Costa Rica', 'learndash' ),
			'CI' => esc_html__( "Côte d'Ivoire", 'learndash' ),
			'HR' => esc_html__( 'Croatia', 'learndash' ),
			'CU' => esc_html__( 'Cuba', 'learndash' ),
			'CW' => esc_html__( 'Curaçao', 'learndash' ),
			'CY' => esc_html__( 'Cyprus', 'learndash' ),
			'CZ' => esc_html__( 'Czech Republic', 'learndash' ),
			'DK' => esc_html__( 'Denmark', 'learndash' ),
			'DJ' => esc_html__( 'Djibouti', 'learndash' ),
			'DM' => esc_html__( 'Dominica', 'learndash' ),
			'DO' => esc_html__( 'Dominican Republic', 'learndash' ),
			'EC' => esc_html__( 'Ecuador', 'learndash' ),
			'EG' => esc_html__( 'Egypt', 'learndash' ),
			'SV' => esc_html__( 'El Salvador', 'learndash' ),
			'GQ' => esc_html__( 'Equatorial Guinea', 'learndash' ),
			'ER' => esc_html__( 'Eritrea', 'learndash' ),
			'EE' => esc_html__( 'Estonia', 'learndash' ),
			'ET' => esc_html__( 'Ethiopia', 'learndash' ),
			'FK' => esc_html__( 'Falkland Islands', 'learndash' ),
			'FO' => esc_html__( 'Faroe Islands', 'learndash' ),
			'FJ' => esc_html__( 'Fiji', 'learndash' ),
			'FI' => esc_html__( 'Finland', 'learndash' ),
			'FR' => esc_html__( 'France', 'learndash' ),
			'GF' => esc_html__( 'French Guiana', 'learndash' ),
			'PF' => esc_html__( 'French Polynesia', 'learndash' ),
			'TF' => esc_html__( 'French Southern Lands', 'learndash' ),
			'GA' => esc_html__( 'Gabon', 'learndash' ),
			'GM' => esc_html__( 'Gambia', 'learndash' ),
			'GE' => esc_html__( 'Georgia', 'learndash' ),
			'DE' => esc_html__( 'Germany', 'learndash' ),
			'GH' => esc_html__( 'Ghana', 'learndash' ),
			'GI' => esc_html__( 'Gibraltar', 'learndash' ),
			'GR' => esc_html__( 'Greece', 'learndash' ),
			'GL' => esc_html__( 'Greenland', 'learndash' ),
			'GD' => esc_html__( 'Grenada', 'learndash' ),
			'GP' => esc_html__( 'Guadeloupe', 'learndash' ),
			'GU' => esc_html__( 'Guam', 'learndash' ),
			'GT' => esc_html__( 'Guatemala', 'learndash' ),
			'GG' => esc_html__( 'Guernsey', 'learndash' ),
			'GN' => esc_html__( 'Guinea', 'learndash' ),
			'GW' => esc_html__( 'Guinea-Bissau', 'learndash' ),
			'GY' => esc_html__( 'Guyana', 'learndash' ),
			'HT' => esc_html__( 'Haiti', 'learndash' ),
			'HM' => esc_html__( 'Heard and McDonald Islands', 'learndash' ),
			'HN' => esc_html__( 'Honduras', 'learndash' ),
			'HK' => esc_html__( 'Hong Kong', 'learndash' ),
			'HU' => esc_html__( 'Hungary', 'learndash' ),
			'IS' => esc_html__( 'Iceland', 'learndash' ),
			'IN' => esc_html__( 'India', 'learndash' ),
			'ID' => esc_html__( 'Indonesia', 'learndash' ),
			'IR' => esc_html__( 'Iran', 'learndash' ),
			'IQ' => esc_html__( 'Iraq', 'learndash' ),
			'IE' => esc_html__( 'Ireland', 'learndash' ),
			'IM' => esc_html__( 'Isle of Man', 'learndash' ),
			'IL' => esc_html__( 'Israel', 'learndash' ),
			'IT' => esc_html__( 'Italy', 'learndash' ),
			'JM' => esc_html__( 'Jamaica', 'learndash' ),
			'JP' => esc_html__( 'Japan', 'learndash' ),
			'JE' => esc_html__( 'Jersey', 'learndash' ),
			'JO' => esc_html__( 'Jordan', 'learndash' ),
			'KZ' => esc_html__( 'Kazakhstan', 'learndash' ),
			'KE' => esc_html__( 'Kenya', 'learndash' ),
			'KI' => esc_html__( 'Kiribati', 'learndash' ),
			'KP' => esc_html__( 'Korea, North', 'learndash' ),
			'KR' => esc_html__( 'Korea, South', 'learndash' ),
			'KW' => esc_html__( 'Kuwait', 'learndash' ),
			'KG' => esc_html__( 'Kyrgyzstan', 'learndash' ),
			'LA' => esc_html__( 'Laos', 'learndash' ),
			'LV' => esc_html__( 'Latvia', 'learndash' ),
			'LB' => esc_html__( 'Lebanon', 'learndash' ),
			'LS' => esc_html__( 'Lesotho', 'learndash' ),
			'LR' => esc_html__( 'Liberia', 'learndash' ),
			'LY' => esc_html__( 'Libya', 'learndash' ),
			'LI' => esc_html__( 'Liechtenstein', 'learndash' ),
			'LT' => esc_html__( 'Lithuania', 'learndash' ),
			'LU' => esc_html__( 'Luxembourg', 'learndash' ),
			'MO' => esc_html__( 'Macau', 'learndash' ),
			'MK' => esc_html__( 'Macedonia', 'learndash' ),
			'MG' => esc_html__( 'Madagascar', 'learndash' ),
			'MW' => esc_html__( 'Malawi', 'learndash' ),
			'MY' => esc_html__( 'Malaysia', 'learndash' ),
			'MV' => esc_html__( 'Maldives', 'learndash' ),
			'ML' => esc_html__( 'Mali', 'learndash' ),
			'MT' => esc_html__( 'Malta', 'learndash' ),
			'MH' => esc_html__( 'Marshall Islands', 'learndash' ),
			'MQ' => esc_html__( 'Martinique', 'learndash' ),
			'MR' => esc_html__( 'Mauritania', 'learndash' ),
			'MU' => esc_html__( 'Mauritius', 'learndash' ),
			'YT' => esc_html__( 'Mayotte', 'learndash' ),
			'MX' => esc_html__( 'Mexico', 'learndash' ),
			'FM' => esc_html__( 'Micronesia', 'learndash' ),
			'MD' => esc_html__( 'Moldova', 'learndash' ),
			'MC' => esc_html__( 'Monaco', 'learndash' ),
			'MN' => esc_html__( 'Mongolia', 'learndash' ),
			'ME' => esc_html__( 'Montenegro', 'learndash' ),
			'MS' => esc_html__( 'Montserrat', 'learndash' ),
			'MA' => esc_html__( 'Morocco', 'learndash' ),
			'MZ' => esc_html__( 'Mozambique', 'learndash' ),
			'MM' => esc_html__( 'Myanmar', 'learndash' ),
			'NA' => esc_html__( 'Namibia', 'learndash' ),
			'NR' => esc_html__( 'Nauru', 'learndash' ),
			'NP' => esc_html__( 'Nepal', 'learndash' ),
			'NL' => esc_html__( 'Netherlands', 'learndash' ),
			'NC' => esc_html__( 'New Caledonia', 'learndash' ),
			'NZ' => esc_html__( 'New Zealand', 'learndash' ),
			'NI' => esc_html__( 'Nicaragua', 'learndash' ),
			'NE' => esc_html__( 'Niger', 'learndash' ),
			'NG' => esc_html__( 'Nigeria', 'learndash' ),
			'NU' => esc_html__( 'Niue', 'learndash' ),
			'NF' => esc_html__( 'Norfolk Island', 'learndash' ),
			'MP' => esc_html__( 'Northern Mariana Islands', 'learndash' ),
			'NO' => esc_html__( 'Norway', 'learndash' ),
			'OM' => esc_html__( 'Oman', 'learndash' ),
			'PK' => esc_html__( 'Pakistan', 'learndash' ),
			'PW' => esc_html__( 'Palau', 'learndash' ),
			'PS' => esc_html__( 'Palestine', 'learndash' ),
			'PA' => esc_html__( 'Panama', 'learndash' ),
			'PG' => esc_html__( 'Papua New Guinea', 'learndash' ),
			'PY' => esc_html__( 'Paraguay', 'learndash' ),
			'PE' => esc_html__( 'Peru', 'learndash' ),
			'PH' => esc_html__( 'Philippines', 'learndash' ),
			'PN' => esc_html__( 'Pitcairn', 'learndash' ),
			'PL' => esc_html__( 'Poland', 'learndash' ),
			'PT' => esc_html__( 'Portugal', 'learndash' ),
			'PR' => esc_html__( 'Puerto Rico', 'learndash' ),
			'QA' => esc_html__( 'Qatar', 'learndash' ),
			'RE' => esc_html__( 'Reunion', 'learndash' ),
			'RO' => esc_html__( 'Romania', 'learndash' ),
			'RU' => esc_html__( 'Russian Federation', 'learndash' ),
			'RW' => esc_html__( 'Rwanda', 'learndash' ),
			'BL' => esc_html__( 'Saint Barthélemy', 'learndash' ),
			'SH' => esc_html__( 'Saint Helena', 'learndash' ),
			'KN' => esc_html__( 'Saint Kitts and Nevis', 'learndash' ),
			'LC' => esc_html__( 'Saint Lucia', 'learndash' ),
			'MF' => esc_html__( 'Saint Martin (French part)', 'learndash' ),
			'PM' => esc_html__( 'Saint Pierre and Miquelon', 'learndash' ),
			'VC' => esc_html__( 'Saint Vincent and the Grenadines', 'learndash' ),
			'WS' => esc_html__( 'Samoa', 'learndash' ),
			'SM' => esc_html__( 'San Marino', 'learndash' ),
			'ST' => esc_html__( 'Sao Tome and Principe', 'learndash' ),
			'SA' => esc_html__( 'Saudi Arabia', 'learndash' ),
			'SN' => esc_html__( 'Senegal', 'learndash' ),
			'RS' => esc_html__( 'Serbia', 'learndash' ),
			'SC' => esc_html__( 'Seychelles', 'learndash' ),
			'SL' => esc_html__( 'Sierra Leone', 'learndash' ),
			'SG' => esc_html__( 'Singapore', 'learndash' ),
			'SX' => esc_html__( 'Sint Maarten (Dutch part)', 'learndash' ),
			'SK' => esc_html__( 'Slovakia', 'learndash' ),
			'SI' => esc_html__( 'Slovenia', 'learndash' ),
			'SB' => esc_html__( 'Solomon Islands', 'learndash' ),
			'SO' => esc_html__( 'Somalia', 'learndash' ),
			'ZA' => esc_html__( 'South Africa', 'learndash' ),
			'GS' => esc_html__( 'South Georgia and South Sandwich Islands', 'learndash' ),
			'SS' => esc_html__( 'South Sudan', 'learndash' ),
			'ES' => esc_html__( 'Spain', 'learndash' ),
			'LK' => esc_html__( 'Sri Lanka', 'learndash' ),
			'SD' => esc_html__( 'Sudan', 'learndash' ),
			'SR' => esc_html__( 'Suriname', 'learndash' ),
			'SJ' => esc_html__( 'Svalbard and Jan Mayen Islands', 'learndash' ),
			'SZ' => esc_html__( 'Swaziland', 'learndash' ),
			'SE' => esc_html__( 'Sweden', 'learndash' ),
			'CH' => esc_html__( 'Switzerland', 'learndash' ),
			'SY' => esc_html__( 'Syria', 'learndash' ),
			'TW' => esc_html__( 'Taiwan', 'learndash' ),
			'TJ' => esc_html__( 'Tajikistan', 'learndash' ),
			'TZ' => esc_html__( 'Tanzania', 'learndash' ),
			'TH' => esc_html__( 'Thailand', 'learndash' ),
			'TL' => esc_html__( 'Timor-Leste', 'learndash' ),
			'TG' => esc_html__( 'Togo', 'learndash' ),
			'TK' => esc_html__( 'Tokelau', 'learndash' ),
			'TO' => esc_html__( 'Tonga', 'learndash' ),
			'TT' => esc_html__( 'Trinidad and Tobago', 'learndash' ),
			'TN' => esc_html__( 'Tunisia', 'learndash' ),
			'TR' => esc_html__( 'Turkey', 'learndash' ),
			'TM' => esc_html__( 'Turkmenistan', 'learndash' ),
			'TC' => esc_html__( 'Turks and Caicos Islands', 'learndash' ),
			'TV' => esc_html__( 'Tuvalu', 'learndash' ),
			'UG' => esc_html__( 'Uganda', 'learndash' ),
			'UA' => esc_html__( 'Ukraine', 'learndash' ),
			'AE' => esc_html__( 'United Arab Emirates', 'learndash' ),
			'GB' => esc_html__( 'United Kingdom', 'learndash' ),
			'UM' => esc_html__( 'United States Minor Outlying Islands', 'learndash' ),
			'US' => esc_html__( 'United States', 'learndash' ),
			'UY' => esc_html__( 'Uruguay', 'learndash' ),
			'UZ' => esc_html__( 'Uzbekistan', 'learndash' ),
			'VU' => esc_html__( 'Vanuatu', 'learndash' ),
			'VA' => esc_html__( 'Vatican City', 'learndash' ),
			'VE' => esc_html__( 'Venezuela', 'learndash' ),
			'VN' => esc_html__( 'Vietnam', 'learndash' ),
			'VG' => esc_html__( 'Virgin Islands, British', 'learndash' ),
			'VI' => esc_html__( 'Virgin Islands, U.S.', 'learndash' ),
			'WF' => esc_html__( 'Wallis and Futuna Islands', 'learndash' ),
			'EH' => esc_html__( 'Western Sahara', 'learndash' ),
			'YE' => esc_html__( 'Yemen', 'learndash' ),
			'ZM' => esc_html__( 'Zambia', 'learndash' ),
			'ZW' => esc_html__( 'Zimbabwe', 'learndash' ),
		];
	}

	/**
	 * Returns the name of a country.
	 *
	 * @since 4.25.0
	 *
	 * @param string $code The code of the country.
	 *
	 * @return string The name of the country. If the country code is not found, an empty string will be returned.
	 */
	public static function get_name( string $code ): string {
		return Cast::to_string(
			Arr::get( self::get_all(), strtoupper( $code ), '' )
		);
	}
}
