<?php
/**
 * Admin Settings General Appearance section template.
 *
 * @package LearnDash\Core
 *
 * @since 4.21.0
 * @version 4.21.0
 *
 * @var array{ field_html: string, label: string, description: string, feedback_url: string, learn_more_url: string }[] $rows The table row data.
 */

use LearnDash\Core\Template\Template;

?>
<div class="sfwd sfwd_options">
	<table class="learndash-settings-table learndash-settings-table-emails widefat striped" cellspacing="0">
		<thead>
		<tr>
			<th class="col-name-enabled"></th>
			<th class="col-name-modern-ui">
				<span class="col-name-modern-ui-header">
					<?php esc_html_e( 'Modern UI', 'learndash' ); ?>
				</span>
				<?php echo Template::get_admin_template( 'common/badges/beta' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Templates should not be escaped. ?>
			</th>
			<th class="col-name-description"><?php esc_html_e( 'Short Description', 'learndash' ); ?></th>
			<th class="col-name-manage"></th>
		<tr>
		</thead>
		<tbody>
		<?php foreach ( $rows as $row ) : ?>
			<tr>
				<td class="col-name-enabled col-valign-middle">
					<div class="sfwd_option_div">
						<?php echo $row['field_html']; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped, StellarWP.XSS.EscapeOutput.OutputNotEscaped -- This content is generated by the section class and is legitimate HTML. ?>
					</div>
				</td>
				<td class="col-valign-middle">
					<?php echo esc_html( $row['label'] ); ?>
				</td>
				<td class="col-valign-middle">
					<?php echo esc_html( $row['description'] ); ?>
				</td>
				<td class="col-name-manage col-valign-middle">
					<button class="button-action-items button button-secondary">
						<span class="icon dashicons dashicons-ellipsis"></span>
					</button>
					<ul class="action-items action-items--closed">
						<li class="action-item">
							<a href="<?php echo esc_url( $row['learn_more_url'] ); ?>" target="_blank">
								<?php esc_html_e( 'Learn More', 'learndash' ); ?>
							</a>
						</li>
						<li class="action-item">
							<a href="<?php echo esc_url( $row['feedback_url'] ); ?>" target="_blank">
								<?php esc_html_e( 'Give Feedback', 'learndash' ); ?>
							</a>
						</li>
					</ul>
				</td>
			</tr>
		<?php endforeach; ?>
		</tbody>
	</table>
</div>
