<?php
/**
 * View: Stripe logo
 *
 * @var array<string> $classes Additional classes to add to the svg icon.
 *
 * @since 4.16.0
 * @version 4.16.0
 *
 * @package LearnDash\Core
 */

$svg_classes = [ 'ld-svglogo', 'ld-svglogo__stripe' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}
?>
<svg
	class="<?php echo esc_attr( implode( ' ', $svg_classes ) ); ?>"
	aria-label="<?php esc_attr_e( 'Stripe logo', 'learndash' ); ?>"
	role="img"
	width="54"
	height="24"
	viewBox="0 0 54 24"
	fill="none"
	xmlns="http://www.w3.org/2000/svg"
>
	<path fill-rule="evenodd" clip-rule="evenodd" d="M53.9457 13.7193H46.6553C46.8271 15.465 48.1025 16.0259 49.5497 16.0259C51.0332 16.0259 52.2271 15.6912 53.2131 15.1666V18.1696C51.9619 18.8895 50.5302 19.2348 49.0884 19.1645C45.4613 19.1645 42.9105 16.9032 42.9105 12.3987C42.9105 8.60876 45.0724 5.5967 48.609 5.5967C52.1548 5.5967 54 8.56354 54 12.3806C54 12.7424 53.9638 13.5203 53.9457 13.7193ZM48.591 8.6359C47.6593 8.6359 46.6281 9.2962 46.6281 10.9696H50.4724C50.4724 9.2962 49.5045 8.6359 48.591 8.6359ZM37.0402 19.1645C35.7377 19.1645 34.9417 18.6218 34.4171 18.2238L34.399 22.4118L30.6724 23.1987V5.84093H34.0734L34.1457 6.76354C34.9346 6.01531 35.9801 5.59774 37.0673 5.5967C39.6905 5.5967 42.1508 7.94846 42.1508 12.2902C42.1508 17.0208 39.7085 19.1645 37.0402 19.1645ZM36.1809 8.89821C35.3216 8.89821 34.7879 9.20575 34.399 9.63088L34.4171 15.1666C34.7789 15.5645 35.3035 15.8721 36.1809 15.8721C37.5558 15.8721 38.4784 14.3796 38.4784 12.3716C38.4784 10.4269 37.5377 8.89821 36.1809 8.89821ZM25.5437 5.84093H29.2794V18.9022H25.5437V5.84093ZM25.5437 1.58967L29.2794 0.802734V3.84193L25.5437 4.63791V1.59871V1.58967ZM21.6362 10.047V18.9022H17.9095V5.84093H21.2563L21.3648 6.94444C22.2693 5.34344 24.1417 5.66907 24.6392 5.84093V9.26907C24.1688 9.1153 22.5678 8.88012 21.6362 10.047ZM13.9025 14.3163C13.9025 16.5143 16.2543 15.8359 16.7246 15.6369V18.6761C16.2271 18.9475 15.3317 19.1645 14.1106 19.1645C13.6016 19.1794 13.095 19.0905 12.6215 18.9034C12.1479 18.7163 11.7174 18.4348 11.3562 18.076C10.9949 17.7173 10.7103 17.2888 10.5199 16.8166C10.3294 16.3444 10.237 15.8384 10.2482 15.3294L10.2573 3.41681L13.8935 2.63892V5.84093H16.7337V9.03389H13.9025V14.3253V14.3163ZM9.46131 14.9495C9.46131 17.6359 7.37186 19.1645 4.27839 19.1645C2.89024 19.1635 1.51711 18.8772 0.244221 18.3233V14.7686C1.49246 15.447 3.04824 15.9535 4.27839 15.9535C5.11055 15.9535 5.66231 15.7364 5.66231 15.049C5.66231 13.258 0 13.9274 0 9.80273C0 7.17057 2.06231 5.5967 5.08342 5.5967C6.31357 5.5967 7.54372 5.77761 8.78291 6.2751V9.78465C7.63775 9.18195 6.36815 8.85371 5.07437 8.82585C4.29648 8.82585 3.77186 9.05198 3.77186 9.63992C3.77186 11.3133 9.46131 10.5173 9.46131 14.9585V14.9495Z" fill="#635BFF"/>
</svg>
