<?php

if ( ! defined( 'ABSPATH' ) ) exit;

	function wppb_change_colors(){

		$wppb_toolbox_forms_settings = get_option( 'wppb_toolbox_forms_settings' );
		$active_design = wppb_get_active_form_design();

		if( isset( $wppb_toolbox_forms_settings['color-switcher'] ) &&  $wppb_toolbox_forms_settings['color-switcher'] == 'yes' && $active_design !== 'form-style-default' ){


			$wppb_primary_color = ( isset( $wppb_toolbox_forms_settings['primary-color'] ) &&  !empty( $wppb_toolbox_forms_settings['primary-color'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['primary-color'] ) : '';
			$wppb_secondary_color = ( isset( $wppb_toolbox_forms_settings['secondary-color'] ) &&  !empty( $wppb_toolbox_forms_settings['secondary-color'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['secondary-color'] ) : '';
			$wppb_button_text_color = ( isset( $wppb_toolbox_forms_settings['button-text-color'] ) &&  !empty( $wppb_toolbox_forms_settings['button-text-color'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['button-text-color'] ) : '';
			$wppb_label_size = ( isset( $wppb_toolbox_forms_settings['label-size'] ) &&  !empty( $wppb_toolbox_forms_settings['label-size'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['label-size'] ) : '';
			$wppb_label_color = ( isset( $wppb_toolbox_forms_settings['label-color'] ) &&  !empty( $wppb_toolbox_forms_settings['label-color'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['label-color'] ) : '';
			$wppb_label_color_ = ( isset( $wppb_toolbox_forms_settings['label-color'] ) &&  !empty( $wppb_toolbox_forms_settings['label-color'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['label-color'] ) : '';
			$wppb_notifications_text_color = ( isset( $wppb_toolbox_forms_settings['notifications-text-color'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-text-color'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-text-color'] ) : '';
			$wppb_notifications_background_color_success = ( isset( $wppb_toolbox_forms_settings['notifications-background-color-success'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-background-color-success'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-background-color-success'] ) : '';
			$wppb_notifications_background_color_error = ( isset( $wppb_toolbox_forms_settings['notifications-background-color-error'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-background-color-error'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-background-color-error'] ) : '';
			$wppb_notifications_background_color_warning = ( isset( $wppb_toolbox_forms_settings['notifications-background-color-warning'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-background-color-warning'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-background-color-warning'] ) : '';
			$wppb_notifications_background_color_note = ( isset( $wppb_toolbox_forms_settings['notifications-background-color-note'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-background-color-note'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-background-color-note'] ) : '';
			$wppb_notifications_background_color = ( isset( $wppb_toolbox_forms_settings['notifications-background-color'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-background-color'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-background-color'] ) : '';
			$wppb_notifications_border_color_success = ( isset( $wppb_toolbox_forms_settings['notifications-border-color-success'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-border-color-success'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-border-color-success'] ) : '';
			$wppb_notifications_border_color_error = ( isset( $wppb_toolbox_forms_settings['notifications-border-color-error'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-border-color-error'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-border-color-error'] ) : '';
			$wppb_notifications_border_color_warning = ( isset( $wppb_toolbox_forms_settings['notifications-border-color-warning'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-border-color-warning'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-border-color-warning'] ) : '';
			$wppb_notifications_border_color_note = ( isset( $wppb_toolbox_forms_settings['notifications-border-color-note'] ) &&  !empty( $wppb_toolbox_forms_settings['notifications-border-color-note'] ) ) ? esc_attr( $wppb_toolbox_forms_settings['notifications-border-color-note'] ) : '';

			$wppb_custom_colors = ':root {
			                                --wppb-primary-color: '. $wppb_primary_color .' !important;
			                                --wppb-secondary-color: '. $wppb_secondary_color .' !important;
			                                --wppb-button-text-color: '. $wppb_button_text_color .' !important;
			                                --wppb-label-size: '. $wppb_label_size .'px !important;
			                                --wppb-label-color: '. $wppb_label_color .' !important;
			                                --wppb-label-color_: '. $wppb_label_color_ .' !important;
			                                --wppb-notifications-text-color: '. $wppb_notifications_text_color .' !important;
			                                --wppb-notifications-border-color-success: '. $wppb_notifications_border_color_success .' !important;
			                                --wppb-notifications-border-color-error: '. $wppb_notifications_border_color_error .' !important;
			                                --wppb-notifications-border-color-warning: '. $wppb_notifications_border_color_warning .' !important;
			                                --wppb-notifications-border-color-note: '. $wppb_notifications_border_color_note .' !important;';

			if( $active_design === 'form-style-1' ){
				$wppb_custom_colors .= '    --wppb-notifications-background-color-success: '. $wppb_notifications_background_color_success .' !important;
			                                --wppb-notifications-background-color-error: '. $wppb_notifications_background_color_error .' !important;
			                                --wppb-notifications-background-color-warning: '. $wppb_notifications_background_color_warning .' !important;
			                                --wppb-notifications-background-color-note: '. $wppb_notifications_background_color_note .' !important;';
			}
			else{
				$wppb_custom_colors .= '--wppb-notifications-background-color: '. $wppb_notifications_background_color .' !important;';
			}

			$wppb_custom_colors .= '}';

			wp_add_inline_style( 'wppb_form_designs_general_style', $wppb_custom_colors );
			wp_add_inline_style( 'wppb_register_success_notification_style', $wppb_custom_colors );
		}

	}

	add_action( 'wp_print_styles', 'wppb_change_colors', 20 );

function wppb_enqueue_color_switcher_scripts() {
	$active_design = wppb_get_active_form_design();

	if( $active_design !== 'form-style-default' && isset( $_GET['page'] ) && $_GET['page'] === 'profile-builder-toolbox-settings' ){
		wp_register_style( 'wppb_color_switcher_settings_style', WPPB_PAID_PLUGIN_URL.'features/form-designs/css/color-switcher/color-switcher-settings-style.css', array(),PROFILE_BUILDER_VERSION );
		wp_enqueue_style( 'wppb_color_switcher_settings_style' );

		wp_enqueue_script( 'wppb_color_switcher_settings_js', WPPB_PAID_PLUGIN_URL . 'features/form-designs/js/color-switcher-settings.js', array( 'jquery' ), PROFILE_BUILDER_VERSION );

		wp_enqueue_script( 'jquery-ui-dialog' );
		wp_enqueue_style( 'wp-jquery-ui-dialog' );

	}
}
add_action('admin_enqueue_scripts' , 'wppb_enqueue_color_switcher_scripts');

if( isset( $_POST['action'] ) && $_POST['action'] == 'color_switcher_reset_data' ){
	$wppb_toolbox_forms_settings = get_option( 'wppb_toolbox_forms_settings' );

	if( isset( $_POST['reset_primary_color'] ) )
		$wppb_toolbox_forms_settings['primary-color'] = sanitize_text_field( $_POST['reset_primary_color'] );

	if( isset( $_POST['reset_secondary_color'] ) )
		$wppb_toolbox_forms_settings['secondary-color'] = sanitize_text_field( $_POST['reset_secondary_color'] );

	if( isset( $_POST['reset_button_text_color'] ) )
		$wppb_toolbox_forms_settings['button-text-color'] = sanitize_text_field( $_POST['reset_button_text_color'] );

	if( isset( $_POST['reset_label_size'] ) )
		$wppb_toolbox_forms_settings['label-size'] = sanitize_text_field( $_POST['reset_label_size'] );

	if( isset( $_POST['reset_label_color'] ) )
		$wppb_toolbox_forms_settings['label-color'] = sanitize_text_field( $_POST['reset_label_color'] );

	if( isset( $_POST['reset_notifications_text_color'] ) )
		$wppb_toolbox_forms_settings['notifications-text-color'] = sanitize_text_field( $_POST['reset_notifications_text_color'] );

	if( isset( $_POST['reset_notifications_background_color_success'] ) )
		$wppb_toolbox_forms_settings['notifications-background-color-success'] = sanitize_text_field( $_POST['reset_notifications_background_color_success'] );

	if( isset( $_POST['reset_notifications_background_color_error'] ) )
		$wppb_toolbox_forms_settings['notifications-background-color-error'] = sanitize_text_field( $_POST['reset_notifications_background_color_error'] );

	if( isset( $_POST['reset_notifications_background_color_warning'] ) )
		$wppb_toolbox_forms_settings['notifications-background-color-warning'] = sanitize_text_field( $_POST['reset_notifications_background_color_warning'] );

	if( isset( $_POST['reset_notifications_background_color_note'] ) )
		$wppb_toolbox_forms_settings['notifications-background-color-note'] = sanitize_text_field( $_POST['reset_notifications_background_color_note'] );

	if( isset( $_POST['reset_notifications_background_color'] ) )
		$wppb_toolbox_forms_settings['notifications-background-color'] = sanitize_text_field( $_POST['reset_notifications_background_color'] );

	if( isset( $_POST['reset_notifications_border_color_success'] ) )
		$wppb_toolbox_forms_settings['notifications-border-color-success'] = sanitize_text_field( $_POST['reset_notifications_border_color_success'] );

	if( isset( $_POST['reset_notifications_border_color_error'] ) )
		$wppb_toolbox_forms_settings['notifications-border-color-error'] = sanitize_text_field( $_POST['reset_notifications_border_color_error'] );

	if( isset( $_POST['reset_notifications_border_color_warning'] ) )
		$wppb_toolbox_forms_settings['notifications-border-color-warning'] = sanitize_text_field( $_POST['reset_notifications_border_color_warning'] );

	if( isset( $_POST['reset_notifications_border_color_note'] ) )
		$wppb_toolbox_forms_settings['notifications-border-color-note'] = sanitize_text_field( $_POST['reset_notifications_border_color_note'] );

	update_option('wppb_toolbox_forms_settings', $wppb_toolbox_forms_settings);
}
