<?php
/**
 * View: Upload icon.
 *
 * @since 4.24.0
 * @version 4.24.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__upload' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Upload icon', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 21,
		'label'   => $label,
		'width'   => 20,
	],
);
?>

<path d="M16.3008 12.3155C16.8116 12.3155 17.2256 12.7294 17.2256 13.2403V16.4405L17.2129 16.6905C17.1635 17.1856 16.9688 17.6553 16.6533 18.0401L16.4863 18.2256C16.0722 18.6396 15.5288 18.8946 14.9512 18.9522L14.7012 18.9649H3.50098C2.83135 18.9649 2.18834 18.6991 1.71484 18.2256C1.30101 17.8115 1.04575 17.2672 0.988281 16.6895L0.975586 16.4405V13.2403C0.975586 12.7292 1.39073 12.3155 1.90137 12.3155L1.99609 12.3204C2.46224 12.3679 2.82617 12.7615 2.82617 13.2403V16.4405L2.83887 16.5723C2.86483 16.7021 2.92949 16.8221 3.02441 16.917C3.15104 17.0435 3.32222 17.1153 3.50098 17.1153H14.7012L14.833 17.1026C14.9628 17.0767 15.0827 17.0119 15.1777 16.917L15.2627 16.8145C15.3116 16.7411 15.346 16.6587 15.3633 16.5723L15.376 16.4405V13.2403C15.376 12.7295 15.79 12.3156 16.3008 12.3155Z" fill="currentColor"/>
<path d="M9.28125 2.73247L9.32715 2.74516C9.34067 2.74947 9.34642 2.75163 9.35449 2.75395L9.48438 2.79887L9.61426 2.86821L9.68848 2.92387L9.75488 2.98442L13.7559 6.98637L13.8184 7.05571C14.1145 7.41864 14.0937 7.95331 13.7559 8.29204C13.4172 8.63058 12.8799 8.65277 12.5166 8.35649L12.4463 8.29301L10.0264 5.87309V13.2393L10.0215 13.334C9.97691 13.7688 9.63116 14.1148 9.19629 14.1592L9.10156 14.1641C8.62317 14.164 8.22852 13.8001 8.18066 13.334L8.17578 13.2393V5.87211L5.75488 8.29204L5.75586 8.29301C5.39463 8.65412 4.80749 8.65416 4.44629 8.29301C4.08669 7.93211 4.0867 7.34732 4.44629 6.98637L8.44629 2.9854L8.51953 2.92094C8.54431 2.90152 8.56992 2.88357 8.59473 2.86723L8.72656 2.79692C8.77146 2.77779 8.81712 2.76217 8.8623 2.75004L8.88184 2.74418C8.89118 2.74111 8.906 2.7358 8.92285 2.73247L9.0127 2.71977C9.10204 2.71112 9.19265 2.715 9.28125 2.73247Z" fill="currentColor"/>

<?php
$this->template( 'components/icons/icon/end' );
