<?php
/**
 * View: PayPal logo
 *
 * @var array<string> $classes Additional classes to add to the svg icon.
 *
 * @since 4.16.0
 * @version 4.16.0
 *
 * @package LearnDash\Core
 */

$svg_classes = [ 'ld-svglogo', 'ld-svglogo__paypal' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}
?>
<svg
	class="<?php echo esc_attr( implode( ' ', $svg_classes ) ); ?>"
	aria-label="<?php esc_attr_e( 'PayPal logo', 'learndash' ); ?>"
	role="img"
	width="84"
	height="24"
	viewBox="0 0 84 24"
	fill="none"
	xmlns="http://www.w3.org/2000/svg"
>
	<mask id="mask0_7432_1851" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="1" y="0" width="83" height="24">
		<path d="M1.48438 0.998047H83.5079V23.003H1.48438V0.998047Z" fill="white"/>
	</mask>
	<g mask="url(#mask0_7432_1851)">
		<path d="M31.4105 14.3358C32.602 14.3348 33.7539 13.903 34.6584 13.1182C35.5629 12.3333 36.1605 11.2472 36.3432 10.0558C36.7287 7.57233 34.811 5.40433 32.0938 5.40433H27.7145C27.6323 5.40325 27.5526 5.43227 27.4899 5.48603C27.4273 5.53978 27.3859 5.61465 27.3735 5.69683L25.4218 18.2328C25.4147 18.2786 25.4175 18.3254 25.43 18.37C25.4425 18.4146 25.4644 18.4559 25.4941 18.4912C25.5239 18.5264 25.5608 18.5547 25.6024 18.5742C25.644 18.5936 25.6892 18.6037 25.735 18.6038H28.0524C28.1344 18.6047 28.2139 18.5755 28.2764 18.5218C28.3388 18.4681 28.38 18.3933 28.3924 18.3113L28.9666 14.6288C28.9788 14.5466 29.0201 14.4717 29.0826 14.4179C29.1452 14.364 29.2249 14.3349 29.307 14.3358H31.4105ZM33.3499 9.94283C33.2066 10.8608 32.5054 11.5373 31.1634 11.5373H29.4468L29.9671 8.19733H31.6526C33.0411 8.20033 33.4922 9.02883 33.3499 9.94533V9.94283ZM46.3837 9.35283H44.1834C44.1013 9.35186 44.0216 9.38091 43.959 9.43465C43.8963 9.48839 43.855 9.5632 43.8425 9.64533L43.7713 10.1073C43.7713 10.1073 42.0631 8.21983 39.0401 9.49483C37.3058 10.2253 36.4737 11.7348 36.1199 12.8398C36.1199 12.8398 34.9948 16.1988 37.538 18.0483C37.538 18.0483 39.8955 19.8263 42.5508 17.9383L42.5049 18.2328C42.4977 18.2786 42.5005 18.3255 42.513 18.3701C42.5254 18.4147 42.5473 18.4561 42.5771 18.4913C42.6068 18.5266 42.6438 18.5549 42.6854 18.5743C42.727 18.5938 42.7723 18.6038 42.8182 18.6038H45.0175C45.0996 18.6049 45.1794 18.5759 45.242 18.5221C45.3047 18.4684 45.346 18.3935 45.3584 18.3113L46.6965 9.72383C46.7035 9.67803 46.7007 9.63123 46.6882 9.58664C46.6757 9.54205 46.6539 9.50071 46.6241 9.46548C46.5944 9.43024 46.5574 9.40193 46.5158 9.38248C46.4743 9.36304 46.4295 9.35292 46.3837 9.35283ZM43.1487 14.0988C43.0626 14.6972 42.765 15.2436 42.3111 15.6368C41.8571 16.0299 41.2776 16.2431 40.6801 16.2368C40.4461 16.2395 40.2132 16.2049 39.9898 16.1343C39.0411 15.8263 38.5001 14.9033 38.6557 13.9033C38.7419 13.3033 39.0407 12.7555 39.4966 12.3621C39.9524 11.9686 40.5341 11.7563 41.1332 11.7648C41.3674 11.7623 41.6007 11.7973 41.824 11.8678C42.7692 12.1748 43.3068 13.0978 43.1512 14.0988H43.1487Z" fill="#003087"/>
		<path d="M63.091 14.3358C64.2832 14.3355 65.4359 13.904 66.3413 13.1191C67.2467 12.3343 67.845 11.2478 68.0282 10.0558C68.4131 7.57231 66.496 5.40431 63.7778 5.40431H59.3999C59.3179 5.40347 59.2383 5.43258 59.1758 5.48631C59.1133 5.54003 59.072 5.61477 59.0595 5.69681L57.1018 18.2363C57.0906 18.3054 57.1022 18.3763 57.1348 18.438C57.1674 18.4997 57.2192 18.5489 57.2822 18.5778C57.3238 18.5975 57.3691 18.6077 57.4151 18.6078H59.733C59.8151 18.6086 59.8947 18.5795 59.9573 18.5256C60.0198 18.4718 60.0611 18.3969 60.0734 18.3148L60.6481 14.6323C60.6603 14.5501 60.7015 14.4751 60.764 14.4212C60.8266 14.3674 60.9064 14.3383 60.9885 14.3393L63.091 14.3358ZM65.0304 9.94281C64.8871 10.8608 64.186 11.5373 62.8435 11.5373H61.1274L61.6482 8.19731H63.3336C64.7211 8.20031 65.1732 9.02882 65.0304 9.94532V9.94281ZM78.0638 9.35281H75.8659C75.7839 9.35197 75.7043 9.38108 75.6418 9.43481C75.5793 9.48853 75.538 9.56327 75.5255 9.64532L75.4533 10.1073C75.4533 10.1073 73.7457 8.21981 70.7227 9.49481C68.9888 10.2253 68.1562 11.7348 67.8019 12.8398C67.8019 12.8398 66.6773 16.1988 69.22 18.0483C69.22 18.0483 71.578 19.8263 74.2334 17.9383L74.1874 18.2328C74.1762 18.3019 74.1878 18.3728 74.2204 18.4345C74.253 18.4962 74.3048 18.5454 74.3678 18.5743C74.4093 18.5943 74.4547 18.6043 74.5007 18.6043H76.7C76.7822 18.6056 76.8621 18.5765 76.9247 18.5226C76.9873 18.4687 77.0285 18.3936 77.0404 18.3113L78.379 9.72381C78.3856 9.67787 78.3825 9.63102 78.3699 9.58638C78.3573 9.54174 78.3355 9.5003 78.3059 9.46482C78.2762 9.42925 78.2391 9.40076 78.1972 9.3814C78.1553 9.36204 78.1098 9.35228 78.0638 9.35281ZM74.8293 14.0988C74.7442 14.6976 74.4468 15.2446 73.9926 15.638C73.5385 16.0314 72.9584 16.2442 72.3607 16.2368C72.1263 16.2396 71.8931 16.205 71.6694 16.1343C70.7202 15.8263 70.1786 14.9033 70.3343 13.9033C70.4202 13.3049 70.7178 12.7583 71.1718 12.3651C71.6258 11.9718 72.2053 11.7585 72.8029 11.7648C73.0376 11.7623 73.2708 11.7968 73.4942 11.8678C74.4493 12.1748 74.9884 13.0978 74.8317 14.0988H74.8293Z" fill="#0070E0"/>
		<path d="M54.4544 9.56411L51.8025 14.0936L50.457 9.59761C50.4359 9.52626 50.3925 9.46375 50.3334 9.41941C50.2743 9.37507 50.2025 9.35128 50.1289 9.35161H47.7364C47.6952 9.35081 47.6544 9.36015 47.6175 9.37882C47.5806 9.3975 47.5487 9.42495 47.5246 9.45883C47.5005 9.49271 47.4849 9.53199 47.4791 9.57332C47.4733 9.61465 47.4775 9.65679 47.4913 9.69611L49.9026 17.2691L47.7221 20.8381C47.6975 20.8774 47.6837 20.9227 47.6824 20.9692C47.6811 21.0157 47.6922 21.0617 47.7146 21.1024C47.7369 21.143 47.7697 21.1768 47.8095 21.2002C47.8493 21.2235 47.8945 21.2356 47.9405 21.2351H50.5183C50.592 21.2355 50.6646 21.2164 50.7288 21.1798C50.793 21.1431 50.8466 21.0902 50.8844 21.0261L57.6203 9.75011C57.6445 9.71076 57.6578 9.66551 57.6588 9.61915C57.6598 9.57278 57.6484 9.52699 57.6259 9.48662C57.6033 9.44624 57.5704 9.41276 57.5307 9.38971C57.4909 9.36666 57.4457 9.35488 57.3999 9.35561H54.8231C54.749 9.35474 54.6759 9.37353 54.6113 9.41011C54.5466 9.4467 54.4925 9.49979 54.4544 9.56411Z" fill="#003087"/>
		<path d="M80.5361 5.69291L78.5784 18.2324C78.5672 18.3015 78.5788 18.3723 78.6114 18.4341C78.644 18.4958 78.6958 18.5449 78.7587 18.5739C78.8002 18.5939 78.8457 18.6039 78.8916 18.6039H81.2086C81.2907 18.6049 81.3705 18.5758 81.433 18.522C81.4956 18.4681 81.5368 18.3931 81.549 18.3109L83.5072 5.77141C83.5145 5.7256 83.5118 5.67874 83.4994 5.63409C83.4869 5.58944 83.465 5.54808 83.4351 5.51291C83.4052 5.47772 83.3682 5.44945 83.3266 5.43004C83.285 5.41062 83.2397 5.40052 83.1939 5.40041H80.8765C80.7945 5.39956 80.7149 5.42867 80.6524 5.4824C80.5898 5.53613 80.5485 5.61087 80.5361 5.69291Z" fill="#0070E0"/>
		<path d="M18.8481 11.1297C18.351 13.9972 16.039 16.1647 13.0051 16.1647H11.0791C10.6862 16.1647 10.2904 16.5327 10.2277 16.9397L9.38423 22.3572C9.33531 22.6657 9.19251 22.7682 8.88369 22.7682H5.78557C5.4723 22.7682 5.39818 22.6622 5.44513 22.3497L5.80089 18.6032L2.08216 18.4087C1.76938 18.4087 1.65623 18.2362 1.7007 17.9202L4.238 1.64022C4.28691 1.33172 4.47665 1.19922 4.78449 1.19922H11.2194C14.317 1.19922 16.2767 3.30922 16.5163 6.04522C18.3594 7.30522 19.2211 8.98172 18.8486 11.1292L18.8481 11.1297Z" fill="#001C64"/>
		<path d="M6.75107 12.5369L5.80879 18.6034L5.21288 22.4094C5.20181 22.4828 5.20649 22.5577 5.22659 22.6291C5.2467 22.7005 5.28176 22.7666 5.32939 22.8231C5.37702 22.8795 5.4361 22.9249 5.50263 22.9562C5.56915 22.9875 5.64155 23.0039 5.7149 23.0044H8.98695C9.1363 23.0042 9.28069 22.9501 9.39418 22.8519C9.50766 22.7536 9.5828 22.6177 9.60608 22.4684L10.4673 16.9384C10.4907 16.7892 10.5659 16.6533 10.6794 16.5552C10.7928 16.457 10.9372 16.403 11.0865 16.4029H13.0125C14.4802 16.4009 15.8989 15.8685 17.0129 14.9016C18.1269 13.9347 18.8629 12.5969 19.0882 11.1294C19.4217 8.97587 18.351 7.01538 16.5183 6.04688C16.5141 6.27632 16.4943 6.5052 16.459 6.73187C16.2328 8.19863 15.4966 9.53548 14.3828 10.5017C13.269 11.4678 11.8509 11.9998 10.3838 12.0019H7.3697C7.22053 12.0019 7.07627 12.0558 6.96287 12.1539C6.84946 12.252 6.77436 12.3878 6.75107 12.5369Z" fill="#0070E0"/>
		<path d="M5.80345 18.602H1.99331C1.9198 18.6017 1.84723 18.5853 1.78055 18.554C1.71386 18.5227 1.65464 18.4772 1.6069 18.4206C1.55916 18.3641 1.52403 18.2978 1.50391 18.2262C1.48379 18.1547 1.47914 18.0796 1.49029 18.006L4.05773 1.53405C4.08081 1.38477 4.15582 1.24873 4.26924 1.15046C4.38267 1.05219 4.52705 0.998137 4.67636 0.998047H11.2185C14.3161 0.998047 16.5683 3.27905 16.5154 6.04255C15.691 5.61214 14.7754 5.39128 13.8477 5.39905H8.39361C8.24425 5.39908 8.0998 5.45303 7.98622 5.55119C7.87265 5.64934 7.79739 5.78527 7.77399 5.93455L6.74622 12.5355L5.80345 18.602Z" fill="#003087"/>
	</g>
</svg>
