<?php
/**
 * View: Discover logo.
 *
 * @since 4.25.0
 * @version 4.25.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__discover' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Discover logo', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 24,
		'label'   => $label,
		'width'   => 40,
	],
);

?>

<g clip-path="url(#clip0_11282_39297)">
	<path d="M38.833 24H2.167C1.25 24 0.5 23.28 0.5 22.4V1.6C0.5 0.72 1.25 0 2.167 0H38.833C39.75 0 40.5 0.72 40.5 1.6V22.4C40.5 23.28 39.75 24 38.833 24Z" fill="white"/>
	<path d="M39.495 11.75C39.495 11.75 28.022 20.1 7 23.5H38.495C39.047 23.5 39.495 23.052 39.495 22.5V11.75Z" fill="#F48024"/>
	<path d="M5.832 11.7582C5.494 12.0632 5.056 12.1962 4.362 12.1962H4.072V8.55023H4.362C5.056 8.55023 5.477 8.67423 5.832 8.99623C6.202 9.32623 6.427 9.84023 6.427 10.3682C6.427 10.8982 6.203 11.4282 5.832 11.7582ZM4.577 7.61523H3V13.1302H4.57C5.403 13.1302 6.005 12.9332 6.533 12.4932C7.163 11.9732 7.533 11.1882 7.533 10.3772C7.533 8.74923 6.319 7.61523 4.577 7.61523ZM8.03 13.1302H9.104V7.61623H8.03M11.727 9.73223C11.082 9.49223 10.893 9.33523 10.893 9.03723C10.893 8.69023 11.231 8.42723 11.693 8.42723C12.015 8.42723 12.28 8.55923 12.56 8.87323L13.122 8.13623C12.66 7.73123 12.107 7.52423 11.504 7.52423C10.529 7.52423 9.786 8.20223 9.786 9.10423C9.786 9.86423 10.132 10.2542 11.141 10.6172C11.561 10.7652 11.776 10.8642 11.884 10.9312C12.099 11.0712 12.206 11.2712 12.206 11.5012C12.206 11.9492 11.852 12.2812 11.372 12.2812C10.862 12.2812 10.448 12.0232 10.202 11.5452L9.507 12.2152C10.002 12.9412 10.597 13.2652 11.414 13.2652C12.53 13.2652 13.314 12.5202 13.314 11.4532C13.314 10.5772 12.951 10.1802 11.729 9.73323L11.727 9.73223ZM13.65 10.3772C13.65 11.9972 14.92 13.2542 16.557 13.2542C17.019 13.2542 17.415 13.1642 17.904 12.9342V11.6672C17.474 12.0972 17.094 12.2712 16.607 12.2712C15.525 12.2712 14.757 11.4862 14.757 10.3712C14.757 9.31123 15.549 8.47623 16.557 8.47623C17.069 8.47623 17.457 8.65923 17.904 9.09623V7.83023C17.432 7.59023 17.044 7.49023 16.582 7.49023C14.955 7.49023 13.65 8.77323 13.65 10.3772ZM26.422 11.3202L24.954 7.61523H23.78L26.117 13.2712H26.695L29.075 7.61623H27.91M29.56 13.1302H32.606V12.1962H30.633V10.7082H32.533V9.77423H30.633V8.55023H32.606V7.61523H29.56M34.707 10.1542H34.393V8.48423H34.723C35.393 8.48423 35.757 8.76423 35.757 9.30223C35.757 9.85623 35.393 10.1542 34.707 10.1542ZM36.862 9.24424C36.862 8.21124 36.152 7.61623 34.912 7.61623H33.32V13.1302H34.393V10.9152H34.533L36.02 13.1302H37.34L35.607 10.8072C36.417 10.6422 36.862 10.0872 36.862 9.24424Z" fill="#221F20"/>
	<path d="M24.0972 10.3773C24.0972 11.9973 22.7872 13.3073 21.1702 13.3073C19.5532 13.3093 18.2422 11.9973 18.2422 10.3773C18.2422 8.75731 19.5522 7.44531 21.1702 7.44531C22.7882 7.44531 24.0972 8.75731 24.0972 10.3773Z" fill="#F48024"/>
</g>
<defs>
	<clipPath id="clip0_11282_39297">
		<rect width="40" height="24" fill="white" transform="translate(0.5)"/>
	</clipPath>
</defs>

<?php
$this->template( 'components/icons/icon/end' );
