<?php
/**
 * View: JCB logo small.
 *
 * @since 4.25.0
 * @version 4.25.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__jcb-small' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'JCB logo', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 17,
		'label'   => $label,
		'width'   => 26,
	],
);

?>

<g clip-path="url(#clip0_16085_26075)">
	<path d="M24.9164 16.1484H1.08355C0.4875 16.1484 0 15.6684 0 15.0818V1.2151C0 0.628438 0.4875 0.148438 1.08355 0.148438H24.9164C25.5125 0.148438 26 0.628438 26 1.2151V15.0818C26 15.6684 25.5125 16.1484 24.9164 16.1484Z" fill="white"/>
	<path d="M21.6273 1.4885H21.6358V12.8632C21.6332 13.5818 21.3023 14.2652 20.744 14.6938C20.3345 15.0072 19.8561 15.1405 19.353 15.1405C19.0689 15.1405 16.2115 15.1578 16.1972 15.1405C16.1907 15.1338 16.1972 15.0938 16.1972 15.0858V10.5392C16.1972 10.5125 16.1998 10.4965 16.2187 10.4965H19.6331C20.1967 10.4965 20.5067 10.3252 20.7329 10.0898C21.0189 9.79117 21.106 9.31517 20.924 8.93517C20.768 8.60983 20.4456 8.41517 20.1154 8.3265C20.0127 8.29983 19.9074 8.28117 19.8015 8.27117C19.795 8.27117 19.7599 8.27117 19.756 8.26717C19.7365 8.2445 19.7709 8.2405 19.7807 8.2365C19.847 8.2145 19.9204 8.2085 19.9887 8.18783C20.3345 8.0785 20.6341 7.82317 20.7277 7.45117C20.8252 7.0665 20.6952 6.65517 20.3871 6.4165C20.1661 6.24517 19.8879 6.16583 19.6156 6.14117C19.3361 6.11583 16.5125 6.1265 16.2291 6.1265C16.1823 6.1265 16.1966 6.11317 16.1966 6.0665V3.90183C16.1966 3.69517 16.2031 3.49117 16.244 3.2885C16.3259 2.89383 16.5105 2.52583 16.7738 2.2285C17.1365 1.8185 17.6428 1.55517 18.1778 1.49983C18.4885 1.46783 21.3563 1.4885 21.626 1.4885H21.6273ZM18.9883 7.2325C19.0273 7.41383 18.9818 7.6105 18.8557 7.74583C18.7433 7.86317 18.5912 7.9125 18.4345 7.9145C18.3078 7.9165 17.3133 7.9145 17.2723 7.9145L17.2743 6.81783C17.2821 6.79983 17.2873 6.80583 17.3133 6.80583C17.3763 6.80583 18.4267 6.80317 18.4982 6.80917C18.649 6.8225 18.7907 6.88917 18.8869 7.01317C18.9363 7.07717 18.9701 7.15183 18.9877 7.23183L18.9883 7.2325ZM17.2749 8.59117H18.5385C18.6958 8.5925 18.844 8.63317 18.9623 8.74317C19.1092 8.87917 19.1749 9.0865 19.1463 9.2865C19.1203 9.46183 19.0202 9.61983 18.872 9.70917C18.7504 9.78383 18.6185 9.7925 18.482 9.7925H17.2749V8.5925V8.59117Z" fill="#53B230"/>
	<path d="M4.27365 9.40862C4.23465 9.38862 4.23465 9.39662 4.22815 9.36862C4.22425 9.35129 4.2249 3.79196 4.2301 3.66329C4.2561 3.02996 4.54665 2.42529 5.0166 2.01662C5.35265 1.72729 5.7706 1.54329 6.2061 1.49796C6.4635 1.47129 6.72805 1.48596 6.9861 1.48596C7.4346 1.48596 9.6576 1.47729 9.6641 1.48596C9.6693 1.49129 9.6654 12.658 9.6641 12.8686C9.66215 13.506 9.40215 14.1206 8.94585 14.5506C8.61695 14.8606 8.19835 15.064 7.75635 15.124C7.48985 15.1613 4.49335 15.1453 4.2704 15.1453C4.2275 15.1453 4.2353 15.154 4.2275 15.1293C4.221 15.1126 4.2275 10.4626 4.2275 10.3493C4.6565 10.468 5.105 10.536 5.547 10.5813C5.9773 10.626 6.4115 10.6433 6.84245 10.6226C7.44695 10.5933 8.108 10.4946 8.60525 10.1146C8.81325 9.95596 8.97835 9.74596 9.07975 9.49996C9.17595 9.26463 9.20975 9.00929 9.20975 8.75529C9.20975 8.52329 9.21365 6.13529 9.19935 6.12729C9.1844 6.11796 7.3241 6.11729 7.31435 6.13529C7.30655 6.14996 7.31435 8.71529 7.31435 8.76862C7.3124 9.08196 7.21035 9.39062 6.98025 9.60329C6.67605 9.88329 6.25875 9.91662 5.8707 9.88529C5.42415 9.84862 4.98865 9.72196 4.57525 9.54663C4.4732 9.50329 4.37245 9.45662 4.27235 9.40796L4.27365 9.40862Z" fill="#006CB9"/>
	<path d="M10.3673 6.70529C10.351 6.71862 10.3348 6.73195 10.3205 6.74529V4.18195C10.3205 3.98529 10.3127 3.78595 10.327 3.58995C10.405 2.52795 11.2194 1.64129 12.2406 1.50595C12.4889 1.47262 15.7486 1.47795 15.7571 1.48862C15.7636 1.49529 15.7571 1.52995 15.7571 1.53795V12.8426C15.7571 13.712 15.2858 14.5226 14.5286 14.9093C14.201 15.076 13.8493 15.1426 13.4853 15.1426C13.276 15.1426 10.3933 15.1526 10.3432 15.1426C10.3107 15.136 10.3283 15.1493 10.3205 15.1293C10.3159 15.1146 10.3205 10.764 10.3205 10.1693V9.88795C10.6806 10.208 11.1369 10.388 11.5945 10.4933C11.9429 10.5733 12.2991 10.6106 12.654 10.624C13.003 10.6373 13.3534 10.6306 13.7005 10.5993C14.0554 10.566 14.4077 10.5086 14.7567 10.4366C14.8458 10.418 14.9348 10.3986 15.0232 10.3766C15.0447 10.3726 15.1337 10.3653 15.1448 10.3473C15.1532 10.334 15.1448 10.2826 15.1448 10.2673V9.38462C14.7665 9.57929 14.3713 9.73462 13.9553 9.81929C13.4496 9.92262 12.8893 9.95129 12.405 9.73729C11.9162 9.51995 11.625 9.05462 11.5769 8.51262C11.5275 7.95462 11.6894 7.36862 12.1509 7.03795C12.6293 6.69595 13.2559 6.69329 13.8103 6.78462C14.2224 6.85129 14.6196 6.98795 14.9966 7.17129C15.0473 7.19595 15.0967 7.22129 15.1461 7.24662V6.36329C15.1461 6.34995 15.1545 6.29662 15.1461 6.28462C15.1331 6.26595 15.0473 6.25929 15.0239 6.25395C14.981 6.24329 14.9374 6.23395 14.8939 6.22395C14.5468 6.14862 14.1958 6.08729 13.8448 6.04862C13.4983 6.00862 13.1506 5.99729 12.8028 6.00462C12.4505 6.01129 12.0969 6.04062 11.7498 6.10729C11.3195 6.19062 10.8918 6.33195 10.5259 6.58462C10.4706 6.62195 10.4173 6.66262 10.3666 6.70462L10.3673 6.70529Z" fill="#E20138"/>
</g>
<defs>
	<clipPath id="clip0_16085_26075">
		<rect width="26" height="16" fill="white" transform="translate(0 0.148438)"/>
	</clipPath>
</defs>

<?php
$this->template( 'components/icons/icon/end' );
