<?php
/**
 * View: Trash Can Icon.
 *
 * @since 4.24.0
 * @version 4.24.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__trash-can' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Trash can icon', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 15,
		'label'   => $label,
		'width'   => 14,
	],
);
?>

<path d="M8.23711 0.540283C8.72878 0.540369 9.20034 0.735632 9.54805 1.08325C9.89584 1.43105 10.091 1.90311 10.091 2.39497V3.01294H12.5637C12.9051 3.01294 13.1816 3.2895 13.1816 3.63091C13.1816 3.9723 12.9051 4.24888 12.5637 4.24888H11.9457V12.2856C11.9457 12.7775 11.7505 13.2495 11.4027 13.5973C11.0549 13.9451 10.5828 14.1403 10.091 14.1403H3.90977C3.41794 14.1403 2.94584 13.9451 2.59805 13.5973C2.25025 13.2495 2.05508 12.7775 2.05508 12.2856V4.24888H1.43633C1.09503 4.24876 0.818389 3.97222 0.818359 3.63091C0.818359 3.28957 1.09501 3.01305 1.43633 3.01294H3.90977V2.39497C3.90977 1.90311 4.10494 1.43105 4.45273 1.08325C4.80043 0.735627 5.27202 0.540386 5.76367 0.540283H8.23711ZM3.29102 12.2856C3.29102 12.4495 3.35633 12.6072 3.47227 12.7231C3.58819 12.839 3.74584 12.9036 3.90977 12.9036H10.091C10.2549 12.9036 10.4126 12.839 10.5285 12.7231C10.6444 12.6072 10.7098 12.4495 10.7098 12.2856V4.24888H9.48867C9.48351 4.249 9.47824 4.24966 9.47305 4.24966C9.46782 4.24966 9.46262 4.24901 9.45742 4.24888H4.54336C4.53816 4.24901 4.53296 4.24966 4.52773 4.24966C4.52252 4.24966 4.51729 4.24901 4.51211 4.24888H3.29102V12.2856ZM5.76445 6.10356C6.10573 6.10373 6.38242 6.38022 6.38242 6.72153V10.4309C6.38222 10.772 6.1056 11.0487 5.76445 11.0489C5.42317 11.0489 5.14591 10.7721 5.1457 10.4309V6.72153C5.1457 6.38012 5.42304 6.10356 5.76445 6.10356ZM8.23633 6.10356C8.57774 6.10356 8.85508 6.38012 8.85508 6.72153V10.4309C8.85488 10.7721 8.57762 11.0489 8.23633 11.0489C7.89514 11.0488 7.61856 10.7721 7.61836 10.4309V6.72153C7.61836 6.38019 7.89501 6.10368 8.23633 6.10356ZM5.76367 1.777C5.59992 1.7771 5.44278 1.84171 5.32695 1.95747C5.21102 2.0734 5.1457 2.23102 5.1457 2.39497V3.01294H8.85508V2.39497C8.85508 2.23102 8.78976 2.0734 8.67383 1.95747C8.55799 1.84171 8.40087 1.77709 8.23711 1.777H5.76367Z" fill="currentColor"/>

<?php
$this->template( 'components/icons/icon/end' );
