<?php
/**
 * The file that defines the core plugin class
 *
 * @link    https://posimyth.com/
 * @since   6.2.7
 *
 * @package the-plus-addons-for-elementor-page-builder
 */

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;

if ( ! defined( 'WPINC' ) ) {
	exit;
}

/*
 * Equal Height Theplus.
 */
if ( ! class_exists( 'Tpaep_Adv_Magic_Scroll' ) ) {

	/**
	 * Define Tpaep_Adv_Magic_Scroll class
	 *
	 * @since 6.2.7
	 */
	class Tpaep_Adv_Magic_Scroll {

		/**
		 * A reference to an instance of this class.
		 *
		 * @since 6.2.7
		 * @var   object
		 */
		private static $instance = null;

		/**
		 * Returns a singleton instance of the class.
		 *
		 * This method ensures that only one instance of the class is created (singleton pattern).
		 * If an instance doesn't exist, it creates one using the provided shortcodes.
		 *
		 * @since 6.2.7
		 *
		 * @param array $shortcodes Optional. An array of shortcodes to initialize the instance with.
		 * @return self The single instance of the class.
		 */
		public static function get_instance( $shortcodes = array() ) {

			if ( null === self::$instance ) {
				self::$instance = new self( $shortcodes );
			}

			return self::$instance;
		}

		/**
		 * Get the widget name.
		 *
		 * @since 6.2.7
		 */
		public function get_name() {
			return 'plus-adv-magic-scroll';
		}

		/**
		 * Initalize integration hooks
		 *
		 * @since 6.2.7
		 *
		 * @return void
		 */
		public function __construct() {

			// add_action( 'elementor/element/section/section_advanced/after_section_end', array( $this, 'tp_adv_magic_scroll_controls' ), 10, 2 );
			// add_action( 'elementor/element/column/_section_responsive/after_section_end', array( $this, 'tp_adv_magic_scroll_controls' ), 10, 2 );

			if ( \Elementor\Plugin::instance()->experiments->is_feature_active( 'container' ) ) {
				add_action( 'elementor/element/container/section_layout/after_section_end', array( $this, 'tp_adv_magic_scroll_controls' ), 10, 2 );
			}

			add_action( 'elementor/element/common/section_custom_css_pro/after_section_end', array( $this, 'tp_adv_magic_scroll_controls' ), 10, 2 );

			add_filter( 'elementor/widget/render_content', array( $this, 'tp_adv_magic_scroll_before_render' ), 10, 2 );

			// add_action( 'elementor/frontend/before_render', array( $this, 'tp_adv_magic_scroll_before_container_new' ), 10 );
			add_action( 'elementor/frontend/before_render', array( $this, 'tp_adv_magic_scroll_before_container' ), 10 );
			add_action( 'elementor/frontend/after_render', array( $this, 'tp_adv_magic_scroll_after_container' ), 10 );

			add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'tp_enqueue_scripts' ), 10 );
		}

		/**
		 * Register controls for the Advanced Magic Scroll feature.
		 *
		 * @since 6.2.7
		 *
		 * @param \Elementor\Element_Base $widget The widget instance.
		 */
		public function tp_adv_magic_scroll_controls( $widget ) {

			$widget->start_controls_section(
				'plus_magic_scroll_section',
				array(
					'label' => esc_html__( 'Advanced Scroll Interactions', 'theplus' ),
					'tab'   => Controls_Manager::TAB_ADVANCED,
				)
			);
			$widget->add_control(
				'adv_magic_scroll',
				array(
					'label'       => esc_html__( 'Advanced Scroll Interactions', 'theplus' ),
					'type'        => Controls_Manager::SWITCHER,
					'label_on'    => esc_html__( 'Yes', 'theplus' ),
					'label_off'   => esc_html__( 'No', 'theplus' ),
					'render_type' => 'template',
				)
			);
			// $widget->add_control(
			// 	'ms_refresh_button',
			// 	array(
			// 		'label'       => esc_html__( 'Refresh Editor', 'theplus' ),
			// 		'type'        => Controls_Manager::BUTTON,
			// 		'button_type' => 'default',
			// 		'text'        => esc_html__( 'Refresh', 'theplus' ),
			// 		'event'       => 'theplus:iframe:reload',
			// 		'condition'   => array(
			// 			'adv_magic_scroll' => array( 'yes' ),
			// 		),
			// 	)
			// );
			$repeater = new \Elementor\Repeater();
			$repeater->add_control(
				'msitem_name',
				array(
					'label'   => __( 'Item Name', 'theplus' ),
					'type'    => \Elementor\Controls_Manager::TEXT,
					'default' => __( 'Effect 1', 'theplus' ),
					'ai'      => 'false',
				)
			);

			$repeater->add_control(
				'scrollOpttp',
				array(
					'label'        => __( 'Scroll Options', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'triggertp',
					array(
						'label'       => esc_html__( 'Trigger', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'separator'   => 'before',
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 1,
								'step' => 0.01,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0.5,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'scrollOpttp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'durationtp',
					array(
						'label'       => esc_html__( 'Duration', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'separator'   => 'before',
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 2000,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 300,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'scrollOpttp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'offsettp',
					array(
						'label'       => esc_html__( 'Offset', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'separator'   => 'before',
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 500,
								'step' => 5,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'scrollOpttp' => array( 'yes' ),
						),
					)
				);

				$repeater->add_control(
					'dynamicHeighttp',
					array(
						'label'        => __( 'Dynamic Height', 'theplus' ),
						'type'         => Controls_Manager::SWITCHER,
						'label_off'    => __( 'No', 'theplus' ),
						'label_on'     => __( 'Yes', 'theplus' ),
						'return_value' => 'yes',
						'default'      => 'no',
						'separator'    => 'before',
					)
				);
					$repeater->add_responsive_control(
						'referenceHeighttp',
						array(
							'label'       => esc_html__( 'Reference Height (px)', 'theplus' ),
							'type'        => Controls_Manager::NUMBER,
							'separator'   => 'before',
							'min'         => 100,
							'max'         => 5000,
							'step'        => 10,
							'default'     => 1080,
							'description' => sprintf(
								wp_kses(
									__( 'Click <a href="https://viewportsizer.com/what-is-my-screen-size/" target="_blank" rel="noopener noreferrer">here</a> to check your screen size', 'theplus' ),
									array(
										'a' => array(
											'href'   => array(),
											'target' => array(),
											'rel'    => array(),
										),
									)
								)
							),
							'condition'   => array(
								'dynamicHeighttp' => array( 'yes' ),
							),
						)
					);

			$repeater->end_popover();

			$repeater->add_control(
				'motion_category',
				array(
					'label'        => esc_html__( 'Motion', 'theplus' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Show', 'theplus' ),
					'label_off'    => esc_html__( 'Hide', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'yes',
					'separator'    => 'before',
				)
			);

			$repeater->add_control(
				'verticaltp',
				array(
					'label'        => __( 'Vertical', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => array(
						'motion_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'speedtpvs',
					array(
						'label'       => esc_html__( 'Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'separator'   => 'before',
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -200,
								'max'  => 200,
								'step' => 2,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'verticaltp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'speedtpve',
					array(
						'label'       => esc_html__( 'End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'separator'   => 'before',
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -200,
								'max'  => 200,
								'step' => 2,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 20,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'verticaltp' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'horizontaltp',
				array(
					'label'        => __( 'Horizontal', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => array(
						'motion_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'speedtphs',
					array(
						'label'       => esc_html__( 'Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'separator'   => 'before',
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -200,
								'max'  => 200,
								'step' => 2,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'horizontaltp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'speedtphe',
					array(
						'label'       => esc_html__( 'End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -200,
								'max'  => 200,
								'step' => 2,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 20,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'horizontaltp' => array( 'yes' ),
						),
					)
				);
						$repeater->end_popover();

			$repeater->add_control(
				'rotatetp',
				array(
					'label'        => __( 'Rotate', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => array(
						'motion_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_control(
					'positiontpr',
					array(
						'label'     => esc_html__( 'Position', 'theplus' ),
						'type'      => Controls_Manager::SELECT,
						'default'   => 'center center',
						'options'   => array(
							'left top'      => esc_html__( 'Left Top', 'theplus' ),
							'left center'   => esc_html__( 'Left Center', 'theplus' ),
							'left bottom'   => esc_html__( 'Left Bottom', 'theplus' ),
							'center top'    => esc_html__( 'Center Top', 'theplus' ),
							'center center' => esc_html__( 'Center Center', 'theplus' ),
							'center bottom' => esc_html__( 'Center Bottom', 'theplus' ),
							'right top'     => esc_html__( 'Right Top', 'theplus' ),
							'right center'  => esc_html__( 'Right Center', 'theplus' ),
							'right bottom'  => esc_html__( 'Right Bottom', 'theplus' ),
						),
						'condition' => array(
							'rotatetp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'rotateXtprs',
					array(
						'label'       => esc_html__( 'Rotate X Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'deg' ),
						'range'       => array(
							'deg' => array(
								'min'  => -360,
								'max'  => 360,
								'step' => 2,
							),
						),
						'default'     => array(
							'unit' => 'deg',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'rotatetp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'rotateXtpre',
					array(
						'label'       => esc_html__( 'Rotate X End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'deg' ),
						'range'       => array(
							'deg' => array(
								'min'  => -360,
								'max'  => 360,
								'step' => 2,
							),
						),
						'default'     => array(
							'unit' => 'deg',
							'size' => 44,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'rotatetp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'rotateYtprs',
					array(
						'label'       => esc_html__( 'Rotate Y Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'deg' ),
						'range'       => array(
							'deg' => array(
								'min'  => -360,
								'max'  => 360,
								'step' => 2,
							),
						),
						'default'     => array(
							'unit' => 'deg',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'rotatetp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'rotateYtpre',
					array(
						'label'       => esc_html__( 'Rotate Y End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'deg' ),
						'range'       => array(
							'deg' => array(
								'min'  => -360,
								'max'  => 360,
								'step' => 2,
							),
						),
						'default'     => array(
							'unit' => 'deg',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'rotatetp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'rotateZtprs',
					array(
						'label'       => esc_html__( 'Rotate Z Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'deg' ),
						'range'       => array(
							'deg' => array(
								'min'  => -360,
								'max'  => 360,
								'step' => 2,
							),
						),
						'default'     => array(
							'unit' => 'deg',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'rotatetp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'rotateZtpre',
					array(
						'label'       => esc_html__( 'Rotate Z End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'deg' ),
						'range'       => array(
							'deg' => array(
								'min'  => -360,
								'max'  => 360,
								'step' => 2,
							),
						),
						'default'     => array(
							'unit' => 'deg',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'rotatetp' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'scaletp',
				array(
					'label'        => __( 'Scale', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => array(
						'motion_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'scaleXtpss',
					array(
						'label'       => esc_html__( 'Scale X Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -10,
								'max'  => 0,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 0,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 1,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'scaletp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'scaleXtpse',
					array(
						'label'       => esc_html__( 'Scale X End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 10,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 1.5,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'scaletp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'scaleYtpss',
					array(
						'label'       => esc_html__( 'Scale Y Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -10,
								'max'  => 0,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 0,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 1,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'scaletp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'scaleYtpse',
					array(
						'label'       => esc_html__( 'Scale Y End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 10,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 1,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'scaletp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'scaleZtps',
					array(
						'label'       => esc_html__( 'Scale Z Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -10,
								'max'  => 0,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 0,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 1,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'scaletp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'scaleZtpe',
					array(
						'label'       => esc_html__( 'Scale Z End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 10,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 1,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'scaletp' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'skewtp',
				array(
					'label'        => __( 'Skew', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => array(
						'motion_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'skewXtpss',
					array(
						'label'       => esc_html__( 'SkewX Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -10,
								'max'  => 0,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 0,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'skewtp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'skewXtpse',
					array(
						'label'       => esc_html__( 'SkewX End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 10,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 1,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'skewtp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'skewYtpss',
					array(
						'label'       => esc_html__( 'SkewY Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -10,
								'max'  => 0,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 0,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'skewtp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'skewYtpse',
					array(
						'label'       => esc_html__( 'SkewY End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 10,
								'step' => 0.01,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'skewtp' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'appearance_category',
				array(
					'label'        => esc_html__( 'Appearance', 'theplus' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Show', 'theplus' ),
					'label_off'    => esc_html__( 'Hide', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'yes',
				)
			);

			$repeater->add_control(
				'opacitytp',
				array(
					'label'        => __( 'Opacity', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => array(
						'appearance_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'speedtpos',
					array(
						'label'       => esc_html__( 'Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 1,
								'step' => 0.05,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'opacitytp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'speedtpoe',
					array(
						'label'       => esc_html__( 'End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 1,
								'step' => 0.05,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 1,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'opacitytp' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'paddingms',
				array(
					'label'     => __( 'Padding', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'default'   => '',
					'condition' => array(
						'appearance_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'paddingValuemsStart',
					array(
						'label'      => esc_html__( 'Padding Start', 'theplus' ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => array( 'px', '%', 'em' ),
						'default'    => array(
							'top'    => '',
							'right'  => '',
							'bottom' => '',
							'left'   => '',
							'unit'   => 'px',
						),
						'condition'  => array(
							'paddingms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'paddingValuemsEnd',
					array(
						'label'      => esc_html__( 'Padding End', 'theplus' ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => array( 'px', '%', 'em' ),
						'default'    => array(
							'top'    => '',
							'right'  => '',
							'bottom' => '',
							'left'   => '',
							'unit'   => 'px',
						),
						'condition'  => array(
							'paddingms' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'colorms',
				array(
					'label'     => __( 'Color', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'condition' => array(
						'appearance_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'colorValueStartms',
					array(
						'label'     => esc_html__( 'Color Start', 'theplus' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#000000',
						'condition' => array(
							'colorms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'colorValueEndms',
					array(
						'label'     => esc_html__( 'Color End', 'theplus' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#000000',
						'condition' => array(
							'colorms' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();
			$repeater->add_control(
				'fontsizems',
				array(
					'label'     => __( 'Font Size', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'default'   => '',
					'condition' => array(
						'appearance_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'fontSizeValueStartms',
					array(
						'label'       => esc_html__( 'Font Size Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%', 'em' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 200,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 200,
								'step' => 1,
							),
							'em' => array(
								'min'  => 0,
								'max'  => 20,
								'step' => 0.1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 16,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'fontsizems' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'fontSizeValueEndms',
					array(
						'label'       => esc_html__( 'Font Size End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%', 'em' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 200,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 200,
								'step' => 1,
							),
							'em' => array(
								'min'  => 0,
								'max'  => 20,
								'step' => 0.1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 16,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'fontsizems' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'letterspacingms',
				array(
					'label'     => __( 'Letter Spacing', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'default'   => '',
					'condition' => array(
						'appearance_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'letterSpacingValueStartms',
					array(
						'label'       => esc_html__( 'Letter Spacing Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%', 'em' ),
						'range'       => array(
							'px' => array(
								'min'  => -10,
								'max'  => 50,
								'step' => 0.1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
							'em' => array(
								'min'  => -2,
								'max'  => 5,
								'step' => 0.1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'letterspacingms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'letterSpacingValueEndms',
					array(
						'label'       => esc_html__( 'Letter Spacing End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%', 'em' ),
						'range'       => array(
							'px' => array(
								'min'  => -10,
								'max'  => 50,
								'step' => 0.1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
							'em' => array(
								'min'  => -2,
								'max'  => 5,
								'step' => 0.1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'letterspacingms' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'textshadowms',
				array(
					'label'     => __( 'Text Shadow', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'default'   => '',
					'condition' => array(
						'appearance_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_control(
					'labelTextShadowStartms',
					array(
						'label'     => esc_html__( 'Start', 'theplus' ),
						'type'      => Controls_Manager::HEADING,
						'separator' => 'before',
						'condition' => array(
							'textshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'textShadowHStartms',
					array(
						'label'       => esc_html__( 'Horizontal Offset', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -50,
								'max'  => 50,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'textshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'textShadowVStartms',
					array(
						'label'       => esc_html__( 'Vertical Offset', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -50,
								'max'  => 50,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'textshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'textShadowBlurStartms',
					array(
						'label'       => esc_html__( 'Blur', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 50,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 10,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'textshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'textShadowColorStartms',
					array(
						'label'     => esc_html__( 'Shadow Color', 'theplus' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#000000',
						'condition' => array(
							'textshadowms' => array( 'yes' ),
						),
					)
				);

				$repeater->add_control(
					'labelTextShadowEndms',
					array(
						'label'     => esc_html__( 'End', 'theplus' ),
						'type'      => Controls_Manager::HEADING,
						'separator' => 'before',
						'condition' => array(
							'textshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'textShadowHEndms',
					array(
						'label'      => esc_html__( 'Horizontal Offset', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => -50,
								'max'  => 50,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'textshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'textShadowVEndms',
					array(
						'label'      => esc_html__( 'Vertical Offset', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => -50,
								'max'  => 50,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'textshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'textShadowColorEndms',
					array(
						'label'     => esc_html__( 'Shadow Color', 'theplus' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#000000',
						'condition' => array(
							'textshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'textShadowBlurEndms',
					array(
						'label'      => esc_html__( 'Blur', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => 0,
								'max'  => 50,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'boxshadowms',
				array(
					'label'     => __( 'Box Shadow', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'default'   => '',
					'condition' => array(
						'appearance_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();

			$repeater->add_control(
				'labelBoxShadowStartms',
				array(
					'label'     => esc_html__( 'Start', 'theplus' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
					'condition' => array(
						'boxshadowms' => array( 'yes' ),
					),
				)
			);

				$repeater->add_responsive_control(
					'boxShadowHOffsetStartms',
					array(
						'label'      => esc_html__( 'Horizontal Offset', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'boxShadowVOffsetStartms',
					array(
						'label'      => esc_html__( 'Vertical Offset', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'boxShadowBlurStartms',
					array(
						'label'      => esc_html__( 'Blur', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'boxShadowSpreadStartms',
					array(
						'label'      => esc_html__( 'Spread Radius', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'boxShadowColorStartms',
					array(
						'label'     => esc_html__( 'Shadow Color', 'theplus' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#000000',
						'condition' => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'boxShadowPositionStartms',
					array(
						'label'     => esc_html__( 'Shadow Position', 'theplus' ),
						'type'      => Controls_Manager::SELECT,
						'default'   => '',
						'options'   => array(
							''      => esc_html__( 'Outline', 'theplus' ),
							'inset' => esc_html__( 'Inset', 'theplus' ),
						),
						'condition' => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'labelBoxShadowEndms',
					array(
						'label'     => esc_html__( 'End', 'theplus' ),
						'type'      => Controls_Manager::HEADING,
						'separator' => 'before',
						'condition' => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'boxShadowHOffsetEndms',
					array(
						'label'      => esc_html__( 'Horizontal Offset', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'boxShadowVOffsetEndms',
					array(
						'label'      => esc_html__( 'Vertical Offset', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'boxShadowBlurEndms',
					array(
						'label'      => esc_html__( 'Blur', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'boxShadowSpreadEndms',
					array(
						'label'      => esc_html__( 'Spread Radius', 'theplus' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => array( 'px', '%' ),
						'range'      => array(
							'px' => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 0,
						),
						'condition'  => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'boxShadowColorEndms',
					array(
						'label'     => esc_html__( 'Shadow Color', 'theplus' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#000000',
						'condition' => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'boxShadowPositionEndms',
					array(
						'label'     => esc_html__( 'Shadow Position', 'theplus' ),
						'type'      => Controls_Manager::SELECT,
						'default'   => '',
						'options'   => array(
							''      => esc_html__( 'Outline', 'theplus' ),
							'inset' => esc_html__( 'Inset', 'theplus' ),
						),
						'condition' => array(
							'boxshadowms' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'borderRtp',
				array(
					'label'        => __( 'Border Radius', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => array(
						'appearance_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'fromBRtp',
					array(
						'label'      => esc_html__( 'Start Border Radius', 'theplus' ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => array( 'px', '%' ),
						'condition'  => array(
							'borderRtp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'toBRtp',
					array(
						'label'      => esc_html__( 'End Border Radius', 'theplus' ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => array( 'px', '%' ),
						'condition'  => array(
							'borderRtp' => array( 'yes' ),
						),
					)
				);

			$repeater->end_popover();

			$repeater->add_control(
				'bgColortp',
				array(
					'label'        => __( 'Background Color', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => array(
						'appearance_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_control(
					'fromColortp',
					array(
						'label'     => esc_html__( 'Start Color', 'theplus' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '',
						'condition' => array(
							'bgColortp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'toColortp',
					array(
						'label'     => esc_html__( 'End Color', 'theplus' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '',
						'condition' => array(
							'bgColortp' => array( 'yes' ),
						),
					)
				);

			$repeater->end_popover();

			$repeater->add_control(
				'visual_effects_category',
				array(
					'label'        => esc_html__( 'Visual Effects', 'theplus' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Show', 'theplus' ),
					'label_off'    => esc_html__( 'Hide', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'yes',
				)
			);

			$repeater->add_control(
				'blurms',
				array(
					'label'     => __( 'Blur', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'default'   => '',
					'condition' => array(
						'visual_effects_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'blurValueStartms',
					array(
						'label'       => esc_html__( 'Blur Value Start', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 10,
								'step' => 0.1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'blurms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'blurValueEndms',
					array(
						'label'       => esc_html__( 'Blur Value End', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => 0,
								'max'  => 10,
								'step' => 0.1,
							),
							'%'  => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'blurms' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'grayscalems',
				array(
					'label'     => __( 'Grayscale', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'default'   => '',
					'condition' => array(
						'visual_effects_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'grayscaleValueStartms',
					array(
						'label'       => esc_html__( 'Grayscale Start (%)', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'separator'   => 'before',
						'range'       => array(
							'%' => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'grayscalems' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'grayscaleValueEndms',
					array(
						'label'       => esc_html__( 'Grayscale End (%)', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'separator'   => 'before',
						'range'       => array(
							'%' => array(
								'min'  => 0,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'size' => 0,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'grayscalems' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'brightnessms',
				array(
					'label'     => __( 'Brightness', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'default'   => '',
					'condition' => array(
						'visual_effects_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
			$repeater->add_responsive_control(
				'brightnessValueStartms',
				array(
					'label'       => esc_html__( 'Brightness Start (%)', 'theplus' ),
					'type'        => Controls_Manager::SLIDER,
					'separator'   => 'before',
					'range'       => array(
						'%' => array(
							'min'  => 0,
							'max'  => 200,
							'step' => 1,
						),
					),
					'default'     => array(
						'size' => 100,
					),
					'render_type' => 'ui',
					'condition'   => array(
						'brightnessms' => array( 'yes' ),
					),
				)
			);
				$repeater->add_responsive_control(
					'brightnessValueEndms',
					array(
						'label'       => esc_html__( 'Brightness End (%)', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'separator'   => 'before',
						'range'       => array(
							'%' => array(
								'min'  => 0,
								'max'  => 200,
								'step' => 1,
							),
						),
						'default'     => array(
							'size' => 100,
						),
						'render_type' => 'ui',
						'condition'   => array(
							'brightnessms' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'advanced_category',
				array(
					'label'        => esc_html__( 'Advanced', 'theplus' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Show', 'theplus' ),
					'label_off'    => esc_html__( 'Hide', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'yes',
				)
			);

			$repeater->add_control(
				'playvideoms',
				array(
					'label'     => __( 'Play Video', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'condition' => array(
						'advanced_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_control(
					'videoSelectorMs',
					array(
						'label'       => __( 'Video Selector (CSS)', 'theplus' ),
						'type'        => Controls_Manager::TEXT,
						'default'     => '.tp-video-element',
						'description' => __( 'CSS selector of the video element to play on scroll.', 'theplus' ),
						'condition'   => array(
							'playvideoms' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'drawsvgms',
				array(
					'label'     => __( 'Draw SVG', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'condition' => array(
						'advanced_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_control(
					'svgSelectorMs',
					array(
						'label'       => __( 'SVG Selector (CSS)', 'theplus' ),
						'type'        => Controls_Manager::TEXT,
						'default'     => '.tp-svg-path',
						'description' => __( 'CSS selector for SVG path to animate.', 'theplus' ),
						'condition'   => array(
							'drawsvgms' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'parallaxms',
				array(
					'label'     => __( 'Parallax Effect', 'theplus' ),
					'type'      => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'Enable', 'theplus' ),
					'label_on'  => __( 'Disable', 'theplus' ),
					'condition' => array(
						'advanced_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'parallaxXms',
					array(
						'label'       => __( 'Horizontal Movement (X)', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -200,
								'max'  => 200,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'description' => __( 'Positive values move right, negative values move left. Creates depth illusion.', 'theplus' ),
						'condition'   => array(
							'parallaxms' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'parallaxYms',
					array(
						'label'       => __( 'Vertical Movement (Y)', 'theplus' ),
						'type'        => Controls_Manager::SLIDER,
						'size_units'  => array( 'px', '%' ),
						'range'       => array(
							'px' => array(
								'min'  => -200,
								'max'  => 200,
								'step' => 1,
							),
							'%'  => array(
								'min'  => -100,
								'max'  => 100,
								'step' => 1,
							),
						),
						'default'     => array(
							'unit' => 'px',
							'size' => 0,
						),
						'description' => __( 'Positive values move down, negative values move up. Creates depth illusion.', 'theplus' ),
						'condition'   => array(
							'parallaxms' => array( 'yes' ),
						),
					)
				);
			$repeater->end_popover();

			$repeater->add_control(
				'advOptiontp',
				array(
					'label'        => __( 'Advanced Options', 'theplus' ),
					'type'         => Controls_Manager::POPOVER_TOGGLE,
					'label_off'    => __( 'Enable', 'theplus' ),
					'label_on'     => __( 'Disable', 'theplus' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'condition'    => array(
						'advanced_category' => array( 'yes' ),
					),
				)
			);
			$repeater->start_popover();
				$repeater->add_responsive_control(
					'repeattpa',
					array(
						'label'     => esc_html__( 'Repeat', 'theplus' ),
						'type'      => Controls_Manager::NUMBER,
						'min'       => -1,
						'max'       => 50,
						'step'      => 1,
						'default'   => 0,
						'dynamic'   => array(
							'active' => true,
						),
						'condition' => array(
							'advOptiontp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_control(
					'easingtpa',
					array(
						'label'     => esc_html__( 'Easing', 'theplus' ),
						'type'      => Controls_Manager::SELECT,
						'default'   => '',
						'options'   => array(
							''                    => esc_html__( 'Default', 'theplus' ),
							'none'                => esc_html__( 'None (Linear)', 'theplus' ),
							'power1.in'           => esc_html__( 'Power1 In', 'theplus' ),
							'power1.out'          => esc_html__( 'Power1 Out', 'theplus' ),
							'power1.inOut'        => esc_html__( 'Power1 InOut', 'theplus' ),
							'power2.in'           => esc_html__( 'Power2 In', 'theplus' ),
							'power2.out'          => esc_html__( 'Power2 Out', 'theplus' ),
							'power2.inOut'        => esc_html__( 'Power2 InOut', 'theplus' ),
							'power3.in'           => esc_html__( 'Power3 In', 'theplus' ),
							'power3.out'          => esc_html__( 'Power3 Out', 'theplus' ),
							'power3.inOut'        => esc_html__( 'Power3 InOut', 'theplus' ),
							'back.in'             => esc_html__( 'Back In', 'theplus' ),
							'back.out'            => esc_html__( 'Back Out', 'theplus' ),
							'back.inOut'          => esc_html__( 'Back InOut', 'theplus' ),
							'circ.in'             => esc_html__( 'Circ In', 'theplus' ),
							'circ.out'            => esc_html__( 'Circ Out', 'theplus' ),
							'circ.inOut'          => esc_html__( 'Circ InOut', 'theplus' ),
							'expo.in'             => esc_html__( 'Expo In', 'theplus' ),
							'expo.out'            => esc_html__( 'Expo Out', 'theplus' ),
							'expo.inOut'          => esc_html__( 'Expo InOut', 'theplus' ),
							'elastic.out'         => esc_html__( 'Elastic Out', 'theplus' ),
							'bounce.out'          => esc_html__( 'Bounce Out', 'theplus' ),
							'rough'               => esc_html__( 'Rough (Random)', 'theplus' ),
							'slow(0.7,0.7,false)' => esc_html__( 'SlowMo Style', 'theplus' ),
						),
						'condition' => array(
							'advOptiontp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'timingtpa',
					array(
						'label'     => esc_html__( 'Timing', 'theplus' ),
						'type'      => Controls_Manager::NUMBER,
						'min'       => 0,
						'max'       => 20,
						'step'      => 0.01,
						'default'   => 1,
						'dynamic'   => array(
							'active' => true,
						),
						'condition' => array(
							'advOptiontp' => array( 'yes' ),
						),
					)
				);
				$repeater->add_responsive_control(
					'delaytpa',
					array(
						'label'     => esc_html__( 'Delay', 'theplus' ),
						'type'      => Controls_Manager::NUMBER,
						'min'       => 0,
						'max'       => 20,
						'step'      => 0.01,
						'default'   => 0,
						'dynamic'   => array(
							'active' => true,
						),
						'condition' => array(
							'advOptiontp' => array( 'yes' ),
						),
					)
				);
				// $repeater->add_control(
				// 	'reversetpa',
				// 	array(
				// 		'label'     => esc_html__( 'Reverse', 'theplus' ),
				// 		'type'      => Controls_Manager::SWITCHER,
				// 		'label_on'  => esc_html__( 'Show', 'theplus' ),
				// 		'label_off' => esc_html__( 'Hide', 'theplus' ),
				// 		'default'   => 'yes',
				// 		'condition' => array(
				// 			'advOptiontp' => array( 'yes' ),
				// 		),
				// 	)
				// );
			$repeater->end_popover();

			$repeater->add_control(
				'stickytp',
				array(
					'label'     => esc_html__( 'Sticky', 'theplus' ),
					'type'      => Controls_Manager::SWITCHER,
					'label_on'  => esc_html__( 'Show', 'theplus' ),
					'label_off' => esc_html__( 'Hide', 'theplus' ),
					'default'   => 'no',
					'condition' => array(
						'advanced_category' => array( 'yes' ),
					),
				)
			);

			$repeater->add_responsive_control(
				'zindexsticky',
				array(
					'label'     => esc_html__( 'Z-Index', 'theplus' ),
					'type'      => Controls_Manager::NUMBER,
					'min'       => 0,
					'max'       => 9999,
					'step'      => 1,
					'default'   => 0,
					'dynamic'   => array(
						'active' => true,
					),
					'condition' => array(
						'stickytp' => array( 'yes' ),
					),
				)
			);

			$repeater->add_control(
				'selectortp',
				array(
					'label'       => esc_html__( 'Custom Selector', 'theplus' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => '',
					'label_block' => true,
					'ai'          => 'false',
					'condition'   => array(
						'advanced_category' => array( 'yes' ),
					),
				)
			);

			$repeater->add_control(
				'developtp',
				array(
					'label'     => esc_html__( 'Developer', 'theplus' ),
					'type'      => Controls_Manager::SWITCHER,
					'label_on'  => esc_html__( 'Show', 'theplus' ),
					'label_off' => esc_html__( 'Hide', 'theplus' ),
					'default'   => 'no',
					'separator' => 'before',
				)
			);
			$repeater->add_control(
				'devNametp',
				array(
					'label'       => esc_html__( 'Trigger Name', 'theplus' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => '',
					'placeholder' => esc_html__( 'You can set your unique start and end trigger name.', 'theplus' ),
					'condition'   => array(
						'developtp' => array( 'yes' ),
					),
				)
			);

			$widget->add_control(
				'MSFrame',
				array(
					'label'       => esc_html__( 'Add Frame', 'theplus' ),
					'type'        => Controls_Manager::REPEATER,
					'default'     => array(
						array(
							'msitem_name' => __( 'Effect 1', 'theplus' ),
						),
					),
					'title_field' => '{{{ msitem_name }}}',
					'fields'      => $repeater->get_controls(),
					'condition'   => array(
						'adv_magic_scroll' => array( 'yes' ),
					),
				)
			);

			$widget->add_control(
				'MSView',
				array(
					'label'       => esc_html__( 'Visibility', 'theplus' ),
					'type'        => Controls_Manager::SELECT2,
					'default'     => array( 'md', 'sm', 'xs' ),
					'multiple'    => true,
					'options'     => array(
						'md' => esc_html__( 'Desktop', 'theplus' ),
						'sm' => esc_html__( 'Tablet', 'theplus' ),
						'xs' => esc_html__( 'Mobile', 'theplus' ),
					),
					'condition'   => array(
						'adv_magic_scroll' => array( 'yes' ),
					),
					'label_block' => true,
				)
			);

			$widget->end_controls_section();
		}

		/**
		 * Enqueue necessary scripts and styles for the widget.
		 *
		 * @since 6.2.7
		 */
		public function tp_enqueue_scripts() {
			wp_enqueue_script( 'plus-adv-magic-scroll-gsap', THEPLUS_URL . 'assets/js/extra/gsap/gsap.min.js', array( 'jquery' ), THEPLUS_VERSION, true );

			wp_enqueue_script( 'plus-adv-magic-scroll-gsap-st', THEPLUS_URL . 'assets/js/extra/gsap/ScrollTrigger.min.js', array( 'jquery', 'plus-adv-magic-scroll-gsap' ), THEPLUS_VERSION, true );
			wp_enqueue_script( 'plus-adv-magic-scroll-gsap-sp', THEPLUS_URL . 'assets/js/extra/gsap/ScrollToPlugin.min.js', array( 'jquery', 'plus-adv-magic-scroll-gsap' ), THEPLUS_VERSION, true );

			wp_enqueue_script( 'plus-adv-magic-scroll', THEPLUS_URL . 'modules/extensions/adv-magic-scroll/plus-magic-scroll-advance.js', array( 'jquery', 'plus-adv-magic-scroll-gsap', 'plus-adv-magic-scroll-gsap-st', 'plus-adv-magic-scroll-gsap-sp' ), THEPLUS_VERSION, true );
		}

		/**
		 * Apply Advanced Magic Scroll settings before rendering the widget.
		 *
		 * @since 6.2.7
		 *
		 * @param string                  $content The widget content.
		 * @param \Elementor\Element_Base $element The element instance.
		 * @return string The modified content.
		 */
		public function tp_adv_magic_scroll_before_render( $content, $element ) {

			$settings = $element->get_settings_for_display();

			$adv_magic_scroll = ! empty( $settings['adv_magic_scroll'] ) ? $settings['adv_magic_scroll'] : '';

			if ( empty( $adv_magic_scroll ) || 'yes' !== $adv_magic_scroll ) {
				return $content;
			}

			/* Magic scroll */
			$magic_attr = '';

			$before_content_ams = '';
			$after_content_ams  = '';

			$scroll_attr = array();

			$magic_attr = $this->tp_build_magic_scroll_attr( $settings );

			$uid_widget = uniqid( 'plus' );

			// $before_content_ams .= '<div id="' . esc_attr( $uid_widget ) . '" class=" plus-widget-wrapper ">';

			$before_content_ams .= '<div class="plus-widget-inner-wrap tp-magic-scroll" ' . $magic_attr . '">';

			$after_content_ams .= '</div>';

			// $after_content_ams .= '</div>';

			if ( ! empty( $before_content_ams ) || ! empty( $after_content_ams ) ) {

				$output = $before_content_ams . $content . $after_content_ams;

				return $output;
			}
		}

		/**
		 * Adds advanced magic scroll attributes to the container wrapper before rendering.
		 *
		 * This method checks if the element is a container and if the advanced magic scroll
		 * option is enabled. If so, it builds the necessary data attributes and adds them
		 * to the container's wrapper, ensuring no extra DOM is inserted.
		 *
		 * @since 6.2.7
		 *
		 * @param \Elementor\Element_Base $element The element instance.
		 * @return void
		 */
		public function tp_adv_magic_scroll_before_container_new( $element ) {
			if ( 'container' !== $element->get_name() ) {
				return;
			}

			$settings = $element->get_settings_for_display();
			if ( empty( $settings['adv_magic_scroll'] ) || 'yes' !== $settings['adv_magic_scroll'] ) {
				return;
			}

			$magic_attr = $this->tp_build_magic_scroll_attr( $settings );

			$element->add_render_attribute( '_wrapper', 'class', 'plus-widget-inner-wrap tp-magic-scroll' );

			if ( preg_match_all( '/\s(data-[^\s=]+)="([^"]*)"/', ' ' . $magic_attr, $m, PREG_SET_ORDER ) ) {
				foreach ( $m as $pair ) {
					$element->add_render_attribute( '_wrapper', $pair[1], html_entity_decode( $pair[2], ENT_QUOTES, 'UTF-8' ) );
				}
			}
		}

		/**
		 * Outputs the opening wrapper div for advanced magic scroll on containers.
		 *
		 * This method checks if the element is a container and if the advanced magic scroll
		 * option is enabled. If so, it outputs the opening div with the required classes and attributes.
		 *
		 * @since 6.2.7
		 *
		 * @param \Elementor\Element_Base $element The element instance.
		 * @return void
		 */
		public function tp_adv_magic_scroll_before_container( $element ) {
			if ( 'container' === $element->get_name() ) {
				$settings = $element->get_settings_for_display();

				$adv_magic_scroll = ! empty( $settings['adv_magic_scroll'] ) ? $settings['adv_magic_scroll'] : '';

				if ( empty( $adv_magic_scroll ) || 'yes' !== $adv_magic_scroll ) {
					return;
				}

				$magic_attr = $this->tp_build_magic_scroll_attr( $settings );

				echo '<div class="plus-widget-inner-wrap tp-magic-scroll " ' . $magic_attr . '">';
			}
		}

		/**
		 * Outputs the closing wrapper div for advanced magic scroll on containers.
		 *
		 * This method checks if the element is a container and if the advanced magic scroll
		 * option is enabled. If so, it outputs the closing div tag.
		 *
		 * @since 6.2.7
		 *
		 * @param \Elementor\Element_Base $element The element instance.
		 * @return void
		 */
		public function tp_adv_magic_scroll_after_container( $element ) {
			if ( 'container' === $element->get_name() ) {
				$settings = $element->get_settings_for_display();

				$adv_magic_scroll = ! empty( $settings['adv_magic_scroll'] ) ? $settings['adv_magic_scroll'] : '';

				if ( empty( $adv_magic_scroll ) || 'yes' !== $adv_magic_scroll ) {
					return;
				}

				echo '</div>';
			}
		}

		/**
		 * Builds the data attributes string for advanced magic scroll based on settings.
		 *
		 * This method processes the provided settings and constructs a string of data attributes
		 * to be used for the advanced magic scroll functionality.
		 *
		 * @since 6.2.7
		 *
		 * @param array $settings The settings array for the element.
		 * @return string The data attributes string.
		 */
		public function tp_build_magic_scroll_attr( $settings ) {
			$magic_attr = '';

			foreach ( $settings['MSFrame'] as $key => $val ) {
				$scene_loop = array();

				// Effect variables
				$verticaltp      = ! empty( $val['verticaltp'] ) ? $val['verticaltp'] : '';
				$horizontaltp    = ! empty( $val['horizontaltp'] ) ? $val['horizontaltp'] : '';
				$opacitytp       = ! empty( $val['opacitytp'] ) ? $val['opacitytp'] : '';
				$colorms         = ! empty( $val['colorms'] ) ? $val['colorms'] : '';
				$playvideoms     = ! empty( $val['playvideoms'] ) ? $val['playvideoms'] : '';
				$drawsvgms       = ! empty( $val['drawsvgms'] ) ? $val['drawsvgms'] : '';
				$parallaxms      = ! empty( $val['parallaxms'] ) ? $val['parallaxms'] : '';
				$textshadowms    = ! empty( $val['textshadowms'] ) ? $val['textshadowms'] : '';
				$boxshadowms     = ! empty( $val['boxshadowms'] ) ? $val['boxshadowms'] : '';
				$fontsizems      = ! empty( $val['fontsizems'] ) ? $val['fontsizems'] : '';
				$letterspacingms = ! empty( $val['letterspacingms'] ) ? $val['letterspacingms'] : '';
				$blurms          = ! empty( $val['blurms'] ) ? $val['blurms'] : '';
				$paddingms       = ! empty( $val['paddingms'] ) ? $val['paddingms'] : '';
				$grayscalems     = ! empty( $val['grayscalems'] ) ? $val['grayscalems'] : '';
				$brightnessms    = ! empty( $val['brightnessms'] ) ? $val['brightnessms'] : '';
				$rotatetp        = ! empty( $val['rotatetp'] ) ? $val['rotatetp'] : '';
				$scaletp         = ! empty( $val['scaletp'] ) ? $val['scaletp'] : '';
				$skewtp          = ! empty( $val['skewtp'] ) ? $val['skewtp'] : '';
				$borderRtp       = ! empty( $val['borderRtp'] ) ? $val['borderRtp'] : '';
				$bgColortp       = ! empty( $val['bgColortp'] ) ? $val['bgColortp'] : '';
				$scrollOpttp     = ! empty( $val['scrollOpttp'] ) ? $val['scrollOpttp'] : '';
				$advOptiontp     = ! empty( $val['advOptiontp'] ) ? $val['advOptiontp'] : '';
				$stickytp        = ! empty( $val['stickytp'] ) ? $val['stickytp'] : '';
				$developtp       = ! empty( $val['developtp'] ) ? $val['developtp'] : '';
				$dynamicHeighttp = ! empty( $val['dynamicHeighttp'] ) ? $val['dynamicHeighttp'] : '';
				$zindexsticky  = ! empty( $val['zindexsticky'] ) ? $val['zindexsticky'] : '';

				/** Vertical */
				if ( 'yes' === $verticaltp ) {
					$scene_loopvertical = array();
					if ( ( isset( $val['speedtpvs'] ) && ! empty( $val['speedtpvs'] ) && isset( $val['speedtpvs']['size'] ) ) && ( isset( $val['speedtpve'] ) && ! empty( $val['speedtpve'] ) && isset( $val['speedtpve']['size'] ) ) ) {
						$start_value              = $val['speedtpvs']['size'] . ( isset( $val['speedtpvs']['unit'] ) ? $val['speedtpvs']['unit'] : 'px' );
						$end_value                = $val['speedtpve']['size'] . ( isset( $val['speedtpve']['unit'] ) ? $val['speedtpve']['unit'] : 'px' );
						$scene_loopvertical['md'] = array( $start_value, $end_value );
					}

					if ( ( isset( $val['speedtpvs_tablet'] ) && ! empty( $val['speedtpvs_tablet'] ) && isset( $val['speedtpvs_tablet']['size'] ) ) && ( isset( $val['speedtpve_tablet'] ) && ! empty( $val['speedtpve_tablet'] ) && isset( $val['speedtpve_tablet']['size'] ) ) ) {
						$start_value              = $val['speedtpvs_tablet']['size'] . ( isset( $val['speedtpvs_tablet']['unit'] ) ? $val['speedtpvs_tablet']['unit'] : 'px' );
						$end_value                = $val['speedtpve_tablet']['size'] . ( isset( $val['speedtpve_tablet']['unit'] ) ? $val['speedtpve_tablet']['unit'] : 'px' );
						$scene_loopvertical['sm'] = array( $start_value, $end_value );
					}

					if ( ( isset( $val['speedtpvs_mobile'] ) && ! empty( $val['speedtpvs_mobile'] ) && isset( $val['speedtpvs_mobile']['size'] ) ) && ( isset( $val['speedtpve_mobile'] ) && ! empty( $val['speedtpve_mobile'] ) && isset( $val['speedtpve_mobile']['size'] ) ) ) {
						$start_value              = $val['speedtpvs_mobile']['size'] . ( isset( $val['speedtpvs_mobile']['unit'] ) ? $val['speedtpvs_mobile']['unit'] : 'px' );
						$end_value                = $val['speedtpve_mobile']['size'] . ( isset( $val['speedtpve_mobile']['unit'] ) ? $val['speedtpve_mobile']['unit'] : 'px' );
						$scene_loopvertical['xs'] = array( $start_value, $end_value );
					}
					$scene_loop['vertical']['speed'] = $scene_loopvertical;

				}

				/** Horizontal */
				if ( 'yes' === $horizontaltp ) {
					$scene_loophorizontal = array();
					if ( ( isset( $val['speedtphs'] ) && ! empty( $val['speedtphs'] ) && isset( $val['speedtphs']['size'] ) ) && ( isset( $val['speedtphe'] ) && ! empty( $val['speedtphe'] ) && isset( $val['speedtphe']['size'] ) ) ) {
						$start_value                = $val['speedtphs']['size'] . ( isset( $val['speedtphs']['unit'] ) ? $val['speedtphs']['unit'] : 'px' );
						$end_value                  = $val['speedtphe']['size'] . ( isset( $val['speedtphe']['unit'] ) ? $val['speedtphe']['unit'] : 'px' );
						$scene_loophorizontal['md'] = array( $start_value, $end_value );
					}

					if ( ( isset( $val['speedtphs_tablet'] ) && ! empty( $val['speedtphs_tablet'] ) && isset( $val['speedtphs_tablet']['size'] ) ) && ( isset( $val['speedtphe_tablet'] ) && ! empty( $val['speedtphe_tablet'] ) && isset( $val['speedtphe_tablet']['size'] ) ) ) {
						$start_value                = $val['speedtphs_tablet']['size'] . ( isset( $val['speedtphs_tablet']['unit'] ) ? $val['speedtphs_tablet']['unit'] : 'px' );
						$end_value                  = $val['speedtphe_tablet']['size'] . ( isset( $val['speedtphe_tablet']['unit'] ) ? $val['speedtphe_tablet']['unit'] : 'px' );
						$scene_loophorizontal['sm'] = array( $start_value, $end_value );
					}

					if ( ( isset( $val['speedtphs_mobile'] ) && ! empty( $val['speedtphs_mobile'] ) && isset( $val['speedtphs_mobile']['size'] ) ) && ( isset( $val['speedtphe_mobile'] ) && ! empty( $val['speedtphe_mobile'] ) && isset( $val['speedtphe_mobile']['size'] ) ) ) {
						$start_value                = $val['speedtphs_mobile']['size'] . ( isset( $val['speedtphs_mobile']['unit'] ) ? $val['speedtphs_mobile']['unit'] : 'px' );
						$end_value                  = $val['speedtphe_mobile']['size'] . ( isset( $val['speedtphe_mobile']['unit'] ) ? $val['speedtphe_mobile']['unit'] : 'px' );
						$scene_loophorizontal['xs'] = array( $start_value, $end_value );
					}
					$scene_loop['horizontal']['speed'] = $scene_loophorizontal;
				}

				/** Opacity */
				if ( 'yes' === $opacitytp ) {
					$scene_loopopacity = array();
					if ( ( isset( $val['speedtpos'] ) && ! empty( $val['speedtpos'] ) && isset( $val['speedtpos']['size'] ) ) && ( isset( $val['speedtpoe'] ) && ! empty( $val['speedtpoe'] ) && isset( $val['speedtpoe']['size'] ) ) ) {
						$scene_loopopacity['md'] = array( $val['speedtpos']['size'], $val['speedtpoe']['size'] );
					}

					if ( ( isset( $val['speedtpos_tablet'] ) && ! empty( $val['speedtpos_tablet'] ) && isset( $val['speedtpos_tablet']['size'] ) ) && ( isset( $val['speedtpoe_tablet'] ) && ! empty( $val['speedtpoe_tablet'] ) && isset( $val['speedtpoe_tablet']['size'] ) ) ) {
						$scene_loopopacity['sm'] = array( $val['speedtpos_tablet']['size'], $val['speedtpoe_tablet']['size'] );
					}

					if ( ( isset( $val['speedtpos_mobile'] ) && ! empty( $val['speedtpos_mobile'] ) && isset( $val['speedtpos_mobile']['size'] ) ) && ( isset( $val['speedtpoe_mobile'] ) && ! empty( $val['speedtpoe_mobile'] ) && isset( $val['speedtpoe_mobile']['size'] ) ) ) {
						$scene_loopopacity['xs'] = array( $val['speedtpos_mobile']['size'], $val['speedtpoe_mobile']['size'] );
					}
					$scene_loop['opacity']['speed'] = $scene_loopopacity;
				}

				/** Color */
				if ( 'yes' === $colorms ) {
					$scene_loop_color = array();
					if ( isset( $val['colorValueStartms'] ) && ! empty( $val['colorValueStartms'] ) && isset( $val['colorValueEndms'] ) && ! empty( $val['colorValueEndms'] ) ) {
						$scene_loop_color['md'] = array( $val['colorValueStartms'], $val['colorValueEndms'] );
					}

					if ( isset( $val['colorValueStartms_tablet'] ) && ! empty( $val['colorValueStartms_tablet'] ) && isset( $val['colorValueEndms_tablet'] ) && ! empty( $val['colorValueEndms_tablet'] ) ) {
						$scene_loop_color['sm'] = array( $val['colorValueStartms_tablet'], $val['colorValueEndms_tablet'] );
					}

					if ( isset( $val['colorValueStartms_mobile'] ) && ! empty( $val['colorValueStartms_mobile'] ) && isset( $val['colorValueEndms_mobile'] ) && ! empty( $val['colorValueEndms_mobile'] ) ) {
						$scene_loop_color['xs'] = array( $val['colorValueStartms_mobile'], $val['colorValueEndms_mobile'] );
					}
					$scene_loop['colorms']['colorValuems'] = $scene_loop_color;
				}

				/** Video Player*/
				if ( 'yes' === $playvideoms ) {
					$scene_loop['playvideo'] = true;
					if ( isset( $val['videoSelectorMs'] ) && ! empty( $val['videoSelectorMs'] ) ) {
						$scene_loop['selector'] = $val['videoSelectorMs'];
					}
				}

				/** Draw SVG*/
				if ( 'yes' === $drawsvgms ) {
					$scene_loop['drawsvg'] = isset( $val['svgSelectorMs'] ) ? $val['svgSelectorMs'] : 'svg path, svg circle, svg rect';
				}

				/** Parallax Effect */
				if ( 'yes' === $parallaxms ) {
					$parallax = array();

					if (
						isset( $val['parallaxXms'] ) && is_array( $val['parallaxXms'] ) && isset( $val['parallaxXms']['size'] ) &&
						isset( $val['parallaxYms'] ) && is_array( $val['parallaxYms'] ) && isset( $val['parallaxYms']['size'] )
					) {
						$x_value = $val['parallaxXms']['size'] . ( isset( $val['parallaxXms']['unit'] ) ? $val['parallaxXms']['unit'] : 'px' );
						$y_value = $val['parallaxYms']['size'] . ( isset( $val['parallaxYms']['unit'] ) ? $val['parallaxYms']['unit'] : 'px' );
						$parallax['md'] = array(
							'x' => $x_value,
							'y' => $y_value,
						);
					}

					if (
						isset( $val['parallaxXms_tablet'] ) && is_array( $val['parallaxXms_tablet'] ) && isset( $val['parallaxXms_tablet']['size'] ) &&
						isset( $val['parallaxYms_tablet'] ) && is_array( $val['parallaxYms_tablet'] ) && isset( $val['parallaxYms_tablet']['size'] )
					) {
						$x_value = $val['parallaxXms_tablet']['size'] . ( isset( $val['parallaxXms_tablet']['unit'] ) ? $val['parallaxXms_tablet']['unit'] : 'px' );
						$y_value = $val['parallaxYms_tablet']['size'] . ( isset( $val['parallaxYms_tablet']['unit'] ) ? $val['parallaxYms_tablet']['unit'] : 'px' );
						$parallax['sm'] = array(
							'x' => $x_value,
							'y' => $y_value,
						);
					}

					if (
						isset( $val['parallaxXms_mobile'] ) && is_array( $val['parallaxXms_mobile'] ) && isset( $val['parallaxXms_mobile']['size'] ) &&
						isset( $val['parallaxYms_mobile'] ) && is_array( $val['parallaxYms_mobile'] ) && isset( $val['parallaxYms_mobile']['size'] )
					) {
						$x_value = $val['parallaxXms_mobile']['size'] . ( isset( $val['parallaxXms_mobile']['unit'] ) ? $val['parallaxXms_mobile']['unit'] : 'px' );
						$y_value = $val['parallaxYms_mobile']['size'] . ( isset( $val['parallaxYms_mobile']['unit'] ) ? $val['parallaxYms_mobile']['unit'] : 'px' );
						$parallax['xs'] = array(
							'x' => $x_value,
							'y' => $y_value,
						);
					}

					if ( empty( $parallax ) ) {
						$parallax['md'] = array(
							'x' => 0,
							'y' => 0,
						);
					}

					$scene_loop['parallax'] = $parallax;
				}

				/** Text Shadow */
				if ( 'yes' === $textshadowms ) {
					$scene_loop_text_shadow = array();

					if (
						isset( $val['textShadowHStartms'] ) && is_array( $val['textShadowHStartms'] ) && isset( $val['textShadowHStartms']['size'] ) &&
						isset( $val['textShadowVStartms'] ) && is_array( $val['textShadowVStartms'] ) && isset( $val['textShadowVStartms']['size'] ) &&
						isset( $val['textShadowBlurStartms'] ) && is_array( $val['textShadowBlurStartms'] ) && isset( $val['textShadowBlurStartms']['size'] ) &&
						isset( $val['textShadowColorStartms'] ) &&
						isset( $val['textShadowHEndms'] ) && is_array( $val['textShadowHEndms'] ) && isset( $val['textShadowHEndms']['size'] ) &&
						isset( $val['textShadowVEndms'] ) && is_array( $val['textShadowVEndms'] ) && isset( $val['textShadowVEndms']['size'] ) &&
						isset( $val['textShadowBlurEndms'] ) && is_array( $val['textShadowBlurEndms'] ) && isset( $val['textShadowBlurEndms']['size'] ) &&
						isset( $val['textShadowColorEndms'] )
					) {
						$scene_loop_text_shadow['md'] = array(
							$val['textShadowHStartms']['size'] . ( isset( $val['textShadowHStartms']['unit'] ) ? $val['textShadowHStartms']['unit'] : 'px' ),
							$val['textShadowVStartms']['size'] . ( isset( $val['textShadowVStartms']['unit'] ) ? $val['textShadowVStartms']['unit'] : 'px' ),
							$val['textShadowBlurStartms']['size'] . ( isset( $val['textShadowBlurStartms']['unit'] ) ? $val['textShadowBlurStartms']['unit'] : 'px' ),
							$val['textShadowColorStartms'],
							$val['textShadowHEndms']['size'] . ( isset( $val['textShadowHEndms']['unit'] ) ? $val['textShadowHEndms']['unit'] : 'px' ),
							$val['textShadowVEndms']['size'] . ( isset( $val['textShadowVEndms']['unit'] ) ? $val['textShadowVEndms']['unit'] : 'px' ),
							$val['textShadowBlurEndms']['size'] . ( isset( $val['textShadowBlurEndms']['unit'] ) ? $val['textShadowBlurEndms']['unit'] : 'px' ),
							$val['textShadowColorEndms'],
						);
					}

					if (
						isset( $val['textShadowHStartms_tablet'] ) && is_array( $val['textShadowHStartms_tablet'] ) && isset( $val['textShadowHStartms_tablet']['size'] ) &&
						isset( $val['textShadowVStartms_tablet'] ) && is_array( $val['textShadowVStartms_tablet'] ) && isset( $val['textShadowVStartms_tablet']['size'] ) &&
						isset( $val['textShadowBlurStartms_tablet'] ) && is_array( $val['textShadowBlurStartms_tablet'] ) && isset( $val['textShadowBlurStartms_tablet']['size'] ) &&
						isset( $val['textShadowColorStartms_tablet'] ) &&
						isset( $val['textShadowHEndms_tablet'] ) && is_array( $val['textShadowHEndms_tablet'] ) && isset( $val['textShadowHEndms_tablet']['size'] ) &&
						isset( $val['textShadowVEndms_tablet'] ) && is_array( $val['textShadowVEndms_tablet'] ) && isset( $val['textShadowVEndms_tablet']['size'] ) &&
						isset( $val['textShadowBlurEndms_tablet'] ) && is_array( $val['textShadowBlurEndms_tablet'] ) && isset( $val['textShadowBlurEndms_tablet']['size'] ) &&
						isset( $val['textShadowColorEndms_tablet'] )
					) {
						$scene_loop_text_shadow['sm'] = array(
							$val['textShadowHStartms_tablet']['size'] . ( isset( $val['textShadowHStartms_tablet']['unit'] ) ? $val['textShadowHStartms_tablet']['unit'] : 'px' ),
							$val['textShadowVStartms_tablet']['size'] . ( isset( $val['textShadowVStartms_tablet']['unit'] ) ? $val['textShadowVStartms_tablet']['unit'] : 'px' ),
							$val['textShadowBlurStartms_tablet']['size'] . ( isset( $val['textShadowBlurStartms_tablet']['unit'] ) ? $val['textShadowBlurStartms_tablet']['unit'] : 'px' ),
							$val['textShadowColorStartms_tablet'],
							$val['textShadowHEndms_tablet']['size'] . ( isset( $val['textShadowHEndms_tablet']['unit'] ) ? $val['textShadowHEndms_tablet']['unit'] : 'px' ),
							$val['textShadowVEndms_tablet']['size'] . ( isset( $val['textShadowVEndms_tablet']['unit'] ) ? $val['textShadowVEndms_tablet']['unit'] : 'px' ),
							$val['textShadowBlurEndms_tablet']['size'] . ( isset( $val['textShadowBlurEndms_tablet']['unit'] ) ? $val['textShadowBlurEndms_tablet']['unit'] : 'px' ),
							$val['textShadowColorEndms_tablet'],
						);
					}

					if (
						isset( $val['textShadowHStartms_mobile'] ) && is_array( $val['textShadowHStartms_mobile'] ) && isset( $val['textShadowHStartms_mobile']['size'] ) &&
						isset( $val['textShadowVStartms_mobile'] ) && is_array( $val['textShadowVStartms_mobile'] ) && isset( $val['textShadowVStartms_mobile']['size'] ) &&
						isset( $val['textShadowBlurStartms_mobile'] ) && is_array( $val['textShadowBlurStartms_mobile'] ) && isset( $val['textShadowBlurStartms_mobile']['size'] ) &&
						isset( $val['textShadowColorStartms_mobile'] ) &&
						isset( $val['textShadowHEndms_mobile'] ) && is_array( $val['textShadowHEndms_mobile'] ) && isset( $val['textShadowHEndms_mobile']['size'] ) &&
						isset( $val['textShadowVEndms_mobile'] ) && is_array( $val['textShadowVEndms_mobile'] ) && isset( $val['textShadowVEndms_mobile']['size'] ) &&
						isset( $val['textShadowBlurEndms_mobile'] ) && is_array( $val['textShadowBlurEndms_mobile'] ) && isset( $val['textShadowBlurEndms_mobile']['size'] ) &&
						isset( $val['textShadowColorEndms_mobile'] )
					) {
						$scene_loop_text_shadow['xs'] = array(
							$val['textShadowHStartms_mobile']['size'] . ( isset( $val['textShadowHStartms_mobile']['unit'] ) ? $val['textShadowHStartms_mobile']['unit'] : 'px' ),
							$val['textShadowVStartms_mobile']['size'] . ( isset( $val['textShadowVStartms_mobile']['unit'] ) ? $val['textShadowVStartms_mobile']['unit'] : 'px' ),
							$val['textShadowBlurStartms_mobile']['size'] . ( isset( $val['textShadowBlurStartms_mobile']['unit'] ) ? $val['textShadowBlurStartms_mobile']['unit'] : 'px' ),
							$val['textShadowColorStartms_mobile'],
							$val['textShadowHEndms_mobile']['size'] . ( isset( $val['textShadowHEndms_mobile']['unit'] ) ? $val['textShadowHEndms_mobile']['unit'] : 'px' ),
							$val['textShadowColorStartms_mobile'],
						);
					}
					$scene_loop['textshadowms']['textShadowHms'] = $scene_loop_text_shadow;
				}

				/** Box Shadow */
				if ( 'yes' === $boxshadowms ) {
					$scene_loop_box_shadow = array();

					if (
						isset( $val['boxShadowHOffsetStartms'] ) && is_array( $val['boxShadowHOffsetStartms'] ) && isset( $val['boxShadowHOffsetStartms']['size'] ) &&
						isset( $val['boxShadowVOffsetStartms'] ) && is_array( $val['boxShadowVOffsetStartms'] ) && isset( $val['boxShadowVOffsetStartms']['size'] ) &&
						isset( $val['boxShadowBlurStartms'] ) && is_array( $val['boxShadowBlurStartms'] ) && isset( $val['boxShadowBlurStartms']['size'] ) &&
						isset( $val['boxShadowSpreadStartms'] ) && is_array( $val['boxShadowSpreadStartms'] ) && isset( $val['boxShadowSpreadStartms']['size'] ) &&
						isset( $val['boxShadowColorStartms'] ) &&
						isset( $val['boxShadowPositionStartms'] ) &&
						isset( $val['boxShadowHOffsetEndms'] ) && is_array( $val['boxShadowHOffsetEndms'] ) && isset( $val['boxShadowHOffsetEndms']['size'] ) &&
						isset( $val['boxShadowVOffsetEndms'] ) && is_array( $val['boxShadowVOffsetEndms'] ) && isset( $val['boxShadowVOffsetEndms']['size'] ) &&
						isset( $val['boxShadowBlurEndms'] ) && is_array( $val['boxShadowBlurEndms'] ) && isset( $val['boxShadowBlurEndms']['size'] ) &&
						isset( $val['boxShadowSpreadEndms'] ) && is_array( $val['boxShadowSpreadEndms'] ) && isset( $val['boxShadowSpreadEndms']['size'] ) &&
						isset( $val['boxShadowColorEndms'] ) &&
						isset( $val['boxShadowPositionEndms'] )
					) {
						$scene_loop_box_shadow['md'] = array(
							$val['boxShadowHOffsetStartms']['size'] . ( isset( $val['boxShadowHOffsetStartms']['unit'] ) ? $val['boxShadowHOffsetStartms']['unit'] : 'px' ),
							$val['boxShadowVOffsetStartms']['size'] . ( isset( $val['boxShadowVOffsetStartms']['unit'] ) ? $val['boxShadowVOffsetStartms']['unit'] : 'px' ),
							$val['boxShadowBlurStartms']['size'] . ( isset( $val['boxShadowBlurStartms']['unit'] ) ? $val['boxShadowBlurStartms']['unit'] : 'px' ),
							$val['boxShadowSpreadStartms']['size'] . ( isset( $val['boxShadowSpreadStartms']['unit'] ) ? $val['boxShadowSpreadStartms']['unit'] : 'px' ),
							$val['boxShadowColorStartms'],
							$val['boxShadowPositionStartms'],
							$val['boxShadowHOffsetEndms']['size'] . ( isset( $val['boxShadowHOffsetEndms']['unit'] ) ? $val['boxShadowHOffsetEndms']['unit'] : 'px' ),
							$val['boxShadowVOffsetEndms']['size'] . ( isset( $val['boxShadowVOffsetEndms']['unit'] ) ? $val['boxShadowVOffsetEndms']['unit'] : 'px' ),
							$val['boxShadowBlurEndms']['size'] . ( isset( $val['boxShadowBlurEndms']['unit'] ) ? $val['boxShadowBlurEndms']['unit'] : 'px' ),
							$val['boxShadowSpreadEndms']['size'] . ( isset( $val['boxShadowSpreadEndms']['unit'] ) ? $val['boxShadowSpreadEndms']['unit'] : 'px' ),
							$val['boxShadowColorEndms'],
							$val['boxShadowPositionEndms'],
						);
					}

					if (
						isset( $val['boxShadowHOffsetStartms_tablet'] ) && is_array( $val['boxShadowHOffsetStartms_tablet'] ) && isset( $val['boxShadowHOffsetStartms_tablet']['size'] ) &&
						isset( $val['boxShadowVOffsetStartms_tablet'] ) && is_array( $val['boxShadowVOffsetStartms_tablet'] ) && isset( $val['boxShadowVOffsetStartms_tablet']['size'] ) &&
						isset( $val['boxShadowBlurStartms_tablet'] ) && is_array( $val['boxShadowBlurStartms_tablet'] ) && isset( $val['boxShadowBlurStartms_tablet']['size'] ) &&
						isset( $val['boxShadowSpreadStartms_tablet'] ) && is_array( $val['boxShadowSpreadStartms_tablet'] ) && isset( $val['boxShadowSpreadStartms_tablet']['size'] ) &&
						isset( $val['boxShadowColorStartms_tablet'] ) &&
						isset( $val['boxShadowPositionStartms_tablet'] ) &&
						isset( $val['boxShadowHOffsetEndms_tablet'] ) && is_array( $val['boxShadowHOffsetEndms_tablet'] ) && isset( $val['boxShadowHOffsetEndms_tablet']['size'] ) &&
						isset( $val['boxShadowVOffsetEndms_tablet'] ) && is_array( $val['boxShadowVOffsetEndms_tablet'] ) && isset( $val['boxShadowVOffsetEndms_tablet']['size'] ) &&
						isset( $val['boxShadowBlurEndms_tablet'] ) && is_array( $val['boxShadowBlurEndms_tablet'] ) && isset( $val['boxShadowBlurEndms_tablet']['size'] ) &&
						isset( $val['boxShadowSpreadEndms_tablet'] ) && is_array( $val['boxShadowSpreadEndms_tablet'] ) && isset( $val['boxShadowSpreadEndms_tablet']['size'] ) &&
						isset( $val['boxShadowColorEndms_tablet'] ) &&
						isset( $val['boxShadowPositionEndms_tablet'] )
					) {
						$scene_loop_box_shadow['sm'] = array(
							$val['boxShadowHOffsetStartms_tablet']['size'] . ( isset( $val['boxShadowHOffsetStartms_tablet']['unit'] ) ? $val['boxShadowHOffsetStartms_tablet']['unit'] : 'px' ),
							$val['boxShadowVOffsetStartms_tablet']['size'] . ( isset( $val['boxShadowVOffsetStartms_tablet']['unit'] ) ? $val['boxShadowVOffsetStartms_tablet']['unit'] : 'px' ),
							$val['boxShadowBlurStartms_tablet']['size'] . ( isset( $val['boxShadowBlurStartms_tablet']['unit'] ) ? $val['boxShadowBlurStartms_tablet']['unit'] : 'px' ),
							$val['boxShadowSpreadStartms_tablet']['size'] . ( isset( $val['boxShadowSpreadStartms_tablet']['unit'] ) ? $val['boxShadowSpreadStartms_tablet']['unit'] : 'px' ),
							$val['boxShadowColorStartms_tablet'],
							$val['boxShadowPositionStartms_tablet'],
							$val['boxShadowHOffsetEndms_tablet']['size'] . ( isset( $val['boxShadowHOffsetEndms_tablet']['unit'] ) ? $val['boxShadowHOffsetEndms_tablet']['unit'] : 'px' ),
							$val['boxShadowVOffsetEndms_tablet']['size'] . ( isset( $val['boxShadowVOffsetEndms_tablet']['unit'] ) ? $val['boxShadowVOffsetEndms_tablet']['unit'] : 'px' ),
							$val['boxShadowBlurEndms_tablet']['size'] . ( isset( $val['boxShadowBlurEndms_tablet']['unit'] ) ? $val['boxShadowBlurEndms_tablet']['unit'] : 'px' ),
							$val['boxShadowSpreadEndms_tablet']['size'] . ( isset( $val['boxShadowSpreadEndms_tablet']['unit'] ) ? $val['boxShadowSpreadEndms_tablet']['unit'] : 'px' ),
							$val['boxShadowColorEndms_tablet'],
							$val['boxShadowPositionEndms_tablet'],
						);
					}

					if (
						isset( $val['boxShadowHOffsetStartms_mobile'] ) && is_array( $val['boxShadowHOffsetStartms_mobile'] ) && isset( $val['boxShadowHOffsetStartms_mobile']['size'] ) &&
						isset( $val['boxShadowVOffsetStartms_mobile'] ) && is_array( $val['boxShadowVOffsetStartms_mobile'] ) && isset( $val['boxShadowVOffsetStartms_mobile']['size'] ) &&
						isset( $val['boxShadowBlurStartms_mobile'] ) && is_array( $val['boxShadowBlurStartms_mobile'] ) && isset( $val['boxShadowBlurStartms_mobile']['size'] ) &&
						isset( $val['boxShadowSpreadStartms_mobile'] ) && is_array( $val['boxShadowSpreadStartms_mobile'] ) && isset( $val['boxShadowSpreadStartms_mobile']['size'] ) &&
						isset( $val['boxShadowColorStartms_mobile'] ) &&
						isset( $val['boxShadowPositionStartms_mobile'] ) &&
						isset( $val['boxShadowHOffsetEndms_mobile'] ) && is_array( $val['boxShadowHOffsetEndms_mobile'] ) && isset( $val['boxShadowHOffsetEndms_mobile']['size'] ) &&
						isset( $val['boxShadowVOffsetEndms_mobile'] ) && is_array( $val['boxShadowVOffsetEndms_mobile'] ) && isset( $val['boxShadowVOffsetEndms_mobile']['size'] ) &&
						isset( $val['boxShadowBlurEndms_mobile'] ) && is_array( $val['boxShadowBlurEndms_mobile'] ) && isset( $val['boxShadowBlurEndms_mobile']['size'] ) &&
						isset( $val['boxShadowSpreadEndms_mobile'] ) && is_array( $val['boxShadowSpreadEndms_mobile'] ) && isset( $val['boxShadowSpreadEndms_mobile']['size'] ) &&
						isset( $val['boxShadowColorEndms_mobile'] ) &&
						isset( $val['boxShadowPositionEndms_mobile'] )
					) {
						$scene_loop_box_shadow['xs'] = array(
							$val['boxShadowHOffsetStartms_mobile']['size'] . ( isset( $val['boxShadowHOffsetStartms_mobile']['unit'] ) ? $val['boxShadowHOffsetStartms_mobile']['unit'] : 'px' ),
							$val['boxShadowVOffsetStartms_mobile']['size'] . ( isset( $val['boxShadowVOffsetStartms_mobile']['unit'] ) ? $val['boxShadowVOffsetStartms_mobile']['unit'] : 'px' ),
							$val['boxShadowBlurStartms_mobile']['size'] . ( isset( $val['boxShadowBlurStartms_mobile']['unit'] ) ? $val['boxShadowBlurStartms_mobile']['unit'] : 'px' ),
							$val['boxShadowSpreadStartms_mobile']['size'] . ( isset( $val['boxShadowSpreadStartms_mobile']['unit'] ) ? $val['boxShadowSpreadStartms_mobile']['unit'] : 'px' ),
							$val['boxShadowColorStartms_mobile'],
							$val['boxShadowPositionStartms_mobile'],
							$val['boxShadowHOffsetEndms_mobile']['size'] . ( isset( $val['boxShadowHOffsetEndms_mobile']['unit'] ) ? $val['boxShadowHOffsetEndms_mobile']['unit'] : 'px' ),
							$val['boxShadowVOffsetEndms_mobile']['size'] . ( isset( $val['boxShadowVOffsetEndms_mobile']['unit'] ) ? $val['boxShadowVOffsetEndms_mobile']['unit'] : 'px' ),
							$val['boxShadowBlurEndms_mobile']['size'] . ( isset( $val['boxShadowBlurEndms_mobile']['unit'] ) ? $val['boxShadowBlurEndms_mobile']['unit'] : 'px' ),
							$val['boxShadowSpreadEndms_mobile']['size'] . ( isset( $val['boxShadowSpreadEndms_mobile']['unit'] ) ? $val['boxShadowSpreadEndms_mobile']['unit'] : 'px' ),
							$val['boxShadowColorEndms_mobile'],
							$val['boxShadowPositionEndms_mobile'],
						);
					}
					$scene_loop['boxshadowms']['boxShadowHms'] = $scene_loop_box_shadow;
				}

				/** Font Size */
				if ( 'yes' === $fontsizems ) {
					$scene_loop_font_size = array();

					if (
						isset( $val['fontSizeValueStartms'] ) && is_array( $val['fontSizeValueStartms'] ) && isset( $val['fontSizeValueStartms']['size'] ) &&
						isset( $val['fontSizeValueEndms'] ) && is_array( $val['fontSizeValueEndms'] ) && isset( $val['fontSizeValueEndms']['size'] )
					) {
						$scene_loop_font_size['md'] = array(
							$val['fontSizeValueStartms']['size'] . ( isset( $val['fontSizeValueStartms']['unit'] ) ? $val['fontSizeValueStartms']['unit'] : 'px' ),
							$val['fontSizeValueEndms']['size'] . ( isset( $val['fontSizeValueEndms']['unit'] ) ? $val['fontSizeValueEndms']['unit'] : 'px' ),
						);
					}

					if (
						isset( $val['fontSizeValueStartms_tablet'] ) && is_array( $val['fontSizeValueStartms_tablet'] ) && isset( $val['fontSizeValueStartms_tablet']['size'] ) &&
						isset( $val['fontSizeValueEndms_tablet'] ) && is_array( $val['fontSizeValueEndms_tablet'] ) && isset( $val['fontSizeValueEndms_tablet']['size'] )
					) {
						$scene_loop_font_size['sm'] = array(
							$val['fontSizeValueStartms_tablet']['size'] . ( isset( $val['fontSizeValueStartms_tablet']['unit'] ) ? $val['fontSizeValueStartms_tablet']['unit'] : 'px' ),
							$val['fontSizeValueEndms_tablet']['size'] . ( isset( $val['fontSizeValueEndms_tablet']['unit'] ) ? $val['fontSizeValueEndms_tablet']['unit'] : 'px' ),
						);
					}

					if (
						isset( $val['fontSizeValueStartms_mobile'] ) && is_array( $val['fontSizeValueStartms_mobile'] ) && isset( $val['fontSizeValueStartms_mobile']['size'] ) &&
						isset( $val['fontSizeValueEndms_mobile'] ) && is_array( $val['fontSizeValueEndms_mobile'] ) && isset( $val['fontSizeValueEndms_mobile']['size'] )
					) {
						$scene_loop_font_size['xs'] = array(
							$val['fontSizeValueStartms_mobile']['size'] . ( isset( $val['fontSizeValueStartms_mobile']['unit'] ) ? $val['fontSizeValueStartms_mobile']['unit'] : 'px' ),
							$val['fontSizeValueEndms_mobile']['size'] . ( isset( $val['fontSizeValueEndms_mobile']['unit'] ) ? $val['fontSizeValueEndms_mobile']['unit'] : 'px' ),
						);
					}
					$scene_loop['fontsizems']['fontSizeValuems'] = $scene_loop_font_size;
				}

				/** Letter Spacing */
				if ( 'yes' === $letterspacingms ) {
					$scene_loop_letter_spacing = array();

					if (
						isset( $val['letterSpacingValueStartms'] ) && is_array( $val['letterSpacingValueStartms'] ) && isset( $val['letterSpacingValueStartms']['size'] ) &&
						isset( $val['letterSpacingValueEndms'] ) && is_array( $val['letterSpacingValueEndms'] ) && isset( $val['letterSpacingValueEndms']['size'] )
					) {
						$scene_loop_letter_spacing['md'] = array(
							$val['letterSpacingValueStartms']['size'] . ( isset( $val['letterSpacingValueStartms']['unit'] ) ? $val['letterSpacingValueStartms']['unit'] : 'px' ),
							$val['letterSpacingValueEndms']['size'] . ( isset( $val['letterSpacingValueEndms']['unit'] ) ? $val['letterSpacingValueEndms']['unit'] : 'px' ),
						);
					}

					if (
						isset( $val['letterSpacingValueStartms_tablet'] ) && is_array( $val['letterSpacingValueStartms_tablet'] ) && isset( $val['letterSpacingValueStartms_tablet']['size'] ) &&
						isset( $val['letterSpacingValueEndms_tablet'] ) && is_array( $val['letterSpacingValueEndms_tablet'] ) && isset( $val['letterSpacingValueEndms_tablet']['size'] )
					) {
						$scene_loop_letter_spacing['sm'] = array(
							$val['letterSpacingValueStartms_tablet']['size'] . ( isset( $val['letterSpacingValueStartms_tablet']['unit'] ) ? $val['letterSpacingValueStartms_tablet']['unit'] : 'px' ),
							$val['letterSpacingValueEndms_tablet']['size'] . ( isset( $val['letterSpacingValueEndms_tablet']['unit'] ) ? $val['letterSpacingValueEndms_tablet']['unit'] : 'px' ),
						);
					}

					if (
						isset( $val['letterSpacingValueStartms_mobile'] ) && is_array( $val['letterSpacingValueStartms_mobile'] ) && isset( $val['letterSpacingValueStartms_mobile']['size'] ) &&
						isset( $val['letterSpacingValueEndms_mobile'] ) && is_array( $val['letterSpacingValueEndms_mobile'] ) && isset( $val['letterSpacingValueEndms_mobile']['size'] )
					) {
						$scene_loop_letter_spacing['xs'] = array(
							$val['letterSpacingValueStartms_mobile']['size'] . ( isset( $val['letterSpacingValueStartms_mobile']['unit'] ) ? $val['letterSpacingValueStartms_mobile']['unit'] : 'px' ),
							$val['letterSpacingValueEndms_mobile']['size'] . ( isset( $val['letterSpacingValueEndms_mobile']['unit'] ) ? $val['letterSpacingValueEndms_mobile']['unit'] : 'px' ),
						);
					}
					$scene_loop['letterspacingms']['letterSpacingValuems'] = $scene_loop_letter_spacing;
				}

				/** Blur */
				if ( 'yes' === $blurms ) {
					$scene_loop_blur = array();

					if (
						isset( $val['blurValueStartms'] ) && is_array( $val['blurValueStartms'] ) && isset( $val['blurValueStartms']['size'] ) &&
						isset( $val['blurValueEndms'] ) && is_array( $val['blurValueEndms'] ) && isset( $val['blurValueEndms']['size'] )
					) {
						$scene_loop_blur['md'][0] = $val['blurValueStartms']['size'];
						$scene_loop_blur['md'][1] = $val['blurValueEndms']['size'];
					}

					if (
						isset( $val['blurValueStartms_tablet'] ) && is_array( $val['blurValueStartms_tablet'] ) && isset( $val['blurValueStartms_tablet']['size'] ) &&
						isset( $val['blurValueEndms_tablet'] ) && is_array( $val['blurValueEndms_tablet'] ) && isset( $val['blurValueEndms_tablet']['size'] )
					) {
						$scene_loop_blur['sm'][0] = $val['blurValueStartms_tablet']['size'];
						$scene_loop_blur['sm'][1] = $val['blurValueEndms_tablet']['size'];
					}

					if (
						isset( $val['blurValueStartms_mobile'] ) && is_array( $val['blurValueStartms_mobile'] ) && isset( $val['blurValueStartms_mobile']['size'] ) &&
						isset( $val['blurValueEndms_mobile'] ) && is_array( $val['blurValueEndms_mobile'] ) && isset( $val['blurValueEndms_mobile']['size'] )
					) {
						$scene_loop_blur['xs'][0] = $val['blurValueStartms_mobile']['size'];
						$scene_loop_blur['xs'][1] = $val['blurValueEndms_mobile']['size'];
					}
					$scene_loop['blurms']['blurValuems'] = $scene_loop_blur;
				}

				/** Padding */
				if ( 'yes' === $paddingms ) {
					$scene_loop_padding = array();

					if (
						isset( $val['paddingValuemsStart'] ) && is_array( $val['paddingValuemsStart'] ) &&
						isset( $val['paddingValuemsEnd'] ) && is_array( $val['paddingValuemsEnd'] )
					) {
						$scene_loop_padding['md'][0] = $val['paddingValuemsStart'];
						$scene_loop_padding['md'][1] = $val['paddingValuemsEnd'];
					}

					if (
						isset( $val['paddingValuemsStart_tablet'] ) && is_array( $val['paddingValuemsStart_tablet'] ) &&
						isset( $val['paddingValuemsEnd_tablet'] ) && is_array( $val['paddingValuemsEnd_tablet'] )
					) {
						$scene_loop_padding['sm'][0] = $val['paddingValuemsStart_tablet'];
						$scene_loop_padding['sm'][1] = $val['paddingValuemsEnd_tablet'];
					}

					if (
						isset( $val['paddingValuemsStart_mobile'] ) && is_array( $val['paddingValuemsStart_mobile'] ) &&
						isset( $val['paddingValuemsEnd_mobile'] ) && is_array( $val['paddingValuemsEnd_mobile'] )
					) {
						$scene_loop_padding['xs'][0] = $val['paddingValuemsStart_mobile'];
						$scene_loop_padding['xs'][1] = $val['paddingValuemsEnd_mobile'];
					}
					$scene_loop['paddingms']['paddingValuems'] = $scene_loop_padding;
				}

				/** Grayscale */
				if ( 'yes' === $grayscalems ) {
					$scene_loop_grayscale = array();

					if (
						isset( $val['grayscaleValueStartms'] ) && is_array( $val['grayscaleValueStartms'] ) && isset( $val['grayscaleValueStartms']['size'] ) &&
						isset( $val['grayscaleValueEndms'] ) && is_array( $val['grayscaleValueEndms'] ) && isset( $val['grayscaleValueEndms']['size'] )
					) {
						$scene_loop_grayscale['md'] = array( $val['grayscaleValueStartms']['size'], $val['grayscaleValueEndms']['size'] );
					}

					if (
						isset( $val['grayscaleValueStartms_tablet'] ) && is_array( $val['grayscaleValueStartms_tablet'] ) && isset( $val['grayscaleValueStartms_tablet']['size'] ) &&
						isset( $val['grayscaleValueEndms_tablet'] ) && is_array( $val['grayscaleValueEndms_tablet'] ) && isset( $val['grayscaleValueEndms_tablet']['size'] )
					) {
						$scene_loop_grayscale['sm'] = array( $val['grayscaleValueStartms_tablet']['size'], $val['grayscaleValueEndms_tablet']['size'] );
					}

					if (
						isset( $val['grayscaleValueStartms_mobile'] ) && is_array( $val['grayscaleValueStartms_mobile'] ) && isset( $val['grayscaleValueStartms_mobile']['size'] ) &&
						isset( $val['grayscaleValueEndms_mobile'] ) && is_array( $val['grayscaleValueEndms_mobile'] ) && isset( $val['grayscaleValueEndms_mobile']['size'] )
					) {
						$scene_loop_grayscale['xs'] = array( $val['grayscaleValueStartms_mobile']['size'], $val['grayscaleValueEndms_mobile']['size'] );
					}
					$scene_loop['grayscalems']['grayscaleValuems'] = $scene_loop_grayscale;
				}

				/** Brightness */
				if ( 'yes' === $brightnessms ) {
					$scene_loop_brightness = array();

					if (
						isset( $val['brightnessValueStartms'] ) && is_array( $val['brightnessValueStartms'] ) && isset( $val['brightnessValueStartms']['size'] ) &&
						isset( $val['brightnessValueEndms'] ) && is_array( $val['brightnessValueEndms'] ) && isset( $val['brightnessValueEndms']['size'] )
					) {
						$scene_loop_brightness['md'] = array( $val['brightnessValueStartms']['size'], $val['brightnessValueEndms']['size'] );
					}

					if (
						isset( $val['brightnessValueStartms_tablet'] ) && is_array( $val['brightnessValueStartms_tablet'] ) && isset( $val['brightnessValueStartms_tablet']['size'] ) &&
						isset( $val['brightnessValueEndms_tablet'] ) && is_array( $val['brightnessValueEndms_tablet'] ) && isset( $val['brightnessValueEndms_tablet']['size'] )
					) {
						$scene_loop_brightness['sm'] = array( $val['brightnessValueStartms_tablet']['size'], $val['brightnessValueEndms_tablet']['size'] );
					}

					if (
						isset( $val['brightnessValueStartms_mobile'] ) && is_array( $val['brightnessValueStartms_mobile'] ) && isset( $val['brightnessValueStartms_mobile']['size'] ) &&
						isset( $val['brightnessValueEndms_mobile'] ) && is_array( $val['brightnessValueEndms_mobile'] ) && isset( $val['brightnessValueEndms_mobile']['size'] )
					) {
						$scene_loop_brightness['xs'] = array( $val['brightnessValueStartms_mobile']['size'], $val['brightnessValueEndms_mobile']['size'] );
					}
					$scene_loop['brightnessms']['brightnessValuems'] = $scene_loop_brightness;
				}

				/** Rotate */
				if ( 'yes' === $rotatetp ) {
					$rotate_loopx = array();
					if ( ( isset( $val['rotateXtprs'] ) && ! empty( $val['rotateXtprs'] ) && isset( $val['rotateXtprs']['size'] ) ) && ( isset( $val['rotateXtpre'] ) && ! empty( $val['rotateXtpre'] ) && isset( $val['rotateXtpre']['size'] ) ) ) {
						$rotate_loopx['md'] = array( $val['rotateXtprs']['size'], $val['rotateXtpre']['size'] );
					}

					if ( ( isset( $val['rotateXtprs_tablet'] ) && ! empty( $val['rotateXtprs_tablet'] ) && isset( $val['rotateXtprs_tablet']['size'] ) ) && ( isset( $val['rotateXtpre_tablet'] ) && ! empty( $val['rotateXtpre_tablet'] ) && isset( $val['rotateXtpre_tablet']['size'] ) ) ) {
						$rotate_loopx['sm'] = array( $val['rotateXtprs_tablet']['size'], $val['rotateXtpre_tablet']['size'] );
					}

					if ( ( isset( $val['rotateXtprs_mobile'] ) && ! empty( $val['rotateXtprs_mobile'] ) && isset( $val['rotateXtprs_mobile']['size'] ) ) && ( isset( $val['rotateXtpre_mobile'] ) && ! empty( $val['rotateXtpre_mobile'] ) && isset( $val['rotateXtpre_mobile']['size'] ) ) ) {
						$rotate_loopx['xs'] = array( $val['rotateXtprs_mobile']['size'], $val['rotateXtpre_mobile']['size'] );
					}
					$scene_loop['rotate']['rotateX'] = $rotate_loopx;

					$rotate_loopy = array();
					if ( ( isset( $val['rotateYtprs'] ) && ! empty( $val['rotateYtprs'] ) && isset( $val['rotateYtprs']['size'] ) ) && ( isset( $val['rotateYtpre'] ) && ! empty( $val['rotateYtpre'] ) && isset( $val['rotateYtpre']['size'] ) ) ) {
						$rotate_loopy['md'] = array( $val['rotateYtprs']['size'], $val['rotateYtpre']['size'] );
					}

					if ( ( isset( $val['rotateYtprs_tablet'] ) && ! empty( $val['rotateYtprs_tablet'] ) && isset( $val['rotateYtprs_tablet']['size'] ) ) && ( isset( $val['rotateYtpre_tablet'] ) && ! empty( $val['rotateYtpre_tablet'] ) && isset( $val['rotateYtpre_tablet']['size'] ) ) ) {
						$rotate_loopy['sm'] = array( $val['rotateYtprs_tablet']['size'], $val['rotateYtpre_tablet']['size'] );
					}

					if ( ( isset( $val['rotateYtprs_mobile'] ) && ! empty( $val['rotateYtprs_mobile'] ) && isset( $val['rotateYtprs_mobile']['size'] ) ) && ( isset( $val['rotateYtpre_mobile'] ) && ! empty( $val['rotateYtpre_mobile'] ) && isset( $val['rotateYtpre_mobile']['size'] ) ) ) {
						$rotate_loopy['xs'] = array( $val['rotateYtprs_mobile']['size'], $val['rotateYtpre_mobile']['size'] );
					}
					$scene_loop['rotate']['rotateY'] = $rotate_loopy;

					$rotate_loopz = array();
					if ( ( isset( $val['rotateZtprs'] ) && ! empty( $val['rotateZtprs'] ) && isset( $val['rotateZtprs']['size'] ) ) && ( isset( $val['rotateZtpre'] ) && ! empty( $val['rotateZtpre'] ) && isset( $val['rotateZtpre']['size'] ) ) ) {
						$rotate_loopz['md'] = array( $val['rotateZtprs']['size'], $val['rotateZtpre']['size'] );
					}

					if ( ( isset( $val['rotateZtprs_tablet'] ) && ! empty( $val['rotateZtprs_tablet'] ) && isset( $val['rotateZtprs_tablet']['size'] ) ) && ( isset( $val['rotateZtpre_tablet'] ) && ! empty( $val['rotateZtpre_tablet'] ) && isset( $val['rotateZtpre_tablet']['size'] ) ) ) {
						$rotate_loopz['sm'] = array( $val['rotateZtprs_tablet']['size'], $val['rotateZtpre_tablet']['size'] );
					}

					if ( ( isset( $val['rotateZtprs_mobile'] ) && ! empty( $val['rotateZtprs_mobile'] ) && isset( $val['rotateZtprs_mobile']['size'] ) ) && ( isset( $val['rotateZtpre_mobile'] ) && ! empty( $val['rotateZtpre_mobile'] ) && isset( $val['rotateZtpre_mobile']['size'] ) ) ) {
						$rotate_loopz['xs'] = array( $val['rotateZtprs_mobile']['size'], $val['rotateZtpre_mobile']['size'] );
					}
					$scene_loop['rotate']['rotateZ']  = $rotate_loopz;
					$scene_loop['rotate']['position'] = ! empty( $val['positiontpr'] ) ? $val['positiontpr'] : 'center center';
				}

				/** Scale */
				if ( 'yes' === $scaletp ) {
					$scale_loopx = array();
					if ( ( isset( $val['scaleXtpss'] ) && ! empty( $val['scaleXtpss'] ) && isset( $val['scaleXtpss']['size'] ) ) && ( isset( $val['scaleXtpse'] ) && ! empty( $val['scaleXtpse'] ) && isset( $val['scaleXtpse']['size'] ) ) ) {
						$scale_loopx['md'] = array( $val['scaleXtpss']['size'], $val['scaleXtpse']['size'] );
					}

					if ( ( isset( $val['scaleXtpss_tablet'] ) && ! empty( $val['scaleXtpss_tablet'] ) && isset( $val['scaleXtpss_tablet']['size'] ) ) && ( isset( $val['scaleXtpse_tablet'] ) && ! empty( $val['scaleXtpse_tablet'] ) && isset( $val['scaleXtpse_tablet']['size'] ) ) ) {
						$scale_loopx['sm'] = array( $val['scaleXtpss_tablet']['size'], $val['scaleXtpse_tablet']['size'] );
					}

					if ( ( isset( $val['scaleXtpss_mobile'] ) && ! empty( $val['scaleXtpss_mobile'] ) && isset( $val['scaleXtpss_mobile']['size'] ) ) && ( isset( $val['scaleXtpse_mobile'] ) && ! empty( $val['scaleXtpse_mobile'] ) && isset( $val['scaleXtpse_mobile']['size'] ) ) ) {
						$scale_loopx['xs'] = array( $val['scaleXtpss_mobile']['size'], $val['scaleXtpse_mobile']['size'] );
					}
					$scene_loop['scale']['scaleX'] = $scale_loopx;

					$scale_loopy = array();
					if ( ( isset( $val['scaleYtpss'] ) && ! empty( $val['scaleYtpss'] ) && isset( $val['scaleYtpss']['size'] ) ) && ( isset( $val['scaleYtpse'] ) && ! empty( $val['scaleYtpse'] ) && isset( $val['scaleYtpse']['size'] ) ) ) {
						$scale_loopy['md'] = array( $val['scaleYtpss']['size'], $val['scaleYtpse']['size'] );
					}

					if ( ( isset( $val['scaleYtpss_tablet'] ) && ! empty( $val['scaleYtpss_tablet'] ) && isset( $val['scaleYtpss_tablet']['size'] ) ) && ( isset( $val['scaleYtpse_tablet'] ) && ! empty( $val['scaleYtpse_tablet'] ) && isset( $val['scaleYtpse_tablet']['size'] ) ) ) {
						$scale_loopy['sm'] = array( $val['scaleYtpss_tablet']['size'], $val['scaleYtpse_tablet']['size'] );
					}

					if ( ( isset( $val['scaleYtpss_mobile'] ) && ! empty( $val['scaleYtpss_mobile'] ) && isset( $val['scaleYtpss_mobile']['size'] ) ) && ( isset( $val['scaleYtpse_mobile'] ) && ! empty( $val['scaleYtpse_mobile'] ) && isset( $val['scaleYtpse_mobile']['size'] ) ) ) {
						$scale_loopy['xs'] = array( $val['scaleYtpss_mobile']['size'], $val['scaleYtpse_mobile']['size'] );
					}
					$scene_loop['scale']['scaleY'] = $scale_loopy;

					$scale_loopz = array();
					if ( ( isset( $val['scaleZtps'] ) && ! empty( $val['scaleZtps'] ) && isset( $val['scaleZtps']['size'] ) ) && ( isset( $val['scaleZtpe'] ) && ! empty( $val['scaleZtpe'] ) && isset( $val['scaleZtpe']['size'] ) ) ) {
						$scale_loopz['md'] = array( $val['scaleZtps']['size'], $val['scaleZtpe']['size'] );
					}

					if ( ( isset( $val['scaleZtps_tablet'] ) && ! empty( $val['scaleZtps_tablet'] ) && isset( $val['scaleZtps_tablet']['size'] ) ) && ( isset( $val['scaleZtpe_tablet'] ) && ! empty( $val['scaleZtpe_tablet'] ) && isset( $val['scaleZtpe_tablet']['size'] ) ) ) {
						$scale_loopz['sm'] = array( $val['scaleZtps_tablet']['size'], $val['scaleZtpe_tablet']['size'] );
					}

					if ( ( isset( $val['scaleZtps_mobile'] ) && ! empty( $val['scaleZtps_mobile'] ) && isset( $val['scaleZtps_mobile']['size'] ) ) && ( isset( $val['scaleZtpe_mobile'] ) && ! empty( $val['scaleZtpe_mobile'] ) && isset( $val['scaleZtpe_mobile']['size'] ) ) ) {
						$scale_loopz['xs'] = array( $val['scaleZtps_mobile']['size'], $val['scaleZtpe_mobile']['size'] );
					}
					$scene_loop['scale']['scaleZ'] = $scale_loopz;
				}

				/** Skew */
				if ( 'yes' === $skewtp ) {
					$skew_loopx = array();
					if ( ( isset( $val['skewXtpss'] ) && ! empty( $val['skewXtpss'] ) && isset( $val['skewXtpss']['size'] ) ) && ( isset( $val['skewXtpse'] ) && ! empty( $val['skewXtpse'] ) && isset( $val['skewXtpse']['size'] ) ) ) {
						$skew_loopx['md'] = array( $val['skewXtpss']['size'], $val['skewXtpse']['size'] );
					}

					if ( ( isset( $val['skewXtpss_tablet'] ) && ! empty( $val['skewXtpss_tablet'] ) && isset( $val['skewXtpss_tablet']['size'] ) ) && ( isset( $val['skewXtpse_tablet'] ) && ! empty( $val['skewXtpse_tablet'] ) && isset( $val['skewXtpse_tablet']['size'] ) ) ) {
						$skew_loopx['sm'] = array( $val['skewXtpss_tablet']['size'], $val['skewXtpse_tablet']['size'] );
					}

					if ( ( isset( $val['skewXtpss_mobile'] ) && ! empty( $val['skewXtpss_mobile'] ) && isset( $val['skewXtpss_mobile']['size'] ) ) && ( isset( $val['skewXtpse_mobile'] ) && ! empty( $val['skewXtpse_mobile'] ) && isset( $val['skewXtpse_mobile']['size'] ) ) ) {
						$skew_loopx['xs'] = array( $val['skewXtpss_mobile']['size'], $val['skewXtpse_mobile']['size'] );
					}
					$scene_loop['skew']['skewX'] = $skew_loopx;

					$skew_loopy = array();
					if ( ( isset( $val['skewYtpss'] ) && ! empty( $val['skewYtpss'] ) && isset( $val['skewYtpss']['size'] ) ) && ( isset( $val['skewYtpse'] ) && ! empty( $val['skewYtpse'] ) && isset( $val['skewYtpse']['size'] ) ) ) {
						$skew_loopy['md'] = array( $val['skewYtpss']['size'], $val['skewYtpse']['size'] );
					}

					if ( ( isset( $val['skewYtpss_tablet'] ) && ! empty( $val['skewYtpss_tablet'] ) && isset( $val['skewYtpss_tablet']['size'] ) ) && ( isset( $val['skewYtpse_tablet'] ) && ! empty( $val['skewYtpse_tablet'] ) && isset( $val['skewYtpse_tablet']['size'] ) ) ) {
						$skew_loopy['sm'] = array( $val['skewYtpss_tablet']['size'], $val['skewYtpse_tablet']['size'] );
					}

					if ( ( isset( $val['skewYtpss_mobile'] ) && ! empty( $val['skewYtpss_mobile'] ) && isset( $val['skewYtpss_mobile']['size'] ) ) && ( isset( $val['skewYtpse_mobile'] ) && ! empty( $val['skewYtpse_mobile'] ) && isset( $val['skewYtpse_mobile']['size'] ) ) ) {
						$skew_loopy['xs'] = array( $val['skewYtpss_mobile']['size'], $val['skewYtpse_mobile']['size'] );
					}
					$scene_loop['skew']['skewY'] = $skew_loopy;
				}

				/** BRadius */
				if ( 'yes' === $borderRtp ) {
						$from_b_rtp_loop = array();
					if ( ! empty( $val['fromBRtp'] ) ) {
						$from_b_rtp_loop['md'] = $val['fromBRtp'];
					}

					if ( ! empty( $val['fromBRtp_tablet'] ) ) {
						$from_b_rtp_loop['sm'] = $val['fromBRtp_tablet'];
					}

					if ( ! empty( $val['fromBRtp_mobile'] ) ) {
						$from_b_rtp_loop['xs'] = $val['fromBRtp_mobile'];
					}
						$abc['fromBR'] = $from_b_rtp_loop;

						$to_b_rtp_loop = array();
					if ( ! empty( $val['toBRtp'] ) ) {
						$to_b_rtp_loop['md'] = $val['toBRtp'];
					}

					if ( ! empty( $val['toBRtp_tablet'] ) ) {
						$to_b_rtp_loop['sm'] = $val['toBRtp_tablet'];
					}

					if ( ! empty( $val['toBRtp_mobile'] ) ) {
						$to_b_rtp_loop['xs'] = $val['toBRtp_mobile'];
					}
						$bbc['toBR']       = $to_b_rtp_loop;
					$scene_loop['borderR'] = array( $abc, $bbc );
				}

				/** BgColor */
				if ( 'yes' === $bgColortp ) {

					$from_colortploop = array();
					if ( ! empty( $val['fromColortp'] ) ) {
						$from_colortploop['fromColor'] = $val['fromColortp'];
					}
						$to_colortploop = array();
					if ( ! empty( $val['toColortp'] ) ) {
						$to_colortploop['toColor'] = $val['toColortp'];
					}

					$scene_loop['bgColor'] = array( $from_colortploop, $to_colortploop );
				}

				/** ScrollOptions */
				if ( 'yes' === $scrollOpttp ) {
					$scroll_opttp = $val['scrollOpttp'];

					if ( isset( $val['offsettp'] ) && ! empty( $val['offsettp'] ) && isset( $val['offsettp']['size'] ) ) {
						$scene_loop['offset']['md'] = $val['offsettp']['size'];
					} else {
						$scene_loop['offset']['md'] = 0;
					}

					if ( isset( $val['offsettp_tablet'] ) && ! empty( $val['offsettp_tablet'] ) && isset( $val['offsettp_tablet']['size'] ) ) {
						$scene_loop['offset']['sm'] = $val['offsettp_tablet']['size'];
					} else {
						$scene_loop['offset']['sm'] = 0;
					}

					if ( isset( $val['offsettp_mobile'] ) && ! empty( $val['offsettp_mobile'] ) && isset( $val['offsettp_mobile']['size'] ) ) {
						$scene_loop['offset']['xs'] = $val['offsettp_mobile']['size'];
					} else {
						$scene_loop['offset']['xs'] = 0;
					}

					/*duration*/
					if ( isset( $val['durationtp'] ) && ! empty( $val['durationtp'] ) && isset( $val['durationtp']['size'] ) ) {
						$scene_loop['duration']['md']   = $val['durationtp']['size'];
						$scene_loop['duration']['unit'] = $val['durationtp']['unit'];
					}

					if ( isset( $val['durationtp_tablet'] ) && ! empty( $val['durationtp_tablet'] ) && isset( $val['durationtp_tablet']['size'] ) ) {
						$scene_loop['duration']['sm'] = $val['durationtp_tablet']['size'];
					}

					if ( isset( $val['durationtp_mobile'] ) && ! empty( $val['durationtp_mobile'] ) && isset( $val['durationtp_mobile']['size'] ) ) {
						$scene_loop['duration']['xs'] = $val['durationtp_mobile']['size'];
					}

					/*trigger*/
					if ( isset( $val['triggertp'] ) && ! empty( $val['triggertp'] ) && isset( $val['triggertp']['size'] ) ) {
						$scene_loop['trigger']['md']   = $val['triggertp']['size'];
						$scene_loop['trigger']['unit'] = $val['triggertp']['unit'];
					}

					if ( isset( $val['triggertp_tablet'] ) && ! empty( $val['triggertp_tablet'] ) && isset( $val['triggertp_tablet']['size'] ) ) {
						$scene_loop['trigger']['sm'] = $val['triggertp_tablet']['size'];
					}

					if ( isset( $val['triggertp_mobile'] ) && ! empty( $val['triggertp_mobile'] ) && isset( $val['triggertp_mobile']['size'] ) ) {
						$scene_loop['trigger']['xs'] = $val['triggertp_mobile']['size'];
					}
				} else {
					$scene_loop['trigger']  = (object) array( 'md' => 0.5 );
					$scene_loop['duration'] = (object) array(
						'md'   => 300,
						'unit' => 'px',
					);
					$scene_loop['offset']   = (object) array(
						'md'   => '0',
						'unit' => 'px',
					);
				}

				/** Dynamic Height */
				if ( 'yes' === $dynamicHeighttp ) {
					$dynamic_height = array();

					if ( isset( $val['referenceHeighttp'] ) && ! empty( $val['referenceHeighttp'] ) ) {
						$dynamic_height['referenceHeight'] = $val['referenceHeighttp'];
					} else {
						$dynamic_height['referenceHeight'] = 1080;
					}

					$scene_loop['dynamicHeight'] = $dynamic_height;
				}

				/** Custom Selector */
				if ( ! empty( $val['selectortp'] ) ) {
					$scene_loop['selector'] = $val['selectortp'];
				}

				/** AdvOptions */
				if ( 'yes' === $advOptiontp ) {
					$adv_opt        = $val['advOptiontp'];
					$repeattpa_loop = array();

					if ( isset( $val['repeattpa'] ) ) {
						$repeattpa_loop['md'] = $val['repeattpa'];
					}

					if ( isset( $val['repeattpa_tablet'] ) ) {
						$repeattpa_loop['sm'] = $val['repeattpa_tablet'];
					}

					if ( isset( $val['repeattpa_mobile'] ) ) {
						$repeattpa_loop['xs'] = $val['repeattpa_mobile'];
					}
					$scene_loop['repeat'] = $repeattpa_loop;

					$delaytpa_loop = array();
					if ( isset( $val['delaytpa'] ) ) {
						$delaytpa_loop['md'] = $val['delaytpa'];
					}

					if ( isset( $val['delaytpa_tablet'] ) ) {
						$delaytpa_loop['sm'] = $val['delaytpa_tablet'];
					}

					if ( isset( $val['delaytpa_mobile'] ) ) {
						$delaytpa_loop['xs'] = $val['delaytpa_mobile'];
					}

					$scene_loop['delay'] = $delaytpa_loop;

					$timingtpa_loop = array();
					if ( ! empty( $val['timingtpa'] ) ) {
						$timingtpa_loop['md'] = $val['timingtpa'];
					}

					if ( ! empty( $val['timingtpa_tablet'] ) ) {
						$timingtpa_loop['sm'] = $val['timingtpa_tablet'];
					}

					if ( ! empty( $val['timingtpa_mobile'] ) ) {
						$timingtpa_loop['xs'] = $val['timingtpa_mobile'];
					}

					$scene_loop['timing'] = $timingtpa_loop;

					if ( ! empty( $val['easingtpa'] ) ) {
						$scene_loop['easing'] = $val['easingtpa'];
					}
				} else {
					$scene_loop['repeat'] = (object) array( 'md' => 0 );
					$scene_loop['delay']  = (object) array( 'md' => 0 );
					$scene_loop['timing'] = (object) array( 'md' => 1 );
				}

				/** Sticky */
				if ( 'yes' === $stickytp ) {
					$scene_loop['sticky'] = isset( $val['stickytp'] ) && 'yes' === $val['stickytp'] ? true : false;


					if( ! empty( $zindexsticky ) ) {
						$scene_loop['zindex'] = $zindexsticky;
					}
				}

				/** Developer */
				if ( isset( $developtp ) ) {
					$scene_loop['develop'] = isset( $val['developtp'] ) && 'yes' === $val['developtp'] ? true : false;
					if ( true === $scene_loop['develop'] && ! empty( $val['devNametp'] ) ) {
						$scene_loop['develop_name'] = $val['devNametp'];
					}
				}

				if ( ! empty( $scene_loop ) ) {
					$scroll_attr[] = $scene_loop;
				}
			}

			/** Visibility */
			if ( isset( $settings['MSView'] ) ) {
				$devices = array();
				foreach ( $settings['MSView'] as $key => $val ) {
					$devices[] = $val;
				}
				$magic_attr .= ' data-tpms-msview="' . htmlspecialchars( wp_json_encode( $devices ), ENT_QUOTES, 'UTF-8' ) . '"';
			}

			if ( ! empty( $scroll_attr ) ) {
				$magic_attr .= ' data-tpms-ms="' . htmlspecialchars( wp_json_encode( $scroll_attr ), ENT_QUOTES, 'UTF-8' ) . '"';
			}

			return $magic_attr;
		}
	}
}

Tpaep_Adv_Magic_Scroll::get_instance();
