<div class="uap-wrapper">
<form  method="post">
	<div class="uap-stuffbox">
		<h3 class="uap-h3"><?php esc_html_e('Stripe - Payouts', 'uap');?></h3>
		<div class="inside">
			<div class="uap-form-line">
				<div class="row">
						<div class="col-xs-7">
							<h2><?php esc_html_e('Activate/Hold Stripe Gateway', 'uap');?></h2>
							<p><?php esc_html_e('Once activated you can process payments to your affiliate users via Stripe directly from the affiliate system.', 'uap');?></p>
							<label class="uap_label_shiwtch uap-switch-button-margin">
							<?php $checked = ($data['metas']['uap_stripe_v3_enable']) ? 'checked' : '';?>
								<input type="checkbox" class="uap-switch" onClick="uapCheckAndH(this, '#uap_stripe_v3_enable');" <?php echo esc_attr($checked);?> />
								<div class="switch uap-display-inline"></div>
							</label>
							<input type="hidden" name="uap_stripe_v3_enable" value="<?php echo esc_attr($data['metas']['uap_stripe_v3_enable']);?>" id="uap_stripe_v3_enable" />
						</div>
				</div>

				<div class="row">
					<div class="col-xs-10">
						<div class="uap-form-line">
							<div class="input-group">
							<label class="input-group-addon"><?php esc_html_e('Live Secret Key', 'uap');?></label>
								<input type="text" name="uap_stripe_v3_secret_key" value="<?php echo esc_attr($data['metas']['uap_stripe_v3_secret_key']);?>" class="form-control" />
							</div>

							<div class="uap-form-line"></div>

							<div class="input-group">
							<label class="input-group-addon"><?php esc_html_e('Live Publishable Key', 'uap');?></label>
								<input type="text" name="uap_stripe_v3_publishable_key" value="<?php echo esc_attr($data['metas']['uap_stripe_v3_publishable_key']);?>" class="form-control" />
							</div>

							<div class="uap-form-line"></div>

							<div class="input-group">
             		<label class="input-group-addon"><?php esc_html_e('Live mode client ID', 'uap');?></label>
              		<input type="text" name="uap_stripe_v3_client_id" value="<?php echo esc_attr($data['metas']['uap_stripe_v3_client_id']);?>" class="form-control" />
              </div>
						</div>

          <div class="row">
					<div class="col-xs-4">
						<div class="uap-form-line">
						<h2><?php esc_html_e('Sandbox', 'uap');?></h2>
						<label class="uap_label_shiwtch uap-switch-button-margin">
						<?php $checked = ($data['metas']['uap_stripe_v3_sandbox']) ? 'checked' : '';?>
						<input type="checkbox" class="uap-switch" onClick="uapCheckAndH(this, '#uap_stripe_v3_sandbox');" <?php echo esc_attr($checked);?> />
						<div class="switch uap-display-inline"></div>
						</label>
						<input type="hidden" name="uap_stripe_v3_sandbox" value="<?php echo esc_attr($data['metas']['uap_stripe_v3_sandbox']);?>" id="uap_stripe_v3_sandbox" />
					</div>
				</div>
				</div>
					<div class="row">
						<div class="col-xs-6">
            <div class="uap-form-line">

									<div class="input-group">
											<label class="input-group-addon"><?php esc_html_e('Sandbox Secret Key', 'uap');?></label>
											<input type="text" name="uap_stripe_v3_sandbox_secret_key" value="<?php echo esc_attr($data['metas']['uap_stripe_v3_sandbox_secret_key']);?>" class="form-control" />
									</div>

									<div class="uap-form-line"></div>

									<div class="input-group">
										<label class="input-group-addon"><?php esc_html_e('Sandbox Publishable Key', 'uap');?></label>
										<input type="text" name="uap_stripe_v3_sandbox_publishable_key" value="<?php echo esc_attr($data['metas']['uap_stripe_v3_sandbox_publishable_key']);?>"  class="form-control"/>
									</div>

									<div class="uap-form-line"></div>
									<div class="input-group">
											<label class="input-group-addon"><?php esc_html_e('Test mode client ID', 'uap');?></label>
											<input type="text" name="uap_stripe_v3_sandbox_client_id" value="<?php echo esc_attr($data['metas']['uap_stripe_v3_sandbox_client_id']);?>" class="form-control" />
									</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-6">
							<div class="uap-form-line">
								<h4><?php esc_html_e('Setup Intructions', 'uap');?></h4>
								<p><?php esc_html_e('To complete the Stripe Payout integration, please follow the step-by-step guide available in our documentation:', 'uap');?></p>
								<p><a href="https://ultimateaffiliate.pro/docs/setting-up-stripe-payouts/" target="_blank"><?php esc_html_e('Setting up Stripe Payouts', 'uap');?></a></p>
								<p><?php esc_html_e('Make sure to carefully review each step to ensure a successful setup.', 'uap');?></p>
							</div>

						</div>
				</div>

				<div class="row">
						<div class="col-xs-6">
							<div class="uap-form-line">
								<?php
									if ( !isset( $data['metas']['uap_stripe_v3_source_type'] ) ){
											$data['metas']['uap_stripe_v3_source_type'] = 'card';
									}
								?>
								<div class="input-group">
								<label class="input-group-addon"><?php esc_html_e('Balance Source', 'uap');?></label>
								<select name="uap_stripe_v3_source_type">
										<option value="bank_account" <?php if ( $data['metas']['uap_stripe_v3_source_type'] === 'bank_account' ) echo esc_attr('selected');?> ><?php esc_html_e('Bank Account', 'uap');?></option>
										<option value="card" <?php if ( $data['metas']['uap_stripe_v3_source_type'] === 'card' ) echo esc_attr('selected');?> ><?php esc_html_e('Card', 'uap');?></option>
										<option value="fpx" <?php if ( $data['metas']['uap_stripe_v3_source_type'] === 'fpx' ) echo esc_attr('selected');?> ><?php esc_html_e('FPX', 'uap');?></option>
								</select>
								</div>
								<p><?php esc_html_e('The source balance to use for transfers.','uap'); ?></p>
							</div>
						</div>
				</div>

				<div class="inside">
					<h5 class="uap-h5"><?php esc_html_e('Important:', 'uap');?></h5>
					<p><?php esc_html_e('1. When Affiliate connects his Stripe Account with your merchant Stripe Account, Stripe will create a Sub Account for him where payout will be transferred.','uap'); ?></p>
					<p><?php esc_html_e('2. Affiliates may see all their Sub Accounts on Profile page from Stripe Dashboard.', 'uap');?></p>
					<p><?php esc_html_e('3. In order to run some tests before switching live, make sure that in Stripe balance you have the required amount to be in the same currency as the currency saved in UAP.', 'uap');?></p>
					<p><?php esc_html_e('4. In "Settings" > "Connect settings" make sure that you have configured ', 'uap');?> <b> <?php esc_html_e('Accounts Types', 'uap');?></b> <?php esc_html_e(' and ', 'uap');?> <b> <?php esc_html_e('Capabilities.', 'uap');?></b></p>
				</div>

				<div id="uap_save_changes" class="uap-submit-form">
					<input type="submit" value="<?php esc_html_e('Save Changes', 'uap');?>" name="save" class="button button-primary button-large" />
				</div>
			</div>
		</div>
	</div>
</div>
</div>
</form>
</div>
