<?php
/**
 * @wordpress-plugin
 * Plugin Name:       Wordfence Security Activator
 * Plugin URI:        https://www.wordfence.com
 * Description:       فعال کننده افزونه وردفنس
 * Version:           2.5.0
 * Author:            Activ@tor
 * Author URI:        https://www.wordfence.com
 * Downloaded:		  Pluginyab.ir
 **/

// Security
defined('ABSPATH') || exit;

$PLUGIN_NAME   = 'Wordfence Security Activator';
$PLUGIN_DOMAIN = 'wordfence-security-activator';
$RemainingDays = 365 * 10;

/** Handle database operations with proper multisite support */
function wf_activator_update_config() {
    global $wpdb;
    
    // Get the current blog ID
    $blog_id = get_current_blog_id();
    
    // For multisite, we need to handle the main site and subsites differently
    if (is_multisite()) {
        // Get all sites in the network
        $sites = get_sites();
        
        foreach ($sites as $site) {
            // Switch to each site context
            switch_to_blog($site->blog_id);
            
            // Get the correct table prefix for this site
            $table_name = $wpdb->prefix . 'wfconfig';
            
            // Check if the table exists
            $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'");
            
            if ($table_exists) {
                // Proceed with database operations only if the table exists
                $data = array(
                    'name' => 'scan_exclude',
                    'val' => '/wordfence-activator/*',
                    'autoload' => 'yes'
                );
                
                // Check if entry exists
                $existing_entry = $wpdb->get_var($wpdb->prepare(
                    "SELECT COUNT(*) FROM $table_name WHERE name = %s",
                    $data['name']
                ));
                
                if ($existing_entry == 0) {
                    // Insert the new record if no entry exists
                    $wpdb->insert($table_name, $data, array('%s', '%s', '%s'));
                } else {
                    // Check if the value already contains our exclusion
                    $current_val = $wpdb->get_var($wpdb->prepare(
                        "SELECT val FROM $table_name WHERE name = %s",
                        $data['name']
                    ));
                    
                    if (strpos($current_val, $data['val']) === false) {
                        // Append the new value to the existing value only if it's not already there
                        $wpdb->query(
                            $wpdb->prepare(
                                "UPDATE $table_name SET val = CONCAT(val, %s) WHERE name = %s",
                                ',' . $data['val'], // Appending a comma and the new value
                                $data['name']
                            )
                        );
                    }
                }
            }
            
            // Switch back to the current site
            restore_current_blog();
        }
    } else {
        // Single site WordPress installation
        $table_name = $wpdb->prefix . 'wfconfig';
        
        // Check if the table exists
        $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'");
        
        if ($table_exists) {
            $data = array(
                'name' => 'scan_exclude',
                'val' => '/wordfence-activator/*',
                'autoload' => 'yes'
            );
            
            $existing_entry = $wpdb->get_var($wpdb->prepare(
                "SELECT COUNT(*) FROM $table_name WHERE name = %s",
                $data['name']
            ));
            
            if ($existing_entry == 0) {
                // Insert the new record if no entry exists
                $wpdb->insert($table_name, $data, array('%s', '%s', '%s'));
            } else {
                // Check if the value already contains our exclusion
                $current_val = $wpdb->get_var($wpdb->prepare(
                    "SELECT val FROM $table_name WHERE name = %s",
                    $data['name']
                ));
                
                if (strpos($current_val, $data['val']) === false) {
                    // Append the new value to the existing value only if it's not already there
                    $wpdb->query(
                        $wpdb->prepare(
                            "UPDATE $table_name SET val = CONCAT(val, %s) WHERE name = %s",
                            ',' . $data['val'], // Appending a comma and the new value
                            $data['name']
                        )
                    );
                }
            }
        }
    }
}

// Run the database update function
wf_activator_update_config();


$init = function () use ($RemainingDays, $PLUGIN_NAME) {
    try {
        wfOnboardingController::_markAttempt1Shown();
        wfConfig::set('onboardingAttempt3', wfOnboardingController::ONBOARDING_LICENSE);
        if (empty(wfConfig::get('apiKey'))) {
            wordfence::ajax_downgradeLicense_callback();
        }
        wfConfig::set('isPaid', true);
        wfConfig::set('keyType', wfLicense::KEY_TYPE_PAID_CURRENT);
        wfConfig::set('premiumNextRenew', time() + $RemainingDays * 86400);
        wfWAF::getInstance()->getStorageEngine()->setConfig('wafStatus', wfFirewall::FIREWALL_MODE_ENABLED);
    } catch (Exception $exception) {
        // Handle the exception if needed
    }
};

add_action('plugins_loaded', function () use ($RemainingDays, $init) {
    if (class_exists('wfLicense')) {
        $init();
        wfLicense::current()->setType(wfLicense::TYPE_RESPONSE);
        wfLicense::current()->setPaid(true);
        wfLicense::current()->setRemainingDays($RemainingDays);
        wfLicense::current()->setConflicting(false);
        wfLicense::current()->setDeleted(false);
        wfLicense::current()->getKeyType();
    }
});
