<?php
namespace TRegx\CleanRegex\Internal\Numeral;

class NumeralLowerBound
{
    /** @var string[] */
    private $lowerBounds64 = [
        2  => '1000000000000000000000000000000000000000000000000000000000000000',
        3  => '2021110011022210012102010021220101220222',
        4  => '20000000000000000000000000000000',
        5  => '1104332401304422434310311213',
        6  => '1540241003031030222122212',
        7  => '22341010611245052052301',
        8  => '1000000000000000000000',
        9  => '67404283172107811828',
        10 => '9223372036854775808',
        11 => '1728002635214590698',
        12 => '41a792678515120368',
        13 => '10b269549075433c38',
        14 => '4340724c6c71dc7a8',
        15 => '160e2ad3246366808',
        16 => '8000000000000000',
        17 => '33d3d8307b214009',
        18 => '16agh595df825fa8',
        19 => 'ba643dci0ffeehi',
        20 => '5cbfjia3fh26ja8',
        21 => '2heiciiie82dh98',
        22 => '1adaibb21dckfa8',
        23 => 'i6k448cf4192c3',
        24 => 'acd772jnc9l0l8',
        25 => '64ie1focnn5g78',
        26 => '3igoecjbmca688',
        27 => '27c48l5b37oaoq',
        28 => '1bk39f3ah3dmq8',
        29 => 'q1se8f0m04isc',
        30 => 'hajppbc1fc208',
        31 => 'bm03i95hia438',
        32 => '8000000000000',
        33 => '5hg4ck9jd4u38',
        34 => '3tdtk1v8j6tpq',
        35 => '2pijmikexrxp8',
        36 => '1y2p0ij32e8e8',
    ];
    /** @var string[] */
    private $lowerBounds32 = [
        2  => '10000000000000000000000000000000',
        3  => '12112122212110202102',
        4  => '2000000000000000',
        5  => '13344223434043',
        6  => '553032005532',
        7  => '104134211162',
        8  => '20000000000',
        9  => '5478773672',
        10 => '2147483648',
        11 => 'a02220282',
        12 => '4bb2308a8',
        13 => '282ba4aab',
        14 => '1652ca932',
        15 => 'c87e66b8',
        16 => '80000000',
        17 => '53g7f549',
        18 => '3928g3h2',
        19 => '27c57h33',
        20 => '1db1f928',
        21 => '140h2d92',
        22 => 'ikf5bf2',
        23 => 'ebelf96',
        24 => 'b5gge58',
        25 => '8jmdnkn',
        26 => '6oj8ioo',
        27 => '5ehnckb',
        28 => '4clm98g',
        29 => '3hk7988',
        30 => '2sb6cs8',
        31 => '2d09uc2',
        32 => '2000000',
        33 => '1lsqtl2',
        34 => '1d8xqrq',
        35 => '15v22un',
        36 => 'zik0zk',
    ];

    public function lowerBound(Base $base): string
    {
        if (\PHP_INT_SIZE === 8) {
            return $this->lowerBounds64[$base->base()];
        }
        return $this->lowerBounds32[$base->base()];
    }

    public function minimalValue(): int
    {
        if (\PHP_INT_SIZE === 8) {
            return -9223372036854775806 - 2;
        }
        return -2147483646 - 2;
    }
}
