import type { SVGProps } from 'react';
interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}
const key = ({
    size = 24,
    fill = 'none',
    stroke = 'none',
    strokeWidth = 1,
    viewBox = '0 0 23 13',
    ...props
}:CustomIconProps) => (
    <svg
        width={size}
        height={size}
        fill={fill}
        stroke={stroke}
        strokeWidth={strokeWidth}
        viewBox={viewBox}
        strokeLinecap="round"
        strokeLinejoin="round"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            d="M6.25879 8.5C5.70879 8.5 5.23796 8.30417 4.84629 7.9125C4.45462 7.52083 4.25879 7.05 4.25879 6.5C4.25879 5.95 4.45462 5.47917 4.84629 5.0875C5.23796 4.69583 5.70879 4.5 6.25879 4.5C6.80879 4.5 7.27962 4.69583 7.67129 5.0875C8.06296 5.47917 8.25879 5.95 8.25879 6.5C8.25879 7.05 8.06296 7.52083 7.67129 7.9125C7.27962 8.30417 6.80879 8.5 6.25879 8.5ZM6.25879 12.5C4.59212 12.5 3.17546 11.9167 2.00879 10.75C0.842122 9.58333 0.258789 8.16667 0.258789 6.5C0.258789 4.83333 0.842122 3.41667 2.00879 2.25C3.17546 1.08333 4.59212 0.5 6.25879 0.5C7.37546 0.5 8.38796 0.775 9.29629 1.325C10.2046 1.875 10.9255 2.6 11.4588 3.5H19.8338C19.9671 3.5 20.0963 3.525 20.2213 3.575C20.3463 3.625 20.4588 3.7 20.5588 3.8L22.5588 5.8C22.6588 5.9 22.7296 6.00833 22.7713 6.125C22.813 6.24167 22.8338 6.36667 22.8338 6.5C22.8338 6.63333 22.813 6.75833 22.7713 6.875C22.7296 6.99167 22.6588 7.1 22.5588 7.2L19.3838 10.375C19.3005 10.4583 19.2005 10.525 19.0838 10.575C18.9671 10.625 18.8505 10.6583 18.7338 10.675C18.6171 10.6917 18.5005 10.6833 18.3838 10.65C18.2671 10.6167 18.1588 10.5583 18.0588 10.475L16.7588 9.5L15.3338 10.575C15.2505 10.6417 15.1588 10.6917 15.0588 10.725C14.9588 10.7583 14.8588 10.775 14.7588 10.775C14.6588 10.775 14.5546 10.7583 14.4463 10.725C14.338 10.6917 14.2421 10.6417 14.1588 10.575L12.6338 9.5H11.4588C10.9255 10.4 10.2046 11.125 9.29629 11.675C8.38796 12.225 7.37546 12.5 6.25879 12.5ZM6.25879 10.5C7.19212 10.5 8.01296 10.2167 8.72129 9.65C9.42962 9.08333 9.90046 8.36667 10.1338 7.5H13.2588L14.7088 8.525L16.7588 7L18.5338 8.375L20.4088 6.5L19.4088 5.5H10.1338C9.90046 4.63333 9.42962 3.91667 8.72129 3.35C8.01296 2.78333 7.19212 2.5 6.25879 2.5C5.15879 2.5 4.21712 2.89167 3.43379 3.675C2.65046 4.45833 2.25879 5.4 2.25879 6.5C2.25879 7.6 2.65046 8.54167 3.43379 9.325C4.21712 10.1083 5.15879 10.5 6.25879 10.5Z"
        />
    </svg>
);

export default key;