<?php if (!defined('WPO_VERSION')) die('No direct access allowed'); ?>
<div id="wpo_auto_cleanup">
	<h3><?php esc_html_e('Scheduled clean-up settings', 'wp-optimize'); ?></h3>
	<div class="wpo-fieldgroup">
		<div id="wp-optimize-auto-options">
			<div class="wpo_auto_event_heading wpo_no_schedules"><?php echo esc_html__('There are no scheduled tasks.', 'wp-optimize'); ?></div>
			<div id="save_settings_reminder" class="save_settings_reminder"><?php esc_html_e('Remember to save your settings so that your changes take effect.', 'wp-optimize');?></div>
			<p class="innodb_force_optimize--container<?php echo $show_innodb_option ? '' : ' hidden'; ?>">
				<span class="dashicons dashicons-warning"></span>
				<strong><?php esc_html_e('Tables using the InnoDB engine', 'wp-optimize'); ?></strong><br>
				<input name="auto-innodb" id="auto-innodb" type="checkbox" value="true" <?php checked($settings_cleanup_data['data']['is_auto_innodb'], 'true'); ?>>
				<label for="auto-innodb"><?php esc_html_e('Optimize InnoDB tables anyway.', 'wp-optimize'); ?></label>
				<?php echo $settings_cleanup_data['data']['warning_url'];  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Output already escaped ?>
			</p>
			<div id="wpo_auto_events" class="wpo_cf">
				<?php

				$auto_options = $settings_cleanup_data['data']['scheduled_optimizations'];
				if (!empty($auto_options)) {
				?>
					<div class="wpo_auto_event_heading_container wpo_cf">
						<div class="wpo_optimizations wpo_auto_event_heading"><?php esc_html_e('Optimizations', 'wp-optimize'); ?></div>
						<div class="wpo_schedule wpo_auto_event_heading"><?php esc_html_e('Type', 'wp-optimize'); ?></div>
						<div class="wpo_schedule_details wpo_auto_event_heading"><?php esc_html_e('Schedule', 'wp-optimize'); ?></div>
						<div class="wpo_schedule_status wpo_auto_event_heading"><?php esc_html_e('Status', 'wp-optimize'); ?></div>
						<div class="wpo_actions wpo_auto_event_heading"><?php esc_html_e('Actions', 'wp-optimize'); ?></div>
					</div>
				<?php
				}

				foreach ($auto_options as $index => $event) {
					$div_schedule_fields_opened = false;
					wpo_display_event_summary($index, $event, $settings_cleanup_data['data']['auto_optimizations'], $settings_cleanup_data['data']['week_days']);
					printf('<div class="wpo_auto_event wpo_cf" data-count="%s" style="display: none;">', esc_attr($index));
					foreach ($event as $key => $value) {
						switch ($key) {
							case 'optimization':
								wpo_display_optimizations($value, $index, $settings_cleanup_data['data']['auto_optimizations']);
								break;
							case 'schedule_type':
								wpo_display_schedule_type($value, $index, $settings_cleanup_data['data']['provided_schedule_types']);
								echo '<div class="wpo_schedule_fields">';
								$div_schedule_fields_opened = true;
								break;
							case 'date':
								wpo_display_date($value, $index);
								break;
							case 'time':
								wpo_display_time($value, $index);
								break;
							case 'week':
								wpo_display_week($value, $index);
								break;
							case 'day':
								wpo_display_week_day($value, $index, $settings_cleanup_data['data']['week_days']);
								break;
							case 'day_number':
								wpo_display_day_number($value, $index, $settings_cleanup_data['data']['days']);
								break;
							case 'status':
								if ($div_schedule_fields_opened) {
									echo '</div>';
									$div_schedule_fields_opened = false;
								}
								wpo_display_status($value, $index);
								break;
						}
					}

					if ($div_schedule_fields_opened) {
						echo '</div>';
						$div_schedule_fields_opened = false;
					}

					wpo_display_actions($index);
					echo '</div>';
				}
				?>
			</div>
		</div>
		<p><a href="#" id="wpo-add-event" class="wpo-repeater__add"><span class="dashicons dashicons-plus"></span> <?php esc_html_e('Add scheduled task', 'wp-optimize'); ?></a></p>
	</div>
</div>	
<?php
/**
 * Displays scheduled event summary
 *
 * @param integer $index Count of events
 * @param array   $event An array with event details
 *
 * @return void
 */
function wpo_display_event_summary($index, $event, $auto_optimizations, $week_days) {
	// var_dump($event);
	printf('<div class="wpo_scheduled_event wpo_cf" data-count="%s">'."\n", esc_attr($index));

	if (isset($event['optimization']) && is_array($event['optimization'])) wpo_display_optimization_list($event['optimization'], $auto_optimizations);
	if (isset($event['schedule_type'])) {
	?>

	<div class="wpo_schedule"><?php echo esc_html(ucfirst(substr($event['schedule_type'], 4))); ?></div>

	<?php } ?>
	<div class="wpo_schedule_details">
		<?php
		if (isset($event['date'])) {
			// translators: %s is a date
			printf('<span class="wpo_schedule_date">%s</span>', sprintf(esc_html__('Date: %s', 'wp-optimize'), esc_html($event['date'])));
		}
		if (isset($event['time'])) {
			// translators: %s is a time
			printf('<span class="wpo_schedule_time">%s</span>', sprintf(esc_html__('Time: %s', 'wp-optimize'), esc_html($event['time'])));
		}
		if (isset($event['week'])) {
			// translators: %s is a week
			printf('<span class="wpo_schedule_week">%s</span>', sprintf(esc_html__('Week: %s', 'wp-optimize'), esc_html($event['week'])));
		}
		if (isset($event['day'])) {
			// translators: %s is a week day
			printf('<span class="wpo_schedule_week_day">%s</span>', sprintf(esc_html__('Day: %s', 'wp-optimize'), esc_html($week_days[$event['day']])));
		}
		if (isset($event['day_number'])) {
			// translators: %s is a day number
			printf('<span class="wpo_schedule_day_number">%s</span>', sprintf(esc_html__('Date: %s', 'wp-optimize'), esc_html($event['day_number'])));
		}
		?>
	</div>
	<?php if (isset($event['status'])) { ?>

			<div class="wpo_schedule_status <?php echo ('1' == $event['status']) ? 'active' : 'inactive'; ?>">
				<?php
					$status = ('1' == $event['status']) ? __('Active', 'wp-optimize') : __('Inactive', 'wp-optimize');
					echo esc_html($status);
				?>
			</div>
	<?php
	}

	wpo_display_actions($index, true);
	?>

	</div> <!-- End of .wpo_scheduled_event -->

	<?php
}

/**
 * Displays available auto optimizations as select field
 *
 * @param array   $optimizations An array of available auto optimizations
 * @param integer $count         Index of scheduled events
 *
 * @return void
 */
function wpo_display_optimizations($optimizations, $count, $auto_optimizations) {
	$html = '';
	$html .= sprintf('<select class="wpo_auto_optimizations" name="wp-optimize-auto[%s][optimization][]" multiple="multiple">', esc_attr($count));
	foreach ($auto_optimizations as $id => $details) {
		$selected = in_array($id, $optimizations) ? 'selected="selected"' : '';
		$html .= sprintf('<option value="%1$s" %2$s>%3$s</option>', esc_attr($id), $selected, esc_html($details['optimization']));
	}
	$html .= '</select>';
	echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Output already escaped
}

/**
 * Displays schedule type as select field
 *
 * @param array   $schedule_type Date value
 * @param integer $count         Index of scheduled events
 *
 * @return void
 */
function wpo_display_schedule_type($schedule_type, $count, $schedule_types) {
	$html = '';
	$html .= sprintf('<select class="wpo_schedule_type" name="wp-optimize-auto[%s][schedule_type]">', esc_attr($count));
	foreach ($schedule_types as $key => $value) {
		$html .= sprintf('<option value="%1$s" %2$s>%3$s</option>', esc_attr($key), selected($schedule_type, $key, false), esc_html($value));
	}
	$html .= '</select>';
	echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Output already escaped
}

/**
 * Displays date field
 *
 * @param string  $date  Date value
 * @param integer $count Index of scheduled events
 *
 * @return void
 */
function wpo_display_date($date, $count) {
	$today = gmdate("Y-m-d");
	$html = '';
	$html .= sprintf('<label>%s', esc_html__('Date:', 'wp-optimize'));
	$html .= sprintf('<input type="date" name="wp-optimize-auto[%1$s][date]" value="%2$s" min="%3$s">', esc_attr($count), esc_attr($date), esc_attr($today));
	$html .= '</label>';
	echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Output already escaped
}

/**
 * Displays time field
 *
 * @param string  $time  Time value
 * @param integer $count Index of scheduled events
 *
 * @return void
 */
function wpo_display_time($time, $count) {
	$html = '';
	$html .= sprintf('<label>%s', esc_html__('Time:', 'wp-optimize'));
	$html .= sprintf('<input type="time" name="wp-optimize-auto[%1$s][time]" value="%2$s">', esc_attr($count), esc_attr($time));
	$html .= '</label>';
	echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Output already escaped
}

/**
 * Displays week select field
 *
 * @param array   $week  An array of 2 weeks
 * @param integer $count Index of scheduled events
 *
 * @return void
 */
function wpo_display_week($week, $count) {
	$weeks = array('1st' => __('1st', 'wp-optimize'), '2nd' => __('2nd', 'wp-optimize'));
	$html = '';
	$html .= sprintf('<select class="wpo_week_number" name="wp-optimize-auto[%s][week]">', esc_attr($count));
	foreach ($weeks as $key => $value) {
		$html .= sprintf('<option value="%1$s" %2$s>%3$s</option>', esc_attr($key), selected($week, $key, false), esc_html($value));
	}
	$html .= '</select>';
	echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Output already escaped
}

/**
 * Displays week days select field
 *
 * @param array   $week_day An array of week days
 * @param integer $count    Index of scheduled events
 *
 * @return void
 */
function wpo_display_week_day($week_day, $count, $week_days) {
	$html = '';
	$html .= sprintf('<select class="wpo_week_days" name="wp-optimize-auto[%s][day]">', esc_attr($count));
	foreach ($week_days as $key => $value) {
		$html .= sprintf('<option value="%1$s" %2$s>%3$s</option>', esc_attr($key), selected($week_day, $key, false), esc_html($value));
	}
	$html .= '</select>';
	echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Output already escaped
}

/**
 * Displays days select field
 *
 * @param array   $day   An array of days of a month
 * @param integer $count Index of scheduled events
 *
 * @return void
 */
function wpo_display_day_number($day, $count, $days) {
	$html = '';
	$html .= sprintf('<label>%s</label>', esc_html__('Day Number:', 'wp-optimize'));
	$html .= sprintf('<select class="wpo_day_number" name="wp-optimize-auto[%s][day_number]">', esc_attr($count));
	foreach ($days as $value) {
		$html .= sprintf('<option value="%1$s" %2$s>%3$s</option>', esc_attr($value), selected($day, $value, false), esc_html($value));
	}
	$html .= '</select>';
	echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Output already escaped
}

/**
 * Displays status field
 *
 * @param integer $status Status value
 * @param integer $count  Index of scheduled events
 *
 * @return void
 */
function wpo_display_status($status, $count) {
	echo '<div class="wpo_event_status">';
	printf('<label><input type="checkbox" name="wp-optimize-auto[%1$s][status]" value="1" %2$s>%3$s</label>', esc_attr($count), checked($status, 1, false), esc_html__('Active', 'wp-optimize'));
	echo '</div>';
}

/**
 * Displays actions field
 *
 * @param integer $index Count of event
 * @param boolean $edit  Boolean value to determine edit action
 *
 * @return void
 */
function wpo_display_actions($index, $edit = false) {
	printf('<div class="wpo_event_actions %s">', $edit ? "wpo_event_edit" : "");
	if (true === $edit) {
		printf('<span class="wpo_edit_event" title="%1$s">%1$s</span>', esc_html__('Edit', 'wp-optimize'));
		printf('<span class="wpo_remove_event" title="%1$s" data-count="%2$s">%1s</span>', esc_html__('Delete', 'wp-optimize'), esc_attr($index));
	} else {
		printf('<span class="wpo_cancel_event button button-secondary" title="%1$s">%1$s</span>', esc_html__('Cancel', 'wp-optimize'));
		printf('<span class="wpo_save_event button button-primary" title="%1$s">%1$s</span>', esc_html__('Apply', 'wp-optimize'));
	}
	echo '</div>';
}

/**
 * Displays date field
 *
 * @param array $optimizations An array of selected optimizations
 *
 * @return void
 */
function wpo_display_optimization_list($optimizations, $auto_optimizations) {
	$html = '';
	$html .= '<ul class="wpo_optimizations">';
	foreach ($optimizations as $optimization) {
		$html .= sprintf('<li data-optimization="%s"><span class="dashicons dashicons-arrow-right"></span>%s</li>', esc_attr($optimization), esc_html($auto_optimizations[$optimization]['optimization']));
	}
	$html .= '</ul>';
	echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Output already escaped
}
