# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Development Commands

### Build & Development
- `npm run dev` - Start webpack in watch mode for development
- `npm run build` - Create production build

### Code Quality
- Run WordPress Coding Standards checks with PHPCS (if configured)
- No built-in linting commands in package.json - check if project uses WordPress standards

### Deployment
- `npm run zip` - Create distribution zip on Desktop (macOS only)
- `npm run 7zip` - Create distribution zip using 7zip (cross-platform)

### Analysis
- `npm run analysis` - Analyze webpack bundle size

## Architecture Overview

This is a WordPress plugin called "Perfect Images" (formerly WP Retina 2x Pro) that handles responsive images, retina displays, and modern image formats.

### PHP Architecture
The plugin uses a modular class-based architecture:
- **Entry point**: `wp-retina-2x-pro.php` - Bootstraps the plugin and loads all components
- **Core system**: `classes/core.php` (`Meow_WR2X_Core`) - Central hub managing all features
- **Image processing**: `classes/engine.php` (`Meow_WR2X_Engine`) - Handles image generation, resizing, WebP/AVIF conversion
- **REST API**: `classes/rest.php` - Provides endpoints for admin operations
- **Admin interface**: `classes/admin.php` and `classes/dashboard.php` - Settings and media library integration
- **Pro features**: `premium/` directory - Contains upscaling and advanced features

### JavaScript Architecture
Modern React-based admin interface:
- **Entry**: `app/js/index.js` - Main React app entry point
- **State management**: React Query (TanStack Query) for server state
- **UI Library**: Custom Neko UI components from `@meow-apps/neko-ui`
- **Bundling**: Webpack with vendor splitting, outputs to `app/` directory
- **WordPress integration**: Uses WordPress's bundled React via externals

### Key Integration Points
1. **Image Generation**: Hooks into WordPress upload process to generate retina/WebP/AVIF versions
2. **Frontend Delivery**: Multiple methods (Responsive Images, PictureFill, HTML Rewrite, Retina.js)
3. **Media Library**: Custom columns and bulk actions for retina management
4. **REST API**: All admin operations go through REST endpoints with `wp_rest` nonce

### Database & Storage
- Stores retina info in post meta (`_wr2x_info`)
- Image files follow pattern: `filename-{width}x{height}@2x.{ext}` for retina
- WebP/AVIF versions stored alongside originals

## Important Notes

- Always test image generation after making changes to `Engine` class
- Pro features require valid license - check `common/premium/licenser.php`
- Frontend scripts (`retina.js`, `picturefill.min.js`) are loaded conditionally based on settings
- When modifying REST endpoints, remember to handle both free and pro versions
- Image processing can be memory intensive - respect WordPress memory limits