<?php

class MeowPro_WR2X_Core {

	private $item = 'WP Retina 2x Pro';
	private $core;
	private $engine;

	public function __construct( $core, $engine ) {
		$this->core = $core;
		$this->engine = $engine;
		add_action( 'init', array( $this, 'init' ) );
	}

	function init() {

		// Common behaviors, license, update system, etc.
		new MeowCommonPro_Licenser( WR2X_PREFIX, WR2X_ENTRY, WR2X_DOMAIN, $this->item, WR2X_VERSION );

		// The Rest API for the Pro
		if ( MeowCommon_Helpers::is_rest() ) {
			new MeowPro_WR2X_Rest( $this->core, $this->engine );
		}

		// Uploader for Retina for Full-Size.
		if ( is_admin() && $this->core->get_option( "full_size" ) ) {
			new MeowPro_WR2X_Uploader( $this );
		}
	}

}
