<div v-if="met_dependencies" class="panel-field-opt panel-field-opt-address-field wpuf-mb-0">
    <div class="wpuf-mt-2">
        <div v-for="(addr_field_details, addr_field) in field.address" :class="['wpuf-address-field', addr_field]" v-if="addr_field_details.checked">
            <div class="wpuf-sub-fields">
                <template v-if="'country_select' !== addr_field">
                    <input
                        v-if="'text' == addr_field_details.type"
                        type="text"
                        size="40"
                        :class="builder_class_names('textfield')"
                        :value="addr_field_details.value"
                        :placeholder="addr_field_details.placeholder"
                        :required="'checked' === addr_field_details.required"
                    >
                    <select
                        v-if="'select' == addr_field_details.type"
                        :class="builder_class_names('dropdown')"
                        name=""
                        id=""
                    >
                    <option value=""><?php _e( 'Select State', 'wpuf-pro' ); ?></option>
                    </select>
                </template>
                <template v-else>
                    <select
                        :required="'checked' === addr_field_details.required"
                        :class="builder_class_names('dropdown')"
                        v-model=default_country>
                        <option value=""><?php _e( 'Select Country', 'wpuf-pro' ); ?></option>
                        <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
                    </select>
                </template>
            </div>

            <label class="wpuf-form-sub-label">
                {{ addr_field_details.label }}
                <span v-if="'checked' === addr_field_details.required" class="required">*</span>
            </label>
        </div>
        <span v-if="field.help" class="wpuf-help" v-html="field.help"/>
    </div>
</div>
