<?php

namespace WeDevs\Wpuf\Pro\Admin\Forms\PostTemplates;

use WeDevs\Wpuf\Admin\Forms\Form_Template;

/**
 * News/Press Release submission form template
 */
class Post_Form_Template_Press_Release extends Form_Template {

    public function __construct() {
        $this->enabled     = true;
        $this->title       = __( 'News/Press Release Submission', 'wpuf-pro' );
        $this->description = __( 'Collect press releases or news content with contact details, images, and media resources.', 'wpuf-pro' );
        $this->image       = WPUF_PRO_ASSET_URI . '/images/templates/press-release.svg';
        $this->form_fields = [
            [
                'input_type'      => 'text',
                'template'        => 'post_title',
                'required'        => 'yes',
                'label'           => 'Headline',
                'name'            => 'post_title',
                'is_meta'         => 'no',
                'help'            => 'This will be the main title of your press release.',
                'css'             => '',
                'placeholder'     => 'Enter your compelling news headline',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'text_field',
                'required'        => 'no',
                'label'           => 'Subheadline',
                'name'            => 'subheadline',
                'is_meta'         => 'yes',
                'help'            => 'A concise summary that expands on the headline and encourages reading.',
                'css'             => '',
                'placeholder'     => 'Provide a brief, engaging subheadline',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'text_field',
                'required'        => 'yes',
                'label'           => 'Dateline',
                'name'            => 'dateline',
                'is_meta'         => 'yes',
                'help'            => 'City, State/Country, and current date of the press release\'s origin.',
                'css'             => '',
                'placeholder'     => 'e.g., NEW YORK, NY – July 7, 2025',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'          => 'textarea',
                'template'            => 'post_content',
                'required'            => 'yes',
                'label'               => 'Press Release Body',
                'name'                => 'post_content',
                'is_meta'             => 'no',
                'help'                => '',
                'css'                 => '',
                'rows'                => '10',
                'cols'                => '25',
                'placeholder'         => '',
                'default'             => '',
                'rich'                => 'yes',
                'insert_image'        => 'yes',
                'word_restriction'    => '',
                'wpuf_cond'           => $this->conditionals,
                'wpuf_visibility'     => $this->get_default_visibility_prop(),
                'text_editor_control' => [],
                'show_in_post'        => 'yes',
            ],
            [
                'input_type'          => 'textarea',
                'template'            => 'post_excerpt',
                'required'            => 'no',
                'label'               => 'Summary/Excerpt',
                'name'                => 'post_excerpt',
                'is_meta'             => 'no',
                'help'                => '',
                'css'                 => '',
                'rows'                => '5',
                'cols'                => '25',
                'placeholder'         => '',
                'default'             => '',
                'rich'                => 'no',
                'wpuf_cond'           => $this->conditionals,
                'wpuf_visibility'     => $this->get_default_visibility_prop(),
                'text_editor_control' => [],
                'show_in_post'        => 'yes',
            ],
            [
                'input_type'      => 'image_upload',
                'template'        => 'featured_image',
                'count'           => '1',
                'required'        => 'yes',
                'label'           => 'Featured Image',
                'name'            => 'featured_image',
                'button_label'    => 'Select Image',
                'is_meta'         => 'no',
                'help'            => 'An impactful image that represents your news story.',
                'css'             => '',
                'max_size'        => '2048',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'website_url',
                'template'        => 'website_url',
                'required'        => 'no',
                'label'           => 'Official Source URL',
                'name'            => 'source_url',
                'is_meta'         => 'yes',
                'help'            => '',
                'css'             => '',
                'placeholder'     => 'https://www.yourcompany.com',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'taxonomy',
                'template'        => 'taxonomy',
                'required'        => 'yes',
                'label'           => 'Category',
                'name'            => 'category',
                'is_meta'         => 'no',
                'help'            => '',
                'first'           => __( '- Select -', 'wpuf-pro' ),
                'css'             => '',
                'type'            => 'select',
                'orderby'         => 'name',
                'order'           => 'ASC',
                'exclude_type'    => 'exclude',
                'exclude'         => [],
                'woo_attr'        => 'no',
                'woo_attr_vis'    => 'no',
                'options'         => [],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'post_tags',
                'required'        => 'no',
                'label'           => 'Tags',
                'name'            => 'tags',
                'is_meta'         => 'no',
                'help'            => 'Relevant keywords to help users find your press release (e.g., product, industry, event).',
                'css'             => '',
                'placeholder'     => 'Enter keywords, separated by commas',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'text_field',
                'required'        => 'yes',
                'label'           => 'Contact Name',
                'name'            => 'contact_name',
                'is_meta'         => 'yes',
                'help'            => '',
                'css'             => '',
                'placeholder'     => 'Enter your name',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'email_address',
                'template'        => 'email_address',
                'required'        => 'yes',
                'label'           => 'Contact Email',
                'name'            => 'contact_email',
                'is_meta'         => 'yes',
                'help'            => '',
                'css'             => '',
                'placeholder'     => 'Enter email address',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'phone_field',
                'template'        => 'phone_field',
                'required'        => 'no',
                'label'           => 'Contact Phone',
                'name'            => 'contact_phone',
                'is_meta'         => 'yes',
                'help'            => '',
                'css'             => '',
                'placeholder'     => 'Enter phone number',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'file_upload',
                'template'        => 'file_upload',
                'required'        => 'no',
                'label'           => 'Company Logo Upload',
                'name'            => 'company_logo',
                'is_meta'         => 'yes',
                'help'            => 'Your official company logo for media use. Accepted formats: JPG, PNG. Max size: 2MB.',
                'css'             => '',
                'max_size'        => '2048',
                'count'           => '1',
                'extension'       => [ 'images' ],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'file_upload',
                'template'        => 'file_upload',
                'required'        => 'no',
                'label'           => 'Press Kit / Document Upload',
                'name'            => 'press_kit',
                'is_meta'         => 'yes',
                'help'            => 'Upload supported documents. Accepted formats: PDF, DOCX, PPTX. Max size: 5MB.',
                'css'             => '',
                'max_size'        => '5120',
                'count'           => '3',
                'extension'       => [ 'pdf', 'office' ],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'address',
                'template'        => 'address_field',
                'required'        => 'no',
                'label'           => 'Office Address',
                'name'            => 'office_address',
                'is_meta'         => 'yes',
                'help'            => 'The physical address of the submitting organization.',
                'css'             => '',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'address_desc'    => '',
                'address'         => [
                    'street_1'       => [
                        'checked'     => 'checked',
                        'type'        => 'text',
                        'required'    => '',
                        'label'       => 'Street',
                        'value'       => '',
                        'placeholder' => '',
                    ],
                    'street_2'       => [
                        'checked'     => '',
                        'type'        => 'text',
                        'required'    => '',
                        'label'       => 'Street 2',
                        'value'       => '',
                        'placeholder' => '',
                    ],
                    'city'           => [
                        'checked'     => 'checked',
                        'type'        => 'text',
                        'required'    => '',
                        'label'       => 'City',
                        'value'       => '',
                        'placeholder' => '',
                    ],
                    'zip'            => [
                        'checked'     => 'checked',
                        'type'        => 'text',
                        'required'    => '',
                        'label'       => 'Zip Code',
                        'value'       => '',
                        'placeholder' => '',
                    ],
                    'country_select' => [
                        'checked'                          => 'checked',
                        'type'                             => 'select',
                        'required'                         => '',
                        'label'                            => 'Country',
                        'value'                            => '',
                        'country_list_visibility_opt_name' => 'all',
                        'country_select_hide_list'         => [],
                        'country_select_show_list'         => [],
                    ],
                    'state'          => [
                        'checked'     => 'checked',
                        'type'        => 'select',
                        'required'    => '',
                        'label'       => 'State',
                        'value'       => '',
                    ],
                ],
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'embed',
                'template'        => 'embed',
                'required'        => 'no',
                'label'           => 'Video Embed',
                'name'            => 'video_embed',
                'is_meta'         => 'yes',
                'help'            => 'Link to a relevant video that enhances your press release.',
                'css'             => '',
                'placeholder'     => '',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'date',
                'template'        => 'date_field',
                'required'        => 'no',
                'label'           => 'Embargo Until',
                'name'            => 'embargo_until',
                'is_meta'         => 'yes',
                'help'            => 'Set a specific date and time before which this press release should not be published.',
                'css'             => '',
                'format'          => 'dd/mm/yy',
                'time'            => 'yes',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'recaptcha',
                'template'        => 'recaptcha',
                'required'        => 'no',
                'label'           => 'Spam Protection',
                'name'            => 'recaptcha',
                'is_meta'         => 'no',
                'help'            => 'Please confirm you\'re not a robot.',
                'css'             => '',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'no',
            ],
        ];
        $this->form_settings = [
            'post_type'          => 'post',
            'expiration_settings' => [],
            'post_status'        => 'draft',
            'default_cat'        => '-1',
            'post_permission'    => 'guest_post',
            'guest_post'         => 'true',
            'guest_details'      => 'on',
            'name_label'         => 'Name',
            'email_label'        => 'E-Mail',
            'guest_email_verify' => 'on',
            'message_restrict'   => 'This page is restricted. Please Log in / Register to view this page.',
            'redirect_to'        => 'same',
            'comment_status'     => 'closed',
            'submit_text'        => 'Submit Press Release',
            'submit_button_cond' => [
                'condition_status' => 'no',
                'cond_logic'       => 'any',
                'conditions'       => [
                    [
                        'name'     => '',
                        'operator' => '=',
                        'option'   => '',
                    ],
                ],
            ],
            'draft_post'         => 'true',
            'edit_post_status'   => 'draft',
            'edit_redirect_to'   => 'same',
            'update_message'     => 'Press release has been updated successfully. <a target="_blank" href="{link}">View Press Release</a>',
            'edit_url'           => '',
            'update_text'        => 'Update Press Release',
            'form_template'      => 'post_form_template_press_release',
            'notification'       => [
                'new'          => 'on',
                'new_to'       => get_option( 'admin_email' ),
                'new_subject'  => 'New press release submission',
                'new_body'     => 'Hi,
A new press release has been submitted to your site {sitename} ({siteurl}).

Here are the details:
Headline: {post_title}
Dateline: {dateline}
Press Release Body: {post_content}
Summary: {post_excerpt}
Contact Name: {contact_name}
Contact Email: {contact_email}
Contact Phone: {contact_phone}
Author: {author}
Post URL: {permalink}
Edit URL: {editlink}',
                'edit'         => 'on',
                'edit_to'      => get_option( 'admin_email' ),
                'edit_subject' => 'Press release has been updated',
                'edit_body'    => 'Hi,
The press release "{post_title}" has been updated.

Here are the details:
Headline: {post_title}
Dateline: {dateline}
Press Release Body: {post_content}
Summary: {post_excerpt}
Contact Name: {contact_name}
Contact Email: {contact_email}
Contact Phone: {contact_phone}
Author: {author}
Post URL: {permalink}
Edit URL: {editlink}'
            ],
        ];
    }
}