<?php

namespace WeDevs\Wpuf\Pro\Admin\Forms\PostTemplates;

use WeDevs\Wpuf\Admin\Forms\Form_Template;

/**
 * Professional Video submission form template
 */
class Post_Form_Template_Professional_Video extends Form_Template {

    public function __construct() {
        $this->enabled     = true;
        $this->title       = __( 'Professional Video Submission', 'wpuf-pro' );
        $this->description = __( 'Feature-rich form for professional video content submission with production details and rights management.', 'wpuf-pro' );
        $this->image       = WPUF_PRO_ASSET_URI . '/images/templates/professional-video.svg';
        $this->form_fields = [
            // Section 1: Core Video Details
            [
                'input_type'      => 'text',
                'template'        => 'post_title',
                'required'        => 'yes',
                'label'           => 'Video Title',
                'name'            => 'post_title',
                'is_meta'         => 'no',
                'help'            => '',
                'css'             => '',
                'placeholder'     => 'Enter your video\'s main title',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'          => 'textarea',
                'template'            => 'post_content',
                'required'            => 'yes',
                'label'               => 'Video Description',
                'name'                => 'post_content',
                'is_meta'             => 'no',
                'help'                => 'The detailed summary shown on the video page.',
                'css'                 => '',
                'rows'                => '10',
                'cols'                => '25',
                'placeholder'         => '',
                'default'             => '',
                'rich'                => 'yes',
                'insert_image'        => 'yes',
                'word_restriction'    => '',
                'wpuf_cond'           => $this->conditionals,
                'wpuf_visibility'     => $this->get_default_visibility_prop(),
                'text_editor_control' => [],
                'show_in_post'        => 'yes',
            ],
            [
                'input_type'      => 'image_upload',
                'template'        => 'featured_image',
                'count'           => '1',
                'required'        => 'yes',
                'label'           => 'Featured Thumbnail',
                'name'            => 'featured_image',
                'button_label'    => 'Upload Thumbnail',
                'is_meta'         => 'no',
                'help'            => 'The preview image for the video. Crucial for engagement.',
                'css'             => '',
                'max_size'        => '2048',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'taxonomy',
                'template'        => 'taxonomy',
                'required'        => 'yes',
                'label'           => 'Video Category',
                'name'            => 'category',
                'is_meta'         => 'no',
                'help'            => 'Organizes content (e.g., News, Tutorial, Interview).',
                'first'           => __( '- Select -', 'wpuf-pro' ),
                'css'             => '',
                'type'            => 'select',
                'orderby'         => 'name',
                'order'           => 'ASC',
                'exclude_type'    => 'exclude',
                'exclude'         => [],
                'woo_attr'        => 'no',
                'woo_attr_vis'    => 'no',
                'options'         => [],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'post_tags',
                'required'        => 'no',
                'label'           => 'Tags',
                'name'            => 'tags',
                'is_meta'         => 'no',
                'help'            => 'Adds specific keywords for searchability.',
                'css'             => '',
                'placeholder'     => 'e.g., dhaka, react-js, cooking',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            // Section 2: Video Source
            [
                'input_type'      => 'website_url',
                'template'        => 'website_url',
                'required'        => 'yes',
                'label'           => 'Video URL',
                'name'            => 'video_url',
                'is_meta'         => 'yes',
                'help'            => 'For embedding from YouTube, Vimeo, etc. The most common use case.',
                'css'             => '',
                'placeholder'     => 'https://youtube.com/watch?v=...',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'file_upload',
                'template'        => 'file_upload',
                'required'        => 'no',
                'label'           => 'OR Upload Video File',
                'name'            => 'video_file',
                'is_meta'         => 'yes',
                'help'            => '(Optional) For submitting raw footage or original files (e.g., MP4, MOV). Essential for news agencies or when self-hosting.',
                'css'             => '',
                'max_size'        => '102400',
                'count'           => '1',
                'extension'       => [ 'video' ],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            // Section 3: Context & Credits
            [
                'input_type'      => 'date',
                'template'        => 'date_field',
                'required'        => 'no',
                'label'           => 'Date Recorded',
                'name'            => 'date_recorded',
                'is_meta'         => 'yes',
                'help'            => 'Crucial for time-sensitive content like news reports or event coverage.',
                'css'             => '',
                'format'          => 'mm/dd/yy',
                'time'            => 'yes',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'text_field',
                'required'        => 'no',
                'label'           => 'Location / Dateline',
                'name'            => 'video_location',
                'is_meta'         => 'yes',
                'help'            => 'The location where the video was filmed.',
                'css'             => '',
                'placeholder'     => 'e.g., Dhaka, Bangladesh',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'text_field',
                'required'        => 'no',
                'label'           => 'Credit / Author(s)',
                'name'            => 'video_credit',
                'is_meta'         => 'yes',
                'help'            => 'Acknowledge the creator, director, or speaker if different from the submitter.',
                'css'             => '',
                'placeholder'     => '',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'numeric_text',
                'template'        => 'numeric_text_field',
                'required'        => 'no',
                'label'           => 'Runtime (Minutes)',
                'name'            => 'video_runtime',
                'is_meta'         => 'yes',
                'help'            => 'Useful for display and for contest submissions with time limits.',
                'css'             => '',
                'placeholder'     => '',
                'default'         => '',
                'size'            => '40',
                'step_text_field' => '1',
                'min_value_field' => '0',
                'max_value_field' => '',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            // Section 4: Permissions & Agreement
            [
                'input_type'      => 'select',
                'template'        => 'dropdown_field',
                'required'        => 'yes',
                'label'           => 'Usage Rights',
                'name'            => 'usage_rights',
                'is_meta'         => 'yes',
                'help'            => 'Defines how the content can be used.',
                'css'             => '',
                'first'           => '- Select -',
                'options'         => [
                    'full_rights' => 'Full Rights (I am the owner)',
                    'creative_commons' => 'Creative Commons',
                    'editorial_only' => 'Editorial Use Only',
                ],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'toc',
                'template'        => 'toc',
                'required'        => 'yes',
                'label'           => 'Agree to Terms',
                'name'            => 'agree_terms',
                'is_meta'         => 'yes',
                'help'            => '',
                'css'             => '',
                'description'     => 'I certify that I have the right to submit this video and agree to the platform\'s policies regarding content usage, copyright, and distribution.',
                'show_checkbox'   => 'yes',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'no',
            ],
        ];
        $this->form_settings = [
            'post_type'          => 'post',
            'expiration_settings' => [],
            'post_status'        => 'draft',
            'default_cat'        => '-1',
            'post_permission'    => 'guest_post',
            'guest_post'         => 'true',
            'guest_details'      => 'on',
            'name_label'         => 'Name',
            'email_label'        => 'E-Mail',
            'guest_email_verify' => 'on',
            'message_restrict'   => 'This page is restricted. Please Log in / Register to view this page.',
            'redirect_to'        => 'same',
            'comment_status'     => 'closed',
            'submit_text'        => 'Submit Video',
            'submit_button_cond' => [
                'condition_status' => 'no',
                'cond_logic'       => 'any',
                'conditions'       => [
                    [
                        'name'     => '',
                        'operator' => '=',
                        'option'   => '',
                    ],
                ],
            ],
            'draft_post'         => 'true',
            'edit_post_status'   => 'draft',
            'edit_redirect_to'   => 'same',
            'update_message'     => 'Your video has been updated successfully.',
            'edit_url'           => '',
            'update_text'        => 'Update Video',
            'form_template'      => 'post_form_template_professional_video',
            'notification'       => [
                'new'          => 'on',
                'new_to'       => get_option( 'admin_email' ),
                'new_subject'  => 'New professional video submission',
                'new_body'     => 'Hi,
A new professional video has been submitted to your site {sitename} ({siteurl}).

Here are the details:
Video Title: {post_title}
Video Description: {post_content}
Video URL: {video_url}
Location: {video_location}
Date Recorded: {date_recorded}
Runtime: {video_runtime} minutes
Credit: {video_credit}
Usage Rights: {usage_rights}
Author: {author}
Post URL: {permalink}
Edit URL: {editlink}',
                'edit'         => 'on',
                'edit_to'      => get_option( 'admin_email' ),
                'edit_subject' => 'Professional video has been updated',
                'edit_body'    => 'Hi,
The professional video "{post_title}" has been updated.

Here are the details:
Video Title: {post_title}
Video Description: {post_content}
Video URL: {video_url}
Location: {video_location}
Date Recorded: {date_recorded}
Runtime: {video_runtime} minutes
Credit: {video_credit}
Usage Rights: {usage_rights}
Author: {author}
Post URL: {permalink}
Edit URL: {editlink}'
            ],
        ];
    }
}